/* alpm_octopi_utils.c generated by valac 0.56.17, the Vala compiler
 * generated from alpm_octopi_utils.vala, do not modify */

/*
 *  alpm_octopi_utils
 *
 *  Copyright (C) 2014-2016 Guillaume Benoit <guillaume@manjaro.org>
 *  Copyright (C) 2016 Alexandre Albuquerque Arnt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "alpm.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "alpm_octopi_utils.h"
#include "alpm_list.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _alpm_release0(var) ((var == NULL) ? NULL : (var = (alpm_release (var), NULL)))
#define _alpm_list_free0(var) ((var == NULL) ? NULL : (var = (alpm_list_free (var), NULL)))
typedef struct _AlpmConfig AlpmConfig;
typedef struct _AlpmRepo AlpmRepo;
#define _alpm_config_free0(var) ((var == NULL) ? NULL : (var = (alpm_config_free (var), NULL)))

struct _AlpmConfig {
	gchar* conf_path;
	gchar* rootdir;
	gchar* dbpath;
	gchar* logfile;
	gchar* gpgdir;
	alpm_list_t* architectures;
	gint usesyslog;
	gint checkspace;
	alpm_list_t* cachedirs;
	alpm_list_t* hookdirs;
	alpm_list_t* ignoregroups;
	alpm_list_t* ignorepkgs;
	alpm_list_t* noextracts;
	alpm_list_t* noupgrades;
	alpm_list_t* holdpkgs;
	alpm_list_t* syncfirsts;
	alpm_siglevel_t siglevel;
	alpm_siglevel_t localfilesiglevel;
	alpm_siglevel_t remotefilesiglevel;
	alpm_siglevel_t siglevel_mask;
	alpm_siglevel_t localfilesiglevel_mask;
	alpm_siglevel_t remotefilesiglevel_mask;
	GList* repo_order;
};

VALA_EXTERN gint alpm_pkg_compare_name (alpm_pkg_t* pkg_a,
                            alpm_pkg_t* pkg_b);
static void alpm_utils_instance_init (AlpmUtils * self);
VALA_EXTERN void alpm_config_free (AlpmConfig * self);
VALA_EXTERN AlpmConfig* alpm_config_new (const gchar* path);
VALA_EXTERN alpm_handle_t* alpm_config_get_handle (AlpmConfig* self);
VALA_EXTERN void alpm_repo_free (AlpmRepo * self);
static void _g_free_alpm_list_fn_free (gconstpointer a);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

gint
alpm_pkg_compare_name (alpm_pkg_t* pkg_a,
                       alpm_pkg_t* pkg_b)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result;
#line 21 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (pkg_a != NULL, 0);
#line 21 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (pkg_b != NULL, 0);
#line 22 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp0_ = ((GCompareFunc) g_strcmp0);
#line 22 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp1_ = alpm_pkg_get_name (pkg_a);
#line 22 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp2_ = _tmp1_;
#line 22 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp3_ = alpm_pkg_get_name (pkg_b);
#line 22 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp4_ = _tmp3_;
#line 22 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	result = _tmp0_ (_tmp2_, _tmp4_);
#line 22 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	return result;
#line 118 "alpm_octopi_utils.c"
}

AlpmUtils*
alpm_utils_new (const gchar* conf_file_path)
{
	AlpmUtils* self;
	gchar* _tmp0_;
#line 32 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (conf_file_path != NULL, NULL);
#line 32 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	self = g_slice_new0 (AlpmUtils);
#line 32 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	alpm_utils_instance_init (self);
#line 33 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp0_ = g_strdup (conf_file_path);
#line 33 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_g_free0 (self->conf_file_path);
#line 33 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	self->conf_file_path = _tmp0_;
#line 34 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	alpm_utils_refresh_handle (self);
#line 32 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	return self;
#line 142 "alpm_octopi_utils.c"
}

void
alpm_utils_refresh_handle (AlpmUtils* self)
{
	AlpmConfig* alpm_config = NULL;
	const gchar* _tmp0_;
	AlpmConfig* _tmp1_;
	alpm_handle_t* _tmp2_;
	alpm_list_t* _tmp3_;
	alpm_list_t* _tmp4_;
#line 37 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_if_fail (self != NULL);
#line 38 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp0_ = self->conf_file_path;
#line 38 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp1_ = alpm_config_new (_tmp0_);
#line 38 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	alpm_config = _tmp1_;
#line 39 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp2_ = alpm_config_get_handle (alpm_config);
#line 39 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_alpm_release0 (self->alpm_handle);
#line 39 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	self->alpm_handle = _tmp2_;
#line 40 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp3_ = alpm_config->holdpkgs;
#line 40 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	alpm_config->holdpkgs = NULL;
#line 40 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_alpm_list_free0 (self->holdpkgs);
#line 40 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	self->holdpkgs = _tmp3_;
#line 41 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp4_ = alpm_config->syncfirsts;
#line 41 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	alpm_config->syncfirsts = NULL;
#line 41 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_alpm_list_free0 (self->syncfirsts);
#line 41 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	self->syncfirsts = _tmp4_;
#line 37 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_alpm_config_free0 (alpm_config);
#line 186 "alpm_octopi_utils.c"
}

alpm_pkg_t*
alpm_utils_get_installed_pkg (AlpmUtils* self,
                              const gchar* pkg_name)
{
	alpm_handle_t* _tmp0_;
	alpm_db_t* _tmp1_;
	alpm_db_t* _tmp2_;
	alpm_pkg_t* _tmp3_;
	alpm_pkg_t* result;
#line 44 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (pkg_name != NULL, NULL);
#line 45 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp0_ = self->alpm_handle;
#line 45 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp1_ = alpm_get_localdb (_tmp0_);
#line 45 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp2_ = _tmp1_;
#line 45 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp3_ = alpm_db_get_pkg (_tmp2_, pkg_name);
#line 45 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	result = _tmp3_;
#line 45 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	return result;
#line 214 "alpm_octopi_utils.c"
}

alpm_pkg_t*
alpm_utils_get_sync_pkg (AlpmUtils* self,
                         const gchar* pkg_name)
{
	alpm_pkg_t* pkg = NULL;
	alpm_list_t* list = NULL;
	alpm_handle_t* _tmp0_;
	alpm_list_t* _tmp1_;
	alpm_list_t* _tmp2_;
	alpm_pkg_t* _tmp11_;
	alpm_pkg_t* result;
#line 48 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 48 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (pkg_name != NULL, NULL);
#line 49 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	pkg = NULL;
#line 50 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp0_ = self->alpm_handle;
#line 50 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp1_ = alpm_get_syncdbs (_tmp0_);
#line 50 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp2_ = _tmp1_;
#line 50 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	list = _tmp2_;
#line 51 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	while (TRUE) {
#line 244 "alpm_octopi_utils.c"
		alpm_list_t* _tmp3_;
		alpm_db_t* db = NULL;
		alpm_list_t* _tmp4_;
		gconstpointer _tmp5_;
		alpm_db_t* _tmp6_;
		alpm_pkg_t* _tmp7_;
		alpm_pkg_t* _tmp8_;
		alpm_list_t* _tmp9_;
		alpm_list_t* _tmp10_;
#line 51 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp3_ = list;
#line 51 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		if (!(_tmp3_ != NULL)) {
#line 51 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			break;
#line 260 "alpm_octopi_utils.c"
		}
#line 52 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp4_ = list;
#line 52 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp5_ = _tmp4_->data;
#line 52 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		db = (alpm_db_t*) _tmp5_;
#line 53 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp6_ = db;
#line 53 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp7_ = alpm_db_get_pkg (_tmp6_, pkg_name);
#line 53 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		pkg = _tmp7_;
#line 54 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp8_ = pkg;
#line 54 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		if (_tmp8_ != NULL) {
#line 55 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			break;
#line 280 "alpm_octopi_utils.c"
		}
#line 57 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp9_ = list;
#line 57 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp10_ = _tmp9_->next;
#line 57 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		list = _tmp10_;
#line 288 "alpm_octopi_utils.c"
	}
#line 59 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp11_ = pkg;
#line 59 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	result = _tmp11_;
#line 59 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	return result;
#line 296 "alpm_octopi_utils.c"
}

alpm_list_t*
alpm_utils_search_all_dbs (AlpmUtils* self,
                           const gchar* search_string)
{
	alpm_list_t* syncpkgs = NULL;
	alpm_list_t* results = NULL;
	alpm_list_t* ret = NULL;
	alpm_list_t* needles = NULL;
	gchar** splitted = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint splitted_length1;
	gint _splitted_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	alpm_handle_t* _tmp4_;
	alpm_db_t* _tmp5_;
	alpm_db_t* _tmp6_;
	alpm_list_t* _tmp7_;
	alpm_list_t* _tmp8_ = NULL;
	alpm_list_t* list = NULL;
	alpm_handle_t* _tmp9_;
	alpm_list_t* _tmp10_;
	alpm_list_t* _tmp11_;
	alpm_list_t* _tmp26_;
	alpm_list_t* _tmp27_;
	alpm_list_t* result;
#line 62 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 62 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (search_string != NULL, NULL);
#line 63 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	syncpkgs = NULL;
#line 64 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	results = NULL;
#line 65 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	ret = NULL;
#line 66 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	needles = NULL;
#line 67 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp1_ = _tmp0_ = g_strsplit (search_string, " ", 0);
#line 67 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	splitted = _tmp1_;
#line 67 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	splitted_length1 = _vala_array_length (_tmp0_);
#line 67 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_splitted_size_ = splitted_length1;
#line 68 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp2_ = splitted;
#line 68 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp2__length1 = splitted_length1;
#line 350 "alpm_octopi_utils.c"
	{
		gchar** part_collection = NULL;
		gint part_collection_length1 = 0;
		gint _part_collection_size_ = 0;
		gint part_it = 0;
#line 68 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		part_collection = _tmp2_;
#line 68 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		part_collection_length1 = _tmp2__length1;
#line 68 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		for (part_it = 0; part_it < part_collection_length1; part_it = part_it + 1) {
#line 362 "alpm_octopi_utils.c"
			const gchar* part = NULL;
#line 68 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			part = part_collection[part_it];
#line 366 "alpm_octopi_utils.c"
			{
				const gchar* _tmp3_;
#line 69 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp3_ = part;
#line 69 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				needles = alpm_list_add (needles, _tmp3_);
#line 373 "alpm_octopi_utils.c"
			}
		}
	}
#line 71 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp4_ = self->alpm_handle;
#line 71 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp5_ = alpm_get_localdb (_tmp4_);
#line 71 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp6_ = _tmp5_;
#line 71 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp7_ = needles;
#line 71 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	alpm_db_search (_tmp6_, _tmp7_, &_tmp8_);
#line 71 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_alpm_list_free0 (results);
#line 71 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	results = _tmp8_;
#line 72 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp9_ = self->alpm_handle;
#line 72 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp10_ = alpm_get_syncdbs (_tmp9_);
#line 72 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp11_ = _tmp10_;
#line 72 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	list = _tmp11_;
#line 73 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	while (TRUE) {
#line 401 "alpm_octopi_utils.c"
		alpm_list_t* _tmp12_;
		alpm_db_t* db = NULL;
		alpm_list_t* _tmp13_;
		gconstpointer _tmp14_;
		alpm_list_t* _tmp15_;
		alpm_list_t* _tmp24_;
		alpm_list_t* _tmp25_;
#line 73 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp12_ = list;
#line 73 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		if (!(_tmp12_ != NULL)) {
#line 73 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			break;
#line 415 "alpm_octopi_utils.c"
		}
#line 74 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp13_ = list;
#line 74 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp14_ = _tmp13_->data;
#line 74 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		db = (alpm_db_t*) _tmp14_;
#line 75 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp15_ = syncpkgs;
#line 75 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		if (alpm_list_count (_tmp15_) == ((gsize) 0)) {
#line 427 "alpm_octopi_utils.c"
			alpm_db_t* _tmp16_;
			alpm_list_t* _tmp17_;
			alpm_list_t* _tmp18_ = NULL;
#line 76 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp16_ = db;
#line 76 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp17_ = needles;
#line 76 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			alpm_db_search (_tmp16_, _tmp17_, &_tmp18_);
#line 76 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_alpm_list_free0 (syncpkgs);
#line 76 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			syncpkgs = _tmp18_;
#line 441 "alpm_octopi_utils.c"
		} else {
			alpm_db_t* _tmp19_;
			alpm_list_t* _tmp20_;
			alpm_list_t* _tmp21_ = NULL;
			alpm_list_t* _tmp22_;
			alpm_list_t* _tmp23_;
#line 79 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp19_ = db;
#line 79 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp20_ = needles;
#line 79 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			alpm_db_search (_tmp19_, _tmp20_, &_tmp21_);
#line 79 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_alpm_list_free0 (ret);
#line 79 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			ret = _tmp21_;
#line 80 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp22_ = ret;
#line 80 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp23_ = alpm_list_copy (_tmp22_);
#line 80 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			syncpkgs = alpm_list_join (syncpkgs, _tmp23_);
#line 464 "alpm_octopi_utils.c"
		}
#line 82 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp24_ = list;
#line 82 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp25_ = _tmp24_->next;
#line 82 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		list = _tmp25_;
#line 472 "alpm_octopi_utils.c"
	}
#line 86 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp26_ = syncpkgs;
#line 86 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp27_ = alpm_list_copy (_tmp26_);
#line 86 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	results = alpm_list_join (results, _tmp27_);
#line 88 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	result = results;
#line 88 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
#line 88 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_alpm_list_free0 (needles);
#line 88 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_alpm_list_free0 (ret);
#line 88 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_alpm_list_free0 (syncpkgs);
#line 88 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	return result;
#line 492 "alpm_octopi_utils.c"
}

alpm_list_t*
alpm_utils_get_group_pkgs (AlpmUtils* self,
                           const gchar* group_name)
{
	alpm_list_t* results = NULL;
	alpm_group_t* grp = NULL;
	alpm_handle_t* _tmp0_;
	alpm_db_t* _tmp1_;
	alpm_db_t* _tmp2_;
	alpm_group_t* _tmp3_;
	alpm_group_t* _tmp4_;
	alpm_handle_t* _tmp13_;
	alpm_list_t* _tmp14_;
	alpm_list_t* _tmp15_;
	alpm_list_t* _tmp16_;
	alpm_list_t* _tmp17_;
	alpm_list_t* _tmp18_;
	alpm_list_t* result;
#line 91 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 91 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (group_name != NULL, NULL);
#line 92 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	results = NULL;
#line 93 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp0_ = self->alpm_handle;
#line 93 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp1_ = alpm_get_localdb (_tmp0_);
#line 93 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp2_ = _tmp1_;
#line 93 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp3_ = alpm_db_get_group (_tmp2_, group_name);
#line 93 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	grp = _tmp3_;
#line 94 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp4_ = grp;
#line 94 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	if (_tmp4_ != NULL) {
#line 533 "alpm_octopi_utils.c"
		alpm_list_t* list = NULL;
		alpm_group_t* _tmp5_;
		alpm_list_t* _tmp6_;
#line 95 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp5_ = grp;
#line 95 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp6_ = _tmp5_->packages;
#line 95 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		list = _tmp6_;
#line 96 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		while (TRUE) {
#line 545 "alpm_octopi_utils.c"
			alpm_list_t* _tmp7_;
			alpm_pkg_t* pkg = NULL;
			alpm_list_t* _tmp8_;
			gconstpointer _tmp9_;
			alpm_pkg_t* _tmp10_;
			alpm_list_t* _tmp11_;
			alpm_list_t* _tmp12_;
#line 96 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp7_ = list;
#line 96 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			if (!(_tmp7_ != NULL)) {
#line 96 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				break;
#line 559 "alpm_octopi_utils.c"
			}
#line 97 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp8_ = list;
#line 97 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp9_ = _tmp8_->data;
#line 97 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			pkg = (alpm_pkg_t*) _tmp9_;
#line 98 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp10_ = pkg;
#line 98 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			results = alpm_list_add (results, _tmp10_);
#line 99 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp11_ = list;
#line 99 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp12_ = _tmp11_->next;
#line 99 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			list = _tmp12_;
#line 577 "alpm_octopi_utils.c"
		}
	}
#line 102 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp13_ = self->alpm_handle;
#line 102 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp14_ = alpm_get_syncdbs (_tmp13_);
#line 102 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp15_ = _tmp14_;
#line 102 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp16_ = alpm_find_group_pkgs (_tmp15_, group_name);
#line 102 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp17_ = results;
#line 102 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp18_ = alpm_list_diff (_tmp16_, _tmp17_, (alpm_list_fn_cmp) alpm_pkg_compare_name);
#line 102 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	results = alpm_list_join (results, _tmp18_);
#line 104 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	result = results;
#line 104 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	return result;
#line 598 "alpm_octopi_utils.c"
}

alpm_list_t*
alpm_utils_get_installed_pkgs (AlpmUtils* self)
{
	alpm_handle_t* _tmp0_;
	alpm_db_t* _tmp1_;
	alpm_db_t* _tmp2_;
	alpm_list_t* _tmp3_;
	alpm_list_t* _tmp4_;
	alpm_list_t* _tmp5_;
	alpm_list_t* result;
#line 107 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 108 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp0_ = self->alpm_handle;
#line 108 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp1_ = alpm_get_localdb (_tmp0_);
#line 108 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp2_ = _tmp1_;
#line 108 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp3_ = alpm_db_get_pkgcache (_tmp2_);
#line 108 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp4_ = _tmp3_;
#line 108 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp5_ = alpm_list_copy (_tmp4_);
#line 108 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	result = _tmp5_;
#line 108 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	return result;
#line 629 "alpm_octopi_utils.c"
}

static void
_g_free_alpm_list_fn_free (gconstpointer a)
{
#line 123 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_free (a);
#line 637 "alpm_octopi_utils.c"
}

alpm_list_t*
alpm_utils_get_orphans (AlpmUtils* self)
{
	alpm_list_t* results = NULL;
	alpm_list_t* list = NULL;
	alpm_handle_t* _tmp0_;
	alpm_db_t* _tmp1_;
	alpm_db_t* _tmp2_;
	alpm_list_t* _tmp3_;
	alpm_list_t* _tmp4_;
	alpm_list_t* result;
#line 111 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 112 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	results = NULL;
#line 113 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp0_ = self->alpm_handle;
#line 113 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp1_ = alpm_get_localdb (_tmp0_);
#line 113 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp2_ = _tmp1_;
#line 113 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp3_ = alpm_db_get_pkgcache (_tmp2_);
#line 113 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp4_ = _tmp3_;
#line 113 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	list = _tmp4_;
#line 114 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	while (TRUE) {
#line 669 "alpm_octopi_utils.c"
		alpm_list_t* _tmp5_;
		alpm_pkg_t* pkg = NULL;
		alpm_list_t* _tmp6_;
		gconstpointer _tmp7_;
		alpm_pkg_t* _tmp8_;
		alpm_pkgreason_t _tmp9_;
		alpm_pkgreason_t _tmp10_;
		alpm_list_t* _tmp20_;
		alpm_list_t* _tmp21_;
#line 114 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp5_ = list;
#line 114 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		if (!(_tmp5_ != NULL)) {
#line 114 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			break;
#line 685 "alpm_octopi_utils.c"
		}
#line 115 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp6_ = list;
#line 115 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp7_ = _tmp6_->data;
#line 115 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		pkg = (alpm_pkg_t*) _tmp7_;
#line 116 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp8_ = pkg;
#line 116 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp9_ = alpm_pkg_get_reason (_tmp8_);
#line 116 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp10_ = _tmp9_;
#line 116 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		if (_tmp10_ == ALPM_PKG_REASON_DEPEND) {
#line 701 "alpm_octopi_utils.c"
			alpm_list_t* requiredby = NULL;
			alpm_pkg_t* _tmp11_;
			alpm_list_t* _tmp12_;
			alpm_list_t* _tmp13_;
			alpm_list_t* _tmp19_;
#line 117 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp11_ = pkg;
#line 117 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp12_ = alpm_pkg_compute_requiredby (_tmp11_);
#line 117 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			requiredby = _tmp12_;
#line 118 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp13_ = requiredby;
#line 118 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			if (alpm_list_count (_tmp13_) == ((gsize) 0)) {
#line 717 "alpm_octopi_utils.c"
				alpm_list_t* optionalfor = NULL;
				alpm_pkg_t* _tmp14_;
				alpm_list_t* _tmp15_;
				alpm_list_t* _tmp16_;
				alpm_list_t* _tmp18_;
#line 119 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp14_ = pkg;
#line 119 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp15_ = alpm_pkg_compute_optionalfor (_tmp14_);
#line 119 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				optionalfor = _tmp15_;
#line 120 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp16_ = optionalfor;
#line 120 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				if (alpm_list_count (_tmp16_) == ((gsize) 0)) {
#line 733 "alpm_octopi_utils.c"
					alpm_pkg_t* _tmp17_;
#line 121 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
					_tmp17_ = pkg;
#line 121 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
					results = alpm_list_add (results, _tmp17_);
#line 739 "alpm_octopi_utils.c"
				}
#line 123 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp18_ = optionalfor;
#line 123 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				alpm_list_free_inner (_tmp18_, _g_free_alpm_list_fn_free);
#line 118 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_alpm_list_free0 (optionalfor);
#line 747 "alpm_octopi_utils.c"
			}
#line 125 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp19_ = requiredby;
#line 125 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			alpm_list_free_inner (_tmp19_, _g_free_alpm_list_fn_free);
#line 116 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_alpm_list_free0 (requiredby);
#line 755 "alpm_octopi_utils.c"
		}
#line 127 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp20_ = list;
#line 127 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp21_ = _tmp20_->next;
#line 127 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		list = _tmp21_;
#line 763 "alpm_octopi_utils.c"
	}
#line 129 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	result = results;
#line 129 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	return result;
#line 769 "alpm_octopi_utils.c"
}

alpm_list_t*
alpm_utils_get_unrequired (AlpmUtils* self)
{
	alpm_list_t* results = NULL;
	alpm_list_t* list = NULL;
	alpm_handle_t* _tmp0_;
	alpm_db_t* _tmp1_;
	alpm_db_t* _tmp2_;
	alpm_list_t* _tmp3_;
	alpm_list_t* _tmp4_;
	alpm_list_t* result;
#line 132 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 133 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	results = NULL;
#line 134 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp0_ = self->alpm_handle;
#line 134 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp1_ = alpm_get_localdb (_tmp0_);
#line 134 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp2_ = _tmp1_;
#line 134 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp3_ = alpm_db_get_pkgcache (_tmp2_);
#line 134 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp4_ = _tmp3_;
#line 134 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	list = _tmp4_;
#line 135 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	while (TRUE) {
#line 801 "alpm_octopi_utils.c"
		alpm_list_t* _tmp5_;
		alpm_pkg_t* pkg = NULL;
		alpm_list_t* _tmp6_;
		gconstpointer _tmp7_;
		alpm_list_t* requiredby = NULL;
		alpm_pkg_t* _tmp8_;
		alpm_list_t* _tmp9_;
		alpm_list_t* _tmp10_;
		alpm_list_t* _tmp16_;
		alpm_list_t* _tmp17_;
		alpm_list_t* _tmp18_;
#line 135 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp5_ = list;
#line 135 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		if (!(_tmp5_ != NULL)) {
#line 135 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			break;
#line 819 "alpm_octopi_utils.c"
		}
#line 136 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp6_ = list;
#line 136 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp7_ = _tmp6_->data;
#line 136 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		pkg = (alpm_pkg_t*) _tmp7_;
#line 137 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp8_ = pkg;
#line 137 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp9_ = alpm_pkg_compute_requiredby (_tmp8_);
#line 137 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		requiredby = _tmp9_;
#line 138 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp10_ = requiredby;
#line 138 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		if (alpm_list_count (_tmp10_) == ((gsize) 0)) {
#line 837 "alpm_octopi_utils.c"
			alpm_list_t* optionalfor = NULL;
			alpm_pkg_t* _tmp11_;
			alpm_list_t* _tmp12_;
			alpm_list_t* _tmp13_;
			alpm_list_t* _tmp15_;
#line 139 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp11_ = pkg;
#line 139 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp12_ = alpm_pkg_compute_optionalfor (_tmp11_);
#line 139 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			optionalfor = _tmp12_;
#line 140 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp13_ = optionalfor;
#line 140 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			if (alpm_list_count (_tmp13_) == ((gsize) 0)) {
#line 853 "alpm_octopi_utils.c"
				alpm_pkg_t* _tmp14_;
#line 141 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp14_ = pkg;
#line 141 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				results = alpm_list_add (results, _tmp14_);
#line 859 "alpm_octopi_utils.c"
			}
#line 143 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp15_ = optionalfor;
#line 143 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			alpm_list_free_inner (_tmp15_, _g_free_alpm_list_fn_free);
#line 138 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_alpm_list_free0 (optionalfor);
#line 867 "alpm_octopi_utils.c"
		}
#line 145 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp16_ = requiredby;
#line 145 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		alpm_list_free_inner (_tmp16_, _g_free_alpm_list_fn_free);
#line 146 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp17_ = list;
#line 146 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp18_ = _tmp17_->next;
#line 146 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		list = _tmp18_;
#line 135 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_alpm_list_free0 (requiredby);
#line 881 "alpm_octopi_utils.c"
	}
#line 148 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	result = results;
#line 148 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	return result;
#line 887 "alpm_octopi_utils.c"
}

alpm_list_t*
alpm_utils_get_foreign_pkgs (AlpmUtils* self)
{
	alpm_list_t* results = NULL;
	alpm_list_t* list = NULL;
	alpm_handle_t* _tmp0_;
	alpm_db_t* _tmp1_;
	alpm_db_t* _tmp2_;
	alpm_list_t* _tmp3_;
	alpm_list_t* _tmp4_;
	alpm_list_t* result;
#line 151 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 152 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	results = NULL;
#line 153 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp0_ = self->alpm_handle;
#line 153 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp1_ = alpm_get_localdb (_tmp0_);
#line 153 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp2_ = _tmp1_;
#line 153 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp3_ = alpm_db_get_pkgcache (_tmp2_);
#line 153 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp4_ = _tmp3_;
#line 153 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	list = _tmp4_;
#line 154 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	while (TRUE) {
#line 919 "alpm_octopi_utils.c"
		alpm_list_t* _tmp5_;
		alpm_pkg_t* pkg = NULL;
		alpm_list_t* _tmp6_;
		gconstpointer _tmp7_;
		alpm_pkg_t* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		alpm_pkg_t* _tmp11_;
		alpm_list_t* _tmp13_;
		alpm_list_t* _tmp14_;
#line 154 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp5_ = list;
#line 154 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		if (!(_tmp5_ != NULL)) {
#line 154 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			break;
#line 936 "alpm_octopi_utils.c"
		}
#line 155 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp6_ = list;
#line 155 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp7_ = _tmp6_->data;
#line 155 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		pkg = (alpm_pkg_t*) _tmp7_;
#line 156 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp8_ = pkg;
#line 156 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp9_ = alpm_pkg_get_name (_tmp8_);
#line 156 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp10_ = _tmp9_;
#line 156 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp11_ = alpm_utils_get_sync_pkg (self, _tmp10_);
#line 156 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		if (_tmp11_ == NULL) {
#line 954 "alpm_octopi_utils.c"
			alpm_pkg_t* _tmp12_;
#line 157 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp12_ = pkg;
#line 157 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			results = alpm_list_add (results, _tmp12_);
#line 960 "alpm_octopi_utils.c"
		}
#line 159 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp13_ = list;
#line 159 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp14_ = _tmp13_->next;
#line 159 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		list = _tmp14_;
#line 968 "alpm_octopi_utils.c"
	}
#line 161 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	result = results;
#line 161 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	return result;
#line 974 "alpm_octopi_utils.c"
}

alpm_list_t*
alpm_utils_get_repo_pkgs (AlpmUtils* self,
                          const gchar* repo_name)
{
	alpm_list_t* results = NULL;
	alpm_list_t* list = NULL;
	alpm_handle_t* _tmp0_;
	alpm_list_t* _tmp1_;
	alpm_list_t* _tmp2_;
	alpm_list_t* result;
#line 164 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 164 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (repo_name != NULL, NULL);
#line 165 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	results = NULL;
#line 166 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp0_ = self->alpm_handle;
#line 166 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp1_ = alpm_get_syncdbs (_tmp0_);
#line 166 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp2_ = _tmp1_;
#line 166 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	list = _tmp2_;
#line 167 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	while (TRUE) {
#line 1003 "alpm_octopi_utils.c"
		alpm_list_t* _tmp3_;
		alpm_db_t* db = NULL;
		alpm_list_t* _tmp4_;
		gconstpointer _tmp5_;
		alpm_db_t* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		alpm_list_t* _tmp27_;
		alpm_list_t* _tmp28_;
#line 167 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp3_ = list;
#line 167 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		if (!(_tmp3_ != NULL)) {
#line 167 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			break;
#line 1019 "alpm_octopi_utils.c"
		}
#line 168 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp4_ = list;
#line 168 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp5_ = _tmp4_->data;
#line 168 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		db = (alpm_db_t*) _tmp5_;
#line 169 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp6_ = db;
#line 169 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp7_ = alpm_db_get_name (_tmp6_);
#line 169 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp8_ = _tmp7_;
#line 169 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		if (g_strcmp0 (_tmp8_, repo_name) == 0) {
#line 1035 "alpm_octopi_utils.c"
			alpm_list_t* list2 = NULL;
			alpm_db_t* _tmp9_;
			alpm_list_t* _tmp10_;
			alpm_list_t* _tmp11_;
#line 170 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp9_ = db;
#line 170 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp10_ = alpm_db_get_pkgcache (_tmp9_);
#line 170 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp11_ = _tmp10_;
#line 170 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			list2 = _tmp11_;
#line 171 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			while (TRUE) {
#line 1050 "alpm_octopi_utils.c"
				alpm_list_t* _tmp12_;
				alpm_pkg_t* sync_pkg = NULL;
				alpm_list_t* _tmp13_;
				gconstpointer _tmp14_;
				alpm_pkg_t* local_pkg = NULL;
				alpm_handle_t* _tmp15_;
				alpm_db_t* _tmp16_;
				alpm_db_t* _tmp17_;
				alpm_pkg_t* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				alpm_pkg_t* _tmp21_;
				alpm_pkg_t* _tmp22_;
				alpm_list_t* _tmp25_;
				alpm_list_t* _tmp26_;
#line 171 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp12_ = list2;
#line 171 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				if (!(_tmp12_ != NULL)) {
#line 171 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
					break;
#line 1072 "alpm_octopi_utils.c"
				}
#line 172 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp13_ = list2;
#line 172 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp14_ = _tmp13_->data;
#line 172 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				sync_pkg = (alpm_pkg_t*) _tmp14_;
#line 173 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp15_ = self->alpm_handle;
#line 173 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp16_ = alpm_get_localdb (_tmp15_);
#line 173 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp17_ = _tmp16_;
#line 173 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp18_ = sync_pkg;
#line 173 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp19_ = alpm_pkg_get_name (_tmp18_);
#line 173 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp20_ = _tmp19_;
#line 173 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp21_ = alpm_db_get_pkg (_tmp17_, _tmp20_);
#line 173 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				local_pkg = _tmp21_;
#line 174 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp22_ = local_pkg;
#line 174 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				if (_tmp22_ != NULL) {
#line 1100 "alpm_octopi_utils.c"
					alpm_pkg_t* _tmp23_;
#line 175 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
					_tmp23_ = local_pkg;
#line 175 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
					results = alpm_list_add (results, _tmp23_);
#line 1106 "alpm_octopi_utils.c"
				} else {
					alpm_pkg_t* _tmp24_;
#line 177 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
					_tmp24_ = sync_pkg;
#line 177 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
					results = alpm_list_add (results, _tmp24_);
#line 1113 "alpm_octopi_utils.c"
				}
#line 179 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp25_ = list2;
#line 179 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp26_ = _tmp25_->next;
#line 179 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				list2 = _tmp26_;
#line 1121 "alpm_octopi_utils.c"
			}
		}
#line 182 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp27_ = list;
#line 182 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp28_ = _tmp27_->next;
#line 182 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		list = _tmp28_;
#line 1130 "alpm_octopi_utils.c"
	}
#line 184 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	result = results;
#line 184 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	return result;
#line 1136 "alpm_octopi_utils.c"
}

alpm_list_t*
alpm_utils_get_all_pkgs (AlpmUtils* self)
{
	alpm_list_t* syncpkgs = NULL;
	alpm_list_t* results = NULL;
	alpm_handle_t* _tmp0_;
	alpm_db_t* _tmp1_;
	alpm_db_t* _tmp2_;
	alpm_list_t* _tmp3_;
	alpm_list_t* _tmp4_;
	alpm_list_t* _tmp5_;
	alpm_list_t* list = NULL;
	alpm_handle_t* _tmp6_;
	alpm_list_t* _tmp7_;
	alpm_list_t* _tmp8_;
	alpm_list_t* _tmp24_;
	alpm_list_t* _tmp25_;
	alpm_list_t* _tmp26_;
	alpm_list_t* result;
#line 187 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 188 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	syncpkgs = NULL;
#line 189 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	results = NULL;
#line 190 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp0_ = self->alpm_handle;
#line 190 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp1_ = alpm_get_localdb (_tmp0_);
#line 190 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp2_ = _tmp1_;
#line 190 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp3_ = alpm_db_get_pkgcache (_tmp2_);
#line 190 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp4_ = _tmp3_;
#line 190 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp5_ = alpm_list_copy (_tmp4_);
#line 190 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_alpm_list_free0 (results);
#line 190 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	results = _tmp5_;
#line 191 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp6_ = self->alpm_handle;
#line 191 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp7_ = alpm_get_syncdbs (_tmp6_);
#line 191 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp8_ = _tmp7_;
#line 191 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	list = _tmp8_;
#line 192 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	while (TRUE) {
#line 1190 "alpm_octopi_utils.c"
		alpm_list_t* _tmp9_;
		alpm_db_t* db = NULL;
		alpm_list_t* _tmp10_;
		gconstpointer _tmp11_;
		alpm_list_t* _tmp12_;
		alpm_list_t* _tmp22_;
		alpm_list_t* _tmp23_;
#line 192 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp9_ = list;
#line 192 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		if (!(_tmp9_ != NULL)) {
#line 192 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			break;
#line 1204 "alpm_octopi_utils.c"
		}
#line 193 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp10_ = list;
#line 193 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp11_ = _tmp10_->data;
#line 193 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		db = (alpm_db_t*) _tmp11_;
#line 194 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp12_ = syncpkgs;
#line 194 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		if (alpm_list_count (_tmp12_) == ((gsize) 0)) {
#line 1216 "alpm_octopi_utils.c"
			alpm_db_t* _tmp13_;
			alpm_list_t* _tmp14_;
			alpm_list_t* _tmp15_;
			alpm_list_t* _tmp16_;
#line 195 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp13_ = db;
#line 195 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp14_ = alpm_db_get_pkgcache (_tmp13_);
#line 195 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp15_ = _tmp14_;
#line 195 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp16_ = alpm_list_copy (_tmp15_);
#line 195 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_alpm_list_free0 (syncpkgs);
#line 195 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			syncpkgs = _tmp16_;
#line 1233 "alpm_octopi_utils.c"
		} else {
			alpm_db_t* _tmp17_;
			alpm_list_t* _tmp18_;
			alpm_list_t* _tmp19_;
			alpm_list_t* _tmp20_;
			alpm_list_t* _tmp21_;
#line 197 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp17_ = db;
#line 197 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp18_ = alpm_db_get_pkgcache (_tmp17_);
#line 197 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp19_ = _tmp18_;
#line 197 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp20_ = syncpkgs;
#line 197 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp21_ = alpm_list_diff (_tmp19_, _tmp20_, (alpm_list_fn_cmp) alpm_pkg_compare_name);
#line 197 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			syncpkgs = alpm_list_join (syncpkgs, _tmp21_);
#line 1252 "alpm_octopi_utils.c"
		}
#line 199 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp22_ = list;
#line 199 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp23_ = _tmp22_->next;
#line 199 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		list = _tmp23_;
#line 1260 "alpm_octopi_utils.c"
	}
#line 201 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp24_ = syncpkgs;
#line 201 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp25_ = results;
#line 201 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp26_ = alpm_list_diff (_tmp24_, _tmp25_, (alpm_list_fn_cmp) alpm_pkg_compare_name);
#line 201 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	results = alpm_list_join (results, _tmp26_);
#line 203 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	result = results;
#line 203 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_alpm_list_free0 (syncpkgs);
#line 203 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	return result;
#line 1276 "alpm_octopi_utils.c"
}

alpm_list_t*
alpm_utils_get_updates (AlpmUtils* self)
{
	alpm_list_t* results = NULL;
	alpm_list_t* list = NULL;
	alpm_list_t* _tmp0_;
	alpm_list_t* _tmp21_;
	alpm_list_t* result;
#line 206 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 207 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	results = NULL;
#line 208 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp0_ = self->syncfirsts;
#line 208 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	list = _tmp0_;
#line 209 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	while (TRUE) {
#line 1297 "alpm_octopi_utils.c"
		alpm_list_t* _tmp1_;
		const gchar* name = NULL;
		alpm_list_t* _tmp2_;
		gconstpointer _tmp3_;
		alpm_pkg_t* pkg = NULL;
		alpm_handle_t* _tmp4_;
		alpm_db_t* _tmp5_;
		alpm_db_t* _tmp6_;
		alpm_list_t* _tmp7_;
		alpm_list_t* _tmp8_;
		const gchar* _tmp9_;
		alpm_pkg_t* _tmp10_;
		alpm_pkg_t* _tmp11_;
		alpm_list_t* _tmp19_;
		alpm_list_t* _tmp20_;
#line 209 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp1_ = list;
#line 209 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		if (!(_tmp1_ != NULL)) {
#line 209 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			break;
#line 1319 "alpm_octopi_utils.c"
		}
#line 210 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp2_ = list;
#line 210 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp3_ = _tmp2_->data;
#line 210 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		name = (const gchar*) _tmp3_;
#line 211 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp4_ = self->alpm_handle;
#line 211 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp5_ = alpm_get_localdb (_tmp4_);
#line 211 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp6_ = _tmp5_;
#line 211 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp7_ = alpm_db_get_pkgcache (_tmp6_);
#line 211 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp8_ = _tmp7_;
#line 211 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp9_ = name;
#line 211 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp10_ = alpm_find_satisfier (_tmp8_, _tmp9_);
#line 211 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		pkg = _tmp10_;
#line 212 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp11_ = pkg;
#line 212 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		if (_tmp11_ != NULL) {
#line 1347 "alpm_octopi_utils.c"
			alpm_pkg_t* candidate = NULL;
			alpm_pkg_t* _tmp12_;
			alpm_handle_t* _tmp13_;
			alpm_list_t* _tmp14_;
			alpm_list_t* _tmp15_;
			alpm_pkg_t* _tmp16_;
			alpm_pkg_t* _tmp17_;
#line 213 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp12_ = pkg;
#line 213 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp13_ = self->alpm_handle;
#line 213 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp14_ = alpm_get_syncdbs (_tmp13_);
#line 213 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp15_ = _tmp14_;
#line 213 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp16_ = alpm_sync_get_new_version (_tmp12_, _tmp15_);
#line 213 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			candidate = _tmp16_;
#line 214 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp17_ = candidate;
#line 214 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			if (_tmp17_ != NULL) {
#line 1371 "alpm_octopi_utils.c"
				alpm_pkg_t* _tmp18_;
#line 215 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp18_ = candidate;
#line 215 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				results = alpm_list_add (results, _tmp18_);
#line 1377 "alpm_octopi_utils.c"
			}
		}
#line 218 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp19_ = list;
#line 218 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp20_ = _tmp19_->next;
#line 218 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		list = _tmp20_;
#line 1386 "alpm_octopi_utils.c"
	}
#line 220 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_tmp21_ = results;
#line 220 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	if (alpm_list_count (_tmp21_) != ((gsize) 0)) {
#line 221 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		result = results;
#line 221 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		return result;
#line 1396 "alpm_octopi_utils.c"
	} else {
		alpm_list_t* list2 = NULL;
		alpm_handle_t* _tmp22_;
		alpm_db_t* _tmp23_;
		alpm_db_t* _tmp24_;
		alpm_list_t* _tmp25_;
		alpm_list_t* _tmp26_;
#line 223 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp22_ = self->alpm_handle;
#line 223 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp23_ = alpm_get_localdb (_tmp22_);
#line 223 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp24_ = _tmp23_;
#line 223 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp25_ = alpm_db_get_pkgcache (_tmp24_);
#line 223 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		_tmp26_ = _tmp25_;
#line 223 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		list2 = _tmp26_;
#line 224 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
		while (TRUE) {
#line 1418 "alpm_octopi_utils.c"
			alpm_list_t* _tmp27_;
			alpm_pkg_t* installed_pkg = NULL;
			alpm_list_t* _tmp28_;
			gconstpointer _tmp29_;
			alpm_handle_t* _tmp30_;
			alpm_pkg_t* _tmp31_;
			alpm_list_t* _tmp39_;
			alpm_list_t* _tmp40_;
#line 224 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp27_ = list2;
#line 224 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			if (!(_tmp27_ != NULL)) {
#line 224 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				break;
#line 1433 "alpm_octopi_utils.c"
			}
#line 225 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp28_ = list2;
#line 225 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp29_ = _tmp28_->data;
#line 225 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			installed_pkg = (alpm_pkg_t*) _tmp29_;
#line 227 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp30_ = self->alpm_handle;
#line 227 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp31_ = installed_pkg;
#line 227 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			if (alpm_pkg_should_ignore (_tmp30_, _tmp31_) == 0) {
#line 1447 "alpm_octopi_utils.c"
				alpm_pkg_t* candidate = NULL;
				alpm_pkg_t* _tmp32_;
				alpm_handle_t* _tmp33_;
				alpm_list_t* _tmp34_;
				alpm_list_t* _tmp35_;
				alpm_pkg_t* _tmp36_;
				alpm_pkg_t* _tmp37_;
#line 228 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp32_ = installed_pkg;
#line 228 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp33_ = self->alpm_handle;
#line 228 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp34_ = alpm_get_syncdbs (_tmp33_);
#line 228 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp35_ = _tmp34_;
#line 228 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp36_ = alpm_sync_get_new_version (_tmp32_, _tmp35_);
#line 228 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				candidate = _tmp36_;
#line 229 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				_tmp37_ = candidate;
#line 229 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
				if (_tmp37_ != NULL) {
#line 1471 "alpm_octopi_utils.c"
					alpm_pkg_t* _tmp38_;
#line 230 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
					_tmp38_ = candidate;
#line 230 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
					results = alpm_list_add (results, _tmp38_);
#line 1477 "alpm_octopi_utils.c"
				}
			}
#line 233 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp39_ = list2;
#line 233 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			_tmp40_ = _tmp39_->next;
#line 233 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
			list2 = _tmp40_;
#line 1486 "alpm_octopi_utils.c"
		}
	}
#line 236 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	result = results;
#line 236 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	return result;
#line 1493 "alpm_octopi_utils.c"
}

static void
alpm_utils_instance_init (AlpmUtils * self)
{
}

void
alpm_utils_free (AlpmUtils * self)
{
#line 27 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_g_free0 (self->conf_file_path);
#line 28 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_alpm_release0 (self->alpm_handle);
#line 29 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_alpm_list_free0 (self->holdpkgs);
#line 30 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	_alpm_list_free0 (self->syncfirsts);
#line 26 "/build/alpm_octopi_utils/src/alpm_octopi_utils/src/alpm_octopi_utils.vala"
	g_slice_free (AlpmUtils, self);
#line 1514 "alpm_octopi_utils.c"
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

