/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.builder.instruction;

import com.android.tools.smali.dexlib2.Format;
import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.builder.BuilderInstruction;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction45cc;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import com.android.tools.smali.dexlib2.util.Preconditions;

public final class BuilderInstruction45cc
extends BuilderInstruction
implements Instruction45cc {
    public final int registerCount;
    public final int registerC;
    public final int registerD;
    public final int registerE;
    public final int registerF;
    public final int registerG;
    public final Reference reference;
    public final Reference reference2;

    public BuilderInstruction45cc(Opcode opcode, int n, int n2, int n3, int n4, int n5, int n6, Reference reference, Reference reference2) {
        super(opcode);
        this.registerCount = Preconditions.check35cAnd45ccRegisterCount(n);
        int n7 = n > 0 ? Preconditions.checkNibbleRegister(n2) : 0;
        this.registerC = n7;
        n7 = n > 1 ? Preconditions.checkNibbleRegister(n3) : 0;
        this.registerD = n7;
        n7 = n > 2 ? Preconditions.checkNibbleRegister(n4) : 0;
        this.registerE = n7;
        n7 = n > 3 ? Preconditions.checkNibbleRegister(n5) : 0;
        this.registerF = n7;
        n7 = n > 4 ? Preconditions.checkNibbleRegister(n6) : 0;
        BuilderInstruction45cc builderInstruction45cc = this;
        builderInstruction45cc.registerG = n7;
        builderInstruction45cc.reference = reference;
        builderInstruction45cc.reference2 = reference2;
    }

    @Override
    public final int getRegisterCount() {
        return this.registerCount;
    }

    @Override
    public final int getRegisterC() {
        return this.registerC;
    }

    @Override
    public final int getRegisterD() {
        return this.registerD;
    }

    @Override
    public final int getRegisterE() {
        return this.registerE;
    }

    @Override
    public final int getRegisterF() {
        return this.registerF;
    }

    @Override
    public final int getRegisterG() {
        return this.registerG;
    }

    @Override
    public final Reference getReference() {
        return this.reference;
    }

    @Override
    public final int getReferenceType() {
        return this.opcode.referenceType;
    }

    @Override
    public final Reference getReference2() {
        return this.reference2;
    }

    @Override
    public final int getReferenceType2() {
        return this.opcode.referenceType2;
    }

    @Override
    public final Format getFormat() {
        return Format.Format45cc;
    }
}

