/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jf.dexlib2.iface.reference.CallSiteReference;
import org.jf.dexlib2.writer.CallSiteSection;
import org.jf.dexlib2.writer.builder.BaseBuilderPool;
import org.jf.dexlib2.writer.builder.BuilderCallSiteReference;
import org.jf.dexlib2.writer.builder.BuilderEncodedArrayPool;
import org.jf.dexlib2.writer.builder.BuilderEncodedValues;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.dexlib2.writer.util.CallSiteUtil;

public class BuilderCallSitePool
extends BaseBuilderPool
implements CallSiteSection<BuilderCallSiteReference, BuilderEncodedValues.BuilderArrayEncodedValue> {
    private final ConcurrentMap<CallSiteReference, BuilderCallSiteReference> internedItems = Maps.newConcurrentMap();

    public BuilderCallSitePool(DexBuilder dexBuilder) {
        super(dexBuilder);
    }

    public BuilderCallSiteReference internCallSite(CallSiteReference callSiteReference) {
        BuilderCallSiteReference internedCallSite = (BuilderCallSiteReference)this.internedItems.get(callSiteReference);
        if (internedCallSite != null) {
            return internedCallSite;
        }
        BuilderEncodedValues.BuilderArrayEncodedValue encodedCallSite = ((BuilderEncodedArrayPool)this.dexBuilder.encodedArraySection).internArrayEncodedValue(CallSiteUtil.getEncodedCallSite(callSiteReference));
        internedCallSite = new BuilderCallSiteReference(callSiteReference.getName(), encodedCallSite);
        BuilderCallSiteReference existing = this.internedItems.putIfAbsent(internedCallSite, internedCallSite);
        return existing == null ? internedCallSite : existing;
    }

    @Override
    public BuilderEncodedValues.BuilderArrayEncodedValue getEncodedCallSite(BuilderCallSiteReference callSiteReference) {
        return callSiteReference.encodedCallSite;
    }

    @Override
    public int getItemIndex(BuilderCallSiteReference builderCallSite) {
        return builderCallSite.index;
    }

    @Override
    public Collection<? extends Map.Entry<? extends BuilderCallSiteReference, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderCallSiteReference>(this.internedItems.values()){

            @Override
            protected int getValue(BuilderCallSiteReference builderCallSiteReference) {
                return builderCallSiteReference.index;
            }

            @Override
            protected int setValue(BuilderCallSiteReference builderCallSiteReference, int value) {
                int prev = builderCallSiteReference.index;
                builderCallSiteReference.index = value;
                return prev;
            }
        };
    }

    @Override
    public int getItemCount() {
        return this.internedItems.size();
    }
}

