/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder.instruction;

import org.jf.dexlib2.Format;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rms;
import org.jf.dexlib2.util.Preconditions;

public class BuilderInstruction3rms
extends BuilderInstruction
implements Instruction3rms {
    public static final Format FORMAT = Format.Format3rms;
    protected final int startRegister;
    protected final int registerCount;
    protected final int vtableIndex;

    public BuilderInstruction3rms(Opcode opcode, int startRegister, int registerCount, int vtableIndex) {
        super(opcode);
        this.startRegister = Preconditions.checkShortRegister(startRegister);
        this.registerCount = Preconditions.checkRegisterRangeCount(registerCount);
        this.vtableIndex = vtableIndex;
    }

    @Override
    public int getStartRegister() {
        return this.startRegister;
    }

    @Override
    public int getRegisterCount() {
        return this.registerCount;
    }

    @Override
    public int getVtableIndex() {
        return this.vtableIndex;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

