/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import java.util.logging.Logger;

public class ResConfigFlags {
    public final short mcc;
    public final short mnc;
    public final char[] language;
    public final char[] region;
    public final byte orientation;
    public final byte touchscreen;
    public final int density;
    public final byte keyboard;
    public final byte navigation;
    public final byte inputFlags;
    public final short screenWidth;
    public final short screenHeight;
    public final short sdkVersion;
    public final byte screenLayout;
    public final byte uiMode;
    public final short smallestScreenWidthDp;
    public final short screenWidthDp;
    public final short screenHeightDp;
    private final char[] localeScript;
    private final char[] localeVariant;
    private final byte screenLayout2;
    private final byte colorMode;
    public final boolean isInvalid;
    private final String mQualifiers;
    private final int size;
    private static int sErrCounter = 0;
    private static final Logger LOGGER = Logger.getLogger(ResConfigFlags.class.getName());

    public ResConfigFlags() {
        this.mcc = 0;
        this.mnc = 0;
        this.language = new char[]{'\u0000', '\u0000'};
        this.region = new char[]{'\u0000', '\u0000'};
        this.orientation = 0;
        this.touchscreen = 0;
        this.density = 0;
        this.keyboard = 0;
        this.navigation = 0;
        this.inputFlags = 0;
        this.screenWidth = 0;
        this.screenHeight = 0;
        this.sdkVersion = 0;
        this.screenLayout = 0;
        this.uiMode = 0;
        this.smallestScreenWidthDp = 0;
        this.screenWidthDp = 0;
        this.screenHeightDp = 0;
        this.localeScript = null;
        this.localeVariant = null;
        this.screenLayout2 = 0;
        this.colorMode = 0;
        this.isInvalid = false;
        this.mQualifiers = "";
        this.size = 0;
    }

    public ResConfigFlags(short mcc, short mnc, char[] language, char[] region, byte orientation, byte touchscreen, int density, byte keyboard, byte navigation, byte inputFlags, short screenWidth, short screenHeight, short sdkVersion, byte screenLayout, byte uiMode, short smallestScreenWidthDp, short screenWidthDp, short screenHeightDp, char[] localeScript, char[] localeVariant, byte screenLayout2, byte colorMode, boolean isInvalid, int size) {
        if (orientation < 0 || orientation > 3) {
            LOGGER.warning("Invalid orientation value: " + orientation);
            orientation = 0;
            isInvalid = true;
        }
        if (touchscreen < 0 || touchscreen > 3) {
            LOGGER.warning("Invalid touchscreen value: " + touchscreen);
            touchscreen = 0;
            isInvalid = true;
        }
        if (density < -1) {
            LOGGER.warning("Invalid density value: " + density);
            density = 0;
            isInvalid = true;
        }
        if (keyboard < 0 || keyboard > 3) {
            LOGGER.warning("Invalid keyboard value: " + keyboard);
            keyboard = 0;
            isInvalid = true;
        }
        if (navigation < 0 || navigation > 4) {
            LOGGER.warning("Invalid navigation value: " + navigation);
            navigation = 0;
            isInvalid = true;
        }
        if (localeScript != null && localeScript.length != 0) {
            if (localeScript[0] == '\u0000') {
                localeScript = null;
            }
        } else {
            localeScript = null;
        }
        if (localeVariant != null && localeVariant.length != 0) {
            if (localeVariant[0] == '\u0000') {
                localeVariant = null;
            }
        } else {
            localeVariant = null;
        }
        this.mcc = mcc;
        this.mnc = mnc;
        this.language = language;
        this.region = region;
        this.orientation = orientation;
        this.touchscreen = touchscreen;
        this.density = density;
        this.keyboard = keyboard;
        this.navigation = navigation;
        this.inputFlags = inputFlags;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.sdkVersion = sdkVersion;
        this.screenLayout = screenLayout;
        this.uiMode = uiMode;
        this.smallestScreenWidthDp = smallestScreenWidthDp;
        this.screenWidthDp = screenWidthDp;
        this.screenHeightDp = screenHeightDp;
        this.localeScript = localeScript;
        this.localeVariant = localeVariant;
        this.screenLayout2 = screenLayout2;
        this.colorMode = colorMode;
        this.isInvalid = isInvalid;
        this.size = size;
        this.mQualifiers = this.generateQualifiers();
    }

    public String getQualifiers() {
        return this.mQualifiers;
    }

    private String generateQualifiers() {
        StringBuilder ret = new StringBuilder();
        if (this.mcc != 0) {
            ret.append("-mcc").append(String.format("%03d", this.mcc));
            if (this.mnc != -1) {
                if (this.mnc != 0) {
                    ret.append("-mnc");
                    if (this.size <= 32) {
                        if (this.mnc > 0 && this.mnc < 10) {
                            ret.append(String.format("%02d", this.mnc));
                        } else {
                            ret.append(String.format("%03d", this.mnc));
                        }
                    } else {
                        ret.append(this.mnc);
                    }
                }
            } else {
                ret.append("-mnc00");
            }
        } else if (this.mnc != 0) {
            ret.append("-mnc").append(this.mnc);
        }
        ret.append(this.getLocaleString());
        switch (this.screenLayout & 0xC0) {
            case 128: {
                ret.append("-ldrtl");
                break;
            }
            case 64: {
                ret.append("-ldltr");
            }
        }
        if (this.smallestScreenWidthDp != 0) {
            ret.append("-sw").append(this.smallestScreenWidthDp).append("dp");
        }
        if (this.screenWidthDp != 0) {
            ret.append("-w").append(this.screenWidthDp).append("dp");
        }
        if (this.screenHeightDp != 0) {
            ret.append("-h").append(this.screenHeightDp).append("dp");
        }
        switch (this.screenLayout & 0xF) {
            case 1: {
                ret.append("-small");
                break;
            }
            case 2: {
                ret.append("-normal");
                break;
            }
            case 3: {
                ret.append("-large");
                break;
            }
            case 4: {
                ret.append("-xlarge");
            }
        }
        switch (this.screenLayout & 0x30) {
            case 32: {
                ret.append("-long");
                break;
            }
            case 16: {
                ret.append("-notlong");
            }
        }
        switch (this.screenLayout2 & 3) {
            case 1: {
                ret.append("-notround");
                break;
            }
            case 2: {
                ret.append("-round");
            }
        }
        switch (this.colorMode & 0xC) {
            case 8: {
                ret.append("-highdr");
                break;
            }
            case 4: {
                ret.append("-lowdr");
            }
        }
        switch (this.colorMode & 3) {
            case 2: {
                ret.append("-widecg");
                break;
            }
            case 1: {
                ret.append("-nowidecg");
            }
        }
        switch (this.orientation) {
            case 1: {
                ret.append("-port");
                break;
            }
            case 2: {
                ret.append("-land");
                break;
            }
            case 3: {
                ret.append("-square");
            }
        }
        switch (this.uiMode & 0xF) {
            case 3: {
                ret.append("-car");
                break;
            }
            case 2: {
                ret.append("-desk");
                break;
            }
            case 4: {
                ret.append("-television");
                break;
            }
            case 12: {
                ret.append("-smallui");
                break;
            }
            case 13: {
                ret.append("-mediumui");
                break;
            }
            case 14: {
                ret.append("-largeui");
                break;
            }
            case 11: {
                ret.append("-godzillaui");
                break;
            }
            case 15: {
                ret.append("-hugeui");
                break;
            }
            case 5: {
                ret.append("-appliance");
                break;
            }
            case 6: {
                ret.append("-watch");
                break;
            }
            case 7: {
                ret.append("-vrheadset");
            }
        }
        switch (this.uiMode & 0x30) {
            case 32: {
                ret.append("-night");
                break;
            }
            case 16: {
                ret.append("-notnight");
            }
        }
        switch (this.density) {
            case 0: {
                break;
            }
            case 120: {
                ret.append("-ldpi");
                break;
            }
            case 160: {
                ret.append("-mdpi");
                break;
            }
            case 240: {
                ret.append("-hdpi");
                break;
            }
            case 213: {
                ret.append("-tvdpi");
                break;
            }
            case 320: {
                ret.append("-xhdpi");
                break;
            }
            case 480: {
                ret.append("-xxhdpi");
                break;
            }
            case 640: {
                ret.append("-xxxhdpi");
                break;
            }
            case 65534: {
                ret.append("-anydpi");
                break;
            }
            case 65535: {
                ret.append("-nodpi");
                break;
            }
            default: {
                ret.append('-').append(this.density).append("dpi");
            }
        }
        switch (this.touchscreen) {
            case 1: {
                ret.append("-notouch");
                break;
            }
            case 2: {
                ret.append("-stylus");
                break;
            }
            case 3: {
                ret.append("-finger");
            }
        }
        switch (this.inputFlags & 3) {
            case 1: {
                ret.append("-keysexposed");
                break;
            }
            case 2: {
                ret.append("-keyshidden");
                break;
            }
            case 3: {
                ret.append("-keyssoft");
            }
        }
        switch (this.keyboard) {
            case 1: {
                ret.append("-nokeys");
                break;
            }
            case 2: {
                ret.append("-qwerty");
                break;
            }
            case 3: {
                ret.append("-12key");
            }
        }
        switch (this.inputFlags & 0xC) {
            case 4: {
                ret.append("-navexposed");
                break;
            }
            case 8: {
                ret.append("-navhidden");
            }
        }
        switch (this.navigation) {
            case 1: {
                ret.append("-nonav");
                break;
            }
            case 2: {
                ret.append("-dpad");
                break;
            }
            case 3: {
                ret.append("-trackball");
                break;
            }
            case 4: {
                ret.append("-wheel");
            }
        }
        if (this.screenWidth != 0 && this.screenHeight != 0) {
            if (this.screenWidth > this.screenHeight) {
                ret.append(String.format("-%dx%d", this.screenWidth, this.screenHeight));
            } else {
                ret.append(String.format("-%dx%d", this.screenHeight, this.screenWidth));
            }
        }
        if (this.sdkVersion > 0 && this.sdkVersion >= this.getNaturalSdkVersionRequirement()) {
            ret.append("-v").append(this.sdkVersion);
        }
        if (this.isInvalid) {
            ret.append("-ERR").append(sErrCounter++);
        }
        return ret.toString();
    }

    private short getNaturalSdkVersionRequirement() {
        if ((this.uiMode & 0xF) == 7 || (this.colorMode & 3) != 0 || (this.colorMode & 0xC) != 0) {
            return 26;
        }
        if ((this.screenLayout2 & 3) != 0) {
            return 23;
        }
        if (this.density == 65534) {
            return 21;
        }
        if (this.smallestScreenWidthDp != 0 || this.screenWidthDp != 0 || this.screenHeightDp != 0) {
            return 13;
        }
        if ((this.uiMode & 0x3F) != 0) {
            return 8;
        }
        if ((this.screenLayout & 0x3F) != 0 || this.density != 0) {
            return 4;
        }
        return 0;
    }

    private String getLocaleString() {
        StringBuilder sb = new StringBuilder();
        if (this.localeVariant == null && this.localeScript == null && (this.region[0] != '\u0000' || this.language[0] != '\u0000') && this.region.length != 3) {
            sb.append("-").append(this.language);
            if (this.region[0] != '\u0000') {
                sb.append("-r").append(this.region);
            }
        } else {
            if (this.language[0] == '\u0000' && this.region[0] == '\u0000') {
                return sb.toString();
            }
            sb.append("-b+");
            if (this.language[0] != '\u0000') {
                sb.append(this.language);
            }
            if (this.localeScript != null && this.localeScript.length == 4) {
                sb.append("+").append(this.localeScript);
            }
            if ((this.region.length == 2 || this.region.length == 3) && this.region[0] != '\u0000') {
                sb.append("+").append(this.region);
            }
            if (this.localeVariant != null && this.localeVariant.length >= 5) {
                sb.append("+").append(this.toUpper(this.localeVariant));
            }
        }
        return sb.toString();
    }

    private String toUpper(char[] character) {
        StringBuilder sb = new StringBuilder();
        for (char ch : character) {
            sb.append(Character.toUpperCase(ch));
        }
        return sb.toString();
    }

    public String toString() {
        return !this.getQualifiers().equals("") ? this.getQualifiers() : "[DEFAULT]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResConfigFlags other = (ResConfigFlags)obj;
        return this.mQualifiers.equals(other.mQualifiers);
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.mQualifiers.hashCode();
        return hash;
    }
}

