/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import com.android.tools.smali.baksmali.Main;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;

public class ApktoolProperties {
    private static Properties sProps;
    private static final Logger LOGGER;

    public static String get(String key) {
        return ApktoolProperties.get().getProperty(key);
    }

    public static Properties get() {
        if (sProps == null) {
            ApktoolProperties.loadProps();
        }
        return sProps;
    }

    private static void loadProps() {
        InputStream in = ApktoolProperties.class.getResourceAsStream("/properties/apktool.properties");
        sProps = new Properties();
        try {
            sProps.load(in);
            in.close();
        }
        catch (IOException ex) {
            LOGGER.warning("Can't load properties.");
        }
        InputStream templateStream = null;
        try {
            templateStream = Main.class.getClassLoader().getResourceAsStream("baksmali.properties");
        }
        catch (NoClassDefFoundError ex) {
            LOGGER.warning("Can't load baksmali properties.");
        }
        Properties properties = new Properties();
        String version = "(unknown)";
        if (templateStream != null) {
            try {
                properties.load(templateStream);
                version = properties.getProperty("application.version");
                templateStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        sProps.put("baksmaliVersion", version);
        templateStream = null;
        try {
            templateStream = com.android.tools.smali.smali.Main.class.getClassLoader().getResourceAsStream("smali.properties");
        }
        catch (NoClassDefFoundError ex) {
            LOGGER.warning("Can't load smali properties.");
        }
        properties = new Properties();
        version = "(unknown)";
        if (templateStream != null) {
            try {
                properties.load(templateStream);
                version = properties.getProperty("application.version");
                templateStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        sProps.put("smaliVersion", version);
    }

    static {
        LOGGER = Logger.getLogger(ApktoolProperties.class.getName());
    }
}

