/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.common.BrutException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class OS {
    private static final Logger LOGGER = Logger.getLogger("");

    public static void rmdir(File dir) throws BrutException {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                OS.rmdir(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    public static void cpdir(File src, File dest) throws BrutException {
        dest.mkdirs();
        File[] files = src.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            File destFile = new File(dest.getPath() + File.separatorChar + file.getName());
            if (file.isDirectory()) {
                OS.cpdir(file, destFile);
                continue;
            }
            try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
                 OutputStream out = Files.newOutputStream(destFile.toPath(), new OpenOption[0]);){
                IOUtils.copy(in, out);
            }
            catch (IOException ex) {
                throw new BrutException("Could not copy file: " + file, ex);
            }
        }
    }

    public static void exec(String[] cmd) throws BrutException {
        try {
            ProcessBuilder builder = new ProcessBuilder(cmd);
            Process ps = builder.start();
            new StreamForwarder(ps.getErrorStream(), "ERROR").start();
            new StreamForwarder(ps.getInputStream(), "OUTPUT").start();
            int exitValue = ps.waitFor();
            if (exitValue != 0) {
                throw new BrutException("could not exec (exit code = " + exitValue + "): " + Arrays.toString(cmd));
            }
        }
        catch (IOException ex) {
            throw new BrutException("could not exec: " + Arrays.toString(cmd), ex);
        }
        catch (InterruptedException ex) {
            throw new BrutException("could not exec : " + Arrays.toString(cmd), ex);
        }
    }

    public static String execAndReturn(String[] cmd) {
        ExecutorService executor = Executors.newCachedThreadPool();
        try {
            ProcessBuilder builder = new ProcessBuilder(cmd);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            StreamCollector collector = new StreamCollector(process.getInputStream());
            executor.execute(collector);
            process.waitFor();
            if (!executor.awaitTermination(15L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
                if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    System.err.println("Stream collector did not terminate.");
                }
            }
            return collector.get();
        }
        catch (IOException | InterruptedException e) {
            return null;
        }
    }

    static class StreamCollector
    implements Runnable {
        private final StringBuilder buffer = new StringBuilder();
        private final InputStream inputStream;

        public StreamCollector(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void run() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.buffer.append(line).append('\n');
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String get() {
            return this.buffer.toString();
        }
    }

    static class StreamForwarder
    extends Thread {
        private final InputStream mIn;
        private final String mType;

        StreamForwarder(InputStream is, String type) {
            this.mIn = is;
            this.mType = type;
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.mIn));
                while ((line = br.readLine()) != null) {
                    if (this.mType.equals("OUTPUT")) {
                        LOGGER.info(line);
                        continue;
                    }
                    LOGGER.warning(line);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

