/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.meta;

import brut.androlib.meta.MetaInfo;
import brut.androlib.meta.PackageInfo;
import brut.androlib.meta.UsesFramework;
import brut.androlib.meta.VersionInfo;
import brut.androlib.meta.YamlStringEscapeUtils;
import java.util.ArrayList;
import java.util.List;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class ClassSafeConstructor
extends Constructor {
    protected final List<Class<?>> allowableClasses = new ArrayList();

    public ClassSafeConstructor() {
        super(new LoaderOptions());
        this.yamlConstructors.put(Tag.STR, new ConstructStringEx());
        this.allowableClasses.add(MetaInfo.class);
        this.allowableClasses.add(PackageInfo.class);
        this.allowableClasses.add(UsesFramework.class);
        this.allowableClasses.add(VersionInfo.class);
    }

    @Override
    protected Object newInstance(Node node) {
        if (this.yamlConstructors.containsKey(node.getTag()) || this.allowableClasses.contains(node.getType())) {
            return super.newInstance(node);
        }
        throw new YAMLException("Invalid Class attempting to be constructed: " + node.getTag());
    }

    @Override
    protected Object finalizeConstruction(Node node, Object data) {
        if (this.yamlConstructors.containsKey(node.getTag()) || this.allowableClasses.contains(node.getType())) {
            return super.finalizeConstruction(node, data);
        }
        return this.newInstance(node);
    }

    private class ConstructStringEx
    extends AbstractConstruct {
        private ConstructStringEx() {
        }

        @Override
        public Object construct(Node node) {
            String val = ClassSafeConstructor.this.constructScalar((ScalarNode)node);
            return YamlStringEscapeUtils.unescapeString(val);
        }
    }
}

