/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.Androlib;
import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.InFileNotFoundException;
import brut.androlib.exceptions.OutDirExistsException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.meta.MetaInfo;
import brut.androlib.meta.PackageInfo;
import brut.androlib.meta.UsesFramework;
import brut.androlib.meta.VersionInfo;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.xml.ResXmlPatcher;
import brut.common.BrutException;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.util.OS;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ApkDecoder {
    private static final Logger LOGGER = Logger.getLogger(ApkDecoder.class.getName());
    private final Config config;
    private final Androlib mAndrolib;
    private final ExtFile mApkFile;
    private File mOutDir;
    private ResTable mResTable;
    private Collection<String> mUncompressedFiles;

    public ApkDecoder(Config config, ExtFile apkFile) {
        this.config = config;
        this.mAndrolib = new Androlib(config);
        this.mApkFile = apkFile;
    }

    public void setOutDir(File outDir) {
        this.mOutDir = outDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode() throws AndrolibException, IOException, DirectoryException {
        try {
            File outDir = this.getOutDir();
            if (!this.config.forceDelete && outDir.exists()) {
                throw new OutDirExistsException();
            }
            if (!this.mApkFile.isFile() || !this.mApkFile.canRead()) {
                throw new InFileNotFoundException();
            }
            try {
                OS.rmdir(outDir);
            }
            catch (BrutException ex) {
                throw new AndrolibException(ex);
            }
            outDir.mkdirs();
            LOGGER.info("Using Apktool " + Androlib.getVersion() + " on " + this.mApkFile.getName());
            if (this.hasResources()) {
                switch (this.config.decodeResources) {
                    case 256: {
                        this.mAndrolib.decodeResourcesRaw(this.mApkFile, outDir);
                        if (this.config.forceDecodeManifest != 1 || !this.hasManifest()) break;
                        this.mAndrolib.decodeManifestWithResources(this.mApkFile, outDir, this.getResTable());
                        break;
                    }
                    case 257: {
                        if (this.hasManifest()) {
                            this.mAndrolib.decodeManifestWithResources(this.mApkFile, outDir, this.getResTable());
                        }
                        this.mAndrolib.decodeResourcesFull(this.mApkFile, outDir, this.getResTable());
                    }
                }
            } else if (this.hasManifest()) {
                if (this.config.decodeResources == 257 || this.config.forceDecodeManifest == 1) {
                    this.mAndrolib.decodeManifestFull(this.mApkFile, outDir, this.getResTable());
                } else {
                    this.mAndrolib.decodeManifestRaw(this.mApkFile, outDir);
                }
            }
            if (this.hasSources()) {
                switch (this.config.decodeSources) {
                    case 0: {
                        this.mAndrolib.decodeSourcesRaw(this.mApkFile, outDir, "classes.dex");
                        break;
                    }
                    case 1: 
                    case 16: {
                        this.mAndrolib.decodeSourcesSmali(this.mApkFile, outDir, "classes.dex");
                    }
                }
            }
            if (this.hasMultipleSources()) {
                Set<String> files = this.mApkFile.getDirectory().getFiles(true);
                for (String file : files) {
                    if (!file.endsWith(".dex") || file.equalsIgnoreCase("classes.dex")) continue;
                    switch (this.config.decodeSources) {
                        case 0: {
                            this.mAndrolib.decodeSourcesRaw(this.mApkFile, outDir, file);
                            break;
                        }
                        case 1: {
                            this.mAndrolib.decodeSourcesSmali(this.mApkFile, outDir, file);
                            break;
                        }
                        case 16: {
                            if (file.startsWith("classes") && file.endsWith(".dex")) {
                                this.mAndrolib.decodeSourcesSmali(this.mApkFile, outDir, file);
                                break;
                            }
                            this.mAndrolib.decodeSourcesRaw(this.mApkFile, outDir, file);
                        }
                    }
                }
            }
            this.mAndrolib.decodeRawFiles(this.mApkFile, outDir);
            this.mAndrolib.decodeUnknownFiles(this.mApkFile, outDir);
            this.mUncompressedFiles = new ArrayList<String>();
            this.mAndrolib.recordUncompressedFiles(this.mApkFile, this.mUncompressedFiles);
            this.mAndrolib.writeOriginalFiles(this.mApkFile, outDir);
            this.writeMetaFile();
        }
        finally {
            try {
                this.mApkFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public ResTable getResTable() throws AndrolibException {
        if (this.mResTable == null) {
            boolean hasResources = this.hasResources();
            boolean hasManifest = this.hasManifest();
            if (!hasManifest && !hasResources) {
                throw new AndrolibException("Apk doesn't contain either AndroidManifest.xml file or resources.arsc file");
            }
            this.mResTable = this.mAndrolib.getResTable(this.mApkFile, hasResources);
            this.mResTable.setAnalysisMode(this.config.analysisMode);
        }
        return this.mResTable;
    }

    public boolean hasSources() throws AndrolibException {
        try {
            return this.mApkFile.getDirectory().containsFile("classes.dex");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean hasMultipleSources() throws AndrolibException {
        try {
            Set<String> files = this.mApkFile.getDirectory().getFiles(false);
            for (String file : files) {
                if (!file.endsWith(".dex") || file.equalsIgnoreCase("classes.dex")) continue;
                return true;
            }
            return false;
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean hasManifest() throws AndrolibException {
        try {
            return this.mApkFile.getDirectory().containsFile("AndroidManifest.xml");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean hasResources() throws AndrolibException {
        try {
            return this.mApkFile.getDirectory().containsFile("resources.arsc");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void close() throws IOException {
        if (this.mAndrolib != null) {
            this.mAndrolib.close();
        }
    }

    private File getOutDir() throws AndrolibException {
        if (this.mOutDir == null) {
            throw new AndrolibException("Out dir not set");
        }
        return this.mOutDir;
    }

    private void writeMetaFile() throws AndrolibException {
        MetaInfo meta = new MetaInfo();
        meta.version = Androlib.getVersion();
        meta.apkFileName = this.mApkFile.getName();
        if (this.mResTable != null) {
            meta.isFrameworkApk = this.mAndrolib.isFrameworkApk(this.mResTable);
            this.putUsesFramework(meta);
            this.putSdkInfo(meta);
            this.putPackageInfo(meta);
            this.putVersionInfo(meta);
            this.putSharedLibraryInfo(meta);
            this.putSparseResourcesInfo(meta);
        } else {
            this.putMinSdkInfo(meta);
        }
        this.putUnknownInfo(meta);
        this.putFileCompressionInfo(meta);
        this.mAndrolib.writeMetaFile(this.mOutDir, meta);
    }

    private void putUsesFramework(MetaInfo meta) {
        Set<ResPackage> pkgs = this.mResTable.listFramePackages();
        if (pkgs.isEmpty()) {
            return;
        }
        Object[] ids = new Integer[pkgs.size()];
        int i = 0;
        for (ResPackage pkg : pkgs) {
            ids[i++] = pkg.getId();
        }
        Arrays.sort(ids);
        meta.usesFramework = new UsesFramework();
        meta.usesFramework.ids = Arrays.asList(ids);
        if (this.config.frameworkTag != null) {
            meta.usesFramework.tag = this.config.frameworkTag;
        }
    }

    private void putSdkInfo(MetaInfo meta) {
        Map<String, String> info = this.mResTable.getSdkInfo();
        if (info.size() > 0) {
            String refValue;
            if (info.get("minSdkVersion") != null && (refValue = ResXmlPatcher.pullValueFromIntegers(this.mOutDir, info.get("minSdkVersion"))) != null) {
                info.put("minSdkVersion", refValue);
            }
            if (info.get("targetSdkVersion") != null && (refValue = ResXmlPatcher.pullValueFromIntegers(this.mOutDir, info.get("targetSdkVersion"))) != null) {
                info.put("targetSdkVersion", refValue);
            }
            if (info.get("maxSdkVersion") != null && (refValue = ResXmlPatcher.pullValueFromIntegers(this.mOutDir, info.get("maxSdkVersion"))) != null) {
                info.put("maxSdkVersion", refValue);
            }
            meta.sdkInfo = info;
        }
    }

    private void putMinSdkInfo(MetaInfo meta) {
        int minSdkVersion = this.mAndrolib.getMinSdkVersion();
        if (minSdkVersion > 0) {
            LinkedHashMap<String, String> sdkInfo = new LinkedHashMap<String, String>();
            sdkInfo.put("minSdkVersion", Integer.toString(minSdkVersion));
            meta.sdkInfo = sdkInfo;
        }
    }

    private void putPackageInfo(MetaInfo meta) throws AndrolibException {
        String renamed = this.mResTable.getPackageRenamed();
        String original = this.mResTable.getPackageOriginal();
        int id = this.mResTable.getPackageId();
        try {
            id = this.mResTable.getPackage(renamed).getId();
        }
        catch (UndefinedResObjectException undefinedResObjectException) {
            // empty catch block
        }
        if (Strings.isNullOrEmpty(original)) {
            return;
        }
        meta.packageInfo = new PackageInfo();
        if (!renamed.equalsIgnoreCase(original)) {
            meta.packageInfo.renameManifestPackage = renamed;
        }
        meta.packageInfo.forcedPackageId = String.valueOf(id);
    }

    private void putVersionInfo(MetaInfo meta) {
        VersionInfo info = this.mResTable.getVersionInfo();
        String refValue = ResXmlPatcher.pullValueFromStrings(this.mOutDir, info.versionName);
        if (refValue != null) {
            info.versionName = refValue;
        }
        meta.versionInfo = info;
    }

    private void putSharedLibraryInfo(MetaInfo meta) {
        meta.sharedLibrary = this.mResTable.getSharedLibrary();
    }

    private void putSparseResourcesInfo(MetaInfo meta) {
        meta.sparseResources = this.mResTable.getSparseResources();
    }

    private void putUnknownInfo(MetaInfo meta) {
        meta.unknownFiles = this.mAndrolib.mResUnknownFiles.getUnknownFiles();
    }

    private void putFileCompressionInfo(MetaInfo meta) {
        if (this.mUncompressedFiles != null && !this.mUncompressedFiles.isEmpty()) {
            meta.doNotCompress = this.mUncompressedFiles;
        }
    }
}

