/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.exceptions.AndrolibException;
import brut.util.OSDetection;
import java.io.File;
import java.util.Collection;
import java.util.logging.Logger;

public class Config {
    private static final Logger LOGGER = Logger.getLogger(Config.class.getName());
    public boolean forceBuildAll = false;
    public boolean forceDeleteFramework = false;
    public boolean debugMode = false;
    public boolean netSecConf = false;
    public boolean verbose = false;
    public boolean copyOriginalFiles = false;
    public boolean updateFiles = false;
    public boolean isFramework = false;
    public boolean resourcesAreCompressed = false;
    public boolean useAapt2 = false;
    public boolean noCrunch = false;
    public int forceApi = 0;
    public Collection<String> doNotCompress;
    public short decodeSources = 1;
    public short decodeResources = (short)257;
    public short forceDecodeManifest = 0;
    public short decodeAssets = 1;
    public int apiLevel = 0;
    public boolean analysisMode = false;
    public boolean forceDelete = false;
    public boolean keepBrokenResources = false;
    public boolean baksmaliDebugMode = true;
    public String frameworkDirectory = null;
    public String frameworkTag = null;
    public String aaptPath = "";
    public int aaptVersion = 1;

    public boolean isAapt2() {
        return this.useAapt2 || this.aaptVersion == 2;
    }

    private Config() {
    }

    private void setDefaultFrameworkDirectory() {
        String xdgDataFolder;
        File parentPath = new File(System.getProperty("user.home"));
        String path = OSDetection.isMacOSX() ? parentPath.getAbsolutePath() + String.format("%1$sLibrary%1$sapktool%1$sframework", Character.valueOf(File.separatorChar)) : (OSDetection.isWindows() ? parentPath.getAbsolutePath() + String.format("%1$sAppData%1$sLocal%1$sapktool%1$sframework", Character.valueOf(File.separatorChar)) : ((xdgDataFolder = System.getenv("XDG_DATA_HOME")) != null ? xdgDataFolder + String.format("%1$sapktool%1$sframework", Character.valueOf(File.separatorChar)) : parentPath.getAbsolutePath() + String.format("%1$s.local%1$sshare%1$sapktool%1$sframework", Character.valueOf(File.separatorChar))));
        this.frameworkDirectory = path;
    }

    public void setDecodeSources(short mode) throws AndrolibException {
        if (mode != 0 && mode != 1 && mode != 16) {
            throw new AndrolibException("Invalid decode sources mode: " + mode);
        }
        if (this.decodeSources == 0 && mode == 16) {
            LOGGER.info("--only-main-classes cannot be paired with -s/--no-src. Ignoring.");
            return;
        }
        this.decodeSources = mode;
    }

    public void setDecodeResources(short mode) throws AndrolibException {
        if (mode != 256 && mode != 257) {
            throw new AndrolibException("Invalid decode resources mode");
        }
        this.decodeResources = mode;
    }

    public void setForceDecodeManifest(short mode) throws AndrolibException {
        if (mode != 0 && mode != 1) {
            throw new AndrolibException("Invalid force decode manifest mode");
        }
        this.forceDecodeManifest = mode;
    }

    public void setDecodeAssets(short mode) throws AndrolibException {
        if (mode != 0 && mode != 1) {
            throw new AndrolibException("Invalid decode asset mode");
        }
        this.decodeAssets = mode;
    }

    public static Config getDefaultConfig() {
        Config config = new Config();
        config.setDefaultFrameworkDirectory();
        return config;
    }
}

