/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res;

import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.meta.MetaInfo;
import brut.androlib.meta.PackageInfo;
import brut.androlib.meta.VersionInfo;
import brut.androlib.res.Framework;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResValuesFile;
import brut.androlib.res.decoder.ARSCDecoder;
import brut.androlib.res.decoder.AXmlResourceParser;
import brut.androlib.res.decoder.AndroidManifestResourceParser;
import brut.androlib.res.decoder.Res9patchStreamDecoder;
import brut.androlib.res.decoder.ResAttrDecoder;
import brut.androlib.res.decoder.ResFileDecoder;
import brut.androlib.res.decoder.ResRawStreamDecoder;
import brut.androlib.res.decoder.ResStreamDecoderContainer;
import brut.androlib.res.decoder.XmlPullStreamDecoder;
import brut.androlib.res.util.ExtMXSerializer;
import brut.androlib.res.util.ExtXmlSerializer;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import brut.androlib.res.xml.ResXmlPatcher;
import brut.common.BrutException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.directory.FileDirectory;
import brut.directory.ZipUtils;
import brut.util.AaptManager;
import brut.util.Duo;
import brut.util.OS;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlSerializer;

public final class AndrolibResources {
    private final Config config;
    public Map<String, String> mResFileMapping = new HashMap<String, String>();
    private static final Logger LOGGER = Logger.getLogger(AndrolibResources.class.getName());
    private File mFrameworkDirectory = null;
    private ExtFile mFramework = null;
    private String mMinSdkVersion = null;
    private String mMaxSdkVersion = null;
    private String mTargetSdkVersion = null;
    private String mVersionCode = null;
    private String mVersionName = null;
    private String mPackageRenamed = null;
    private String mPackageId = null;
    private boolean mSharedLibrary = false;
    private boolean mSparseResources = false;
    private static final String[] IGNORED_PACKAGES = new String[]{"android", "com.htc", "com.lge", "com.lge.internal", "yi", "flyme", "air.com.adobe.appentry", "FFFFFFFFFFFFFFFFFFFFFF"};

    public AndrolibResources(Config config) {
        this.config = config;
    }

    public AndrolibResources() {
        this.config = Config.getDefaultConfig();
    }

    public ResTable getResTable(ExtFile apkFile, boolean loadMainPkg) throws AndrolibException {
        ResTable resTable = new ResTable(this);
        if (loadMainPkg) {
            this.loadMainPkg(resTable, apkFile);
        }
        return resTable;
    }

    public ResPackage loadMainPkg(ResTable resTable, ExtFile apkFile) throws AndrolibException {
        ResPackage pkg;
        LOGGER.info("Loading resource table...");
        ResPackage[] pkgs = this.getResPackagesFromApk(apkFile, resTable, this.config.keepBrokenResources);
        switch (pkgs.length) {
            case 0: {
                pkg = new ResPackage(resTable, 0, null);
                break;
            }
            case 1: {
                pkg = pkgs[0];
                break;
            }
            case 2: {
                LOGGER.warning("Skipping package group: " + pkgs[0].getName());
                pkg = pkgs[1];
                break;
            }
            default: {
                pkg = this.selectPkgWithMostResSpecs(pkgs);
            }
        }
        resTable.addPackage(pkg, true);
        return pkg;
    }

    public ResPackage selectPkgWithMostResSpecs(ResPackage[] pkgs) {
        int id = 0;
        int value = 0;
        int index = 0;
        for (int i = 0; i < pkgs.length; ++i) {
            ResPackage resPackage = pkgs[i];
            if (resPackage.getResSpecCount() <= value || resPackage.getName().equalsIgnoreCase("android")) continue;
            value = resPackage.getResSpecCount();
            id = resPackage.getId();
            index = i;
        }
        return id == 0 ? pkgs[0] : pkgs[index];
    }

    public ResPackage loadFrameworkPkg(ResTable resTable, int id) throws AndrolibException {
        ResPackage pkg;
        Framework framework = new Framework(this.config);
        File apk = framework.getFrameworkApk(id, this.config.frameworkTag);
        LOGGER.info("Loading resource table from file: " + apk);
        this.mFramework = new ExtFile(apk);
        ResPackage[] pkgs = this.getResPackagesFromApk(this.mFramework, resTable, true);
        if (pkgs.length > 1) {
            pkg = this.selectPkgWithMostResSpecs(pkgs);
        } else {
            if (pkgs.length == 0) {
                throw new AndrolibException("Arsc files with zero or multiple packages");
            }
            pkg = pkgs[0];
        }
        if (pkg.getId() != id) {
            throw new AndrolibException("Expected pkg of id: " + id + ", got: " + pkg.getId());
        }
        resTable.addPackage(pkg, false);
        return pkg;
    }

    public void decodeManifest(ResTable resTable, ExtFile apkFile, File outDir) throws AndrolibException {
        Duo<ResFileDecoder, AXmlResourceParser> duo = this.getManifestFileDecoder(false);
        ResFileDecoder fileDecoder = (ResFileDecoder)duo.m1;
        ((AXmlResourceParser)duo.m2).setAttrDecoder(new ResAttrDecoder());
        ResAttrDecoder attrDecoder = ((AXmlResourceParser)duo.m2).getAttrDecoder();
        attrDecoder.setCurrentPackage(new ResPackage(resTable, 0, null));
        try {
            Directory inApk = apkFile.getDirectory();
            FileDirectory out = new FileDirectory(outDir);
            LOGGER.info("Decoding AndroidManifest.xml with only framework resources...");
            fileDecoder.decodeManifest(inApk, "AndroidManifest.xml", out, "AndroidManifest.xml");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void adjustPackageManifest(ResTable resTable, String filePath) throws AndrolibException {
        ResPackage resPackage = resTable.getCurrentResPackage();
        String pkgOriginal = resPackage.getName();
        this.mPackageRenamed = resTable.getPackageRenamed();
        resTable.setPackageId(resPackage.getId());
        resTable.setPackageOriginal(pkgOriginal);
        if (pkgOriginal == null || pkgOriginal.equalsIgnoreCase(this.mPackageRenamed) || Arrays.asList(IGNORED_PACKAGES).contains(pkgOriginal)) {
            LOGGER.info("Regular manifest package...");
        } else {
            LOGGER.info("Renamed manifest package found! Replacing " + this.mPackageRenamed + " with " + pkgOriginal);
            ResXmlPatcher.renameManifestPackage(new File(filePath), pkgOriginal);
        }
    }

    public void decodeManifestWithResources(ResTable resTable, ExtFile apkFile, File outDir) throws AndrolibException {
        Duo<ResFileDecoder, AXmlResourceParser> duo = this.getManifestFileDecoder(true);
        ResFileDecoder fileDecoder = (ResFileDecoder)duo.m1;
        ResAttrDecoder attrDecoder = ((AXmlResourceParser)duo.m2).getAttrDecoder();
        attrDecoder.setCurrentPackage(resTable.listMainPackages().iterator().next());
        try {
            Directory inApk = apkFile.getDirectory();
            FileDirectory out = new FileDirectory(outDir);
            LOGGER.info("Decoding AndroidManifest.xml with resources...");
            fileDecoder.decodeManifest(inApk, "AndroidManifest.xml", out, "AndroidManifest.xml");
            if (!this.config.analysisMode) {
                this.adjustPackageManifest(resTable, outDir.getAbsolutePath() + File.separator + "AndroidManifest.xml");
                ResXmlPatcher.removeManifestVersions(new File(outDir.getAbsolutePath() + File.separator + "AndroidManifest.xml"));
                this.mPackageId = String.valueOf(resTable.getPackageId());
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void decode(ResTable resTable, ExtFile apkFile, File outDir) throws AndrolibException {
        Directory in;
        Directory out;
        Duo<ResFileDecoder, AXmlResourceParser> duo = this.getResFileDecoder();
        ResFileDecoder fileDecoder = (ResFileDecoder)duo.m1;
        ResAttrDecoder attrDecoder = ((AXmlResourceParser)duo.m2).getAttrDecoder();
        attrDecoder.setCurrentPackage(resTable.listMainPackages().iterator().next());
        try {
            out = new FileDirectory(outDir);
            in = apkFile.getDirectory();
            out = out.createDir("res");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        ExtMXSerializer xmlSerializer = this.getResXmlSerializer();
        for (ResPackage pkg : resTable.listMainPackages()) {
            attrDecoder.setCurrentPackage(pkg);
            LOGGER.info("Decoding file-resources...");
            for (ResResource res : pkg.listFiles()) {
                fileDecoder.decode(res, in, out, this.mResFileMapping);
            }
            LOGGER.info("Decoding values */* XMLs...");
            for (ResValuesFile valuesFile : pkg.listValuesFiles()) {
                this.generateValuesFile(valuesFile, out, xmlSerializer);
            }
            this.generatePublicXml(pkg, out, xmlSerializer);
        }
        AndrolibException decodeError = ((AXmlResourceParser)duo.m2).getFirstError();
        if (decodeError != null) {
            throw decodeError;
        }
    }

    public void setSdkInfo(Map<String, String> map) {
        if (map != null) {
            this.mMinSdkVersion = map.get("minSdkVersion");
            this.mTargetSdkVersion = map.get("targetSdkVersion");
            this.mMaxSdkVersion = map.get("maxSdkVersion");
        }
    }

    public void setVersionInfo(VersionInfo versionInfo) {
        if (versionInfo != null) {
            this.mVersionCode = versionInfo.versionCode;
            this.mVersionName = versionInfo.versionName;
        }
    }

    public void setPackageRenamed(PackageInfo packageInfo) {
        if (packageInfo != null) {
            this.mPackageRenamed = packageInfo.renameManifestPackage;
        }
    }

    public void setPackageId(PackageInfo packageInfo) {
        if (packageInfo != null) {
            this.mPackageId = packageInfo.forcedPackageId;
        }
    }

    public void setSharedLibrary(boolean flag) {
        this.mSharedLibrary = flag;
    }

    public void setSparseResources(boolean flag) {
        this.mSparseResources = flag;
    }

    public String checkTargetSdkVersionBounds() {
        int target = this.mapSdkShorthandToVersion(this.mTargetSdkVersion);
        int min = this.mMinSdkVersion != null ? this.mapSdkShorthandToVersion(this.mMinSdkVersion) : 0;
        int max = this.mMaxSdkVersion != null ? this.mapSdkShorthandToVersion(this.mMaxSdkVersion) : target;
        target = Math.min(max, target);
        target = Math.max(min, target);
        return Integer.toString(target);
    }

    private File createDoNotCompressExtensionsFile(Config config) throws AndrolibException {
        if (config.doNotCompress == null || config.doNotCompress.isEmpty()) {
            return null;
        }
        try {
            File doNotCompressFile = File.createTempFile("APKTOOL", null);
            doNotCompressFile.deleteOnExit();
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(doNotCompressFile));
            for (String extension : config.doNotCompress) {
                fileWriter.write(extension);
                fileWriter.newLine();
            }
            fileWriter.close();
            return doNotCompressFile;
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void aapt2Package(File apkFile, File manifest, File resDir, File rawDir, File assetDir, File[] include, List<String> cmd, boolean customAapt) throws AndrolibException {
        File buildDir;
        ArrayList<String> compileCommand = new ArrayList<String>(cmd);
        File resourcesZip = null;
        if (resDir != null) {
            buildDir = new File(resDir.getParent(), "build");
            resourcesZip = new File(buildDir, "resources.zip");
        }
        if (resDir != null && !resourcesZip.exists()) {
            cmd.add("compile");
            cmd.add("--dir");
            cmd.add(resDir.getAbsolutePath());
            cmd.add("--legacy");
            buildDir = new File(resDir.getParent(), "build");
            resourcesZip = new File(buildDir, "resources.zip");
            cmd.add("-o");
            cmd.add(resourcesZip.getAbsolutePath());
            if (this.config.verbose) {
                cmd.add("-v");
            }
            if (this.config.noCrunch) {
                cmd.add("--no-crunch");
            }
            try {
                OS.exec(cmd.toArray(new String[0]));
                LOGGER.fine("aapt2 compile command ran: ");
                LOGGER.fine(cmd.toString());
            }
            catch (BrutException ex) {
                throw new AndrolibException(ex);
            }
        }
        if (manifest == null) {
            return;
        }
        cmd = new ArrayList<String>(compileCommand);
        cmd.add("link");
        cmd.add("-o");
        cmd.add(apkFile.getAbsolutePath());
        if (this.mPackageId != null && !this.mSharedLibrary) {
            cmd.add("--package-id");
            cmd.add(this.mPackageId);
        }
        if (this.mSharedLibrary) {
            cmd.add("--shared-lib");
        }
        if (this.mMinSdkVersion != null) {
            cmd.add("--min-sdk-version");
            cmd.add(this.mMinSdkVersion);
        }
        if (this.mTargetSdkVersion != null) {
            cmd.add("--target-sdk-version");
            cmd.add(this.checkTargetSdkVersionBounds());
        }
        if (this.mPackageRenamed != null) {
            cmd.add("--rename-manifest-package");
            cmd.add(this.mPackageRenamed);
            cmd.add("--rename-instrumentation-target-package");
            cmd.add(this.mPackageRenamed);
        }
        if (this.mVersionCode != null) {
            cmd.add("--version-code");
            cmd.add(this.mVersionCode);
        }
        if (this.mVersionName != null) {
            cmd.add("--version-name");
            cmd.add(this.mVersionName);
        }
        cmd.add("--no-auto-version");
        cmd.add("--no-version-vectors");
        cmd.add("--no-version-transitions");
        cmd.add("--no-resource-deduping");
        cmd.add("--allow-reserved-package-id");
        if (this.mSparseResources) {
            cmd.add("--enable-sparse-encoding");
        }
        if (this.config.isFramework) {
            cmd.add("-x");
        }
        if (this.config.doNotCompress != null && !customAapt) {
            File[] extensionsFilePath = Objects.requireNonNull(this.createDoNotCompressExtensionsFile(this.config)).getAbsolutePath();
            cmd.add("-e");
            cmd.add((String)extensionsFilePath);
        } else if (this.config.doNotCompress != null) {
            for (String file : this.config.doNotCompress) {
                cmd.add("-0");
                cmd.add(file);
            }
        }
        if (!this.config.resourcesAreCompressed) {
            cmd.add("-0");
            cmd.add("arsc");
        }
        if (include != null) {
            for (File file : include) {
                cmd.add("-I");
                cmd.add(file.getPath());
            }
        }
        cmd.add("--manifest");
        cmd.add(manifest.getAbsolutePath());
        if (assetDir != null) {
            cmd.add("-A");
            cmd.add(assetDir.getAbsolutePath());
        }
        if (rawDir != null) {
            cmd.add("-R");
            cmd.add(rawDir.getAbsolutePath());
        }
        if (this.config.verbose) {
            cmd.add("-v");
        }
        if (resourcesZip != null) {
            cmd.add(resourcesZip.getAbsolutePath());
        }
        try {
            OS.exec(cmd.toArray(new String[0]));
            LOGGER.fine("aapt2 link command ran: ");
            LOGGER.fine(cmd.toString());
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void aapt1Package(File apkFile, File manifest, File resDir, File rawDir, File assetDir, File[] include, List<String> cmd, boolean customAapt) throws AndrolibException {
        cmd.add("p");
        if (this.config.verbose) {
            cmd.add("-v");
        }
        if (this.config.updateFiles) {
            cmd.add("-u");
        }
        if (this.config.debugMode) {
            cmd.add("--debug-mode");
        }
        if (this.config.noCrunch) {
            cmd.add("--no-crunch");
        }
        if (this.mPackageId != null && !customAapt && !this.mSharedLibrary) {
            cmd.add("--forced-package-id");
            cmd.add(this.mPackageId);
        }
        if (this.mSharedLibrary) {
            cmd.add("--shared-lib");
        }
        if (this.mMinSdkVersion != null) {
            cmd.add("--min-sdk-version");
            cmd.add(this.mMinSdkVersion);
        }
        if (this.mTargetSdkVersion != null) {
            cmd.add("--target-sdk-version");
            cmd.add(this.checkTargetSdkVersionBounds());
        }
        if (this.mMaxSdkVersion != null) {
            cmd.add("--max-sdk-version");
            cmd.add(this.mMaxSdkVersion);
            cmd.add("--max-res-version");
            cmd.add(this.mMaxSdkVersion);
        }
        if (this.mPackageRenamed != null) {
            cmd.add("--rename-manifest-package");
            cmd.add(this.mPackageRenamed);
        }
        if (this.mVersionCode != null) {
            cmd.add("--version-code");
            cmd.add(this.mVersionCode);
        }
        if (this.mVersionName != null) {
            cmd.add("--version-name");
            cmd.add(this.mVersionName);
        }
        cmd.add("--no-version-vectors");
        cmd.add("-F");
        cmd.add(apkFile.getAbsolutePath());
        if (this.config.isFramework) {
            cmd.add("-x");
        }
        if (this.config.doNotCompress != null && !customAapt) {
            File[] extensionsFilePath = Objects.requireNonNull(this.createDoNotCompressExtensionsFile(this.config)).getAbsolutePath();
            cmd.add("-e");
            cmd.add((String)extensionsFilePath);
        } else if (this.config.doNotCompress != null) {
            for (String file : this.config.doNotCompress) {
                cmd.add("-0");
                cmd.add(file);
            }
        }
        if (!this.config.resourcesAreCompressed) {
            cmd.add("-0");
            cmd.add("arsc");
        }
        if (include != null) {
            for (File file : include) {
                cmd.add("-I");
                cmd.add(file.getPath());
            }
        }
        if (resDir != null) {
            cmd.add("-S");
            cmd.add(resDir.getAbsolutePath());
        }
        if (manifest != null) {
            cmd.add("-M");
            cmd.add(manifest.getAbsolutePath());
        }
        if (assetDir != null) {
            cmd.add("-A");
            cmd.add(assetDir.getAbsolutePath());
        }
        if (rawDir != null) {
            cmd.add(rawDir.getAbsolutePath());
        }
        try {
            OS.exec(cmd.toArray(new String[0]));
            LOGGER.fine("command ran: ");
            LOGGER.fine(cmd.toString());
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void aaptPackage(File apkFile, File manifest, File resDir, File rawDir, File assetDir, File[] include) throws AndrolibException {
        String aaptPath = this.config.aaptPath;
        boolean customAapt = !aaptPath.isEmpty();
        ArrayList<String> cmd = new ArrayList<String>();
        try {
            String aaptCommand = AaptManager.getAaptExecutionCommand(aaptPath, this.getAaptBinaryFile());
            cmd.add(aaptCommand);
        }
        catch (BrutException ex) {
            LOGGER.warning("aapt: " + ex.getMessage() + " (defaulting to $PATH binary)");
            cmd.add(AaptManager.getAaptBinaryName(this.getAaptVersion()));
        }
        if (this.config.isAapt2()) {
            this.aapt2Package(apkFile, manifest, resDir, rawDir, assetDir, include, cmd, customAapt);
            return;
        }
        this.aapt1Package(apkFile, manifest, resDir, rawDir, assetDir, include, cmd, customAapt);
    }

    public void zipPackage(File apkFile, File rawDir, File assetDir) throws AndrolibException {
        try {
            ZipUtils.zipFolders(rawDir, apkFile, assetDir, this.config.doNotCompress);
        }
        catch (BrutException | IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    public int getMinSdkVersionFromAndroidCodename(MetaInfo meta, String sdkVersion) {
        int sdkNumber = this.mapSdkShorthandToVersion(sdkVersion);
        if (sdkNumber == 1) {
            return Integer.parseInt(meta.sdkInfo.get("minSdkVersion"));
        }
        return sdkNumber;
    }

    private int mapSdkShorthandToVersion(String sdkVersion) {
        switch (sdkVersion.toUpperCase()) {
            case "M": {
                return 23;
            }
            case "N": {
                return 24;
            }
            case "O": {
                return 26;
            }
            case "P": {
                return 28;
            }
            case "Q": {
                return 29;
            }
            case "R": {
                return 30;
            }
            case "S": {
                return 31;
            }
            case "SV2": {
                return 32;
            }
            case "T": 
            case "TIRAMISU": {
                return 10000;
            }
        }
        return Integer.parseInt(sdkVersion);
    }

    public Duo<ResFileDecoder, AXmlResourceParser> getResFileDecoder() {
        ResStreamDecoderContainer decoders = new ResStreamDecoderContainer();
        decoders.setDecoder("raw", new ResRawStreamDecoder());
        decoders.setDecoder("9patch", new Res9patchStreamDecoder());
        AXmlResourceParser axmlParser = new AXmlResourceParser();
        axmlParser.setAttrDecoder(new ResAttrDecoder());
        decoders.setDecoder("xml", new XmlPullStreamDecoder(axmlParser, this.getResXmlSerializer()));
        return new Duo<ResFileDecoder, AXmlResourceParser>(new ResFileDecoder(decoders), axmlParser);
    }

    public Duo<ResFileDecoder, AXmlResourceParser> getManifestFileDecoder(boolean withResources) {
        ResStreamDecoderContainer decoders = new ResStreamDecoderContainer();
        AndroidManifestResourceParser axmlParser = new AndroidManifestResourceParser();
        if (withResources) {
            axmlParser.setAttrDecoder(new ResAttrDecoder());
        }
        decoders.setDecoder("xml", new XmlPullStreamDecoder(axmlParser, this.getResXmlSerializer()));
        return new Duo<ResFileDecoder, AXmlResourceParser>(new ResFileDecoder(decoders), axmlParser);
    }

    public ExtMXSerializer getResXmlSerializer() {
        ExtMXSerializer serial = new ExtMXSerializer();
        serial.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "    ");
        serial.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", System.getProperty("line.separator"));
        serial.setProperty("DEFAULT_ENCODING", "utf-8");
        serial.setDisabledAttrEscape(true);
        return serial;
    }

    private void generateValuesFile(ResValuesFile valuesFile, Directory out, ExtXmlSerializer serial) throws AndrolibException {
        try {
            OutputStream outStream = out.getFileOutput(valuesFile.getPath());
            serial.setOutput(outStream, null);
            serial.startDocument(null, null);
            serial.startTag(null, "resources");
            for (ResResource res : valuesFile.listResources()) {
                if (valuesFile.isSynthesized(res)) continue;
                ((ResValuesXmlSerializable)((Object)res.getValue())).serializeToResValuesXml(serial, res);
            }
            serial.endTag(null, "resources");
            serial.newLine();
            serial.endDocument();
            serial.flush();
            outStream.close();
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException("Could not generate: " + valuesFile.getPath(), ex);
        }
    }

    private void generatePublicXml(ResPackage pkg, Directory out, XmlSerializer serial) throws AndrolibException {
        try {
            OutputStream outStream = out.getFileOutput("values/public.xml");
            serial.setOutput(outStream, null);
            serial.startDocument(null, null);
            serial.startTag(null, "resources");
            for (ResResSpec spec : pkg.listResSpecs()) {
                serial.startTag(null, "public");
                serial.attribute(null, "type", spec.getType().getName());
                serial.attribute(null, "name", spec.getName());
                serial.attribute(null, "id", String.format("0x%08x", spec.getId().id));
                serial.endTag(null, "public");
            }
            serial.endTag(null, "resources");
            serial.endDocument();
            serial.flush();
            outStream.close();
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException("Could not generate public.xml file", ex);
        }
    }

    private ResPackage[] getResPackagesFromApk(ExtFile apkFile, ResTable resTable, boolean keepBrokenResources) throws AndrolibException {
        ResPackage[] resPackageArray;
        Directory dir = apkFile.getDirectory();
        BufferedInputStream bfi = new BufferedInputStream(dir.getFileInput("resources.arsc"));
        try {
            resPackageArray = ARSCDecoder.decode(bfi, false, keepBrokenResources, resTable).getPackages();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bfi.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (DirectoryException | IOException ex) {
                throw new AndrolibException("Could not load resources.arsc from file: " + apkFile, ex);
            }
        }
        bfi.close();
        return resPackageArray;
    }

    private File getAaptBinaryFile() throws AndrolibException {
        try {
            if (this.getAaptVersion() == 2) {
                return AaptManager.getAapt2();
            }
            return AaptManager.getAapt1();
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    private int getAaptVersion() {
        return this.config.isAapt2() ? 2 : 1;
    }

    public void close() throws IOException {
        if (this.mFramework != null) {
            this.mFramework.close();
        }
    }
}

