/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.meta.VersionInfo;
import brut.androlib.res.AndrolibResources;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ResTable {
    private final AndrolibResources mAndRes;
    private final Map<Integer, ResPackage> mPackagesById = new HashMap<Integer, ResPackage>();
    private final Map<String, ResPackage> mPackagesByName = new HashMap<String, ResPackage>();
    private final Set<ResPackage> mMainPackages = new LinkedHashSet<ResPackage>();
    private final Set<ResPackage> mFramePackages = new LinkedHashSet<ResPackage>();
    private String mPackageRenamed;
    private String mPackageOriginal;
    private int mPackageId;
    private boolean mAnalysisMode = false;
    private boolean mSharedLibrary = false;
    private boolean mSparseResources = false;
    private final Map<String, String> mSdkInfo = new LinkedHashMap<String, String>();
    private final VersionInfo mVersionInfo = new VersionInfo();

    public ResTable() {
        this.mAndRes = null;
    }

    public ResTable(AndrolibResources andRes) {
        this.mAndRes = andRes;
    }

    public ResResSpec getResSpec(int resID) throws AndrolibException {
        if (resID >> 24 == 0) {
            int pkgId = this.mPackageId == 0 ? 2 : this.mPackageId;
            resID = 0xFF000000 & pkgId << 24 | resID;
        }
        return this.getResSpec(new ResID(resID));
    }

    public ResResSpec getResSpec(ResID resID) throws AndrolibException {
        return this.getPackage(resID.package_).getResSpec(resID);
    }

    public Set<ResPackage> listMainPackages() {
        return this.mMainPackages;
    }

    public Set<ResPackage> listFramePackages() {
        return this.mFramePackages;
    }

    public ResPackage getPackage(int id) throws AndrolibException {
        ResPackage pkg = this.mPackagesById.get(id);
        if (pkg != null) {
            return pkg;
        }
        if (this.mAndRes != null) {
            return this.mAndRes.loadFrameworkPkg(this, id);
        }
        throw new UndefinedResObjectException(String.format("package: id=%d", id));
    }

    public ResPackage getHighestSpecPackage() throws AndrolibException {
        int id = 0;
        int value = 0;
        for (ResPackage resPackage : this.mPackagesById.values()) {
            if (resPackage.getResSpecCount() <= value || resPackage.getName().equalsIgnoreCase("android")) continue;
            value = resPackage.getResSpecCount();
            id = resPackage.getId();
        }
        return id == 0 ? this.getPackage(1) : this.getPackage(id);
    }

    public ResPackage getCurrentResPackage() throws AndrolibException {
        ResPackage pkg = this.mPackagesById.get(this.mPackageId);
        if (pkg != null) {
            return pkg;
        }
        if (this.mMainPackages.size() == 1) {
            return this.mMainPackages.iterator().next();
        }
        return this.getHighestSpecPackage();
    }

    public ResPackage getPackage(String name) throws AndrolibException {
        ResPackage pkg = this.mPackagesByName.get(name);
        if (pkg == null) {
            throw new UndefinedResObjectException("package: name=" + name);
        }
        return pkg;
    }

    public void addPackage(ResPackage pkg, boolean main) throws AndrolibException {
        Integer id = pkg.getId();
        if (this.mPackagesById.containsKey(id)) {
            throw new AndrolibException("Multiple packages: id=" + id);
        }
        String name = pkg.getName();
        if (this.mPackagesByName.containsKey(name)) {
            throw new AndrolibException("Multiple packages: name=" + name);
        }
        this.mPackagesById.put(id, pkg);
        this.mPackagesByName.put(name, pkg);
        if (main) {
            this.mMainPackages.add(pkg);
        } else {
            this.mFramePackages.add(pkg);
        }
    }

    public void setAnalysisMode(boolean mode) {
        this.mAnalysisMode = mode;
    }

    public void setPackageRenamed(String pkg) {
        this.mPackageRenamed = pkg;
    }

    public void setPackageOriginal(String pkg) {
        this.mPackageOriginal = pkg;
    }

    public void setPackageId(int id) {
        this.mPackageId = id;
    }

    public void setSharedLibrary(boolean flag) {
        this.mSharedLibrary = flag;
    }

    public void setSparseResources(boolean flag) {
        this.mSparseResources = flag;
    }

    public void clearSdkInfo() {
        this.mSdkInfo.clear();
    }

    public void addSdkInfo(String key, String value) {
        this.mSdkInfo.put(key, value);
    }

    public void setVersionName(String versionName) {
        this.mVersionInfo.versionName = versionName;
    }

    public void setVersionCode(String versionCode) {
        this.mVersionInfo.versionCode = versionCode;
    }

    public VersionInfo getVersionInfo() {
        return this.mVersionInfo;
    }

    public Map<String, String> getSdkInfo() {
        return this.mSdkInfo;
    }

    public boolean getAnalysisMode() {
        return this.mAnalysisMode;
    }

    public String getPackageRenamed() {
        return this.mPackageRenamed;
    }

    public String getPackageOriginal() {
        return this.mPackageOriginal;
    }

    public int getPackageId() {
        return this.mPackageId;
    }

    public boolean getSharedLibrary() {
        return this.mSharedLibrary;
    }

    public boolean getSparseResources() {
        return this.mSparseResources;
    }

    public boolean isFrameworkApk() {
        for (ResPackage pkg : this.listMainPackages()) {
            if (pkg.getId() <= 0 || pkg.getId() >= 64) continue;
            return true;
        }
        return false;
    }
}

