/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.CantFind9PatchChunkException;
import brut.androlib.res.decoder.ResStreamDecoder;
import brut.util.ExtDataInput;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public class Res9patchStreamDecoder
implements ResStreamDecoder {
    @Override
    public void decode(InputStream in, OutputStream out) throws AndrolibException {
        try {
            byte[] data = IOUtils.toByteArray(in);
            if (data.length == 0) {
                return;
            }
            BufferedImage im = ImageIO.read(new ByteArrayInputStream(data));
            int w = im.getWidth();
            int h = im.getHeight();
            BufferedImage im2 = new BufferedImage(w + 2, h + 2, 2);
            if (im.getType() == 0) {
                WritableRaster srcRaster = im.getRaster();
                WritableRaster dstRaster = im2.getRaster();
                int[] gray = null;
                int[] alpha = null;
                for (int y = 0; y < im.getHeight(); ++y) {
                    gray = srcRaster.getSamples(0, y, w, 1, 0, gray);
                    alpha = srcRaster.getSamples(0, y, w, 1, 1, alpha);
                    dstRaster.setSamples(1, y + 1, w, 1, 0, gray);
                    dstRaster.setSamples(1, y + 1, w, 1, 1, gray);
                    dstRaster.setSamples(1, y + 1, w, 1, 2, gray);
                    dstRaster.setSamples(1, y + 1, w, 1, 3, alpha);
                }
            } else {
                im2.createGraphics().drawImage(im, 1, 1, w, h, null);
            }
            NinePatch np = this.getNinePatch(data);
            this.drawHLine(im2, h + 1, np.padLeft + 1, w - np.padRight);
            this.drawVLine(im2, w + 1, np.padTop + 1, h - np.padBottom);
            int[] xDivs = np.xDivs;
            if (xDivs.length == 0) {
                this.drawHLine(im2, 0, 1, w);
            } else {
                for (int i = 0; i < xDivs.length; i += 2) {
                    this.drawHLine(im2, 0, xDivs[i] + 1, xDivs[i + 1]);
                }
            }
            int[] yDivs = np.yDivs;
            if (yDivs.length == 0) {
                this.drawVLine(im2, 0, 1, h);
            } else {
                for (int i = 0; i < yDivs.length; i += 2) {
                    this.drawVLine(im2, 0, yDivs[i] + 1, yDivs[i + 1]);
                }
            }
            try {
                int y;
                int x;
                int i;
                OpticalInset oi = this.getOpticalInset(data);
                for (i = 0; i < oi.layoutBoundsLeft; ++i) {
                    x = 1 + i;
                    im2.setRGB(x, h + 1, -65536);
                }
                for (i = 0; i < oi.layoutBoundsRight; ++i) {
                    x = w - i;
                    im2.setRGB(x, h + 1, -65536);
                }
                for (i = 0; i < oi.layoutBoundsTop; ++i) {
                    y = 1 + i;
                    im2.setRGB(w + 1, y, -65536);
                }
                for (i = 0; i < oi.layoutBoundsBottom; ++i) {
                    y = h - i;
                    im2.setRGB(w + 1, y, -65536);
                }
            }
            catch (CantFind9PatchChunkException cantFind9PatchChunkException) {
                // empty catch block
            }
            ImageIO.write((RenderedImage)im2, "png", out);
        }
        catch (IOException | NullPointerException ex) {
            throw new AndrolibException(ex);
        }
    }

    private NinePatch getNinePatch(byte[] data) throws AndrolibException, IOException {
        ExtDataInput di = new ExtDataInput(new ByteArrayInputStream(data));
        this.find9patchChunk(di, 1852855395);
        return NinePatch.decode(di);
    }

    private OpticalInset getOpticalInset(byte[] data) throws AndrolibException, IOException {
        ExtDataInput di = new ExtDataInput(new ByteArrayInputStream(data));
        this.find9patchChunk(di, 1852853346);
        return OpticalInset.decode(di);
    }

    private void find9patchChunk(DataInput di, int magic) throws AndrolibException, IOException {
        di.skipBytes(8);
        while (true) {
            int size;
            try {
                size = di.readInt();
            }
            catch (IOException ex) {
                throw new CantFind9PatchChunkException("Cant find nine patch chunk", ex);
            }
            if (di.readInt() == magic) {
                return;
            }
            di.skipBytes(size + 4);
        }
    }

    private void drawHLine(BufferedImage im, int y, int x1, int x2) {
        for (int x = x1; x <= x2; ++x) {
            im.setRGB(x, y, -16777216);
        }
    }

    private void drawVLine(BufferedImage im, int x, int y1, int y2) {
        for (int y = y1; y <= y2; ++y) {
            im.setRGB(x, y, -16777216);
        }
    }

    private static class OpticalInset {
        public final int layoutBoundsLeft;
        public final int layoutBoundsTop;
        public final int layoutBoundsRight;
        public final int layoutBoundsBottom;

        public OpticalInset(int layoutBoundsLeft, int layoutBoundsTop, int layoutBoundsRight, int layoutBoundsBottom) {
            this.layoutBoundsLeft = layoutBoundsLeft;
            this.layoutBoundsTop = layoutBoundsTop;
            this.layoutBoundsRight = layoutBoundsRight;
            this.layoutBoundsBottom = layoutBoundsBottom;
        }

        public static OpticalInset decode(ExtDataInput di) throws IOException {
            int layoutBoundsLeft = Integer.reverseBytes(di.readInt());
            int layoutBoundsTop = Integer.reverseBytes(di.readInt());
            int layoutBoundsRight = Integer.reverseBytes(di.readInt());
            int layoutBoundsBottom = Integer.reverseBytes(di.readInt());
            return new OpticalInset(layoutBoundsLeft, layoutBoundsTop, layoutBoundsRight, layoutBoundsBottom);
        }
    }

    private static class NinePatch {
        public final int padLeft;
        public final int padRight;
        public final int padTop;
        public final int padBottom;
        public final int[] xDivs;
        public final int[] yDivs;

        public NinePatch(int padLeft, int padRight, int padTop, int padBottom, int[] xDivs, int[] yDivs) {
            this.padLeft = padLeft;
            this.padRight = padRight;
            this.padTop = padTop;
            this.padBottom = padBottom;
            this.xDivs = xDivs;
            this.yDivs = yDivs;
        }

        public static NinePatch decode(ExtDataInput di) throws IOException {
            di.skipBytes(1);
            byte numXDivs = di.readByte();
            byte numYDivs = di.readByte();
            di.skipBytes(1);
            di.skipBytes(8);
            int padLeft = di.readInt();
            int padRight = di.readInt();
            int padTop = di.readInt();
            int padBottom = di.readInt();
            di.skipBytes(4);
            int[] xDivs = di.readIntArray(numXDivs);
            int[] yDivs = di.readIntArray(numYDivs);
            return new NinePatch(padLeft, padRight, padTop, padBottom, xDivs, yDivs);
        }
    }
}

