/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResScalarValue;

public class ResAttrDecoder {
    private ResPackage mCurrentPackage;

    public String decode(int type, int value, String rawValue, int attrResId) throws AndrolibException {
        ResScalarValue resValue = this.mCurrentPackage.getValueFactory().factory(type, value, rawValue);
        String decoded = null;
        if (attrResId > 0) {
            try {
                ResAttr attr = (ResAttr)this.getCurrentPackage().getResTable().getResSpec(attrResId).getDefaultResource().getValue();
                decoded = attr.convertToResXmlFormat(resValue);
            }
            catch (UndefinedResObjectException | ClassCastException exception) {
                // empty catch block
            }
        }
        return decoded != null ? decoded : resValue.encodeAsResXmlAttr();
    }

    public String decodeManifestAttr(int attrResId) throws AndrolibException {
        if (attrResId != 0) {
            ResResSpec resResSpec;
            int attrId = attrResId;
            if (attrId >> 24 == 0) {
                ResPackage pkg = this.getCurrentPackage();
                int packageId = pkg.getId();
                int pkgId = packageId == 0 ? 2 : packageId;
                attrId = 0xFF000000 & pkgId << 24 | attrId;
            }
            ResID resId = new ResID(attrId);
            ResPackage pkg = this.getCurrentPackage();
            if (pkg.hasResSpec(resId) && (resResSpec = pkg.getResSpec(resId)) != null) {
                return resResSpec.getName();
            }
        }
        return null;
    }

    public ResPackage getCurrentPackage() throws AndrolibException {
        if (this.mCurrentPackage == null) {
            throw new AndrolibException("Current package not set");
        }
        return this.mCurrentPackage;
    }

    public void setCurrentPackage(ResPackage currentPackage) {
        this.mCurrentPackage = currentPackage;
    }
}

