/*
 * Decompiled with CFR 0.152.
 */
package brut.apktool;

import brut.androlib.ApkBuilder;
import brut.androlib.ApkDecoder;
import brut.androlib.ApktoolProperties;
import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.CantFindFrameworkResException;
import brut.androlib.exceptions.InFileNotFoundException;
import brut.androlib.exceptions.OutDirExistsException;
import brut.androlib.res.Framework;
import brut.common.BrutException;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.util.AaptManager;
import brut.util.OSDetection;
import java.io.File;
import java.io.IOException;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {
    private static boolean advanceMode = false;
    private static final Options normalOptions = new Options();
    private static final Options decodeOptions;
    private static final Options buildOptions;
    private static final Options frameOptions;
    private static final Options allOptions;
    private static final Options emptyOptions;
    private static final Options emptyFrameworkOptions;
    private static final Options listFrameworkOptions;

    public static void main(String[] args) throws BrutException {
        CommandLine commandLine;
        System.setProperty("java.awt.headless", "true");
        Verbosity verbosity = Verbosity.NORMAL;
        DefaultParser parser = new DefaultParser();
        Main._Options();
        try {
            commandLine = parser.parse(allOptions, args, false);
            if (!OSDetection.is64Bit()) {
                System.err.println("32 bit support is deprecated. Apktool will not support 32bit on v3.0.0.");
            }
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            Main.usage();
            System.exit(1);
            return;
        }
        if (commandLine.hasOption("-v") || commandLine.hasOption("--verbose")) {
            verbosity = Verbosity.VERBOSE;
        } else if (commandLine.hasOption("-q") || commandLine.hasOption("--quiet")) {
            verbosity = Verbosity.QUIET;
        }
        Main.setupLogging(verbosity);
        if (commandLine.hasOption("advance") || commandLine.hasOption("advanced")) {
            Main.setAdvanceMode();
        }
        Config config = Config.getDefaultConfig();
        Main.initConfig(commandLine, config);
        boolean cmdFound = false;
        for (String opt : commandLine.getArgs()) {
            if (opt.equalsIgnoreCase("d") || opt.equalsIgnoreCase("decode")) {
                Main.cmdDecode(commandLine, config);
                cmdFound = true;
                continue;
            }
            if (opt.equalsIgnoreCase("b") || opt.equalsIgnoreCase("build")) {
                Main.cmdBuild(commandLine, config);
                cmdFound = true;
                continue;
            }
            if (opt.equalsIgnoreCase("if") || opt.equalsIgnoreCase("install-framework")) {
                Main.cmdInstallFramework(commandLine, config);
                cmdFound = true;
                continue;
            }
            if (opt.equalsIgnoreCase("empty-framework-dir")) {
                Main.cmdEmptyFrameworkDirectory(commandLine, config);
                cmdFound = true;
                continue;
            }
            if (opt.equalsIgnoreCase("list-frameworks")) {
                Main.cmdListFrameworks(commandLine, config);
                cmdFound = true;
                continue;
            }
            if (!opt.equalsIgnoreCase("publicize-resources")) continue;
            Main.cmdPublicizeResources(commandLine, config);
            cmdFound = true;
        }
        if (!cmdFound) {
            if (commandLine.hasOption("version")) {
                Main._version();
                System.exit(0);
            } else {
                Main.usage();
            }
        }
    }

    private static void initConfig(CommandLine cli, Config config) {
        if (cli.hasOption("p") || cli.hasOption("frame-path")) {
            config.frameworkDirectory = cli.getOptionValue("p");
        }
        if (cli.hasOption("t") || cli.hasOption("tag")) {
            config.frameworkTag = cli.getOptionValue("t");
        }
        if (cli.hasOption("api") || cli.hasOption("api-level")) {
            config.apiLevel = Integer.parseInt(cli.getOptionValue("api"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cmdDecode(CommandLine cli, Config config) throws AndrolibException {
        File outDir;
        String apkName = Main.getLastArg(cli);
        if (cli.hasOption("s") || cli.hasOption("no-src")) {
            config.setDecodeSources((short)0);
        }
        if (cli.hasOption("only-main-classes")) {
            config.setDecodeSources((short)16);
        }
        if (cli.hasOption("d") || cli.hasOption("debug")) {
            System.err.println("SmaliDebugging has been removed in 2.1.0 onward. Please see: https://github.com/iBotPeaches/Apktool/issues/1061");
            System.exit(1);
        }
        if (cli.hasOption("b") || cli.hasOption("no-debug-info")) {
            config.baksmaliDebugMode = false;
        }
        if (cli.hasOption("f") || cli.hasOption("force")) {
            config.forceDelete = true;
        }
        if (cli.hasOption("r") || cli.hasOption("no-res")) {
            config.setDecodeResources((short)256);
        }
        if (cli.hasOption("force-manifest")) {
            config.setForceDecodeManifest((short)1);
        }
        if (cli.hasOption("no-assets")) {
            config.setDecodeAssets((short)0);
        }
        if (cli.hasOption("k") || cli.hasOption("keep-broken-res")) {
            config.keepBrokenResources = true;
        }
        if (cli.hasOption("m") || cli.hasOption("match-original")) {
            config.analysisMode = true;
        }
        if (cli.hasOption("o") || cli.hasOption("output")) {
            outDir = new File(cli.getOptionValue("o"));
        } else {
            String outName = apkName;
            outName = outName.endsWith(".apk") ? outName.substring(0, outName.length() - 4).trim() : outName + ".out";
            outName = new File(outName).getName();
            outDir = new File(outName);
        }
        ApkDecoder decoder = new ApkDecoder(config, new ExtFile(apkName));
        try {
            decoder.decode(outDir);
        }
        catch (OutDirExistsException ex) {
            System.err.println("Destination directory (" + outDir.getAbsolutePath() + ") already exists. Use -f switch if you want to overwrite it.");
            System.exit(1);
        }
        catch (InFileNotFoundException ex) {
            System.err.println("Input file (" + apkName + ") was not found or was not readable.");
            System.exit(1);
        }
        catch (CantFindFrameworkResException ex) {
            System.err.println("Can't find framework resources for package of id: " + ex.getPkgId() + ". You must install proper framework files, see project website for more info.");
            System.exit(1);
        }
        catch (IOException ex) {
            System.err.println("Could not modify file. Please ensure you have permission.");
            System.exit(1);
        }
        catch (DirectoryException ex) {
            System.err.println("Could not modify internal dex files. Please ensure you have permission.");
            System.exit(1);
        }
        finally {
            try {
                decoder.close();
            }
            catch (IOException ex) {}
        }
    }

    private static void cmdBuild(CommandLine cli, Config config) {
        String appDirName;
        String[] args = cli.getArgs();
        String string = appDirName = args.length < 2 ? "." : args[1];
        if (cli.hasOption("f") || cli.hasOption("force-all")) {
            config.forceBuildAll = true;
        }
        if (cli.hasOption("d") || cli.hasOption("debug")) {
            config.debugMode = true;
        }
        if (cli.hasOption("n") || cli.hasOption("net-sec-conf")) {
            config.netSecConf = true;
        }
        if (cli.hasOption("v") || cli.hasOption("verbose")) {
            config.verbose = true;
        }
        if (cli.hasOption("a") || cli.hasOption("aapt")) {
            config.aaptPath = cli.getOptionValue("a");
        }
        if (cli.hasOption("c") || cli.hasOption("copy-original")) {
            System.err.println("-c/--copy-original has been deprecated. Removal planned for v3.0.0 (#2129)");
            config.copyOriginalFiles = true;
        }
        if (cli.hasOption("nc") || cli.hasOption("no-crunch")) {
            config.noCrunch = true;
        }
        if (cli.hasOption("use-aapt2")) {
            config.useAapt2 = true;
        }
        File outFile = cli.hasOption("o") || cli.hasOption("output") ? new File(cli.getOptionValue("o")) : null;
        if (config.netSecConf && !config.useAapt2) {
            System.err.println("-n / --net-sec-conf is only supported with --use-aapt2.");
            System.exit(1);
        }
        try {
            if (cli.hasOption("a") || cli.hasOption("aapt")) {
                config.aaptVersion = AaptManager.getAaptVersion(cli.getOptionValue("a"));
            }
            new ApkBuilder(config, new ExtFile(appDirName)).build(outFile);
        }
        catch (BrutException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }

    private static void cmdInstallFramework(CommandLine cli, Config config) throws AndrolibException {
        String apkName = Main.getLastArg(cli);
        new Framework(config).installFramework(new File(apkName));
    }

    private static void cmdListFrameworks(CommandLine cli, Config config) throws AndrolibException {
        new Framework(config).listFrameworkDirectory();
    }

    private static void cmdPublicizeResources(CommandLine cli, Config config) throws AndrolibException {
        String apkName = Main.getLastArg(cli);
        new Framework(config).publicizeResources(new File(apkName));
    }

    private static void cmdEmptyFrameworkDirectory(CommandLine cli, Config config) throws AndrolibException {
        if (cli.hasOption("f") || cli.hasOption("force")) {
            config.forceDeleteFramework = true;
        }
        new Framework(config).emptyFrameworkDirectory();
    }

    private static String getLastArg(CommandLine cli) {
        int paraCount = cli.getArgList().size();
        return cli.getArgList().get(paraCount - 1);
    }

    private static void _version() {
        System.out.println(ApktoolProperties.getVersion());
    }

    private static void _Options() {
        Option versionOption = Option.builder("version").longOpt("version").desc("prints the version then exits").build();
        Option advanceOption = Option.builder("advance").longOpt("advanced").desc("prints advance information.").build();
        Option noSrcOption = Option.builder("s").longOpt("no-src").desc("Do not decode sources.").build();
        Option onlyMainClassesOption = Option.builder().longOpt("only-main-classes").desc("Only disassemble the main dex classes (classes[0-9]*.dex) in the root.").build();
        Option noResOption = Option.builder("r").longOpt("no-res").desc("Do not decode resources.").build();
        Option forceManOption = Option.builder().longOpt("force-manifest").desc("Decode the APK's compiled manifest, even if decoding of resources is set to \"false\".").build();
        Option noAssetOption = Option.builder().longOpt("no-assets").desc("Do not decode assets.").build();
        Option debugDecOption = Option.builder("d").longOpt("debug").desc("REMOVED (DOES NOT WORK): Decode in debug mode.").build();
        Option analysisOption = Option.builder("m").longOpt("match-original").desc("Keeps files to closest to original as possible. Prevents rebuild.").build();
        Option apiLevelOption = Option.builder("api").longOpt("api-level").desc("The numeric api-level of the file to generate, e.g. 14 for ICS.").hasArg(true).argName("API").build();
        Option debugBuiOption = Option.builder("d").longOpt("debug").desc("Sets android:debuggable to \"true\" in the APK's compiled manifest").build();
        Option netSecConfOption = Option.builder("n").longOpt("net-sec-conf").desc("Adds a generic Network Security Configuration file in the output APK").build();
        Option noDbgOption = Option.builder("b").longOpt("no-debug-info").desc("don't write out debug info (.local, .param, .line, etc.)").build();
        Option forceDecOption = Option.builder("f").longOpt("force").desc("Force delete destination directory.").build();
        Option frameTagOption = Option.builder("t").longOpt("frame-tag").desc("Uses framework files tagged by <tag>.").hasArg(true).argName("tag").build();
        Option frameDirOption = Option.builder("p").longOpt("frame-path").desc("Uses framework files located in <dir>.").hasArg(true).argName("dir").build();
        Option frameIfDirOption = Option.builder("p").longOpt("frame-path").desc("Stores framework files into <dir>.").hasArg(true).argName("dir").build();
        Option keepResOption = Option.builder("k").longOpt("keep-broken-res").desc("Use if there was an error and some resources were dropped, e.g.\n            \"Invalid config flags detected. Dropping resources\", but you\n            want to decode them anyway, even with errors. You will have to\n            fix them manually before building.").build();
        Option forceBuiOption = Option.builder("f").longOpt("force-all").desc("Skip changes detection and build all files.").build();
        Option aaptOption = Option.builder("a").longOpt("aapt").hasArg(true).argName("loc").desc("Loads aapt from specified location.").build();
        Option aapt2Option = Option.builder().longOpt("use-aapt2").desc("Upgrades apktool to use experimental aapt2 binary.").build();
        Option originalOption = Option.builder("c").longOpt("copy-original").desc("Copies original AndroidManifest.xml and META-INF. See project page for more info.").build();
        Option noCrunchOption = Option.builder("nc").longOpt("no-crunch").desc("Disable crunching of resource files during the build step.").build();
        Option tagOption = Option.builder("t").longOpt("tag").desc("Tag frameworks using <tag>.").hasArg(true).argName("tag").build();
        Option outputBuiOption = Option.builder("o").longOpt("output").desc("The name of apk that gets written. Default is dist/name.apk").hasArg(true).argName("dir").build();
        Option outputDecOption = Option.builder("o").longOpt("output").desc("The name of folder that gets written. Default is apk.out").hasArg(true).argName("dir").build();
        Option quietOption = Option.builder("q").longOpt("quiet").build();
        Option verboseOption = Option.builder("v").longOpt("verbose").build();
        if (Main.isAdvanceMode()) {
            decodeOptions.addOption(noDbgOption);
            decodeOptions.addOption(keepResOption);
            decodeOptions.addOption(analysisOption);
            decodeOptions.addOption(onlyMainClassesOption);
            decodeOptions.addOption(apiLevelOption);
            decodeOptions.addOption(noAssetOption);
            decodeOptions.addOption(forceManOption);
            buildOptions.addOption(apiLevelOption);
            buildOptions.addOption(debugBuiOption);
            buildOptions.addOption(netSecConfOption);
            buildOptions.addOption(aaptOption);
            buildOptions.addOption(originalOption);
            buildOptions.addOption(aapt2Option);
            buildOptions.addOption(noCrunchOption);
        }
        normalOptions.addOption(versionOption);
        normalOptions.addOption(advanceOption);
        decodeOptions.addOption(frameTagOption);
        decodeOptions.addOption(outputDecOption);
        decodeOptions.addOption(frameDirOption);
        decodeOptions.addOption(forceDecOption);
        decodeOptions.addOption(noSrcOption);
        decodeOptions.addOption(noResOption);
        buildOptions.addOption(outputBuiOption);
        buildOptions.addOption(frameDirOption);
        buildOptions.addOption(forceBuiOption);
        frameOptions.addOption(tagOption);
        frameOptions.addOption(frameIfDirOption);
        emptyFrameworkOptions.addOption(forceDecOption);
        emptyFrameworkOptions.addOption(frameIfDirOption);
        listFrameworkOptions.addOption(frameIfDirOption);
        for (Option op : normalOptions.getOptions()) {
            allOptions.addOption(op);
        }
        for (Option op : decodeOptions.getOptions()) {
            allOptions.addOption(op);
        }
        for (Option op : buildOptions.getOptions()) {
            allOptions.addOption(op);
        }
        for (Option op : frameOptions.getOptions()) {
            allOptions.addOption(op);
        }
        allOptions.addOption(apiLevelOption);
        allOptions.addOption(analysisOption);
        allOptions.addOption(debugDecOption);
        allOptions.addOption(noDbgOption);
        allOptions.addOption(forceManOption);
        allOptions.addOption(noAssetOption);
        allOptions.addOption(keepResOption);
        allOptions.addOption(debugBuiOption);
        allOptions.addOption(netSecConfOption);
        allOptions.addOption(aaptOption);
        allOptions.addOption(originalOption);
        allOptions.addOption(verboseOption);
        allOptions.addOption(quietOption);
        allOptions.addOption(aapt2Option);
        allOptions.addOption(noCrunchOption);
        allOptions.addOption(onlyMainClassesOption);
    }

    private static String verbosityHelp() {
        if (Main.isAdvanceMode()) {
            return "[-q|--quiet OR -v|--verbose] ";
        }
        return "";
    }

    private static void usage() {
        Main._Options();
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(120);
        System.out.println("Apktool v" + ApktoolProperties.getVersion() + " - a tool for reengineering Android apk files\nwith smali v" + ApktoolProperties.get("smaliVersion") + " and baksmali v" + ApktoolProperties.get("baksmaliVersion") + "\nCopyright 2010 Ryszard Wi\u015bniewski <brut.alll@gmail.com>\nCopyright 2010 Connor Tumbleson <connor.tumbleson@gmail.com>");
        if (Main.isAdvanceMode()) {
            System.out.println("Apache License 2.0 (https://www.apache.org/licenses/LICENSE-2.0)\n");
        } else {
            System.out.println();
        }
        formatter.printHelp("apktool " + Main.verbosityHelp(), normalOptions);
        formatter.printHelp("apktool " + Main.verbosityHelp() + "if|install-framework [options] <framework.apk>", frameOptions);
        formatter.printHelp("apktool " + Main.verbosityHelp() + "d[ecode] [options] <file_apk>", decodeOptions);
        formatter.printHelp("apktool " + Main.verbosityHelp() + "b[uild] [options] <app_path>", buildOptions);
        if (Main.isAdvanceMode()) {
            formatter.printHelp("apktool " + Main.verbosityHelp() + "publicize-resources <file_path>", emptyOptions);
            formatter.printHelp("apktool " + Main.verbosityHelp() + "empty-framework-dir [options]", emptyFrameworkOptions);
            formatter.printHelp("apktool " + Main.verbosityHelp() + "list-frameworks [options]", listFrameworkOptions);
        }
        System.out.println();
        System.out.println("For additional info, see: https://ibotpeaches.github.io/Apktool/ \nFor smali/baksmali info, see: https://github.com/JesusFreke/smali");
    }

    private static void setupLogging(final Verbosity verbosity) {
        Logger logger = Logger.getLogger("");
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        LogManager.getLogManager().reset();
        if (verbosity == Verbosity.QUIET) {
            return;
        }
        Handler handler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (this.getFormatter() == null) {
                    this.setFormatter(new SimpleFormatter());
                }
                try {
                    String message = this.getFormatter().format(record);
                    if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
                        System.err.write(message.getBytes());
                    } else if (record.getLevel().intValue() >= Level.INFO.intValue()) {
                        System.out.write(message.getBytes());
                    } else if (verbosity == Verbosity.VERBOSE) {
                        System.out.write(message.getBytes());
                    }
                }
                catch (Exception exception) {
                    this.reportError(null, exception, 5);
                }
            }

            @Override
            public void close() throws SecurityException {
            }

            @Override
            public void flush() {
            }
        };
        logger.addHandler(handler);
        if (verbosity == Verbosity.VERBOSE) {
            handler.setLevel(Level.ALL);
            logger.setLevel(Level.ALL);
        } else {
            handler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getLevel().toString().charAt(0) + ": " + record.getMessage() + System.getProperty("line.separator");
                }
            });
        }
    }

    private static boolean isAdvanceMode() {
        return advanceMode;
    }

    private static void setAdvanceMode() {
        advanceMode = true;
    }

    static {
        buildOptions = new Options();
        decodeOptions = new Options();
        frameOptions = new Options();
        allOptions = new Options();
        emptyOptions = new Options();
        emptyFrameworkOptions = new Options();
        listFrameworkOptions = new Options();
    }

    private static enum Verbosity {
        NORMAL,
        VERBOSE,
        QUIET;

    }
}

