/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.apk;

import brut.androlib.ApktoolProperties;
import brut.androlib.apk.ClassSafeConstructor;
import brut.androlib.apk.EscapedStringRepresenter;
import brut.androlib.apk.PackageInfo;
import brut.androlib.apk.UsesFramework;
import brut.androlib.apk.VersionInfo;
import brut.androlib.exceptions.AndrolibException;
import brut.directory.DirectoryException;
import brut.directory.FileDirectory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public class ApkInfo {
    public String version;
    private String mApkFileName;
    public boolean isFrameworkApk;
    public UsesFramework usesFramework;
    private Map<String, String> mSdkInfo = new LinkedHashMap<String, String>();
    public PackageInfo packageInfo = new PackageInfo();
    public VersionInfo versionInfo = new VersionInfo();
    public boolean resourcesAreCompressed;
    public boolean sharedLibrary;
    public boolean sparseResources;
    public Map<String, String> unknownFiles;
    public Collection<String> doNotCompress;

    public ApkInfo() {
        this.version = ApktoolProperties.getVersion();
    }

    private static Yaml getYaml() {
        DumperOptions dumpOptions = new DumperOptions();
        dumpOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        EscapedStringRepresenter representer = new EscapedStringRepresenter();
        PropertyUtils propertyUtils = representer.getPropertyUtils();
        propertyUtils.setSkipMissingProperties(true);
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(0xA00000);
        return new Yaml(new ClassSafeConstructor(), representer, dumpOptions, loaderOptions);
    }

    public void save(Writer output) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        ApkInfo.getYaml().dump(this, output);
    }

    public String checkTargetSdkVersionBounds() {
        int target = this.mapSdkShorthandToVersion(this.getTargetSdkVersion());
        int min = this.getMinSdkVersion() != null ? this.mapSdkShorthandToVersion(this.getMinSdkVersion()) : 0;
        int max = this.getMaxSdkVersion() != null ? this.mapSdkShorthandToVersion(this.getMaxSdkVersion()) : target;
        target = Math.min(max, target);
        target = Math.max(min, target);
        return Integer.toString(target);
    }

    public String getApkFileName() {
        return this.mApkFileName;
    }

    public void setApkFileName(String apkFileName) {
        this.mApkFileName = apkFileName;
    }

    public Map<String, String> getSdkInfo() {
        return this.mSdkInfo;
    }

    public void setSdkInfo(Map<String, String> sdkInfo) {
        this.mSdkInfo = sdkInfo;
    }

    public String getMinSdkVersion() {
        return this.mSdkInfo.get("minSdkVersion");
    }

    public String getMaxSdkVersion() {
        return this.mSdkInfo.get("maxSdkVersion");
    }

    public String getTargetSdkVersion() {
        return this.mSdkInfo.get("targetSdkVersion");
    }

    public int getMinSdkVersionFromAndroidCodename(String sdkVersion) {
        int sdkNumber = this.mapSdkShorthandToVersion(sdkVersion);
        if (sdkNumber == 1) {
            return Integer.parseInt(this.mSdkInfo.get("minSdkVersion"));
        }
        return sdkNumber;
    }

    private int mapSdkShorthandToVersion(String sdkVersion) {
        switch (sdkVersion.toUpperCase()) {
            case "M": {
                return 23;
            }
            case "N": {
                return 24;
            }
            case "O": {
                return 26;
            }
            case "P": {
                return 28;
            }
            case "Q": {
                return 29;
            }
            case "R": {
                return 30;
            }
            case "S": {
                return 31;
            }
            case "SV2": {
                return 32;
            }
            case "T": 
            case "TIRAMISU": {
                return 33;
            }
            case "UPSIDEDOWNCAKE": 
            case "UPSIDE_DOWN_CAKE": 
            case "VANILLAICECREAM": 
            case "VANILLA_ICE_CREAM": {
                return 10000;
            }
        }
        return Integer.parseInt(sdkVersion);
    }

    public void save(File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
             BufferedWriter writer = new BufferedWriter(outputStreamWriter);){
            this.save(writer);
        }
    }

    public static ApkInfo load(InputStream is) {
        return ApkInfo.getYaml().loadAs(is, ApkInfo.class);
    }

    public static ApkInfo load(File appDir) throws AndrolibException {
        ApkInfo apkInfo;
        block8: {
            InputStream in = new FileDirectory(appDir).getFileInput("apktool.yml");
            try {
                apkInfo = ApkInfo.load(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DirectoryException | IOException ex) {
                    throw new AndrolibException(ex);
                }
            }
            in.close();
        }
        return apkInfo;
    }
}

