/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.CantFindFrameworkResException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResScalarValue;

public class ResAttrDecoder {
    private ResTable mResTable;

    public ResAttrDecoder(ResTable resTable) {
        this.mResTable = resTable;
    }

    public String decode(int type, int value, String rawValue, int attrResId) throws AndrolibException {
        ResScalarValue resValue = this.mResTable.getCurrentResPackage().getValueFactory().factory(type, value, rawValue);
        String decoded = null;
        if (attrResId > 0) {
            try {
                ResAttr attr = (ResAttr)this.mResTable.getResSpec(attrResId).getDefaultResource().getValue();
                decoded = attr.convertToResXmlFormat(resValue);
            }
            catch (UndefinedResObjectException | ClassCastException exception) {
                // empty catch block
            }
        }
        return decoded != null ? decoded : resValue.encodeAsResXmlAttr();
    }

    public String decodeFromResourceId(int attrResId) throws AndrolibException {
        if (attrResId != 0) {
            try {
                ResResSpec resResSpec = this.mResTable.getResSpec(attrResId);
                if (resResSpec != null) {
                    return resResSpec.getName();
                }
            }
            catch (CantFindFrameworkResException | UndefinedResObjectException androlibException) {
                // empty catch block
            }
        }
        return null;
    }

    public ResTable getResTable() throws AndrolibException {
        if (this.mResTable == null) {
            throw new AndrolibException("Res Table not set");
        }
        return this.mResTable;
    }
}

