/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.apk;

import brut.androlib.ApktoolProperties;
import brut.androlib.apk.PackageInfo;
import brut.androlib.apk.UsesFramework;
import brut.androlib.apk.VersionInfo;
import brut.androlib.apk.YamlLine;
import brut.androlib.apk.YamlReader;
import brut.androlib.apk.YamlSerializable;
import brut.androlib.apk.YamlWriter;
import brut.androlib.exceptions.AndrolibException;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.directory.FileDirectory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApkInfo
implements YamlSerializable {
    private transient ExtFile mApkFile;
    public String version;
    public String apkFileName;
    public boolean isFrameworkApk;
    public UsesFramework usesFramework;
    private Map<String, String> sdkInfo = new LinkedHashMap<String, String>();
    public PackageInfo packageInfo = new PackageInfo();
    public VersionInfo versionInfo = new VersionInfo();
    public boolean resourcesAreCompressed;
    public boolean sharedLibrary;
    public boolean sparseResources;
    public Map<String, String> unknownFiles = new LinkedHashMap<String, String>();
    public List<String> doNotCompress;

    public ApkInfo() {
        this(null);
    }

    public ApkInfo(ExtFile apkFile) {
        this.version = ApktoolProperties.getVersion();
        if (apkFile != null) {
            this.setApkFile(apkFile);
        }
    }

    public ExtFile getApkFile() {
        return this.mApkFile;
    }

    public void setApkFile(ExtFile apkFile) {
        this.mApkFile = apkFile;
        if (this.apkFileName == null) {
            this.apkFileName = apkFile.getName();
        }
    }

    public boolean hasManifest() throws AndrolibException {
        if (this.mApkFile == null) {
            return false;
        }
        try {
            return this.mApkFile.getDirectory().containsFile("AndroidManifest.xml");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean hasResources() throws AndrolibException {
        if (this.mApkFile == null) {
            return false;
        }
        try {
            return this.mApkFile.getDirectory().containsFile("resources.arsc");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean hasSources() throws AndrolibException {
        if (this.mApkFile == null) {
            return false;
        }
        try {
            return this.mApkFile.getDirectory().containsFile("classes.dex");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean hasMultipleSources() throws AndrolibException {
        if (this.mApkFile == null) {
            return false;
        }
        try {
            Set<String> files = this.mApkFile.getDirectory().getFiles(false);
            for (String file : files) {
                if (!file.endsWith(".dex") || file.equalsIgnoreCase("classes.dex")) continue;
                return true;
            }
            return false;
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void addUnknownFileInfo(String file, String value) {
        this.unknownFiles.put(file, value);
    }

    public String checkTargetSdkVersionBounds() {
        int target = this.mapSdkShorthandToVersion(this.getTargetSdkVersion());
        int min = this.getMinSdkVersion() != null ? this.mapSdkShorthandToVersion(this.getMinSdkVersion()) : 0;
        int max = this.getMaxSdkVersion() != null ? this.mapSdkShorthandToVersion(this.getMaxSdkVersion()) : target;
        target = Math.min(max, target);
        target = Math.max(min, target);
        return Integer.toString(target);
    }

    public Map<String, String> getSdkInfo() {
        return this.sdkInfo;
    }

    public void setSdkInfoField(String key, String value) {
        this.sdkInfo.put(key, value);
    }

    public String getMinSdkVersion() {
        return this.sdkInfo.get("minSdkVersion");
    }

    public String getMaxSdkVersion() {
        return this.sdkInfo.get("maxSdkVersion");
    }

    public String getTargetSdkVersion() {
        return this.sdkInfo.get("targetSdkVersion");
    }

    public int getMinSdkVersionFromAndroidCodename(String sdkVersion) {
        int sdkNumber = this.mapSdkShorthandToVersion(sdkVersion);
        if (sdkNumber == 1) {
            return Integer.parseInt(this.sdkInfo.get("minSdkVersion"));
        }
        return sdkNumber;
    }

    private int mapSdkShorthandToVersion(String sdkVersion) {
        switch (sdkVersion.toUpperCase()) {
            case "M": {
                return 23;
            }
            case "N": {
                return 24;
            }
            case "O": {
                return 26;
            }
            case "P": {
                return 28;
            }
            case "Q": {
                return 29;
            }
            case "R": {
                return 30;
            }
            case "S": {
                return 31;
            }
            case "SV2": {
                return 32;
            }
            case "T": 
            case "TIRAMISU": {
                return 33;
            }
            case "UPSIDEDOWNCAKE": 
            case "UPSIDE_DOWN_CAKE": 
            case "VANILLAICECREAM": 
            case "VANILLA_ICE_CREAM": {
                return 10000;
            }
        }
        return Integer.parseInt(sdkVersion);
    }

    public void save(File file) throws AndrolibException {
        try (YamlWriter writer = new YamlWriter(new FileOutputStream(file));){
            this.write(writer);
        }
        catch (FileNotFoundException e) {
            throw new AndrolibException("File not found");
        }
        catch (Exception e) {
            throw new AndrolibException(e);
        }
    }

    public static ApkInfo load(InputStream is) throws AndrolibException {
        YamlReader reader = new YamlReader(is);
        ApkInfo apkInfo = new ApkInfo();
        reader.readRoot(apkInfo);
        return apkInfo;
    }

    public static ApkInfo load(File appDir) throws AndrolibException {
        ApkInfo apkInfo;
        block8: {
            InputStream in = new FileDirectory(appDir).getFileInput("apktool.yml");
            try {
                ApkInfo apkInfo2 = ApkInfo.load(in);
                apkInfo2.setApkFile(new ExtFile(appDir));
                apkInfo = apkInfo2;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DirectoryException | IOException ex) {
                    throw new AndrolibException(ex);
                }
            }
            in.close();
        }
        return apkInfo;
    }

    @Override
    public void readItem(YamlReader reader) throws AndrolibException {
        YamlLine line = reader.getLine();
        switch (line.getKey()) {
            case "version": {
                this.version = line.getValue();
                break;
            }
            case "apkFileName": {
                this.apkFileName = line.getValue();
                break;
            }
            case "isFrameworkApk": {
                this.isFrameworkApk = line.getValueBool();
                break;
            }
            case "usesFramework": {
                this.usesFramework = new UsesFramework();
                reader.readObject(this.usesFramework);
                break;
            }
            case "sdkInfo": {
                reader.readMap(this.sdkInfo);
                break;
            }
            case "packageInfo": {
                this.packageInfo = new PackageInfo();
                reader.readObject(this.packageInfo);
                break;
            }
            case "versionInfo": {
                this.versionInfo = new VersionInfo();
                reader.readObject(this.versionInfo);
                break;
            }
            case "compressionType": 
            case "resourcesAreCompressed": {
                this.resourcesAreCompressed = line.getValueBool();
                break;
            }
            case "sharedLibrary": {
                this.sharedLibrary = line.getValueBool();
                break;
            }
            case "sparseResources": {
                this.sparseResources = line.getValueBool();
                break;
            }
            case "unknownFiles": {
                this.unknownFiles = new LinkedHashMap<String, String>();
                reader.readMap(this.unknownFiles);
                break;
            }
            case "doNotCompress": {
                this.doNotCompress = new ArrayList<String>();
                reader.readStringList(this.doNotCompress);
            }
        }
    }

    @Override
    public void write(YamlWriter writer) {
        writer.writeString("version", this.version);
        writer.writeString("apkFileName", this.apkFileName);
        writer.writeBool("isFrameworkApk", this.isFrameworkApk);
        writer.writeObject("usesFramework", this.usesFramework);
        writer.writeStringMap("sdkInfo", this.sdkInfo);
        writer.writeObject("packageInfo", this.packageInfo);
        writer.writeObject("versionInfo", this.versionInfo);
        writer.writeBool("resourcesAreCompressed", this.resourcesAreCompressed);
        writer.writeBool("sharedLibrary", this.sharedLibrary);
        writer.writeBool("sparseResources", this.sparseResources);
        if (this.unknownFiles.size() > 0) {
            writer.writeStringMap("unknownFiles", this.unknownFiles);
        }
        writer.writeList("doNotCompress", this.doNotCompress);
    }
}

