/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.ApktoolProperties;
import brut.androlib.Config;
import brut.androlib.apk.ApkInfo;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.InFileNotFoundException;
import brut.androlib.exceptions.OutDirExistsException;
import brut.androlib.res.ResourcesDecoder;
import brut.androlib.res.data.ResUnknownFiles;
import brut.androlib.src.SmaliDecoder;
import brut.common.BrutException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.util.OS;
import com.android.tools.smali.dexlib2.iface.DexFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class ApkDecoder {
    private static final Logger LOGGER = Logger.getLogger(ApkDecoder.class.getName());
    private final Config mConfig;
    private final ExtFile mApkFile;
    protected final ResUnknownFiles mResUnknownFiles;
    private int mMinSdkVersion = 0;
    private static final String[] APK_STANDARD_ALL_FILENAMES = new String[]{"classes.dex", "AndroidManifest.xml", "resources.arsc", "res", "r", "R", "lib", "libs", "assets", "META-INF", "kotlin"};
    private static final Pattern NO_COMPRESS_PATTERN = Pattern.compile("(jpg|jpeg|png|gif|wav|mp2|mp3|ogg|aac|mpg|mpeg|mid|midi|smf|jet|rtttl|imy|xmf|mp4|m4a|m4v|3gp|3gpp|3g2|3gpp2|amr|awb|wma|wmv|webm|webp|mkv)$");

    public ApkDecoder(Config config, ExtFile apkFile) {
        this.mConfig = config;
        this.mResUnknownFiles = new ResUnknownFiles();
        this.mApkFile = apkFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApkInfo decode(File outDir) throws AndrolibException, IOException, DirectoryException {
        try {
            if (!this.mConfig.forceDelete && outDir.exists()) {
                throw new OutDirExistsException();
            }
            if (!this.mApkFile.isFile() || !this.mApkFile.canRead()) {
                throw new InFileNotFoundException();
            }
            try {
                OS.rmdir(outDir);
            }
            catch (BrutException ex) {
                throw new AndrolibException(ex);
            }
            outDir.mkdirs();
            LOGGER.info("Using Apktool " + ApktoolProperties.getVersion() + " on " + this.mApkFile.getName());
            ResourcesDecoder resourcesDecoder = new ResourcesDecoder(this.mConfig, this.mApkFile);
            resourcesDecoder.decodeManifest(outDir);
            resourcesDecoder.decodeResources(outDir);
            if (this.hasSources()) {
                switch (this.mConfig.decodeSources) {
                    case 0: {
                        this.copySourcesRaw(outDir, "classes.dex");
                        break;
                    }
                    case 1: 
                    case 16: {
                        this.decodeSourcesSmali(outDir, "classes.dex");
                    }
                }
            }
            if (this.hasMultipleSources()) {
                Set<String> files = this.mApkFile.getDirectory().getFiles(true);
                for (String file : files) {
                    if (!file.endsWith(".dex") || file.equalsIgnoreCase("classes.dex")) continue;
                    switch (this.mConfig.decodeSources) {
                        case 0: {
                            this.copySourcesRaw(outDir, file);
                            break;
                        }
                        case 1: {
                            this.decodeSourcesSmali(outDir, file);
                            break;
                        }
                        case 16: {
                            if (file.startsWith("classes") && file.endsWith(".dex")) {
                                this.decodeSourcesSmali(outDir, file);
                                break;
                            }
                            this.copySourcesRaw(outDir, file);
                        }
                    }
                }
            }
            ApkInfo apkInfo = resourcesDecoder.getApkInfo();
            if (!resourcesDecoder.hasResources() && this.mMinSdkVersion > 0) {
                apkInfo.setSdkInfoField("minSdkVersion", Integer.toString(this.mMinSdkVersion));
            }
            this.copyRawFiles(outDir);
            this.copyUnknownFiles(apkInfo, outDir);
            ArrayList<String> mUncompressedFiles = new ArrayList<String>();
            this.recordUncompressedFiles(apkInfo, resourcesDecoder.getResFileMapping(), mUncompressedFiles);
            this.copyOriginalFiles(outDir);
            this.writeApkInfo(apkInfo, outDir);
            ApkInfo apkInfo2 = apkInfo;
            return apkInfo2;
        }
        finally {
            try {
                this.mApkFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean hasSources() throws AndrolibException {
        try {
            return this.mApkFile.getDirectory().containsFile("classes.dex");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private boolean hasMultipleSources() throws AndrolibException {
        try {
            Set<String> files = this.mApkFile.getDirectory().getFiles(false);
            for (String file : files) {
                if (!file.endsWith(".dex") || file.equalsIgnoreCase("classes.dex")) continue;
                return true;
            }
            return false;
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void writeApkInfo(ApkInfo apkInfo, File outDir) throws AndrolibException {
        try {
            apkInfo.save(new File(outDir, "apktool.yml"));
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void copySourcesRaw(File outDir, String filename) throws AndrolibException {
        try {
            LOGGER.info("Copying raw " + filename + " file...");
            this.mApkFile.getDirectory().copyToDir(outDir, filename);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void decodeSourcesSmali(File outDir, String filename) throws AndrolibException {
        try {
            File smaliDir = filename.equalsIgnoreCase("classes.dex") ? new File(outDir, "smali") : new File(outDir, "smali_" + filename.substring(0, filename.indexOf(".")));
            OS.rmdir(smaliDir);
            smaliDir.mkdirs();
            LOGGER.info("Baksmaling " + filename + "...");
            DexFile dexFile = SmaliDecoder.decode(this.mApkFile, smaliDir, filename, this.mConfig.baksmaliDebugMode, this.mConfig.apiLevel);
            int minSdkVersion = dexFile.getOpcodes().api;
            if (this.mMinSdkVersion == 0 || this.mMinSdkVersion > minSdkVersion) {
                this.mMinSdkVersion = minSdkVersion;
            }
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void copyRawFiles(File outDir) throws AndrolibException {
        LOGGER.info("Copying assets and libs...");
        try {
            Directory in = this.mApkFile.getDirectory();
            if (this.mConfig.decodeAssets == 1 && in.containsDir("assets")) {
                in.copyToDir(outDir, "assets");
            }
            if (in.containsDir("lib")) {
                in.copyToDir(outDir, "lib");
            }
            if (in.containsDir("libs")) {
                in.copyToDir(outDir, "libs");
            }
            if (in.containsDir("kotlin")) {
                in.copyToDir(outDir, "kotlin");
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private boolean isAPKFileNames(String file) {
        for (String apkFile : APK_STANDARD_ALL_FILENAMES) {
            if (!apkFile.equals(file) && !file.startsWith(apkFile + "/")) continue;
            return true;
        }
        return false;
    }

    private void copyUnknownFiles(ApkInfo apkInfo, File outDir) throws AndrolibException {
        LOGGER.info("Copying unknown files...");
        File unknownOut = new File(outDir, "unknown");
        try {
            Directory unk = this.mApkFile.getDirectory();
            Set<String> files = unk.getFiles(true);
            for (String file : files) {
                if (this.isAPKFileNames(file) || file.endsWith(".dex")) continue;
                unk.copyToDir(unknownOut, file);
                this.mResUnknownFiles.addUnknownFileInfo(file, String.valueOf(unk.getCompressionLevel(file)));
            }
            apkInfo.unknownFiles = this.mResUnknownFiles.getUnknownFiles();
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void copyOriginalFiles(File outDir) throws AndrolibException {
        LOGGER.info("Copying original files...");
        File originalDir = new File(outDir, "original");
        if (!originalDir.exists()) {
            originalDir.mkdirs();
        }
        try {
            Directory in = this.mApkFile.getDirectory();
            if (in.containsFile("AndroidManifest.xml")) {
                in.copyToDir(originalDir, "AndroidManifest.xml");
            }
            if (in.containsFile("stamp-cert-sha256")) {
                in.copyToDir(originalDir, "stamp-cert-sha256");
            }
            if (in.containsDir("META-INF")) {
                in.copyToDir(originalDir, "META-INF");
                if (in.containsDir("META-INF/services")) {
                    LOGGER.info("Copying META-INF/services directory");
                    in.copyToDir(outDir, "META-INF/services");
                }
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void recordUncompressedFiles(ApkInfo apkInfo, Map<String, String> resFileMapping, Collection<String> uncompressedFilesOrExts) throws AndrolibException {
        try {
            Directory unk = this.mApkFile.getDirectory();
            Set<String> files = unk.getFiles(true);
            for (String file : files) {
                if (!this.isAPKFileNames(file) || unk.getCompressionLevel(file) != 0) continue;
                String extOrFile = "";
                if (unk.getSize(file) != 0L) {
                    extOrFile = FilenameUtils.getExtension(file);
                }
                if ((extOrFile.isEmpty() || !NO_COMPRESS_PATTERN.matcher(extOrFile).find()) && resFileMapping.containsKey(extOrFile = file)) {
                    extOrFile = resFileMapping.get(extOrFile);
                }
                if (uncompressedFilesOrExts.contains(extOrFile)) continue;
                uncompressedFilesOrExts.add(extOrFile);
            }
            if (!uncompressedFilesOrExts.isEmpty()) {
                apkInfo.doNotCompress = uncompressedFilesOrExts;
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }
}

