/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res;

import brut.androlib.Config;
import brut.androlib.apk.ApkInfo;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResValuesFile;
import brut.androlib.res.decoder.AXmlResourceParser;
import brut.androlib.res.decoder.AndroidManifestResourceParser;
import brut.androlib.res.decoder.Res9patchStreamDecoder;
import brut.androlib.res.decoder.ResAttrDecoder;
import brut.androlib.res.decoder.ResFileDecoder;
import brut.androlib.res.decoder.ResRawStreamDecoder;
import brut.androlib.res.decoder.ResStreamDecoderContainer;
import brut.androlib.res.decoder.XmlPullStreamDecoder;
import brut.androlib.res.util.ExtMXSerializer;
import brut.androlib.res.util.ExtXmlSerializer;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import brut.androlib.res.xml.ResXmlPatcher;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.directory.FileDirectory;
import brut.util.Duo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlSerializer;

public class ResourcesDecoder {
    private static final Logger LOGGER = Logger.getLogger(ResourcesDecoder.class.getName());
    private final Config mConfig;
    private final ExtFile mApkFile;
    private final ResTable mResTable;
    private final ApkInfo mApkInfo;
    private final Map<String, String> mResFileMapping = new HashMap<String, String>();
    private static final String[] APK_RESOURCES_FILENAMES = new String[]{"resources.arsc", "res", "r", "R"};
    private static final String[] APK_MANIFEST_FILENAMES = new String[]{"AndroidManifest.xml"};
    private static final String[] IGNORED_PACKAGES = new String[]{"android", "com.htc", "com.lge", "com.lge.internal", "yi", "flyme", "air.com.adobe.appentry", "FFFFFFFFFFFFFFFFFFFFFF"};

    public ResourcesDecoder(Config config, ExtFile apkFile) {
        this.mConfig = config;
        this.mApkFile = apkFile;
        this.mApkInfo = new ApkInfo();
        this.mApkInfo.setApkFileName(apkFile.getName());
        this.mResTable = new ResTable(this.mConfig, this.mApkInfo);
    }

    public boolean hasManifest() throws AndrolibException {
        try {
            return this.mApkFile.getDirectory().containsFile("AndroidManifest.xml");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean hasResources() throws AndrolibException {
        try {
            return this.mApkFile.getDirectory().containsFile("resources.arsc");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public ResTable getResTable() throws AndrolibException {
        if (!this.hasManifest() && !this.hasResources()) {
            throw new AndrolibException("Apk doesn't contain either AndroidManifest.xml file or resources.arsc file");
        }
        if (this.hasResources() && !this.mResTable.isMainPkgLoaded()) {
            this.mResTable.loadMainPkg(this.mApkFile);
        }
        return this.mResTable;
    }

    public ApkInfo getApkInfo() {
        return this.mApkInfo;
    }

    public Map<String, String> getResFileMapping() {
        return this.mResFileMapping;
    }

    public void decodeManifest(File outDir) throws AndrolibException {
        if (this.hasManifest()) {
            if (this.mConfig.decodeResources == 257 || this.mConfig.forceDecodeManifest == 1) {
                this.decodeManifest(this.getResTable(), this.mApkFile, outDir);
                if (this.hasResources() && !this.mConfig.analysisMode) {
                    this.adjustPackageManifest(this.getResTable(), outDir.getAbsolutePath() + File.separator + "AndroidManifest.xml");
                    ResXmlPatcher.removeManifestVersions(new File(outDir.getAbsolutePath() + File.separator + "AndroidManifest.xml"));
                    this.mApkInfo.packageInfo.forcedPackageId = String.valueOf(this.mResTable.getPackageId());
                }
            } else {
                try {
                    LOGGER.info("Copying raw manifest...");
                    this.mApkFile.getDirectory().copyToDir(outDir, APK_MANIFEST_FILENAMES);
                }
                catch (DirectoryException ex) {
                    throw new AndrolibException(ex);
                }
            }
        }
    }

    private void decodeManifest(ResTable resTable, ExtFile apkFile, File outDir) throws AndrolibException {
        AndroidManifestResourceParser axmlParser = new AndroidManifestResourceParser();
        ResAttrDecoder attrDecoder = new ResAttrDecoder();
        attrDecoder.setResTable(resTable);
        axmlParser.setAttrDecoder(attrDecoder);
        XmlPullStreamDecoder fileDecoder = new XmlPullStreamDecoder(axmlParser, this.getResXmlSerializer());
        try {
            Directory inApk = apkFile.getDirectory();
            FileDirectory out = new FileDirectory(outDir);
            if (this.hasResources()) {
                LOGGER.info("Decoding AndroidManifest.xml with resources...");
            } else {
                LOGGER.info("Decoding AndroidManifest.xml with only framework resources...");
            }
            InputStream inputStream = inApk.getFileInput("AndroidManifest.xml");
            OutputStream outputStream = out.getFileOutput("AndroidManifest.xml");
            fileDecoder.decodeManifest(inputStream, outputStream);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void adjustPackageManifest(ResTable resTable, String filePath) throws AndrolibException {
        ResPackage resPackage = resTable.getCurrentResPackage();
        String pkgOriginal = resPackage.getName();
        String pkgRenamed = resTable.getPackageRenamed();
        resTable.setPackageId(resPackage.getId());
        resTable.setPackageOriginal(pkgOriginal);
        if (pkgOriginal == null || pkgRenamed == null || pkgOriginal.equalsIgnoreCase(pkgRenamed) || Arrays.asList(IGNORED_PACKAGES).contains(pkgOriginal)) {
            LOGGER.info("Regular manifest package...");
        } else {
            LOGGER.info("Renamed manifest package found! Replacing " + pkgRenamed + " with " + pkgOriginal);
            ResXmlPatcher.renameManifestPackage(new File(filePath), pkgOriginal);
        }
    }

    private ExtMXSerializer getResXmlSerializer() {
        ExtMXSerializer serial = new ExtMXSerializer();
        serial.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "    ");
        serial.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", System.getProperty("line.separator"));
        serial.setProperty("DEFAULT_ENCODING", "utf-8");
        serial.setDisabledAttrEscape(true);
        return serial;
    }

    public ResTable decodeResources(File outDir) throws AndrolibException {
        if (this.hasResources()) {
            switch (this.mConfig.decodeResources) {
                case 256: {
                    try {
                        LOGGER.info("Copying raw resources...");
                        this.mApkFile.getDirectory().copyToDir(outDir, APK_RESOURCES_FILENAMES);
                        break;
                    }
                    catch (DirectoryException ex) {
                        throw new AndrolibException(ex);
                    }
                }
                case 257: {
                    this.decodeResources(this.getResTable(), this.mApkFile, outDir);
                }
            }
            this.mResTable.initApkInfo(this.mApkInfo, outDir);
        }
        return this.mResTable;
    }

    private void decodeResources(ResTable resTable, ExtFile apkFile, File outDir) throws AndrolibException {
        Directory in;
        Directory out;
        Duo<ResFileDecoder, AXmlResourceParser> duo = this.getResFileDecoder();
        ResFileDecoder fileDecoder = (ResFileDecoder)duo.m1;
        ResAttrDecoder attrDecoder = ((AXmlResourceParser)duo.m2).getAttrDecoder();
        attrDecoder.setResTable(resTable);
        try {
            out = new FileDirectory(outDir);
            in = apkFile.getDirectory();
            out = out.createDir("res");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        ExtMXSerializer xmlSerializer = this.getResXmlSerializer();
        for (ResPackage pkg : resTable.listMainPackages()) {
            LOGGER.info("Decoding file-resources...");
            for (ResResource res : pkg.listFiles()) {
                fileDecoder.decode(res, in, out, this.mResFileMapping);
            }
            LOGGER.info("Decoding values */* XMLs...");
            for (ResValuesFile valuesFile : pkg.listValuesFiles()) {
                this.generateValuesFile(valuesFile, out, xmlSerializer);
            }
            this.generatePublicXml(pkg, out, xmlSerializer);
        }
        AndrolibException decodeError = ((AXmlResourceParser)duo.m2).getFirstError();
        if (decodeError != null) {
            throw decodeError;
        }
    }

    private Duo<ResFileDecoder, AXmlResourceParser> getResFileDecoder() {
        ResStreamDecoderContainer decoders = new ResStreamDecoderContainer();
        decoders.setDecoder("raw", new ResRawStreamDecoder());
        decoders.setDecoder("9patch", new Res9patchStreamDecoder());
        AXmlResourceParser axmlParser = new AXmlResourceParser();
        axmlParser.setAttrDecoder(new ResAttrDecoder());
        decoders.setDecoder("xml", new XmlPullStreamDecoder(axmlParser, this.getResXmlSerializer()));
        return new Duo<ResFileDecoder, AXmlResourceParser>(new ResFileDecoder(decoders), axmlParser);
    }

    private void generateValuesFile(ResValuesFile valuesFile, Directory out, ExtXmlSerializer serial) throws AndrolibException {
        try {
            OutputStream outStream = out.getFileOutput(valuesFile.getPath());
            serial.setOutput(outStream, null);
            serial.startDocument(null, null);
            serial.startTag(null, "resources");
            for (ResResource res : valuesFile.listResources()) {
                if (valuesFile.isSynthesized(res)) continue;
                ((ResValuesXmlSerializable)((Object)res.getValue())).serializeToResValuesXml(serial, res);
            }
            serial.endTag(null, "resources");
            serial.newLine();
            serial.endDocument();
            serial.flush();
            outStream.close();
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException("Could not generate: " + valuesFile.getPath(), ex);
        }
    }

    private void generatePublicXml(ResPackage pkg, Directory out, XmlSerializer serial) throws AndrolibException {
        try {
            OutputStream outStream = out.getFileOutput("values/public.xml");
            serial.setOutput(outStream, null);
            serial.startDocument(null, null);
            serial.startTag(null, "resources");
            for (ResResSpec spec : pkg.listResSpecs()) {
                serial.startTag(null, "public");
                serial.attribute(null, "type", spec.getType().getName());
                serial.attribute(null, "name", spec.getName());
                serial.attribute(null, "id", String.format("0x%08x", spec.getId().id));
                serial.endTag(null, "public");
            }
            serial.endTag(null, "resources");
            serial.endDocument();
            serial.flush();
            outStream.close();
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException("Could not generate public.xml file", ex);
        }
    }
}

