/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.ApkDecoder;
import brut.androlib.Config;
import brut.androlib.apk.ApkInfo;
import brut.androlib.apk.UsesFramework;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.Framework;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.decoder.ARSCDecoder;
import brut.androlib.res.xml.ResXmlPatcher;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import com.google.common.base.Strings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ResTable {
    private static final Logger LOGGER = Logger.getLogger(ApkDecoder.class.getName());
    private final Config mConfig;
    private final ApkInfo mApkInfo;
    private final Map<Integer, ResPackage> mPackagesById = new HashMap<Integer, ResPackage>();
    private final Map<String, ResPackage> mPackagesByName = new HashMap<String, ResPackage>();
    private final Set<ResPackage> mMainPackages = new LinkedHashSet<ResPackage>();
    private final Set<ResPackage> mFramePackages = new LinkedHashSet<ResPackage>();
    private String mPackageRenamed;
    private String mPackageOriginal;
    private int mPackageId;
    private boolean mMainPkgLoaded = false;

    public ResTable() {
        this(Config.getDefaultConfig(), new ApkInfo());
    }

    public ResTable(Config config, ApkInfo apkInfo) {
        this.mConfig = config;
        this.mApkInfo = apkInfo;
    }

    public boolean getAnalysisMode() {
        return this.mConfig.analysisMode;
    }

    public boolean isMainPkgLoaded() {
        return this.mMainPkgLoaded;
    }

    public ResResSpec getResSpec(int resID) throws AndrolibException {
        if (resID >> 24 == 0) {
            int pkgId = this.mPackageId == 0 ? 2 : this.mPackageId;
            resID = 0xFF000000 & pkgId << 24 | resID;
        }
        return this.getResSpec(new ResID(resID));
    }

    public ResResSpec getResSpec(ResID resID) throws AndrolibException {
        return this.getPackage(resID.pkgId).getResSpec(resID);
    }

    public Set<ResPackage> listMainPackages() {
        return this.mMainPackages;
    }

    public ResPackage getPackage(int id) throws AndrolibException {
        ResPackage pkg = this.mPackagesById.get(id);
        if (pkg != null) {
            return pkg;
        }
        pkg = this.loadFrameworkPkg(id);
        this.addPackage(pkg, false);
        return pkg;
    }

    private ResPackage selectPkgWithMostResSpecs(ResPackage[] pkgs) {
        int id = 0;
        int value = 0;
        int index = 0;
        for (int i = 0; i < pkgs.length; ++i) {
            ResPackage resPackage = pkgs[i];
            if (resPackage.getResSpecCount() <= value || resPackage.getName().equalsIgnoreCase("android")) continue;
            value = resPackage.getResSpecCount();
            id = resPackage.getId();
            index = i;
        }
        return id == 0 ? pkgs[0] : pkgs[index];
    }

    public void loadMainPkg(ExtFile apkFile) throws AndrolibException {
        ResPackage pkg;
        LOGGER.info("Loading resource table...");
        ResPackage[] pkgs = this.loadResPackagesFromApk(apkFile, this.mConfig.keepBrokenResources);
        switch (pkgs.length) {
            case 0: {
                pkg = new ResPackage(this, 0, null);
                break;
            }
            case 1: {
                pkg = pkgs[0];
                break;
            }
            case 2: {
                LOGGER.warning("Skipping package group: " + pkgs[0].getName());
                pkg = pkgs[1];
                break;
            }
            default: {
                pkg = this.selectPkgWithMostResSpecs(pkgs);
            }
        }
        this.addPackage(pkg, true);
        this.mMainPkgLoaded = true;
    }

    private ResPackage loadFrameworkPkg(int id) throws AndrolibException {
        ResPackage pkg;
        Framework framework = new Framework(this.mConfig);
        File frameworkApk = framework.getFrameworkApk(id, this.mConfig.frameworkTag);
        LOGGER.info("Loading resource table from file: " + frameworkApk);
        ResPackage[] pkgs = this.loadResPackagesFromApk(new ExtFile(frameworkApk), true);
        if (pkgs.length > 1) {
            pkg = this.selectPkgWithMostResSpecs(pkgs);
        } else {
            if (pkgs.length == 0) {
                throw new AndrolibException("Arsc files with zero or multiple packages");
            }
            pkg = pkgs[0];
        }
        if (pkg.getId() != id) {
            throw new AndrolibException("Expected pkg of id: " + id + ", got: " + pkg.getId());
        }
        return pkg;
    }

    private ResPackage[] loadResPackagesFromApk(ExtFile apkFile, boolean keepBrokenResources) throws AndrolibException {
        ResPackage[] resPackageArray;
        Directory dir = apkFile.getDirectory();
        BufferedInputStream bfi = new BufferedInputStream(dir.getFileInput("resources.arsc"));
        try {
            resPackageArray = ARSCDecoder.decode(bfi, false, keepBrokenResources, this).getPackages();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bfi.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (DirectoryException | IOException ex) {
                throw new AndrolibException("Could not load resources.arsc from file: " + apkFile, ex);
            }
        }
        bfi.close();
        return resPackageArray;
    }

    public ResPackage getHighestSpecPackage() throws AndrolibException {
        int id = 0;
        int value = 0;
        for (ResPackage resPackage : this.mPackagesById.values()) {
            if (resPackage.getResSpecCount() <= value || resPackage.getName().equalsIgnoreCase("android")) continue;
            value = resPackage.getResSpecCount();
            id = resPackage.getId();
        }
        return id == 0 ? this.getPackage(1) : this.getPackage(id);
    }

    public ResPackage getCurrentResPackage() throws AndrolibException {
        ResPackage pkg = this.mPackagesById.get(this.mPackageId);
        if (pkg != null) {
            return pkg;
        }
        if (this.mMainPackages.size() == 1) {
            return this.mMainPackages.iterator().next();
        }
        return this.getHighestSpecPackage();
    }

    public ResPackage getPackage(String name) throws AndrolibException {
        ResPackage pkg = this.mPackagesByName.get(name);
        if (pkg == null) {
            throw new UndefinedResObjectException("package: name=" + name);
        }
        return pkg;
    }

    public void addPackage(ResPackage pkg, boolean main) throws AndrolibException {
        Integer id = pkg.getId();
        if (this.mPackagesById.containsKey(id)) {
            throw new AndrolibException("Multiple packages: id=" + id);
        }
        String name = pkg.getName();
        if (this.mPackagesByName.containsKey(name)) {
            throw new AndrolibException("Multiple packages: name=" + name);
        }
        this.mPackagesById.put(id, pkg);
        this.mPackagesByName.put(name, pkg);
        if (main) {
            this.mMainPackages.add(pkg);
        } else {
            this.mFramePackages.add(pkg);
        }
    }

    public void setPackageRenamed(String pkg) {
        this.mPackageRenamed = pkg;
    }

    public void setPackageOriginal(String pkg) {
        this.mPackageOriginal = pkg;
    }

    public void setPackageId(int id) {
        this.mPackageId = id;
    }

    public void setSharedLibrary(boolean flag) {
        this.mApkInfo.sharedLibrary = flag;
    }

    public void setSparseResources(boolean flag) {
        this.mApkInfo.sparseResources = flag;
    }

    public void clearSdkInfo() {
        this.mApkInfo.getSdkInfo().clear();
    }

    public void addSdkInfo(String key, String value) {
        this.mApkInfo.getSdkInfo().put(key, value);
    }

    public void setVersionName(String versionName) {
        this.mApkInfo.versionInfo.versionName = versionName;
    }

    public void setVersionCode(String versionCode) {
        this.mApkInfo.versionInfo.versionCode = versionCode;
    }

    public String getPackageRenamed() {
        return this.mPackageRenamed;
    }

    public String getPackageOriginal() {
        return this.mPackageOriginal;
    }

    public int getPackageId() {
        return this.mPackageId;
    }

    private boolean isFrameworkApk() {
        for (ResPackage pkg : this.mMainPackages) {
            if (pkg.getId() <= 0 || pkg.getId() >= 64) continue;
            return true;
        }
        return false;
    }

    public void initApkInfo(ApkInfo apkInfo, File outDir) throws AndrolibException {
        apkInfo.isFrameworkApk = this.isFrameworkApk();
        apkInfo.usesFramework = this.getUsesFramework();
        if (!this.mApkInfo.getSdkInfo().isEmpty()) {
            this.updateSdkInfoFromResources(outDir);
        }
        this.initPackageInfo();
        this.loadVersionName(outDir);
    }

    private UsesFramework getUsesFramework() {
        UsesFramework info = new UsesFramework();
        Object[] ids = new Integer[this.mFramePackages.size()];
        int i = 0;
        for (ResPackage pkg : this.mFramePackages) {
            ids[i++] = pkg.getId();
        }
        Arrays.sort(ids);
        info.ids = Arrays.asList(ids);
        info.tag = this.mConfig.frameworkTag;
        return info;
    }

    private void updateSdkInfoFromResources(File outDir) {
        String refValue;
        Map<String, String> sdkInfo = this.mApkInfo.getSdkInfo();
        if (sdkInfo.get("minSdkVersion") != null && (refValue = ResXmlPatcher.pullValueFromIntegers(outDir, sdkInfo.get("minSdkVersion"))) != null) {
            sdkInfo.put("minSdkVersion", refValue);
        }
        if (sdkInfo.get("targetSdkVersion") != null && (refValue = ResXmlPatcher.pullValueFromIntegers(outDir, sdkInfo.get("targetSdkVersion"))) != null) {
            sdkInfo.put("targetSdkVersion", refValue);
        }
        if (sdkInfo.get("maxSdkVersion") != null && (refValue = ResXmlPatcher.pullValueFromIntegers(outDir, sdkInfo.get("maxSdkVersion"))) != null) {
            sdkInfo.put("maxSdkVersion", refValue);
        }
    }

    private void initPackageInfo() throws AndrolibException {
        String renamed = this.getPackageRenamed();
        String original = this.getPackageOriginal();
        int id = this.getPackageId();
        try {
            id = this.getPackage(renamed).getId();
        }
        catch (UndefinedResObjectException undefinedResObjectException) {
            // empty catch block
        }
        if (Strings.isNullOrEmpty(original)) {
            return;
        }
        if (renamed != null && !renamed.equalsIgnoreCase(original)) {
            this.mApkInfo.packageInfo.renameManifestPackage = renamed;
        }
        this.mApkInfo.packageInfo.forcedPackageId = String.valueOf(id);
    }

    private void loadVersionName(File outDir) {
        String versionName = this.mApkInfo.versionInfo.versionName;
        String refValue = ResXmlPatcher.pullValueFromStrings(outDir, versionName);
        if (refValue != null) {
            this.mApkInfo.versionInfo.versionName = refValue;
        }
    }
}

