# Changelog

Report issues to [GitHub].

For Android Studio issues, follow the docs on the [Android Studio site].

If you're a build system maintainer that needs to use the tools in the NDK
directly, see the [build system maintainers guide].

[GitHub]: https://github.com/android/ndk/issues
[Android Studio site]: http://tools.android.com/filing-bugs
[build system maintainers guide]: https://android.googlesource.com/platform/ndk/+/master/docs/BuildSystemMaintainers.md


## Announcements

* Support for KitKat (APIs 19 and 20) is planned to be removed in the next NDK
  release. The minimum OS supported by the NDK for r26 will be Lollipop (API
  level 21). See [Issue 1751] for details.

[Issue 1751]: https://github.com/android/ndk/issues/1751

## r25c

* Updated LLVM to clang-r450784d1, based on LLVM 14 development.
  * [Issue 1797]: Fixed LLDB handling of forward slashes in absolute paths on
    Windows.
  * [Issue 1832]: Improvements to aarch64 vector code generation.
* [Issue 1813]: `-Wl,--gc-sections` is no longer set by default for debug
  builds. This behavior was removed because it could cause the linker to remove
  functions that may be useful to evaluate during debugging. The new CMake
  toolchain file (`-DANDROID_USE_LEGACY_TOOLCHAIN_FILE=OFF`, not the default
  behavior) does not include this fix because it requires a CMake fix first.
* [Issue 1757]: Updated simpleperf. Includes fix for signing denial when run on
  macOS.

[Issue 1757]: https://github.com/android/ndk/issues/1757
[Issue 1797]: https://github.com/android/ndk/issues/1797
[Issue 1813]: https://github.com/android/ndk/issues/1813
[Issue 1832]: https://github.com/android/ndk/issues/1832

## r25b

* [Issue 1739]: Fixed C compatibility issue in `amidi/AMidi.h`.
* [Issue 1740]: Fixed the legacy toolchain when using CMake's `Release` build
  configuration. Since r23b it has not be receiving any optimization flag. It
  will now receive `-O3`. If you're building with AGP and haven't overridden
  AGP's default CMake modes, this change does not affect you, as AGP uses
  `RelWithDebInfo` by default.
* [Issue 1744]: Fixes ASan wrap.sh file to support 32-bit apps on 64-bit
  devices.

[Issue 1739]: https://github.com/android/ndk/issues/1739
[Issue 1740]: https://github.com/android/ndk/issues/1740
[Issue 1744]: https://github.com/android/ndk/issues/1744

## Changes

* Includes Android 13 APIs.
* Updated LLVM to clang-r450784d, based on LLVM 14 development.
  * [Issue 1455]: Improved display of Android API levels in Clang diagnostics.
  * [Issue 1608]: Fixed crash in vector conversions.
  * [Issue 1710]: Fixed compiler crash caused by invalid `-march` values.
* Eliminate duplicate static libraries in API-versioned sysroot directories.
  This reduces the uncompressed size of the NDK by 500 MB.
* Strip some binaries and libraries. This reduces the uncompressed size of
  the NDK by 300 MB.
* Remove python2. All scripts now use python3.
* [Issue 933]: Updated reference ASan wrap.sh to support attaching the Java
  debugger.
* [Issue 1334]: Improved argument escaping for compile_commands.json files
  generated by ndk-build.
* [Issue 1634]: Fixed the build rule for the libshaderc_combined target.
* [Issue 1693]: The NDK's toolchain file for CMake (`android.toolchain.cmake`)
  defaults to the legacy toolchain file for all versions of CMake. The new
  toolchain file can still be enabled using
  `-DANDROID_USE_LEGACY_TOOLCHAIN_FILE=OFF`.
* [Issue 1717]: Arranged for --gc-sections to be passed to the linker when
  building shared libraries.

[Issue 933]: https://github.com/android/ndk/issues/933
[Issue 1334]: https://github.com/android/ndk/issues/1334
[Issue 1455]: https://github.com/android/ndk/issues/1455
[Issue 1608]: https://github.com/android/ndk/issues/1608
[Issue 1634]: https://github.com/android/ndk/issues/1634
[Issue 1693]: https://github.com/android/ndk/issues/1693
[Issue 1710]: https://github.com/android/ndk/issues/1710
[Issue 1717]: https://github.com/android/ndk/issues/1717

## Known Issues

This is not intended to be a comprehensive list of all outstanding bugs.

* [Issue 360]: `thread_local` variables with non-trivial destructors will cause
  segfaults if the containing library is `dlclose`ed. This was fixed in API 28,
  but code running on devices older than API 28 will need a workaround. The
  simplest fix is to **stop calling `dlclose`**. If you absolutely must continue
  calling `dlclose`, see the following table:

  |                   | Pre-API 23           |  APIs 23-27   | API 28+ |
  | ----------------- | -------------------- | ------------- | ------- |
  | No workarounds    | Works for static STL | Broken        | Works   |
  | `-Wl,-z,nodelete` | Works for static STL | Works         | Works   |
  | No `dlclose`      | Works                | Works         | Works   |

  If your code must run on devices older than M (API 23) and you cannot use the
  static STL (common), **the only fix is to not call `dlclose`**, or to stop
  using `thread_local` variables with non-trivial destructors.

  If your code does not need to run on devices older than API 23 you can link
  with `-Wl,-z,nodelete`, which instructs the linker to ignore `dlclose` for
  that library. You can backport this behavior by not calling `dlclose`.

  The fix in API 28 is the standardized inhibition of `dlclose`, so you can
  backport the fix to older versions by not calling `dlclose`.

* [Issue 988]: Exception handling when using ASan via wrap.sh can crash. To
  workaround this issue when using libc++_shared, ensure that your application's
  libc++_shared.so is in `LD_PRELOAD` in your `wrap.sh` as in the following
  example:

  ```bash
  #!/system/bin/sh
  HERE="$(cd "$(dirname "$0")" && pwd)"
  export ASAN_OPTIONS=log_to_syslog=false,allow_user_segv_handler=1
  ASAN_LIB=$(ls $HERE/libclang_rt.asan-*-android.so)
  if [ -f "$HERE/libc++_shared.so" ]; then
      # Workaround for https://github.com/android/ndk/issues/988.
      export LD_PRELOAD="$ASAN_LIB $HERE/libc++_shared.so"
  else
      export LD_PRELOAD="$ASAN_LIB"
  fi
  "$@"
   ```

  There is no known workaround for libc++_static.

  Note that because this is a platform bug rather than an NDK bug this cannot be
  fixed with an NDK update. This workaround will be necessary for code running
  on devices that do not contain the fix, and the bug has not been fixed even in
  the latest release of Android.

[Issue 360]: https://github.com/android/ndk/issues/360
[Issue 988]: https://github.com/android/ndk/issues/988
