/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator;

import com.pholser.junit.quickcheck.Pair;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.internal.Items;
import com.pholser.junit.quickcheck.internal.Weighted;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@FunctionalInterface
public interface Gen<T> {
    public T generate(SourceOfRandomness var1, GenerationStatus var2);

    default public <U> Gen<U> map(Function<? super T, ? extends U> mapper) {
        return (random, status) -> mapper.apply((T)this._gen(random, status));
    }

    default public <U> Gen<U> flatMap(Function<? super T, ? extends Gen<? extends U>> mapper) {
        return (random, status) -> ((Gen)mapper.apply((T)this._gen(random, status)))._gen(random, status);
    }

    default public Gen<T> filter(Predicate<? super T> condition) {
        return (random, status) -> {
            T next = this._gen(random, status);
            while (!condition.test((T)next)) {
                next = this._gen(random, status);
            }
            return next;
        };
    }

    default public Gen<Optional<T>> filterOptional(Predicate<? super T> condition) {
        return (random, status) -> {
            T next = this._gen(random, status);
            return condition.test((T)next) ? Optional.ofNullable(next) : Optional.empty();
        };
    }

    default public Gen<List<T>> times(int times) {
        if (times < 0) {
            throw new IllegalArgumentException("negative times: " + times);
        }
        return (random, status) -> {
            ArrayList<T> values = new ArrayList<T>();
            for (int i = 0; i < times; ++i) {
                values.add(this._gen(random, status));
            }
            return values;
        };
    }

    public static <U> Gen<U> pure(U constant) {
        return (random, status) -> constant;
    }

    @SafeVarargs
    public static <U> Gen<U> oneOf(U first, U ... rest) {
        ArrayList choices = new ArrayList();
        choices.add(first);
        Collections.addAll(choices, rest);
        return (random, status) -> Items.choose(choices, random);
    }

    @SafeVarargs
    public static <U> Gen<U> oneOf(Gen<? extends U> first, Gen<? extends U> ... rest) {
        ArrayList choices = new ArrayList();
        choices.add(first);
        Collections.addAll(choices, rest);
        return (random, status) -> ((Gen)Items.choose(choices, random))._gen(random, status);
    }

    @SafeVarargs
    public static <U> Gen<U> frequency(Pair<Integer, Gen<? extends U>> first, Pair<Integer, Gen<? extends U>> ... rest) {
        ArrayList<Pair<Integer, Gen<? extends U>>> pairs = new ArrayList<Pair<Integer, Gen<? extends U>>>();
        pairs.add(first);
        Collections.addAll(pairs, rest);
        List weighted = pairs.stream().map((? super T p) -> new Weighted(p.second, (Integer)p.first)).collect(Collectors.toList());
        return (random, status) -> ((Gen)Items.chooseWeighted(weighted, random))._gen(random, status);
    }

    public static <U> Pair<Integer, Gen<? extends U>> freq(int weight, Gen<? extends U> generator) {
        return new Pair<Integer, Gen<? extends U>>(weight, generator);
    }

    @Deprecated
    default public T _gen(SourceOfRandomness random, GenerationStatus status) {
        T result = this.generate(random, status);
        status.semiAttempt();
        return result;
    }
}

