/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator;

import java.util.Objects;
import java.util.Optional;

public interface GenerationStatus {
    public int size();

    public int attempts();

    default public void semiAttempt() {
    }

    public <T> GenerationStatus setValue(Key<T> var1, T var2);

    public <T> Optional<T> valueOf(Key<T> var1);

    public static final class Key<T> {
        private final String name;
        private final Class<T> type;

        public Key(String name, Class<T> type) {
            if (name == null) {
                throw new NullPointerException("name must not be null");
            }
            if (type == null) {
                throw new NullPointerException("type must not be null");
            }
            this.name = name;
            this.type = type;
        }

        public T cast(Object o) {
            return this.type.cast(o);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            return this.name.equals(other.name) && this.type.equals(other.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }

        public String toString() {
            return this.name + ": " + this.type;
        }
    }
}

