/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator;

import com.pholser.junit.quickcheck.generator.Gen;
import com.pholser.junit.quickcheck.generator.GeneratorConfiguration;
import com.pholser.junit.quickcheck.generator.GeneratorConfigurationException;
import com.pholser.junit.quickcheck.generator.Generators;
import com.pholser.junit.quickcheck.generator.Shrink;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.ReflectionException;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.javaruntype.type.TypeParameter;
import org.javaruntype.type.Types;
import org.javaruntype.type.WildcardTypeParameter;

public abstract class Generator<T>
implements Gen<T>,
Shrink<T> {
    private final List<Class<T>> types = new ArrayList<Class<T>>();
    private Generators repo;

    protected Generator(Class<T> type) {
        this(Collections.singletonList(type));
    }

    protected Generator(List<Class<T>> types) {
        this.types.addAll(types);
    }

    public List<Class<T>> types() {
        return Collections.unmodifiableList(this.types);
    }

    public boolean canRegisterAsType(Class<?> type) {
        return true;
    }

    @Override
    public final List<T> shrink(SourceOfRandomness random, Object larger) {
        if (!this.canShrink(larger)) {
            throw new IllegalStateException(this.getClass() + " not capable of shrinking " + larger);
        }
        return this.doShrink(random, this.narrow(larger));
    }

    public boolean canShrink(Object larger) {
        return this.types().get(0).isInstance(larger);
    }

    public List<T> doShrink(SourceOfRandomness random, T larger) {
        return Collections.emptyList();
    }

    public BigDecimal magnitude(Object value) {
        return BigDecimal.ONE;
    }

    protected final T narrow(Object wider) {
        return this.types().get(0).cast(wider);
    }

    public boolean hasComponents() {
        return false;
    }

    public int numberOfNeededComponents() {
        return 0;
    }

    public void addComponentGenerators(List<Generator<?>> newComponents) {
    }

    public boolean canGenerateForParametersOfTypes(List<TypeParameter<?>> typeParameters) {
        return true;
    }

    public void configure(AnnotatedType annotatedType) {
        this.configureStrict(this.collectConfigurationAnnotations(annotatedType));
    }

    public void configure(AnnotatedElement element) {
        this.configureLenient(this.collectConfigurationAnnotations(element));
    }

    public void provide(Generators provided) {
        this.repo = provided;
    }

    public Generator<T> copy() {
        return (Generator)Reflection.instantiate(this.getClass());
    }

    protected static boolean compatibleWithTypeParameter(TypeParameter<?> parameter, Class<?> clazz) {
        return parameter instanceof WildcardTypeParameter || parameter.getType().isAssignableFrom(Types.forJavaLangReflectType(clazz));
    }

    protected Generators gen() {
        return this.repo;
    }

    protected Generators gen(SourceOfRandomness random) {
        return this.repo.withRandom(random);
    }

    protected static List<Annotation> configurationAnnotationsOn(AnnotatedElement element) {
        return Reflection.allAnnotations(element).stream().filter(a -> a.annotationType().isAnnotationPresent(GeneratorConfiguration.class)).collect(Collectors.toList());
    }

    private Map<Class<? extends Annotation>, Annotation> collectConfigurationAnnotations(AnnotatedElement element) {
        if (element == null) {
            return Collections.emptyMap();
        }
        List<Annotation> configs = Generator.configurationAnnotationsOn(element);
        HashMap<Class<? extends Annotation>, Annotation> byType = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation each : configs) {
            byType.put(each.annotationType(), each);
        }
        return byType;
    }

    private void configureStrict(Map<Class<? extends Annotation>, Annotation> byType) {
        for (Map.Entry<Class<? extends Annotation>, Annotation> each : byType.entrySet()) {
            this.configureStrict(each.getKey(), each.getValue());
        }
    }

    private void configureStrict(Class<? extends Annotation> annotationType, Annotation configuration) {
        this.configure(annotationType, configuration, ex -> {
            throw new GeneratorConfigurationException(String.format("Generator %s does not understand configuration annotation %s", this.getClass().getName(), annotationType.getName()), (Throwable)ex);
        });
    }

    private void configureLenient(Map<Class<? extends Annotation>, Annotation> byType) {
        for (Map.Entry<Class<? extends Annotation>, Annotation> each : byType.entrySet()) {
            this.configureLenient(each.getKey(), each.getValue());
        }
    }

    private void configureLenient(Class<? extends Annotation> annotationType, Annotation configuration) {
        this.configure(annotationType, configuration, ex -> {});
    }

    private void configure(Class<? extends Annotation> annotationType, Annotation configuration, Consumer<ReflectionException> exceptionHandler) {
        Method configurer = null;
        try {
            configurer = Reflection.findMethod(this.getClass(), "configure", annotationType);
        }
        catch (ReflectionException ex) {
            exceptionHandler.accept(ex);
        }
        if (configurer != null) {
            Reflection.invoke(configurer, this, configuration);
        }
    }
}

