/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal;

import com.pholser.junit.quickcheck.random.SourceOfRandomness;

public class GeometricDistribution {
    public int sampleWithMean(double mean, SourceOfRandomness random) {
        return this.sample(this.probabilityOfMean(mean), random);
    }

    int sample(double p, SourceOfRandomness random) {
        this.ensureProbability(p);
        if (p == 1.0) {
            return 0;
        }
        double uniform = random.nextDouble();
        return (int)Math.ceil(Math.log(1.0 - uniform) / Math.log(1.0 - p));
    }

    double probabilityOfMean(double mean) {
        if (mean <= 0.0) {
            throw new IllegalArgumentException("Need a positive mean, got " + mean);
        }
        return 1.0 / mean;
    }

    private void ensureProbability(double p) {
        if (p <= 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Need a probability in (0, 1], got " + p);
        }
    }
}

