/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor;

import bluej.compiler.CompileType;
import bluej.compiler.Diagnostic;
import bluej.debugger.DebuggerThread;
import bluej.editor.TextEditor;
import bluej.editor.fixes.EditorFixesManager;
import bluej.editor.stride.FrameEditor;
import bluej.parser.symtab.ClassInfo;
import bluej.prefmgr.PrefMgr;
import bluej.stride.framedjava.elements.CallElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXRunnable;
import java.io.IOException;
import java.util.List;
import javafx.geometry.Rectangle2D;
import javafx.print.PrinterJob;
import javafx.scene.image.Image;
import threadchecker.OnThread;
import threadchecker.Tag;

public interface Editor {
    public void reloadFile();

    public void setEditorVisible(boolean var1, boolean var2);

    public boolean isOpen();

    public void save() throws IOException;

    default public void saveJavaWithoutWarning() throws IOException {
        this.save();
    }

    public void close();

    public void refresh();

    public void displayMessage(String var1, int var2, int var3);

    public boolean displayDiagnostic(Diagnostic var1, int var2, CompileType var3);

    public boolean setStepMark(int var1, String var2, boolean var3, DebuggerThread var4);

    public void writeMessage(String var1);

    public void removeStepMark();

    public void changeName(String var1, String var2, String var3, String var4);

    public void setCompiled(boolean var1);

    public boolean compileStarted(int var1);

    public void compileFinished(boolean var1, boolean var2);

    public void removeBreakpoints();

    public void reInitBreakpoints();

    public boolean isModified();

    public void removeErrorHighlights();

    public Rectangle2D getScreenBoundsIfSelectedTab();

    public FXRunnable printTo(PrinterJob var1, PrefMgr.PrintSize var2, boolean var3, boolean var4, PrintProgressUpdate var5);

    public void setReadOnly(boolean var1);

    public boolean isReadOnly();

    public void showInterface(boolean var1);

    public Object getProperty(String var1);

    public void setProperty(String var1, Object var2);

    public TextEditor assumeText();

    public FrameEditor assumeFrame();

    public void insertAppendMethod(NormalMethodElement var1, FXPlatformConsumer<Boolean> var2);

    public void insertMethodCallInConstructor(String var1, CallElement var2, FXPlatformConsumer<Boolean> var3);

    public void focusMethod(String var1, List<String> var2);

    public void setExtendsClass(String var1, ClassInfo var2);

    public void removeExtendsClass(ClassInfo var1);

    public void addImplements(String var1, ClassInfo var2);

    public void addExtendsInterface(String var1, ClassInfo var2);

    public void removeExtendsOrImplementsInterface(String var1, ClassInfo var2);

    public void removeImports(List<String> var1);

    public void addImportFromQuickFix(String var1);

    public void setHeaderImage(Image var1);

    public void setLastModified(long var1);

    public EditorFixesManager getEditorFixesManager();

    public static interface PrintProgressUpdate {
        @OnThread(value=Tag.Any)
        public boolean printProgress(int var1, int var2);
    }
}

