/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.base;

import bluej.editor.base.EditorPosition;
import bluej.editor.base.LineContainer;
import bluej.editor.base.LineDisplay;
import bluej.editor.base.MarginAndTextLine;
import bluej.editor.base.TextLine;
import bluej.prefmgr.PrefMgr;
import bluej.utility.javafx.FXFunction;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.value.ObservableValue;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.fxmisc.wellbehaved.event.InputHandler;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform, ignoreParent=true)
public abstract class BaseEditorPane
extends Region {
    protected static final Duration SCROLL_DELAY = Duration.millis((double)50.0);
    private final BaseEditorPaneListener editorPaneListener;
    private final boolean showLeftMargin;
    protected final LineDisplay lineDisplay;
    private final ArrayList<SelectionListener> selectionListeners = new ArrayList();
    private final Path caretShape;
    private final LineContainer lineContainer;
    private final ScrollBar verticalScroll;
    private final ScrollBar horizontalScroll;
    private boolean updatingScrollBarDirectly = false;
    private boolean postScrollRenderQueued = false;
    private double pendingScrollY;
    private boolean allowScrollBars = true;
    private boolean forceCaretShow = false;
    private boolean caretUpdateScheduled;
    private boolean caretUpdateEnsureVisible;
    private boolean isDragScrollScheduled = false;
    private DragScroll offScreenDragScroll = null;
    private double offScreenDragX = 0.0;
    private double offScreenDragY = 0.0;

    protected BaseEditorPane(boolean showLeftMargin, BaseEditorPaneListener listener) {
        this.showLeftMargin = showLeftMargin;
        this.editorPaneListener = listener;
        this.caretShape = new Path();
        this.caretShape.getStyleClass().add((Object)"flow-caret");
        this.caretShape.setStroke((Paint)Color.RED);
        this.caretShape.setMouseTransparent(true);
        this.caretShape.setManaged(false);
        this.verticalScroll = new ScrollBar();
        this.verticalScroll.setOrientation(Orientation.VERTICAL);
        this.verticalScroll.setVisible(false);
        this.horizontalScroll = new ScrollBar();
        this.horizontalScroll.setOrientation(Orientation.HORIZONTAL);
        this.horizontalScroll.setVisible(false);
        this.lineDisplay = new LineDisplay((DoubleExpression)this.horizontalScroll.valueProperty(), PrefMgr.getEditorFontCSS((boolean)true), showLeftMargin, listener);
        this.lineContainer = new LineContainer(this.lineDisplay, false);
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.horizontalScroll.valueProperty(), v -> {
            if (!this.updatingScrollBarDirectly) {
                this.updateRender(false);
            }
        });
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.verticalScroll.valueProperty(), v -> {
            if (!this.updatingScrollBarDirectly) {
                this.lineDisplay.scrollTo(v.intValue(), (v.doubleValue() - (double)v.intValue()) * -1.0 * this.lineDisplay.getLineHeight());
                this.updateRender(false);
            }
        });
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)this.lineContainer.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.lineContainer.heightProperty());
        this.lineContainer.setClip((Node)clip);
        this.getChildren().setAll((Object[])new Node[]{this.lineContainer, this.verticalScroll, this.horizontalScroll});
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.lineContainer.heightProperty(), h -> JavaFXUtil.runAfterCurrent(() -> this.updateRender(false)));
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.widthProperty(), w -> this.updateRender(false));
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.heightProperty(), h -> this.updateRender(false));
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.focusedProperty(), f -> this.updateCaretVisibility());
        this.setAccessibleRole(AccessibleRole.TEXT_AREA);
        Nodes.addInputMap((Node)this, (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.process((EventType)KeyEvent.KEY_PRESSED, e -> {
            this.keyPressed((KeyEvent)e);
            return InputHandler.Result.PROCEED;
        }), InputMap.consume((EventType)KeyEvent.KEY_TYPED, this::keyTyped), InputMap.consume((EventType)MouseEvent.MOUSE_PRESSED, this::mousePressed), InputMap.consume((EventType)MouseEvent.MOUSE_DRAGGED, this::mouseDragged), InputMap.consume((EventType)MouseEvent.MOUSE_RELEASED, this::mouseReleased), InputMap.consume((EventType)MouseEvent.MOUSE_MOVED, this::mouseMoved)}));
        this.selectionListeners.add(new SelectionListener(){
            int oldCaretPos = 0;
            int oldAnchorPos = 0;

            @Override
            @OnThread(value=Tag.FXPlatform)
            public void selectionChanged(int caretPosition, int anchorPosition) {
                if (caretPosition != this.oldCaretPos) {
                    BaseEditorPane.this.notifyAccessibleAttributeChanged(AccessibleAttribute.CARET_OFFSET);
                }
                if (Math.min(caretPosition, anchorPosition) != Math.min(this.oldCaretPos, this.oldAnchorPos)) {
                    BaseEditorPane.this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTION_START);
                }
                if (Math.max(caretPosition, anchorPosition) != Math.max(this.oldCaretPos, this.oldAnchorPos)) {
                    BaseEditorPane.this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTION_END);
                }
                this.oldAnchorPos = anchorPosition;
                this.oldCaretPos = caretPosition;
            }
        });
    }

    protected abstract void keyPressed(KeyEvent var1);

    protected final void showContextMenuAtCaret() {
        Bounds sceneBounds = this.caretShape.localToScene(this.caretShape.getBoundsInLocal());
        Point2D scenePt = new Point2D(sceneBounds.getMaxX(), sceneBounds.getMaxY());
        Scene scene = this.getScene();
        Point2D screenPt = scenePt.add(scene.getWindow().getX() + scene.getX(), scene.getWindow().getY() + scene.getY());
        this.editorPaneListener.getContextMenuToShow(this).show((Node)this, screenPt.getX(), screenPt.getY());
    }

    protected abstract void keyTyped(KeyEvent var1);

    protected abstract void mousePressed(MouseEvent var1);

    protected abstract void mouseMoved(MouseEvent var1);

    protected void mouseDragged(MouseEvent e) {
        if (e.getButton() == MouseButton.PRIMARY) {
            double y = e.getY();
            int fastDistance = 30;
            if (y > this.getHeight()) {
                this.offScreenDragScroll = y - this.getHeight() > (double)fastDistance ? DragScroll.DOWN_FAST : DragScroll.DOWN;
                y = this.getHeight() - 1.0;
            } else if (y < 0.0) {
                this.offScreenDragScroll = y < (double)(-fastDistance) ? DragScroll.UP_FAST : DragScroll.UP;
                y = 0.0;
            } else {
                this.offScreenDragScroll = null;
            }
            this.offScreenDragX = e.getX();
            this.offScreenDragY = y;
            this.getCaretPositionForLocalPoint(new Point2D(e.getX(), y)).ifPresent(p -> this.moveCaret((EditorPosition)p, false));
            if (this.offScreenDragScroll != null && !this.isDragScrollScheduled) {
                JavaFXUtil.runAfter((Duration)Duration.millis((double)50.0), this::doDragScroll);
                this.isDragScrollScheduled = true;
            }
        }
    }

    protected void mouseReleased(MouseEvent e) {
        this.offScreenDragScroll = null;
    }

    protected abstract void moveCaret(EditorPosition var1, boolean var2);

    private void doDragScroll() {
        this.isDragScrollScheduled = false;
        if (this.offScreenDragScroll != null) {
            int amount = 0;
            switch (this.offScreenDragScroll) {
                case UP_FAST: {
                    amount = 50;
                    break;
                }
                case UP: {
                    amount = 15;
                    break;
                }
                case DOWN: {
                    amount = -15;
                    break;
                }
                case DOWN_FAST: {
                    amount = -50;
                }
            }
            this.scroll(0.0, amount);
            this.getCaretPositionForLocalPoint(new Point2D(this.offScreenDragX, this.offScreenDragY)).ifPresent(p -> this.moveCaret((EditorPosition)p, false));
            JavaFXUtil.runAfter((Duration)SCROLL_DELAY, this::doDragScroll);
            this.isDragScrollScheduled = true;
        }
    }

    public Optional<EditorPosition> getCaretPositionForMouseEvent(MouseEvent e) {
        return this.getCaretPositionForLocalPoint(new Point2D(e.getX(), e.getY()));
    }

    protected Optional<EditorPosition> getCaretPositionForLocalPoint(Point2D localPoint) {
        return Optional.ofNullable(this.lineDisplay.getCaretPositionForLocalPoint(localPoint)).map(p -> this.makePosition(p[0], p[1]));
    }

    protected final void layoutChildren() {
        double horizScrollHeight = this.horizontalScroll.isVisible() ? this.horizontalScroll.prefHeight(-1.0) : 0.0;
        this.horizontalScroll.resizeRelocate(0.0, this.getHeight() - horizScrollHeight, this.getWidth(), horizScrollHeight);
        double vertScrollWidth = this.verticalScroll.isVisible() ? this.verticalScroll.prefWidth(-1.0) : 0.0;
        this.verticalScroll.resizeRelocate(this.getWidth() - vertScrollWidth, 0.0, vertScrollWidth, this.getHeight() - horizScrollHeight);
        this.lineContainer.resizeRelocate(0.0, 0.0, this.getWidth() - vertScrollWidth, this.getHeight() - horizScrollHeight);
    }

    protected final void scroll(double deltaX, double deltaY) {
        int lineCount = this.getLineCount();
        this.updatingScrollBarDirectly = true;
        this.horizontalScroll.setValue(Math.max(this.horizontalScroll.getMin(), Math.min(this.horizontalScroll.getMax(), this.horizontalScroll.getValue() - deltaX)));
        this.updatingScrollBarDirectly = false;
        this.pendingScrollY += deltaY;
        if (!this.postScrollRenderQueued) {
            this.postScrollRenderQueued = true;
            JavaFXUtil.runAfter((Duration)SCROLL_DELAY, () -> {
                this.postScrollRenderQueued = false;
                this.lineDisplay.scrollBy(this.pendingScrollY, lineCount, this.lineContainer.getHeight());
                this.pendingScrollY = 0.0;
                this.updateRender(false);
            });
        }
    }

    protected void scheduleCaretUpdate(boolean ensureCaretVisibleRequestedThisTime) {
        this.caretUpdateEnsureVisible = this.caretUpdateEnsureVisible || ensureCaretVisibleRequestedThisTime;
        Scene scene = this.getScene();
        if (scene == null || this.caretUpdateScheduled) {
            return;
        }
        JavaFXUtil.runAfterNextLayout((Scene)scene, () -> {
            boolean ensureCaretVisible = this.caretUpdateEnsureVisible;
            this.caretUpdateScheduled = false;
            this.caretUpdateEnsureVisible = false;
            if (this.lineDisplay.isLineVisible(this.getCaretEditorPosition().getLine())) {
                MarginAndTextLine line = this.lineDisplay.getVisibleLine(this.getCaretEditorPosition().getLine());
                if (line.textLine.isNeedsLayout()) {
                    this.scheduleCaretUpdate(ensureCaretVisible);
                    return;
                }
                this.caretShape.getElements().setAll((Object[])line.textLine.caretShape(this.getCaretEditorPosition().getColumn(), true));
                this.caretShape.layoutXProperty().bind((ObservableValue)line.layoutXProperty());
                if (ensureCaretVisible) {
                    Bounds caretBounds = this.caretShape.getBoundsInLocal();
                    double maxScroll = Math.max(0.0, caretBounds.getCenterX() - 8.0);
                    double minScroll = Math.max(0.0, caretBounds.getCenterX() - (this.getWidth() - (double)MarginAndTextLine.textLeftEdge(this.showLeftMargin) - this.verticalScroll.prefWidth(-1.0) - 6.0));
                    this.horizontalScroll.setValue(Math.min(maxScroll, Math.max(minScroll, this.horizontalScroll.getValue())));
                }
                this.caretShape.translateXProperty().set((double)MarginAndTextLine.textLeftEdge(this.showLeftMargin) - this.horizontalScroll.getValue());
                this.caretShape.layoutYProperty().bind((ObservableValue)line.layoutYProperty());
            } else {
                this.caretShape.getElements().clear();
                this.caretShape.layoutXProperty().unbind();
                this.caretShape.layoutYProperty().unbind();
                this.caretShape.setLayoutX(0.0);
                this.caretShape.setLayoutY(0.0);
            }
            this.updateCaretVisibility();
        });
        this.caretUpdateScheduled = true;
    }

    private void updateCaretVisibility() {
        boolean focused = this.isFocused();
        boolean lineVisible = this.lineDisplay.isLineVisible(this.getCaretEditorPosition().getLine());
        this.caretShape.setVisible(lineVisible && (focused || this.forceCaretShow));
    }

    public void setFakeCaret(boolean fakeOn) {
        this.forceCaretShow = fakeOn;
        this.updateCaretVisibility();
    }

    public void setAllowScrollBars(boolean allowScrollBars) {
        this.allowScrollBars = allowScrollBars;
        this.updateRender(false);
    }

    protected void updateRender(boolean ensureCaretVisible) {
        if (ensureCaretVisible) {
            this.lineDisplay.ensureLineVisible(this.getCaretEditorPosition().getLine(), this.lineContainer.getHeight(), this.getLineCount());
        }
        double width = this.lineDisplay.calculateLineWidth(this.getLongestLineInWholeDocument());
        int EXTRA_WIDTH = 100;
        this.horizontalScroll.setMax(width + (double)EXTRA_WIDTH - this.getWidth());
        if (this.horizontalScroll.getValue() > this.horizontalScroll.getMax()) {
            this.updatingScrollBarDirectly = true;
            this.horizontalScroll.setValue(Math.max(Math.min(this.horizontalScroll.getValue(), this.horizontalScroll.getMax()), this.horizontalScroll.getMin()));
            this.updatingScrollBarDirectly = false;
        }
        this.horizontalScroll.setVisibleAmount(this.getWidth() / (this.horizontalScroll.getMax() + this.getWidth()) * this.horizontalScroll.getMax());
        this.horizontalScroll.setVisible(this.allowScrollBars && width + (double)EXTRA_WIDTH >= this.getWidth());
        ArrayList<MarginAndTextLine> prospectiveChildren = new ArrayList<MarginAndTextLine>();
        List<List<TextLine.StyledSegment>> styledLines = this.getStyledLines();
        prospectiveChildren.addAll(this.lineDisplay.recalculateVisibleLines(styledLines, (FXFunction<Double, Double>)((FXFunction)arg_0 -> ((BaseEditorPane)this).snapSizeY(arg_0)), -this.horizontalScroll.getValue(), this.lineContainer.getWidth(), this.lineContainer.getHeight(), false, this));
        prospectiveChildren.add((MarginAndTextLine)this.caretShape);
        int lineCount = this.getLineCount();
        this.verticalScroll.setVisible(this.allowScrollBars && this.lineDisplay.getVisibleLineCount() < lineCount);
        double visibleLinesEstimate = this.getHeight() / this.lineDisplay.getLineHeight();
        this.verticalScroll.setMax((double)lineCount - visibleLinesEstimate);
        this.verticalScroll.setVisibleAmount(visibleLinesEstimate / (double)lineCount * this.verticalScroll.getMax());
        this.updatingScrollBarDirectly = true;
        this.verticalScroll.setValue((double)this.lineDisplay.getLineRangeVisible()[0] - this.lineDisplay.getFirstVisibleLineOffset() / this.lineDisplay.getLineHeight());
        this.updatingScrollBarDirectly = false;
        boolean needToChangeLinesAndCaret = false;
        for (int i = 0; i < prospectiveChildren.size(); ++i) {
            if (i < this.lineContainer.getChildren().size() && prospectiveChildren.get(i) == this.lineContainer.getChildren().get(i)) continue;
            needToChangeLinesAndCaret = true;
            break;
        }
        if (needToChangeLinesAndCaret) {
            this.lineContainer.getChildren().setAll(prospectiveChildren);
        } else if (this.lineContainer.getChildren().size() > prospectiveChildren.size()) {
            this.lineContainer.getChildren().subList(prospectiveChildren.size(), this.lineContainer.getChildren().size()).clear();
        }
        if (this.getScene() != null) {
            this.scheduleCaretUpdate(ensureCaretVisible);
            String lineText = this.getLineContentAtCaret();
            this.setAccessibleText(lineText);
        }
        this.updateCaretVisibility();
        HashSet<Integer> linesWithSelectionSet = new HashSet<Integer>();
        EditorPosition caret = this.getCaretEditorPosition();
        EditorPosition anchor = this.getAnchorEditorPosition();
        if (caret.getPosition() != anchor.getPosition()) {
            EditorPosition endPos;
            EditorPosition startPos = caret.getPosition() < anchor.getPosition() ? caret : anchor;
            EditorPosition editorPosition = endPos = caret.getPosition() < anchor.getPosition() ? anchor : caret;
            if (startPos.getLine() == endPos.getLine() && this.lineDisplay.isLineVisible(startPos.getLine())) {
                TextLine caretLine = this.lineDisplay.getVisibleLine((int)startPos.getLine()).textLine;
                caretLine.showSelection(startPos.getColumn(), endPos.getColumn(), false);
                linesWithSelectionSet.add(startPos.getLine());
            } else {
                for (int line = startPos.getLine(); line < endPos.getLine(); ++line) {
                    int startOnThisLine;
                    int n = startOnThisLine = line == startPos.getLine() ? startPos.getColumn() : 0;
                    if (!this.lineDisplay.isLineVisible(line)) continue;
                    TextLine textLine = this.lineDisplay.getVisibleLine((int)line).textLine;
                    textLine.showSelection(startOnThisLine, this.getLineLength(line), true);
                    linesWithSelectionSet.add(line);
                }
                if (this.lineDisplay.isLineVisible(endPos.getLine())) {
                    this.lineDisplay.getVisibleLine((int)endPos.getLine()).textLine.showSelection(0, endPos.getColumn(), false);
                    linesWithSelectionSet.add(endPos.getLine());
                }
            }
        }
        int[] visibleLineRange = this.lineDisplay.getLineRangeVisible();
        for (int line = visibleLineRange[0]; line <= visibleLineRange[1]; ++line) {
            if (linesWithSelectionSet.contains(line)) continue;
            this.lineDisplay.getVisibleLine((int)line).textLine.hideSelection();
        }
        this.lineContainer.requestLayout();
        this.requestLayout();
    }

    public void scrollEventOnTextLine(ScrollEvent scrollEvent) {
        this.scroll(scrollEvent.getDeltaX(), scrollEvent.getDeltaY());
    }

    protected abstract int getLineLength(int var1);

    protected abstract String getLineContentAtCaret();

    protected void callSelectionListeners() {
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.selectionChanged(this.getCaretEditorPosition().getPosition(), this.getAnchorEditorPosition().getPosition());
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    protected abstract String getLongestLineInWholeDocument();

    protected abstract int getLineCount();

    protected abstract List<List<TextLine.StyledSegment>> getStyledLines();

    protected abstract EditorPosition makePosition(int var1, int var2);

    protected abstract EditorPosition getCaretEditorPosition();

    protected abstract EditorPosition getAnchorEditorPosition();

    public final double getTextDisplayWidth() {
        return this.lineContainer.getTextDisplayWidth();
    }

    private static enum DragScroll {
        UP_FAST,
        UP,
        DOWN,
        DOWN_FAST;

    }

    @OnThread(value=Tag.FXPlatform)
    public static interface BaseEditorPaneListener {
        public boolean marginClickedForLine(int var1);

        public ContextMenu getContextMenuToShow(BaseEditorPane var1);

        public void scrollEventOnTextLine(ScrollEvent var1, BaseEditorPane var2);
    }

    public static interface SelectionListener {
        @OnThread(value=Tag.FXPlatform)
        public void selectionChanged(int var1, int var2);
    }
}

