/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.fixes;

import bluej.Config;
import bluej.parser.AssistContentThreadSafe;
import bluej.parser.PrimitiveTypeCompletion;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ProjectImportInformation {
    private final @OnThread(value=Tag.Any) List<AssistContentThreadSafe> popularImports;
    private final @OnThread(value=Tag.Any) List<AssistContentThreadSafe> rarerImports;
    private final @OnThread(value=Tag.Any) List<AssistContentThreadSafe> javaLangImports;
    private static final @OnThread(value=Tag.FX) List<AssistContentThreadSafe> prims = PrimitiveTypeCompletion.allPrimitiveTypes().stream().map(AssistContentThreadSafe::copy).collect(Collectors.toList());
    private final Project project;

    @OnThread(value=Tag.Worker)
    public ProjectImportInformation(Project project) {
        this.project = project;
        this.javaLangImports = this.scanImports("java.lang.*");
        this.popularImports = Arrays.asList("java.io.*", "java.math.*", "java.time.*", "java.util.*", "java.util.function.*", "java.util.stream.*", Config.isGreenfoot() ? "greenfoot.*" : null).stream().filter(i -> i != null).flatMap(i -> this.scanImports((String)i).stream()).collect(Collectors.toList());
        this.rarerImports = Arrays.asList(Config.isGreenfoot() ? null : "java.awt.*", Config.isGreenfoot() ? null : "java.awt.event.*", "java.nio.file.*", "java.net.*", "java.text.*", "java.util.concurrent.*", Config.isGreenfoot() ? null : "javafx.application.*", Config.isGreenfoot() ? null : "javafx.beans.*", Config.isGreenfoot() ? null : "javafx.beans.property.*", Config.isGreenfoot() ? null : "javafx.collections.*", Config.isGreenfoot() ? null : "javafx.event.*", Config.isGreenfoot() ? null : "javafx.scene.*", Config.isGreenfoot() ? null : "javafx.scene.control.*", Config.isGreenfoot() ? null : "javafx.scene.input.*", Config.isGreenfoot() ? null : "javafx.scene.layout.*", Config.isGreenfoot() ? null : "javafx.scene.paint.*", Config.isGreenfoot() ? null : "javafx.stage.*", Config.isGreenfoot() ? null : "javax.swing.*", Config.isGreenfoot() ? null : "javax.swing.event.*").stream().filter(i -> i != null).flatMap(i -> this.scanImports((String)i).stream()).collect(Collectors.toList());
    }

    @OnThread(value=Tag.Worker)
    public List<AssistContentThreadSafe> scanImports(String importString) {
        try {
            return this.project.getImportScanner().getImportedTypes(importString);
        }
        catch (Throwable t) {
            Debug.reportError((String)("Exception while scanning for import " + importString), (Throwable)t);
            return Collections.emptyList();
        }
    }

    @OnThread(value=Tag.Any)
    public List<AssistContentThreadSafe> getPopularImports() {
        return this.popularImports;
    }

    @OnThread(value=Tag.Any)
    public List<AssistContentThreadSafe> getRarerImports() {
        return this.rarerImports;
    }

    @OnThread(value=Tag.Any)
    public List<AssistContentThreadSafe> getJavaLangImports() {
        return this.javaLangImports;
    }

    public static List<AssistContentThreadSafe> getPrims() {
        return prims;
    }
}

