/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.Config;
import bluej.editor.TextEditor;
import bluej.editor.fixes.Correction;
import bluej.editor.fixes.EditorFixesManager;
import bluej.editor.fixes.FixSuggestion;
import bluej.editor.flow.FlowEditor;
import bluej.editor.flow.FlowEditorPane;
import bluej.editor.flow.JavaSyntaxView;
import bluej.parser.AssistContent;
import bluej.parser.AssistContentThreadSafe;
import bluej.parser.ExpressionTypeInfo;
import bluej.parser.ParseUtils;
import bluej.parser.SourceLocation;
import bluej.parser.lexer.JavaLexer;
import bluej.parser.lexer.LocatableToken;
import bluej.parser.nodes.FieldNode;
import bluej.parser.nodes.MethodBodyNode;
import bluej.parser.nodes.MethodNode;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedCUNode;
import bluej.parser.nodes.ParsedNode;
import bluej.pkgmgr.JavadocResolver;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.target.role.Kind;
import bluej.utility.Debug;
import bluej.utility.JavaUtils;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformConsumer;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.IndexRange;
import threadchecker.OnThread;
import threadchecker.Tag;

public class FlowErrorManager
implements FlowEditorPane.ErrorQuery {
    private final ObservableList<ErrorDetails> errorInfos = FXCollections.observableArrayList();
    private final FlowEditor editor;

    public FlowErrorManager(FlowEditor editor) {
        this.editor = editor;
    }

    public void addErrorHighlight(int startPos, int endPos, String message, int identifier) {
        if (endPos < startPos) {
            throw new IllegalArgumentException("Error ends before it begins: " + startPos + " to " + endPos);
        }
        FlowEditorPane sourcePane = this.editor.getSourcePane();
        sourcePane.getDocument().addLineAttribute(this.editor.getSourcePane().getDocument().getLineFromPosition(startPos), (Object)JavaSyntaxView.ParagraphAttribute.ERROR, true);
        EditorFixesManager efm = this.editor.getEditorFixesManager();
        Utility.runBackground(() -> {
            Stream imports = efm.getImportSuggestions().values().stream().flatMap(Collection::stream);
            Platform.runLater(() -> this.showErrors(this.editor, sourcePane, startPos, endPos, message, identifier, imports));
        });
    }

    private void showErrors(FlowEditor editor, FlowEditorPane sourcePane, int startPos, int endPos, String message, int identifier, Stream<AssistContentThreadSafe> imports) {
        this.errorInfos.add((Object)new ErrorDetails(editor, startPos, endPos, message, identifier, imports));
        editor.updateHeaderHasErrors(true);
        sourcePane.repaint();
    }

    public void removeAllErrorHighlights() {
        FlowEditorPane sourcePane = this.editor.getSourcePane();
        sourcePane.getDocument().removeLineAttributeThroughout((Object)JavaSyntaxView.ParagraphAttribute.ERROR);
        sourcePane.hideAllErrorUnderlines();
        this.errorInfos.clear();
        this.editor.updateHeaderHasErrors(false);
        sourcePane.repaint();
    }

    public void listenForErrorChange(FXPlatformConsumer<List<ErrorDetails>> listener) {
        this.errorInfos.addListener(c -> listener.accept(Collections.unmodifiableList(this.errorInfos)));
    }

    public ErrorDetails getNextErrorPos(int from) {
        int lowestDist = Integer.MIN_VALUE;
        ErrorDetails next = null;
        for (ErrorDetails err : this.errorInfos) {
            int dist = err.startPos - from;
            if (next != null && (lowestDist > 0 || dist <= 0 && dist > lowestDist) && (lowestDist <= 0 || dist <= 0 || dist > lowestDist)) continue;
            next = err;
            lowestDist = dist;
        }
        return next;
    }

    public ErrorDetails getErrorAtPosition(int pos) {
        return this.errorInfos.stream().filter(e -> e.containsPosition(pos)).reduce((first, second) -> second).orElse(null);
    }

    @OnThread(value=Tag.FXPlatform)
    public ErrorDetails getErrorOnLine(int lineIndex) {
        int lineStart = this.editor.getOffsetFromLineColumn(new SourceLocation(lineIndex + 1, 1));
        if (lineIndex + 1 >= this.editor.numberOfLines()) {
            return this.errorInfos.stream().filter(e -> e.endPos >= lineStart).findFirst().orElse(null);
        }
        int lineEnd = this.editor.getOffsetFromLineColumn(new SourceLocation(lineIndex + 2, 1));
        return this.errorInfos.stream().filter(e -> e.startPos <= lineEnd && e.endPos >= lineStart).findFirst().orElse(null);
    }

    @Override
    public List<IndexRange> getErrorUnderlines() {
        return Utility.mapList(this.errorInfos, e -> new IndexRange(e.startPos, e.endPos));
    }

    public boolean hasErrorHighlights() {
        return !this.errorInfos.isEmpty();
    }

    public ObservableList<ErrorDetails> getObservableErrorList() {
        return this.errorInfos;
    }

    public static class ErrorDetails {
        public final int startPos;
        public final int endPos;
        public final String message;
        private int italicMessageStartIndex;
        private int italicMessageEndIndex;
        public final int identifier;
        public final List<FixSuggestion> corrections = new ArrayList<FixSuggestion>();

        private ErrorDetails(FlowEditor editor, int startPos, int endPos, String message, int identifier, Stream<AssistContentThreadSafe> possibleImports) {
            this.startPos = startPos;
            this.endPos = endPos;
            this.identifier = identifier;
            int italicMessageStartIndex = -1;
            int italicMessageEndIndex = -1;
            try {
                int errorLine = editor.getLineColumnFromOffset(startPos).getLine();
                int errorLineLength = editor.getLineLength(errorLine - 1);
                SourceLocation startErrorLineSourceLocation = new SourceLocation(errorLine, 1);
                SourceLocation startErrorPosSourceLocation = editor.getLineColumnFromOffset(startPos);
                SourceLocation endErrorLineSourceLocation = new SourceLocation(errorLine, errorLineLength);
                String errorLineText = editor.getText(startErrorLineSourceLocation, endErrorLineSourceLocation);
                if (((String)message).contains("cannot find symbol") && ((String)message).contains("class")) {
                    String typeName = ((String)message).substring(((String)message).lastIndexOf(32) + 1);
                    message = Config.getString((String)"editor.quickfix.unknownType.errorMsg") + typeName;
                    if (possibleImports != null) {
                        List<AssistContentThreadSafe> possibleCorrectionsList = possibleImports.filter(ac -> ac.getPackage() != null).collect(Collectors.toList());
                        this.corrections.addAll(possibleCorrectionsList.stream().filter(ac -> ac.getName().equals(typeName) && ac.getDeclaringClass() == null).flatMap(ac -> Stream.of(new EditorFixesManager.FixSuggestionBase(Config.getString((String)"editor.quickfix.unknownType.fixMsg.class") + ac.getPackage() + "." + ac.getName(), () -> {
                            editor.setSelection(startErrorPosSourceLocation, startErrorPosSourceLocation);
                            editor.addImportFromQuickFix(ac.getPackage() + "." + ac.getName());
                        }), new EditorFixesManager.FixSuggestionBase(Config.getString((String)"editor.quickfix.unknownType.fixMsg.package") + ac.getPackage() + " (for " + ac.getName() + " class)", () -> {
                            editor.setSelection(startErrorPosSourceLocation, startErrorPosSourceLocation);
                            editor.addImportFromQuickFix(ac.getPackage() + ".*");
                        }))).collect(Collectors.toList()));
                        Stream<Correction.CorrectionInfo> possibleCorrectionsStream = this.getPossibleCorrectionsStream(editor, AssistContent.CompletionKind.TYPE, possibleCorrectionsList, typeName, startPos);
                        if (possibleCorrectionsStream != null) {
                            this.corrections.addAll(Correction.winnowAndCreateCorrections(typeName, possibleCorrectionsStream, (FXPlatformConsumer<Correction.CorrectionElements>)((FXPlatformConsumer)correctionElements -> this.doTypeQuickFix(editor, startErrorPosSourceLocation, (Correction.CorrectionElements)correctionElements, typeName)), true));
                        }
                    }
                } else if (((String)message).startsWith("incompatible types:") && ((String)message).endsWith("cannot be converted to boolean") && editor.getText(editor.getLineColumnFromOffset(startPos), editor.getLineColumnFromOffset(startPos + 1)).equals("=")) {
                    message = Config.getString((String)"editor.quickfix.wrongComparisonOperator.errorMsg");
                    String leftCompPart = errorLineText.substring(0, startPos - editor.getOffsetFromLineColumn(startErrorLineSourceLocation));
                    String rightCompPart = errorLineText.substring(startPos - editor.getOffsetFromLineColumn(startErrorLineSourceLocation) + 1);
                    this.corrections.add(new EditorFixesManager.FixSuggestionBase(Config.getString((String)"editor.quickfix.wrongComparisonOperator.fixMsg"), () -> {
                        editor.setSelection(startErrorPosSourceLocation, startErrorPosSourceLocation);
                        editor.setText(startErrorLineSourceLocation, endErrorLineSourceLocation, leftCompPart + "==" + rightCompPart);
                        editor.refresh();
                    }));
                } else if (((String)message).startsWith("cannot find symbol -   variable ")) {
                    String varName = ((String)message).substring(((String)message).lastIndexOf(32) + 1);
                    message = Config.getString((String)"editor.quickfix.undeclaredVar.errorMsg") + varName;
                    Stream<Correction.CorrectionInfo> possibleCorrectionsStream = this.getPossibleCorrectionsStream(editor, AssistContent.CompletionKind.FIELD);
                    if (possibleCorrectionsStream != null) {
                        this.corrections.addAll(Correction.winnowAndCreateCorrections(varName, possibleCorrectionsStream, (FXPlatformConsumer<Correction.CorrectionElements>)((FXPlatformConsumer)correctionElements -> {
                            editor.setSelection(startErrorPosSourceLocation, startErrorPosSourceLocation);
                            editor.setText(editor.getLineColumnFromOffset(startPos), editor.getLineColumnFromOffset(endPos), correctionElements.getPrimaryElement());
                        })));
                    }
                    if (editor.getText(startErrorLineSourceLocation, endErrorLineSourceLocation).trim().matches("^(" + varName + ")\\s*=[^=]*$")) {
                        int indexOfEqualOp = editor.getText(startErrorLineSourceLocation, endErrorLineSourceLocation).indexOf(61);
                        String declarationRightPart = editor.getText(startErrorLineSourceLocation, endErrorLineSourceLocation).substring(indexOfEqualOp + 1).trim();
                        String typePlaceholder = "_type_";
                        this.corrections.add(new EditorFixesManager.FixSuggestionBase(Config.getString((String)"editor.quickfix.undeclaredVar.fixMsg.local"), () -> {
                            editor.setText(startErrorPosSourceLocation, endErrorLineSourceLocation, typePlaceholder + " " + varName + "= " + declarationRightPart);
                            editor.setSelection(startErrorPosSourceLocation, new SourceLocation(errorLine, startErrorPosSourceLocation.getColumn() + typePlaceholder.length()));
                            editor.refresh();
                        }));
                        this.corrections.add(new EditorFixesManager.FixSuggestionBase(Config.getString((String)"editor.quickfix.undeclaredVar.fixMsg.class"), () -> {
                            NewFieldInfos newFieldInfos = this.getNewClassFieldPos(editor);
                            int newClassFieldPos = newFieldInfos.getPos();
                            String indentationForNewField = newFieldInfos.getIndentation();
                            if (newClassFieldPos <= -1) {
                                throw new RuntimeException("Cannot find the position for declaring a new class field.");
                            }
                            int prevLine = editor.getLineColumnFromOffset(newClassFieldPos - 1).getLine();
                            editor.setText(editor.getLineColumnFromOffset(newClassFieldPos), editor.getLineColumnFromOffset(newClassFieldPos), indentationForNewField + "private " + typePlaceholder + " " + varName + ";\n");
                            editor.setSelection(new SourceLocation(prevLine + 1, indentationForNewField.length() + "private ".length() + 1), new SourceLocation(prevLine + 1, indentationForNewField.length() + "private ".length() + 1 + typePlaceholder.length()));
                            editor.refresh();
                        }));
                    }
                } else if (((String)message).startsWith("cannot find symbol -   method ")) {
                    String methodName = ((String)message).substring("cannot find symbol -   method ".length(), ((String)message).lastIndexOf(40));
                    message = Config.getString((String)"editor.quickfix.undeclaredMethod.errorMsg") + methodName + ((String)message).substring(((String)message).lastIndexOf(40));
                    Stream<Correction.CorrectionInfo> possibleCorrectionsStream = this.getPossibleCorrectionsStream(editor, AssistContent.CompletionKind.METHOD);
                    if (possibleCorrectionsStream != null) {
                        this.corrections.addAll(Correction.winnowAndCreateCorrections(methodName, possibleCorrectionsStream, (FXPlatformConsumer<Correction.CorrectionElements>)((FXPlatformConsumer)correctionElements -> {
                            editor.setSelection(startErrorPosSourceLocation, startErrorPosSourceLocation);
                            editor.setText(editor.getLineColumnFromOffset(startPos), editor.getLineColumnFromOffset(endPos), correctionElements.getPrimaryElement());
                        })));
                        editor.refresh();
                    }
                } else if (((String)message).startsWith("unreported exception ")) {
                    String exceptionQualifiedNameType = ((String)message).substring("unreported exception ".length(), ((String)message).indexOf(59));
                    Object messageFinal = message = Config.getString((String)"editor.quickfix.unreportedException.errorMsg.part1") + exceptionQualifiedNameType + Config.getString((String)"editor.quickfix.unreportedException.errorMsg.part2");
                    Future<List<AssistContentThreadSafe>> futureImports = editor.getEditorFixesManager().scanImports(exceptionQualifiedNameType);
                    Utility.runBackground(() -> this.lambda$new$16(futureImports, exceptionQualifiedNameType, editor, startPos, (String)messageFinal, errorLine, errorLineText, errorLineLength));
                }
            }
            catch (Exception ex) {
                Debug.reportError((Throwable)ex);
            }
            this.message = message;
            this.italicMessageStartIndex = italicMessageStartIndex;
            this.italicMessageEndIndex = italicMessageEndIndex;
        }

        private void doTypeQuickFix(FlowEditor editor, SourceLocation startErrorPosSourceLocation, Correction.CorrectionElements correctionElements, String typeName) {
            String correctionType = correctionElements.getPrimaryElement();
            String correctionPackage = correctionElements.getSecondaryElements().length > 0 ? correctionElements.getSecondaryElements()[0] : "";
            boolean isInnerClass = correctionType.contains(".");
            String fullyQualifiedNameCorrectionType = correctionPackage.length() > 0 ? correctionPackage + "." + correctionType : "";
            String fullyQualifiedNameCorrectionOuterType = isInnerClass ? correctionPackage + "." + correctionType.substring(0, correctionType.lastIndexOf(".")) : "";
            AtomicBoolean isCorrectionTypeImportedAtomic = new AtomicBoolean(false);
            AtomicBoolean isCorrectionOuterTypeImportedAtomic = new AtomicBoolean(false);
            Future<List<AssistContentThreadSafe>> futureCorrectionTypeImport = editor.getEditorFixesManager().scanImports(fullyQualifiedNameCorrectionType);
            Future<List<AssistContentThreadSafe>> futureCorrectionOuterTypeImport = isInnerClass ? editor.getEditorFixesManager().scanImports(fullyQualifiedNameCorrectionOuterType) : null;
            Utility.runBackground(() -> {
                try {
                    List matchCorrectionTypeACList = (List)futureCorrectionTypeImport.get();
                    List matchCorrectionOuterTypeACList = futureCorrectionOuterTypeImport != null ? (List)futureCorrectionOuterTypeImport.get() : new ArrayList();
                    Platform.runLater(() -> {
                        String codeAfterError;
                        if (matchCorrectionTypeACList.size() > 0) {
                            AssistContentThreadSafe matchCorrectionTypeAC = (AssistContentThreadSafe)matchCorrectionTypeACList.get(0);
                            isCorrectionTypeImportedAtomic.set(editor.checkTypeIsImported(matchCorrectionTypeAC, true));
                        }
                        if (matchCorrectionOuterTypeACList.size() > 0) {
                            AssistContentThreadSafe matchCorrectionOuterTypeAC = (AssistContentThreadSafe)matchCorrectionOuterTypeACList.get(0);
                            isCorrectionOuterTypeImportedAtomic.set(editor.checkTypeIsImported(matchCorrectionOuterTypeAC, false));
                        }
                        String codeBeforeError = editor.getText(new SourceLocation(1, 1), startErrorPosSourceLocation);
                        codeBeforeError = JavaUtils.blankCodeCommentsAndStringLiterals((String)codeBeforeError, (char)' ');
                        int startOfFullType = -1;
                        List<Character> searchTokens = Arrays.asList(Character.valueOf('/'), Character.valueOf('{'), Character.valueOf(';'), Character.valueOf('('), Character.valueOf(','), Character.valueOf('?'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf(':'), Character.valueOf('!'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('='), Character.valueOf('^'));
                        for (int currentSearchIndex = codeBeforeError.length() - 1; startOfFullType == -1 && currentSearchIndex >= 0; --currentSearchIndex) {
                            if (!searchTokens.contains(Character.valueOf(codeBeforeError.charAt(currentSearchIndex)))) continue;
                            startOfFullType = currentSearchIndex + 1;
                        }
                        if (startOfFullType > -1) {
                            codeBeforeError = codeBeforeError.substring(startOfFullType);
                        }
                        JavaLexer l = new JavaLexer((Reader)new StringReader((String)((codeAfterError = editor.getText(startErrorPosSourceLocation, editor.getLineColumnFromOffset(editor.getTextLength()))).startsWith(".") ? codeBeforeError + "." : codeBeforeError)));
                        ArrayList<String> fullTypePreTokens = new ArrayList<String>();
                        boolean feedPreTokens = false;
                        LocatableToken lastToken = null;
                        int fullTypePrePos = -1;
                        LocatableToken t = null;
                        t = l.nextToken();
                        while (t.getType() != 1) {
                            if (feedPreTokens && t.getType() != 68) {
                                fullTypePreTokens.add(t.getText());
                            } else if (!feedPreTokens && t.getType() == 68) {
                                fullTypePreTokens.add(lastToken.getText());
                                fullTypePrePos = startOfFullType > -1 ? startOfFullType + lastToken.getPosition() : lastToken.getPosition();
                                feedPreTokens = true;
                            } else {
                                lastToken = t;
                            }
                            t = l.nextToken();
                        }
                        int endOfWrongTypePos = this.startPos + codeAfterError.indexOf(typeName) + typeName.length();
                        if (fullTypePreTokens.size() > 0) {
                            editor.setSelection(editor.getLineColumnFromOffset(fullTypePrePos), editor.getLineColumnFromOffset(fullTypePrePos));
                            editor.setText(editor.getLineColumnFromOffset(fullTypePrePos), editor.getLineColumnFromOffset(endOfWrongTypePos), isInnerClass && isCorrectionTypeImportedAtomic.get() ? correctionType.substring(correctionType.lastIndexOf(".") + 1) : correctionType);
                        } else {
                            editor.setSelection(startErrorPosSourceLocation, startErrorPosSourceLocation);
                            editor.setText(editor.getLineColumnFromOffset(this.startPos), editor.getLineColumnFromOffset(endOfWrongTypePos), isInnerClass && isCorrectionTypeImportedAtomic.get() ? correctionType.substring(correctionType.lastIndexOf(".") + 1) : correctionType);
                        }
                        if (correctionPackage.length() > 0 && (!isInnerClass && !isCorrectionTypeImportedAtomic.get() || isInnerClass && !isCorrectionTypeImportedAtomic.get() && !isCorrectionOuterTypeImportedAtomic.get())) {
                            String importTypeFullName = correctionPackage + "." + (isInnerClass ? correctionType.substring(0, correctionType.lastIndexOf(".")) : correctionType);
                            editor.addImportFromQuickFix(importTypeFullName);
                            editor.refresh();
                        }
                    });
                }
                catch (InterruptedException | ExecutionException e) {
                    Debug.reportError((Throwable)e);
                }
            });
        }

        public boolean containsPosition(int pos) {
            return this.startPos <= pos && pos <= this.endPos;
        }

        public int getItalicMessageStartIndex() {
            return this.italicMessageStartIndex;
        }

        public int getItalicMessageEndIndex() {
            return this.italicMessageEndIndex;
        }

        private NewFieldInfos getNewClassFieldPos(FlowEditor editor) {
            if (editor == null) {
                return new NewFieldInfos(-1, null);
            }
            TextEditor e = editor.assumeText();
            ParsedCUNode pcuNode = e.getParsedNode();
            if (pcuNode == null) {
                return new NewFieldInfos(-1, null);
            }
            ParsedNode positionNode = pcuNode.getContainingMethodOrClassNode(this.startPos);
            if (positionNode == null) {
                return new NewFieldInfos(-1, null);
            }
            ParsedNode classNode = positionNode instanceof MethodNode ? positionNode.getParentNode() : positionNode;
            Iterator classNodeChildren = classNode.getChildren(0);
            int posOfNextField = -1;
            int posOfFirstField = 0;
            int posOfSeqField = 0;
            Object indentationFromLastField = null;
            while (classNodeChildren.hasNext()) {
                NodeTree.NodeAndPosition classNodeChild = (NodeTree.NodeAndPosition)classNodeChildren.next();
                if (!(classNodeChild.getNode() instanceof FieldNode)) continue;
                boolean isFirstField = ((FieldNode)classNodeChild.getNode()).isFirstFieldNode();
                if (isFirstField) {
                    posOfFirstField = classNodeChild.getPosition();
                }
                posOfSeqField = classNodeChild.getPosition();
                int offset = ((ParsedNode)classNodeChild.getNode()).getAbsoluteEditorPosition();
                int lastFieldLine = editor.getLineColumnFromOffset(offset).getLine();
                String lastFieldLineStr = editor.getText(new SourceLocation(lastFieldLine, 1), new SourceLocation(lastFieldLine, editor.getLineLength(lastFieldLine - 1)));
                int lastFieldNoIndentLength = lastFieldLineStr.replaceAll("^\\s+", "").length();
                posOfNextField = offset + lastFieldNoIndentLength + 1;
                if (!isFirstField) {
                    posOfNextField -= posOfSeqField - posOfFirstField;
                }
                indentationFromLastField = lastFieldLineStr.substring(0, lastFieldLineStr.length() - lastFieldNoIndentLength);
            }
            if (posOfNextField > -1) {
                return new NewFieldInfos(posOfNextField, (String)indentationFromLastField);
            }
            int classOffset = classNode.getAbsoluteEditorPosition();
            int classLine = editor.getLineColumnFromOffset(classOffset).getLine();
            String classLineStr = editor.getText(new SourceLocation(classLine, 1), new SourceLocation(classLine, editor.getLineLength(classLine - 1)));
            int classLineStrNoTailLength = classLineStr.replaceAll("\\s+$", "").length();
            String tailSpaces = classLineStr.substring(classLineStrNoTailLength);
            int classLineStrNoIdentLength = classLineStr.replaceAll("^\\s+", "").length();
            indentationFromLastField = classLineStr.substring(0, classLineStr.length() - classLineStrNoIdentLength) + "    ";
            return new NewFieldInfos(classOffset + tailSpaces.length() + 1, (String)indentationFromLastField);
        }

        private Stream<Correction.CorrectionInfo> getPossibleCorrectionsStream(FlowEditor editor, AssistContent.CompletionKind kind) {
            return this.getPossibleCorrectionsStream(editor, kind, null, null, this.startPos);
        }

        private Stream<Correction.CorrectionInfo> getPossibleCorrectionsStream(FlowEditor editor, AssistContent.CompletionKind kind, List<AssistContentThreadSafe> possibleCorrectionAlImports, String errorStr, int forceLookUpFromPos) {
            if (editor == null) {
                return null;
            }
            TextEditor e = editor.assumeText();
            ParsedCUNode pcuNode = e.getParsedNode();
            if (pcuNode == null) {
                return null;
            }
            ExpressionTypeInfo suggests = pcuNode.getExpressionType(forceLookUpFromPos, e.getSourceDocument());
            if (suggests == null) {
                return null;
            }
            ParsedNode positionNode = pcuNode.getContainingMethodOrClassNode(this.startPos);
            if (positionNode == null) {
                return null;
            }
            if (kind.equals((Object)AssistContent.CompletionKind.TYPE)) {
                ArrayList types = new ArrayList();
                if (editor.getWatcher().getPackage() != null) {
                    List projPackClasses = ParseUtils.getLocalTypes((Package)editor.getWatcher().getPackage(), null, (Set)Kind.all());
                    projPackClasses.sort(Comparator.comparing(AssistContentThreadSafe::getName));
                    types.addAll(projPackClasses);
                }
                ArrayList<AssistContentThreadSafe> commmonTypes = new ArrayList<AssistContentThreadSafe>();
                commmonTypes.addAll(editor.getEditorFixesManager().getPrimitiveTypes());
                if (possibleCorrectionAlImports != null) {
                    commmonTypes.addAll(editor.getEditorFixesManager().getJavaLangImports().stream().filter(ac -> ac.getPackage() != null).collect(Collectors.toList()));
                    commmonTypes.addAll(possibleCorrectionAlImports.stream().filter(ac -> Correction.isClassInUsualPackagesForCorrections(ac) || editor.checkTypeIsImported((AssistContentThreadSafe)ac, false)).collect(Collectors.toList()));
                }
                commmonTypes.sort(Comparator.comparing(AssistContentThreadSafe::getName));
                types.addAll(commmonTypes);
                return types.stream().map(Correction.TypeCorrectionInfo::new);
            }
            if (kind.equals((Object)AssistContent.CompletionKind.FIELD) || kind.equals((Object)AssistContent.CompletionKind.METHOD)) {
                if (editor.getProject() == null) {
                    return null;
                }
                AssistContent[] values = ParseUtils.getPossibleCompletions((ExpressionTypeInfo)suggests, (JavadocResolver)editor.getProject().getJavadocResolver(), null, (ParsedNode)positionNode);
                if (values == null) {
                    return null;
                }
                return Arrays.stream(values).filter(ac -> ac.getKind().equals((Object)kind)).flatMap(ac -> Stream.of(ac.getName())).distinct().map(Correction.SimpleCorrectionInfo::new);
            }
            Iterator methodContentIterator = positionNode.getChildren(0);
            while (methodContentIterator.hasNext()) {
                NodeTree.NodeAndPosition methodChild = (NodeTree.NodeAndPosition)methodContentIterator.next();
                if (!(methodChild.getNode() instanceof MethodBodyNode)) continue;
                Iterator methodBodyIterator = ((MethodBodyNode)methodChild.getNode()).getChildren(0);
                ArrayList<String> varNameList = new ArrayList<String>();
                while (methodBodyIterator.hasNext()) {
                    NodeTree.NodeAndPosition methodBodyChild = (NodeTree.NodeAndPosition)methodBodyIterator.next();
                    if (!(methodBodyChild.getNode() instanceof FieldNode)) continue;
                    varNameList.add(((FieldNode)methodBodyChild.getNode()).getName());
                }
                return varNameList.stream().distinct().map(Correction.SimpleCorrectionInfo::new);
            }
            return Stream.empty();
        }

        private /* synthetic */ void lambda$new$16(Future futureImports, String exceptionQualifiedNameType, FlowEditor editor, int startPos, String messageFinal, int errorLine, String errorLineText, int errorLineLength) {
            try {
                List matchTypeACList = (List)futureImports.get();
                Platform.runLater(() -> {
                    AssistContentThreadSafe matchTypeAC;
                    String exceptionTypeForCorrection = exceptionQualifiedNameType;
                    if (matchTypeACList.size() > 0 && editor.checkTypeIsImported(matchTypeAC = (AssistContentThreadSafe)matchTypeACList.get(0), false)) {
                        exceptionTypeForCorrection = matchTypeAC.getName();
                    }
                    if (editor.getProject() != null) {
                        int statementStartPos;
                        String exceptionVarNameRoot = exceptionQualifiedNameType.substring(exceptionQualifiedNameType.contains(".") ? exceptionQualifiedNameType.lastIndexOf(".") + 1 : 0).replaceAll("[^A-Z]", "").toLowerCase();
                        if (exceptionVarNameRoot.length() == 0) {
                            exceptionVarNameRoot = "e";
                        }
                        boolean foundVarName = false;
                        String fileContent = editor.getText(new SourceLocation(1, 1), editor.getLineColumnFromOffset(editor.getTextLength()));
                        int posOfClass = this.getNewClassFieldPos((FlowEditor)editor).pos;
                        int posOfContainingMethod = editor.getParsedNode().getContainingMethodOrClassNode(startPos).getAbsoluteEditorPosition();
                        int varSuffix = 0;
                        Object exceptionVarName = exceptionVarNameRoot;
                        do {
                            String exceptionVarNameFinal = exceptionVarName;
                            Stream<Correction.CorrectionInfo> localVarsCorrInStream = this.getPossibleCorrectionsStream(editor, AssistContent.CompletionKind.LOCAL_VAR, null, null, posOfContainingMethod);
                            Stream<Correction.CorrectionInfo> fieldsCorrInStream = this.getPossibleCorrectionsStream(editor, AssistContent.CompletionKind.FIELD, null, null, posOfClass);
                            boolean bl = foundVarName = localVarsCorrInStream.filter(ci -> ci.getCorrectionToCompareWith().equalsIgnoreCase(exceptionVarNameFinal)).findFirst().isPresent() || fieldsCorrInStream.filter(ci -> ci.getCorrectionToCompareWith().equalsIgnoreCase(exceptionVarNameFinal)).findFirst().isPresent();
                            if (!foundVarName) continue;
                            exceptionVarName = exceptionVarNameRoot + ++varSuffix;
                        } while (foundVarName);
                        String fileContentBeforeErrorPart = JavaUtils.blankCodeCommentsAndStringLiterals((String)fileContent.substring(0, startPos), (char)'0');
                        int prevStatementPos = Math.max(Math.max(fileContentBeforeErrorPart.lastIndexOf(123), fileContentBeforeErrorPart.lastIndexOf(125)), fileContentBeforeErrorPart.lastIndexOf(59));
                        if (prevStatementPos == -1) {
                            this.italicMessageStartIndex = messageFinal.indexOf(exceptionQualifiedNameType);
                            this.italicMessageEndIndex = messageFinal.indexOf(exceptionQualifiedNameType) + exceptionQualifiedNameType.length();
                            return;
                        }
                        for (statementStartPos = prevStatementPos + 1; statementStartPos < fileContentBeforeErrorPart.length() && Character.isWhitespace(fileContentBeforeErrorPart.charAt(statementStartPos)); ++statementStartPos) {
                        }
                        String fileContentAfterErrorPart = JavaUtils.blankCodeCommentsAndStringLiterals((String)fileContent.substring(startPos), (char)'0');
                        int statementEndPos = 0;
                        boolean needSurroundingBrackets = false;
                        if (!editor.getParsedNode().isCurrentlyInControlStatement(startPos)) {
                            boolean needNewLine = editor.getLineColumnFromOffset(prevStatementPos).getLine() == errorLine;
                            boolean foundEnd = false;
                            int openedBracket = 0;
                            if (fileContentBeforeErrorPart.substring(prevStatementPos, startPos).contains("->")) {
                                needNewLine = true;
                                needSurroundingBrackets = true;
                                statementStartPos = fileContentBeforeErrorPart.lastIndexOf("->") + "->".length();
                                for (searchIndex = 0; !foundEnd && searchIndex < fileContentAfterErrorPart.length(); ++searchIndex) {
                                    c = fileContentAfterErrorPart.charAt(searchIndex);
                                    if (c == '(') {
                                        ++openedBracket;
                                    } else if (c == ',' || c == ';' || c == ':') {
                                        foundEnd = openedBracket == 0;
                                    } else if (c == ')') {
                                        boolean bl = foundEnd = --openedBracket < 0;
                                    }
                                    if (!foundEnd) continue;
                                    statementEndPos = startPos + searchIndex;
                                }
                            } else {
                                while (!foundEnd && searchIndex < fileContentAfterErrorPart.length()) {
                                    c = fileContentAfterErrorPart.charAt(searchIndex);
                                    if (c == '(') {
                                        ++openedBracket;
                                    } else if (c == ')') {
                                        --openedBracket;
                                    } else if (c == ';') {
                                        boolean bl = foundEnd = openedBracket == 0;
                                    }
                                    if (foundEnd) {
                                        statementEndPos = startPos + searchIndex + 1;
                                    }
                                    ++searchIndex;
                                }
                            }
                            if (foundEnd) {
                                Object initIdent = errorLineText.substring(0, errorLineLength - 1 - errorLineText.replaceAll("^\\s*", "").length());
                                String unchangedInitIdent = initIdent;
                                String newIndentSpacing = "    ";
                                if (needSurroundingBrackets) {
                                    initIdent = (String)initIdent + newIndentSpacing;
                                }
                                StringBuffer tryCatchString = new StringBuffer((needNewLine ? "\n" : "") + (String)(needSurroundingBrackets ? unchangedInitIdent + "{\n" : "") + (String)(needSurroundingBrackets ? initIdent : "") + "try\n" + (String)initIdent + "{\n" + (String)initIdent + newIndentSpacing + fileContent.substring(statementStartPos, statementEndPos) + (needSurroundingBrackets ? ";" : "") + "\n" + (String)initIdent + "}\n" + (String)initIdent + "catch (" + exceptionTypeForCorrection + " " + (String)exceptionVarName + ")\n" + (String)initIdent + "{\n" + (String)initIdent + newIndentSpacing);
                                int posOfCatchStatement = tryCatchString.length();
                                String catchStatement = (String)exceptionVarName + ".printStackTrace();";
                                tryCatchString.append(catchStatement + "\n" + (String)initIdent + "}" + (needSurroundingBrackets ? "\n" : "") + (String)(needSurroundingBrackets ? unchangedInitIdent + "}" : ""));
                                int finalStatementEndPos = statementEndPos;
                                int finalStatementStartPos = statementStartPos;
                                this.corrections.add(new EditorFixesManager.FixSuggestionBase(Config.getString((String)"editor.quickfix.unreportedException.fixMsg.trycatch"), () -> {
                                    editor.setSelection(editor.getLineColumnFromOffset(finalStatementStartPos), editor.getLineColumnFromOffset(finalStatementEndPos));
                                    editor.setText(editor.getLineColumnFromOffset(finalStatementStartPos), editor.getLineColumnFromOffset(finalStatementEndPos), tryCatchString.toString());
                                    editor.refresh();
                                    editor.setSelection(editor.getLineColumnFromOffset(finalStatementStartPos + posOfCatchStatement), editor.getLineColumnFromOffset(finalStatementStartPos + posOfCatchStatement + catchStatement.length()));
                                }));
                            }
                        }
                        if (!needSurroundingBrackets) {
                            int posOfClosingMethodParamsBracket = fileContentBeforeErrorPart.indexOf(")", posOfContainingMethod);
                            int posOfOpeningMethodBodyBracket = fileContentBeforeErrorPart.indexOf(123, posOfClosingMethodParamsBracket);
                            if (posOfClosingMethodParamsBracket == -1 || posOfOpeningMethodBodyBracket == -1) {
                                this.italicMessageStartIndex = messageFinal.indexOf(exceptionQualifiedNameType);
                                this.italicMessageEndIndex = messageFinal.indexOf(exceptionQualifiedNameType) + exceptionQualifiedNameType.length();
                                return;
                            }
                            boolean methodHasThrows = fileContentBeforeErrorPart.substring(posOfClosingMethodParamsBracket, posOfOpeningMethodBodyBracket).contains(" throws ");
                            SourceLocation methodSourceLocation = editor.getLineColumnFromOffset(posOfContainingMethod);
                            boolean openingMethodBodyBracketOnSameLine = editor.getLineColumnFromOffset(posOfOpeningMethodBodyBracket).getLine() == methodSourceLocation.getLine();
                            String methodSignNoIdent = fileContent.substring(posOfContainingMethod, posOfOpeningMethodBodyBracket);
                            int posOfNewThrowsAddition = methodHasThrows ? posOfContainingMethod + methodSignNoIdent.indexOf(" throws ") + " throws ".length() : (openingMethodBodyBracketOnSameLine ? posOfOpeningMethodBodyBracket : posOfContainingMethod + methodSignNoIdent.replaceAll("\\s*$", "").length());
                            String throwsStatement = (Character.isWhitespace(fileContentBeforeErrorPart.charAt(posOfNewThrowsAddition - 1)) ? "" : " ") + (methodHasThrows ? exceptionTypeForCorrection + "," : "throws " + exceptionTypeForCorrection) + (openingMethodBodyBracketOnSameLine ? " " : "");
                            this.corrections.add(new EditorFixesManager.FixSuggestionBase(Config.getString((String)"editor.quickfix.unreportedException.fixMsg.throws"), () -> {
                                int currentLocation = editor.getOffsetFromLineColumn(editor.getCaretLocation());
                                editor.setSelection(editor.getLineColumnFromOffset(posOfNewThrowsAddition), editor.getLineColumnFromOffset(posOfNewThrowsAddition));
                                editor.setText(editor.getLineColumnFromOffset(posOfNewThrowsAddition), editor.getLineColumnFromOffset(posOfNewThrowsAddition), throwsStatement);
                                editor.refresh();
                                editor.setSelection(editor.getLineColumnFromOffset(currentLocation + throwsStatement.length()), editor.getLineColumnFromOffset(currentLocation + throwsStatement.length()));
                            }));
                        }
                    }
                });
            }
            catch (InterruptedException | ExecutionException e) {
                Debug.reportError((Throwable)e);
            }
        }

        private final class NewFieldInfos {
            private final int pos;
            private final String indentation;

            public NewFieldInfos(int pos, String indentation) {
                this.pos = pos;
                this.indentation = indentation;
            }

            public int getPos() {
                return this.pos;
            }

            public String getIndentation() {
                return this.indentation;
            }
        }
    }
}

