/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.Config;
import bluej.editor.flow.Document;
import bluej.editor.flow.MultilineStringTracker;
import bluej.editor.flow.TrackedPosition;
import bluej.parser.nodes.JavaParentNode;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.RBTreeNode;
import bluej.parser.nodes.ReparseableDocument;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FlowIndent {
    private static final Pattern WHITESPACE_TABS = Pattern.compile("^[ \\t]*");
    private static final Pattern WHITESPACE_TABS_STAR = Pattern.compile("^[ \\t*]*(/\\*)?");

    public static AutoIndentInformation calculateIndentsAndApply(ReparseableDocument parser, Document doc, MultilineStringTracker multilineStringTracker, int caretPos) {
        return FlowIndent.calculateIndentsAndApply(parser, doc, multilineStringTracker, 0, doc.getLength(), caretPos);
    }

    public static AutoIndentInformation calculateIndentsAndApply(ReparseableDocument parser, Document doc, MultilineStringTracker multilineStringTracker, int startPos, int endPos, int prevCaretPos) {
        boolean thisLineBlank;
        NodeTree.NodeAndPosition nodeAt;
        int i;
        int caretPos = prevCaretPos;
        ReparseableDocument.Element rootElement = parser.getDefaultRootElement();
        LinkedList<DocumentAction> methodUpdates = new LinkedList<DocumentAction>();
        ArrayList<DocumentIndentAction> updates = new ArrayList<DocumentIndentAction>(rootElement.getElementCount());
        RootIndentCalculator ii = new RootIndentCalculator();
        boolean lastLineWasBlank = false;
        boolean perfect = true;
        NodeTree.NodeAndPosition root = new NodeTree.NodeAndPosition((RBTreeNode)parser.getParser(), 0, parser.getParser().getSize());
        TrackedPosition startp = doc.trackPosition(startPos, Document.Bias.FORWARD);
        TrackedPosition endp = doc.trackPosition(endPos, Document.Bias.BACK);
        FlowIndent.checkMethodSpacing((NodeTree.NodeAndPosition<ParsedNode>)root, rootElement, methodUpdates, startPos, endPos);
        for (DocumentAction documentAction : methodUpdates) {
            caretPos = documentAction.apply(parser, doc, caretPos);
        }
        methodUpdates = null;
        for (i = 0; i < rootElement.getElementCount(); ++i) {
            ReparseableDocument.Element element = rootElement.getElement(i);
            if (element.getEndOffset() <= startp.getPosition() || element.getStartOffset() >= endp.getPosition()) continue;
            nodeAt = ((ParsedNode)root.getNode()).findNodeAt(element.getStartOffset(), root.getPosition());
            if (multilineStringTracker.checkStringRelation(element.getStartOffset(), element.getEndOffset(), nodeAt == null ? root.getPosition() : nodeAt.getPosition(), MultilineStringTracker.StringRelation.ENTIRELY_INSIDE)) continue;
            thisLineBlank = FlowIndent.isWhiteSpaceOnly(FlowIndent.getElementContents(doc, element));
            if (thisLineBlank) {
                if (caretPos >= element.getStartOffset() && caretPos < element.getEndOffset()) {
                    caretPos = element.getStartOffset();
                }
                if (lastLineWasBlank) {
                    if (element.getEndOffset() <= doc.getLength()) {
                        doc.replaceText(element.getStartOffset(), element.getEndOffset(), "");
                        perfect = false;
                    }
                } else {
                    int rmlen = element.getEndOffset() - element.getStartOffset() - 1;
                    if (rmlen > 0) {
                        doc.replaceText(element.getStartOffset(), element.getStartOffset() + rmlen, "");
                    }
                }
            }
            lastLineWasBlank = thisLineBlank;
        }
        parser.flushReparseQueue();
        for (i = 0; i < rootElement.getElementCount(); ++i) {
            ReparseableDocument.Element element = rootElement.getElement(i);
            nodeAt = ((ParsedNode)root.getNode()).findNodeAt(element.getStartOffset(), root.getPosition());
            if (multilineStringTracker.checkStringRelation(element.getStartOffset(), element.getEndOffset(), nodeAt == null ? root.getPosition() : nodeAt.getPosition(), MultilineStringTracker.StringRelation.INSIDE_OR_CLOSING_LINE) || element.getEndOffset() <= startp.getPosition() || element.getStartOffset() >= endp.getPosition()) continue;
            thisLineBlank = FlowIndent.isWhiteSpaceOnly(FlowIndent.getElementContents(doc, element));
            DocumentIndentAction update = null;
            if (!thisLineBlank) {
                String indent = FlowIndent.calculateIndent(element, (NodeTree.NodeAndPosition<ParsedNode>)root, ii, doc);
                update = new DocumentIndentAction(i, indent);
                boolean bl = perfect = perfect && FlowIndent.getElementContents(doc, element).toString().startsWith(indent) && !FlowIndent.isWhiteSpaceOnly(FlowIndent.getElementContents(doc, element).subSequence(indent.length(), indent.length() + 1));
            }
            if (update != null) {
                updates.add(update);
            }
            lastLineWasBlank = thisLineBlank;
        }
        for (DocumentAction documentAction : updates) {
            caretPos = documentAction.apply(parser, doc, caretPos);
        }
        return new AutoIndentInformation(perfect, caretPos);
    }

    private static String calculateIndent(ReparseableDocument.Element el, NodeTree.NodeAndPosition<ParsedNode> start, IndentCalculator startIC, Document doc) {
        int pos = el.getStartOffset() + FlowIndent.findFirstNonIndentChar(FlowIndent.getElementContents(doc, el), true);
        if (pos >= start.getPosition() && pos < start.getEnd()) {
            Iterator i = ((ParsedNode)start.getNode()).getChildren(start.getPosition());
            while (i.hasNext()) {
                boolean isInSwitchBlock;
                NodeTree.NodeAndPosition nap = (NodeTree.NodeAndPosition)i.next();
                boolean bl = isInSwitchBlock = nap.getNode() instanceof JavaParentNode && ((JavaParentNode)nap.getNode()).isSwitchBlockNode();
                String inner = FlowIndent.calculateIndent(el, (NodeTree.NodeAndPosition<ParsedNode>)nap, startIC.getForChild((ParsedNode)nap.getNode(), isInSwitchBlock), doc);
                if (inner == null) continue;
                return inner;
            }
            String inner = startIC.getCurIndent(doc.getContent(pos, pos + 1).charAt(0));
            if (inner.length() >= NodeIndentCalculator.tabSize && FlowIndent.getElementContents(doc, el).toString().trim().matches("(case |(default(\\s|:))).*")) {
                inner = inner.substring(0, inner.length() - NodeIndentCalculator.tabSize);
            }
            return inner;
        }
        return null;
    }

    private static void checkMethodSpacing(NodeTree.NodeAndPosition<ParsedNode> root, ReparseableDocument.Element map, List<DocumentAction> updates, int startPos, int endPos) {
        NodeTree.NodeAndPosition current = null;
        NodeTree.NodeAndPosition next = null;
        Iterator i = ((ParsedNode)root.getNode()).getChildren(root.getPosition());
        while (i.hasNext()) {
            next = (NodeTree.NodeAndPosition)i.next();
            if (current != null && ((ParsedNode)current.getNode()).getNodeType() == 2 && ((ParsedNode)current.getNode()).getNodeType() == ((ParsedNode)next.getNode()).getNodeType()) {
                int currentLine = map.getElementIndex(current.getEnd() - 1);
                int nextLine = map.getElementIndex(next.getPosition());
                if (next.getPosition() >= startPos && next.getPosition() <= endPos) {
                    if (currentLine + 1 == nextLine) {
                        updates.add(0, new DocumentAddLineAction(next.getPosition()));
                    } else if (currentLine == nextLine) {
                        updates.add(0, new DocumentAddLineAction(next.getPosition(), true));
                    }
                } else if (current.getEnd() >= startPos && current.getEnd() <= endPos) {
                    if (currentLine + 1 == nextLine) {
                        updates.add(0, new DocumentAddLineAction(current.getEnd()));
                    } else if (currentLine == nextLine) {
                        updates.add(0, new DocumentAddLineAction(current.getEnd(), true));
                    }
                }
            }
            if ((current = next).getPosition() > endPos) {
                return;
            }
            FlowIndent.checkMethodSpacing((NodeTree.NodeAndPosition<ParsedNode>)current, map, updates, startPos, endPos);
        }
    }

    private static CharSequence getElementContents(Document doc, ReparseableDocument.Element el) {
        return doc.getContent(el.getStartOffset(), el.getEndOffset());
    }

    public static boolean isWhiteSpaceOnly(CharSequence s) {
        return s.toString().trim().length() == 0;
    }

    public static int findFirstNonIndentChar(CharSequence line, boolean whitespaceOnly) {
        Matcher m = whitespaceOnly ? WHITESPACE_TABS.matcher(line) : WHITESPACE_TABS_STAR.matcher(line);
        return m.find() ? m.end() : 0;
    }

    public static class AutoIndentInformation {
        private boolean perfect;
        private int newCaretPos;

        public AutoIndentInformation(boolean perfect, int newCaretPos) {
            this.perfect = perfect;
            this.newCaretPos = newCaretPos;
        }

        public boolean isPerfect() {
            return this.perfect;
        }

        public int getNewCaretPosition() {
            return this.newCaretPos;
        }
    }

    private static class RootIndentCalculator
    implements IndentCalculator {
        private RootIndentCalculator() {
        }

        @Override
        public IndentCalculator getForChild(ParsedNode n, boolean doubleIndentation) {
            return new NodeIndentCalculator("", n);
        }

        @Override
        public String getCurIndent(char beginsWith) {
            return "";
        }
    }

    private static interface DocumentAction {
        public int apply(ReparseableDocument var1, Document var2, int var3);
    }

    private static interface IndentCalculator {
        public IndentCalculator getForChild(ParsedNode var1, boolean var2);

        public String getCurIndent(char var1);
    }

    private static class DocumentIndentAction
    implements DocumentAction {
        private final int lineIndex;
        private final String indent;

        public DocumentIndentAction(int lineIndex, String indent) {
            this.lineIndex = lineIndex;
            this.indent = indent;
        }

        @Override
        public int apply(ReparseableDocument parser, Document doc, int caretPos) {
            int lengthPrevWhitespace;
            boolean anyTabs;
            ReparseableDocument.Element el = parser.getDefaultRootElement().getElement(this.lineIndex);
            CharSequence line = FlowIndent.getElementContents(doc, el);
            boolean bl = anyTabs = line.subSequence(0, lengthPrevWhitespace = FlowIndent.findFirstNonIndentChar(line, true)).toString().indexOf("\t") != -1;
            if (this.indent != null && (anyTabs || this.indent.length() != lengthPrevWhitespace)) {
                int origStartOffset = el.getStartOffset();
                doc.replaceText(el.getStartOffset(), el.getStartOffset() + lengthPrevWhitespace, this.indent);
                if (caretPos < origStartOffset) {
                    return caretPos;
                }
                if (caretPos >= origStartOffset + lengthPrevWhitespace) {
                    int changeLength = this.indent.length() - lengthPrevWhitespace;
                    return caretPos + changeLength;
                }
                return origStartOffset + this.indent.length();
            }
            return caretPos;
        }
    }

    private static class NodeIndentCalculator
    implements IndentCalculator {
        private final String existingIndent;
        private final ParsedNode parent;
        private static final int tabSize = Config.getPropInteger((String)"bluej.editor.tabsize", (int)4);
        private static final String spaces = "                                                                                   ";
        private static final String STANDARD_INDENT;
        private static final String CONTINUATION_INDENT;
        private static final String COMMENT_ASTERISK_INDENT = " ";

        public NodeIndentCalculator(String existingIndent, ParsedNode parent) {
            this.existingIndent = existingIndent;
            this.parent = parent;
        }

        @Override
        public IndentCalculator getForChild(ParsedNode child, boolean doubleIndentation) {
            Object newIndent = this.existingIndent;
            if (child.isInner()) {
                newIndent = (String)newIndent + (String)(doubleIndentation ? STANDARD_INDENT + STANDARD_INDENT : STANDARD_INDENT);
            } else if (!(child.isContainer() || this.parent.isContainer() || this.parent.isInner())) {
                newIndent = (String)newIndent + CONTINUATION_INDENT;
            }
            return new NodeIndentCalculator((String)newIndent, child);
        }

        @Override
        public String getCurIndent(char beginsWith) {
            if (this.parent.getNodeType() == 7 && beginsWith == '*') {
                return this.existingIndent + COMMENT_ASTERISK_INDENT;
            }
            return this.existingIndent;
        }

        static {
            CONTINUATION_INDENT = STANDARD_INDENT = spaces.substring(0, tabSize);
        }
    }

    private static class DocumentAddLineAction
    implements DocumentAction {
        private int position;
        private boolean twoSeparators;

        public DocumentAddLineAction(int position) {
            this(position, false);
        }

        public DocumentAddLineAction(int position, boolean twoSeparators) {
            this.position = position;
            this.twoSeparators = twoSeparators;
        }

        @Override
        public int apply(ReparseableDocument parser, Document doc, int prevCaretPos) {
            String lineSeparator = System.getProperty("line.separator");
            if (this.twoSeparators) {
                doc.replaceText(this.position, this.position, lineSeparator + lineSeparator);
            } else {
                doc.replaceText(this.position, this.position, lineSeparator);
            }
            if (this.position > prevCaretPos) {
                return prevCaretPos;
            }
            if (this.twoSeparators) {
                return prevCaretPos + lineSeparator.length() * 2;
            }
            return prevCaretPos + lineSeparator.length();
        }
    }
}

