/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.editor.flow.Document;
import bluej.editor.flow.TrackedPosition;
import bluej.extensions2.editor.DocumentListener;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

public class HoleDocument
implements Document {
    private static final int GROWTH_MARGIN = 256;
    private char[] content;
    private int holeStart = 0;
    private int holeEnd;
    private final ArrayList<LineInformation> lineInformation = new ArrayList();
    private final ArrayList<WeakReference<TrackedPosition>> trackedPositions = new ArrayList();
    private final List<DocumentListener> listeners = new ArrayList<DocumentListener>();

    public HoleDocument() {
        this.content = new char[128];
        this.holeEnd = this.content.length;
        this.lineInformation.add(new LineInformation(null));
    }

    @Override
    public void replaceText(int startCharIncl, int endCharExcl, String text) {
        int linesRemoved = 0;
        int indexToInsertNewNewlines = 1;
        Iterator<LineInformation> iterator = this.lineInformation.iterator();
        while (iterator.hasNext()) {
            LineInformation lineInformation = iterator.next();
            if (lineInformation.lineStart == null) continue;
            TrackedPosition lineStartPosition = lineInformation.lineStart;
            if (lineStartPosition.position <= startCharIncl) {
                ++indexToInsertNewNewlines;
                continue;
            }
            if (lineStartPosition.position <= startCharIncl || lineStartPosition.position > endCharExcl) continue;
            ++linesRemoved;
            iterator.remove();
        }
        if (this.holeStart < startCharIncl) {
            System.arraycopy(this.content, this.holeEnd, this.content, this.holeStart, startCharIncl - this.holeStart);
            this.holeEnd += startCharIncl - this.holeStart;
            this.holeStart = startCharIncl;
        } else if (this.holeStart > startCharIncl) {
            int amountToMove = this.holeStart - startCharIncl;
            System.arraycopy(this.content, startCharIncl, this.content, this.holeEnd - amountToMove, amountToMove);
            this.holeEnd -= amountToMove;
            this.holeStart = startCharIncl;
        }
        String replaced = new String(this.content, this.holeEnd, endCharExcl - startCharIncl);
        this.holeEnd += endCharExcl - startCharIncl;
        int additionAmount = text.length();
        if (this.holeEnd - this.holeStart < additionAmount) {
            int extraLength = additionAmount + 256;
            char[] newContent = new char[this.content.length + extraLength];
            System.arraycopy(this.content, 0, newContent, 0, this.holeStart);
            System.arraycopy(this.content, this.holeEnd, newContent, this.holeEnd + extraLength, this.content.length - this.holeEnd);
            this.content = newContent;
            this.holeEnd += extraLength;
        }
        System.arraycopy(text.toCharArray(), 0, this.content, this.holeStart, text.length());
        this.holeStart += text.length();
        Iterator<WeakReference<TrackedPosition>> iterator2 = this.trackedPositions.iterator();
        while (iterator2.hasNext()) {
            WeakReference<TrackedPosition> trackedPositionRef = iterator2.next();
            TrackedPosition trackedPosition = (TrackedPosition)trackedPositionRef.get();
            if (trackedPosition == null) {
                iterator2.remove();
                continue;
            }
            trackedPosition.updateTrackedPosition(startCharIncl, endCharExcl, text.length());
        }
        int linesAdded = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            this.lineInformation.add(indexToInsertNewNewlines, new LineInformation(this.trackPosition(i + 1 + startCharIncl, Document.Bias.BACK)));
            ++indexToInsertNewNewlines;
            ++linesAdded;
        }
        ArrayList<DocumentListener> listenersCopy = new ArrayList<DocumentListener>(this.listeners);
        for (DocumentListener listener : listenersCopy) {
            listener.textReplaced(startCharIncl, replaced, text, linesRemoved, linesAdded);
        }
    }

    @Override
    public String getFullContent() {
        return new String(this.content, 0, this.holeStart) + new String(this.content, this.holeEnd, this.content.length - this.holeEnd);
    }

    @Override
    public int getLength() {
        return this.content.length - (this.holeEnd - this.holeStart);
    }

    @Override
    public int getLineFromPosition(int position) {
        int index = Collections.binarySearch(this.getLineStartPositions(), position);
        if (index >= 0) {
            return index;
        }
        return -2 - index;
    }

    private List<Integer> getLineStartPositions() {
        return new AbstractList<Integer>(){

            @Override
            public int size() {
                return HoleDocument.this.lineInformation.size();
            }

            @Override
            public Integer get(int index) {
                if (index == 0) {
                    return 0;
                }
                return HoleDocument.this.lineInformation.get((int)index).lineStart.position;
            }
        };
    }

    @Override
    public int getColumnFromPosition(int position) {
        int lineStartIndex = this.getLineFromPosition(position);
        if (lineStartIndex <= 0) {
            return position;
        }
        return position - this.lineInformation.get((int)lineStartIndex).lineStart.position;
    }

    @Override
    public TrackedPosition trackPosition(int position, Document.Bias bias) {
        TrackedPosition trackedPosition = new TrackedPosition(this, position, bias);
        this.trackedPositions.add(new WeakReference<TrackedPosition>(trackedPosition));
        return trackedPosition;
    }

    @Override
    public List<CharSequence> getLines() {
        final List<Integer> lineStarts = this.getLineStartPositions();
        return new AbstractList<CharSequence>(){

            @Override
            public CharSequence get(int lineIndex) {
                int startChar = (Integer)lineStarts.get(lineIndex);
                int endChar = lineIndex + 1 >= lineStarts.size() ? HoleDocument.this.getLength() : (Integer)lineStarts.get(lineIndex + 1) - 1;
                return HoleDocument.this.subSequence(startChar, endChar);
            }

            @Override
            public int size() {
                return lineStarts.size();
            }
        };
    }

    private CharSequence subSequence(final int startChar, final int endChar) {
        return new CharSequence(){

            @Override
            public int length() {
                return endChar - startChar;
            }

            @Override
            public char charAt(int index) {
                if (index + startChar < HoleDocument.this.holeStart) {
                    return HoleDocument.this.content[index + startChar];
                }
                return HoleDocument.this.content[index + startChar + HoleDocument.this.holeEnd - HoleDocument.this.holeStart];
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return HoleDocument.this.subSequence(startChar + start, startChar + end);
            }

            @Override
            public String toString() {
                String beforeHole = startChar < HoleDocument.this.holeStart ? new String(HoleDocument.this.content, startChar, Math.min(endChar, HoleDocument.this.holeStart) - startChar) : "";
                String afterHole = endChar > HoleDocument.this.holeStart ? new String(HoleDocument.this.content, Math.max(startChar + HoleDocument.this.holeEnd - HoleDocument.this.holeStart, HoleDocument.this.holeEnd), endChar + HoleDocument.this.holeEnd - HoleDocument.this.holeStart - Math.max(startChar + HoleDocument.this.holeEnd - HoleDocument.this.holeStart, HoleDocument.this.holeEnd)) : "";
                return beforeHole + afterHole;
            }

            public int hashCode() {
                return this.toString().hashCode();
            }

            public boolean equals(Object obj) {
                if (obj instanceof CharSequence) {
                    CharSequence cs = (CharSequence)obj;
                    if (this.length() != cs.length()) {
                        return false;
                    }
                    for (int i = 0; i < this.length(); ++i) {
                        if (this.charAt(i) == cs.charAt(i)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public CharSequence getContent(int startCharIncl, int endCharExcl) {
        return this.subSequence(startCharIncl, endCharExcl);
    }

    @Override
    public int getLineStart(int lineNumber) {
        return this.getLineStartPositions().get(lineNumber);
    }

    @Override
    public int getLineEnd(int lineNumber) {
        if (lineNumber + 1 < this.lineInformation.size()) {
            return this.getLineStartPositions().get(lineNumber + 1) - 1;
        }
        return this.getLength();
    }

    @Override
    public int getLineCount() {
        return this.lineInformation.size();
    }

    @Override
    public void addListener(boolean atStart, DocumentListener listener) {
        if (atStart) {
            this.listeners.add(0, listener);
        } else {
            this.listeners.add(listener);
        }
    }

    public void removeListener(DocumentListener listener) {
        this.listeners.removeIf(l -> l == listener);
    }

    public boolean hasLineAttribute(int lineIndex, Object attributeKey) {
        if (lineIndex >= 0 && lineIndex < this.lineInformation.size()) {
            return this.lineInformation.get((int)lineIndex).lineAttributes.containsKey(attributeKey);
        }
        return false;
    }

    public void addLineAttribute(int lineIndex, Object key, Object value) {
        if (lineIndex >= 0 && lineIndex < this.lineInformation.size()) {
            this.lineInformation.get((int)lineIndex).lineAttributes.put(key, value);
        }
    }

    public void removeLineAttributeThroughout(Object key) {
        for (LineInformation information : this.lineInformation) {
            information.lineAttributes.remove(key);
        }
    }

    @Override
    public Reader makeReader(int startPos, int endPos) {
        return new HoleReader(startPos, endPos);
    }

    public String getLongestLine() {
        List<Integer> lineStarts = this.getLineStartPositions();
        int longestIndex = 0;
        int longestLength = 0;
        int line = 0;
        while (line + 1 < lineStarts.size()) {
            int length = lineStarts.get(line + 1) - lineStarts.get(line);
            if (length > longestLength) {
                longestLength = length;
                longestIndex = line;
            }
            ++line;
        }
        return this.getLines().get(longestIndex).toString();
    }

    private static class LineInformation {
        private final TrackedPosition lineStart;
        private final HashMap<Object, Object> lineAttributes = new HashMap();

        public LineInformation(TrackedPosition lineStart) {
            this.lineStart = lineStart;
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    private class HoleReader
    extends Reader {
        private int next;
        private int mark = 0;
        private final int end;

        private HoleReader(int start, int end) {
            this.next = start;
            this.end = end;
        }

        @Override
        public int read() {
            if (this.next >= this.end) {
                return -1;
            }
            if (this.next < HoleDocument.this.holeStart) {
                return HoleDocument.this.content[this.next++];
            }
            return HoleDocument.this.content[this.next++ + (HoleDocument.this.holeEnd - HoleDocument.this.holeStart)];
        }

        @Override
        public int read(char[] cbuf, int off, int len) {
            int total;
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.next >= this.end) {
                return -1;
            }
            int toCopy = total = Math.min(this.end - this.next, len);
            if (this.next < HoleDocument.this.holeStart) {
                System.arraycopy(HoleDocument.this.content, this.next, cbuf, off, Math.min(toCopy, HoleDocument.this.holeStart - this.next));
                off += HoleDocument.this.holeStart - this.next;
                toCopy -= HoleDocument.this.holeStart - this.next;
            }
            if (toCopy > 0) {
                System.arraycopy(HoleDocument.this.content, this.next + (HoleDocument.this.holeEnd - HoleDocument.this.holeStart) + Math.max(0, HoleDocument.this.holeStart - this.next), cbuf, off, toCopy);
            }
            this.next += total;
            return total;
        }

        @Override
        public long skip(long ns) {
            if (this.next >= this.end) {
                return 0L;
            }
            long n = Math.min((long)(this.end - this.next), ns);
            n = Math.max((long)(-this.next), n);
            this.next = (int)((long)this.next + n);
            return n;
        }

        @Override
        public boolean ready() {
            return true;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readAheadLimit) {
            if (readAheadLimit < 0) {
                throw new IllegalArgumentException("Read-ahead limit < 0");
            }
            this.mark = this.next;
        }

        @Override
        public void reset() {
            this.next = this.mark;
        }

        @Override
        public void close() {
        }
    }
}

