/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.editor.flow.FlowEditor;
import bluej.editor.stride.FXTab;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.TabMenuManager;
import bluej.utility.javafx.JavaFXUtil;
import java.util.List;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.Image;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class FlowFXTab
extends FXTab {
    private boolean initialised = false;
    private final FlowEditor flowEditor;
    private final TabMenuManager menuManager;
    private final StringProperty windowTitleProperty = new SimpleStringProperty();
    private final SimpleObjectProperty<Image> classIcon;
    private FXTabbedEditor parent;

    @OnThread(value=Tag.FXPlatform)
    public FlowFXTab(FlowEditor flowEditor, String windowTitle) {
        super(false);
        this.flowEditor = flowEditor;
        this.windowTitleProperty.set((Object)windowTitle);
        this.classIcon = new SimpleObjectProperty();
        this.menuManager = new TabMenuManager(this){

            @Override
            @OnThread(value=Tag.FXPlatform)
            List<Menu> getMenus() {
                this.updateMoveMenus();
                List<Menu> moeFXMenu = FlowFXTab.this.flowEditor.getFXMenu();
                if (moeFXMenu.size() > 0 && moeFXMenu.get(0).getItems().get(0) != this.mainMoveMenu) {
                    moeFXMenu.get(0).getItems().add(0, (Object)this.mainMoveMenu);
                    moeFXMenu.get(0).getItems().add(1, (Object)new SeparatorMenuItem());
                }
                return moeFXMenu;
            }
        };
        JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"moe-tab"});
    }

    public void setWindowTitle(String title) {
        this.windowTitleProperty.set((Object)title);
    }

    public void setErrorStatus(boolean errorStatus) {
        if (errorStatus) {
            JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"bj-tab-error"});
        } else {
            this.getStyleClass().removeAll((Object[])new String[]{"bj-tab-error"});
        }
    }

    @Override
    void focusWhenShown() {
        this.flowEditor.requestEditorFocus();
    }

    @Override
    List<Menu> getMenus() {
        return this.menuManager.getMenus();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public FXTabbedEditor getParent() {
        return this.parent;
    }

    @Override
    String getWebAddress() {
        return null;
    }

    @Override
    void initialiseFX() {
        if (!this.initialised) {
            this.initialised = true;
        }
        this.setContent((Node)this.flowEditor);
        this.setText("");
        Label titleLabel = new Label((String)this.windowTitleProperty.get());
        titleLabel.textProperty().bind((ObservableValue)this.windowTitleProperty);
        HBox tabHeader = new HBox(new Node[]{titleLabel});
        tabHeader.getChildren().add((Object)FlowFXTab.makeClassGraphicIcon(this.classIcon, 16, false));
        tabHeader.setAlignment(Pos.CENTER);
        tabHeader.setSpacing(3.0);
        tabHeader.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            if (e.getButton() == MouseButton.MIDDLE) {
                this.flowEditor.setEditorVisible(false, false);
            }
        });
        this.setGraphic((Node)tabHeader);
    }

    @Override
    public void notifySelected() {
        this.flowEditor.notifyVisibleTab(true);
    }

    @Override
    public void notifyUnselected() {
        this.flowEditor.notifyVisibleTab(false);
        this.flowEditor.cancelFreshState();
    }

    @Override
    void setParent(FXTabbedEditor parent, boolean partOfMove) {
        this.parent = parent;
        this.flowEditor.setParent(parent, partOfMove);
        this.flowEditor.notifyVisibleTab(false);
    }

    @Override
    ObservableStringValue windowTitleProperty() {
        return this.windowTitleProperty;
    }

    public FlowEditor getFlowEditor() {
        return this.flowEditor;
    }

    public void setHeaderImage(Image image) {
        this.classIcon.set((Object)image);
    }
}

