/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.discovery;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.util.BlacklistedExceptions;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.ModuleSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.discovery.UriSelector;
import org.junit.platform.engine.support.discovery.SelectorResolver;

class EngineDiscoveryRequestResolution {
    private final Logger logger;
    private final EngineDiscoveryRequest request;
    private final SelectorResolver.Context defaultContext;
    private final List<SelectorResolver> resolvers;
    private final List<TestDescriptor.Visitor> visitors;
    private final TestDescriptor engineDescriptor;
    private final Map<DiscoverySelector, SelectorResolver.Resolution> resolvedSelectors = new LinkedHashMap<DiscoverySelector, SelectorResolver.Resolution>();
    private final Map<UniqueId, SelectorResolver.Match> resolvedUniqueIds = new LinkedHashMap<UniqueId, SelectorResolver.Match>();
    private final Queue<DiscoverySelector> remainingSelectors = new ArrayDeque<DiscoverySelector>();
    private final Map<DiscoverySelector, SelectorResolver.Context> contextBySelector = new HashMap<DiscoverySelector, SelectorResolver.Context>();

    EngineDiscoveryRequestResolution(Logger logger, EngineDiscoveryRequest request, TestDescriptor engineDescriptor, List<SelectorResolver> resolvers, List<TestDescriptor.Visitor> visitors) {
        this.logger = logger;
        this.request = request;
        this.engineDescriptor = engineDescriptor;
        this.resolvers = resolvers;
        this.visitors = visitors;
        this.defaultContext = new DefaultContext(null);
        this.resolvedUniqueIds.put(engineDescriptor.getUniqueId(), SelectorResolver.Match.exact(engineDescriptor));
    }

    void run() {
        this.remainingSelectors.addAll(this.request.getSelectorsByType(DiscoverySelector.class));
        while (!this.remainingSelectors.isEmpty()) {
            this.resolveCompletely(this.remainingSelectors.poll());
        }
        this.visitors.forEach(this.engineDescriptor::accept);
    }

    private void resolveCompletely(DiscoverySelector selector) {
        try {
            Optional<SelectorResolver.Resolution> result = this.resolve(selector);
            if (result.isPresent()) {
                this.enqueueAdditionalSelectors(result.get());
            } else {
                this.logUnresolvedSelector(selector, null);
            }
        }
        catch (Throwable t) {
            BlacklistedExceptions.rethrowIfBlacklisted(t);
            this.logUnresolvedSelector(selector, t);
        }
    }

    private void enqueueAdditionalSelectors(SelectorResolver.Resolution resolution) {
        this.remainingSelectors.addAll(resolution.getSelectors());
        resolution.getMatches().stream().filter(SelectorResolver.Match::isExact).forEach(match -> {
            Set<? extends DiscoverySelector> childSelectors = match.expand();
            if (!childSelectors.isEmpty()) {
                this.remainingSelectors.addAll(childSelectors);
                DefaultContext context = new DefaultContext(match.getTestDescriptor());
                childSelectors.forEach(selector -> this.contextBySelector.put((DiscoverySelector)selector, context));
            }
        });
    }

    private Optional<SelectorResolver.Resolution> resolve(DiscoverySelector selector) {
        if (this.resolvedSelectors.containsKey(selector)) {
            return Optional.of(this.resolvedSelectors.get(selector));
        }
        if (selector instanceof UniqueIdSelector) {
            return this.resolveUniqueId((UniqueIdSelector)selector);
        }
        return this.resolve(selector, resolver -> {
            SelectorResolver.Context context = this.getContext(selector);
            if (selector instanceof ClasspathResourceSelector) {
                return resolver.resolve((ClasspathResourceSelector)selector, context);
            }
            if (selector instanceof ClasspathRootSelector) {
                return resolver.resolve((ClasspathRootSelector)selector, context);
            }
            if (selector instanceof ClassSelector) {
                return resolver.resolve((ClassSelector)selector, context);
            }
            if (selector instanceof DirectorySelector) {
                return resolver.resolve((DirectorySelector)selector, context);
            }
            if (selector instanceof FileSelector) {
                return resolver.resolve((FileSelector)selector, context);
            }
            if (selector instanceof MethodSelector) {
                return resolver.resolve((MethodSelector)selector, context);
            }
            if (selector instanceof ModuleSelector) {
                return resolver.resolve((ModuleSelector)selector, context);
            }
            if (selector instanceof PackageSelector) {
                return resolver.resolve((PackageSelector)selector, context);
            }
            if (selector instanceof UriSelector) {
                return resolver.resolve((UriSelector)selector, context);
            }
            return resolver.resolve(selector, context);
        });
    }

    private Optional<SelectorResolver.Resolution> resolveUniqueId(UniqueIdSelector selector) {
        UniqueId uniqueId = selector.getUniqueId();
        if (this.resolvedUniqueIds.containsKey(uniqueId)) {
            return Optional.of(SelectorResolver.Resolution.match(this.resolvedUniqueIds.get(uniqueId)));
        }
        if (!uniqueId.hasPrefix(this.engineDescriptor.getUniqueId())) {
            return Optional.empty();
        }
        return this.resolve(selector, resolver -> resolver.resolve(selector, this.getContext(selector)));
    }

    private SelectorResolver.Context getContext(DiscoverySelector selector) {
        return this.contextBySelector.getOrDefault(selector, this.defaultContext);
    }

    private Optional<SelectorResolver.Resolution> resolve(DiscoverySelector selector, Function<SelectorResolver, SelectorResolver.Resolution> resolutionFunction) {
        return this.resolvers.stream().map(resolutionFunction).filter(SelectorResolver.Resolution::isResolved).findFirst().map(resolution -> {
            this.contextBySelector.remove(selector);
            this.resolvedSelectors.put(selector, (SelectorResolver.Resolution)resolution);
            resolution.getMatches().forEach(match -> this.resolvedUniqueIds.put(match.getTestDescriptor().getUniqueId(), (SelectorResolver.Match)match));
            return resolution;
        });
    }

    private void logUnresolvedSelector(DiscoverySelector selector, Throwable cause) {
        BiConsumer<Throwable, Supplier> loggingConsumer = this.logger::debug;
        if (selector instanceof UniqueIdSelector) {
            UniqueId uniqueId = ((UniqueIdSelector)selector).getUniqueId();
            if (uniqueId.hasPrefix(this.engineDescriptor.getUniqueId())) {
                loggingConsumer = this.logger::warn;
            } else {
                return;
            }
        }
        loggingConsumer.accept(cause, () -> selector + " could not be resolved.");
    }

    private class DefaultContext
    implements SelectorResolver.Context {
        private final TestDescriptor parent;

        DefaultContext(TestDescriptor parent) {
            this.parent = parent;
        }

        @Override
        public <T extends TestDescriptor> Optional<T> addToParent(Function<TestDescriptor, Optional<T>> creator) {
            if (this.parent != null) {
                return this.createAndAdd(this.parent, creator);
            }
            return this.createAndAdd(EngineDiscoveryRequestResolution.this.engineDescriptor, creator);
        }

        @Override
        public <T extends TestDescriptor> Optional<T> addToParent(Supplier<DiscoverySelector> parentSelectorSupplier, Function<TestDescriptor, Optional<T>> creator) {
            if (this.parent != null) {
                return this.createAndAdd(this.parent, creator);
            }
            return this.resolve(parentSelectorSupplier.get()).flatMap(parent -> this.createAndAdd((TestDescriptor)parent, creator));
        }

        @Override
        public Optional<TestDescriptor> resolve(DiscoverySelector selector) {
            return EngineDiscoveryRequestResolution.this.resolve(selector).map(SelectorResolver.Resolution::getMatches).flatMap(matches -> {
                if (matches.size() > 1) {
                    String stringRepresentation = matches.stream().map(SelectorResolver.Match::getTestDescriptor).map(Objects::toString).collect(Collectors.joining(", "));
                    throw new JUnitException("Selector " + selector + " did not yield unique test descriptor: " + stringRepresentation);
                }
                if (matches.size() == 1) {
                    return Optional.of(((SelectorResolver.Match)CollectionUtils.getOnlyElement(matches)).getTestDescriptor());
                }
                return Optional.empty();
            });
        }

        private <T extends TestDescriptor> Optional<T> createAndAdd(TestDescriptor parent, Function<TestDescriptor, Optional<T>> creator) {
            Optional<T> child = creator.apply(parent);
            if (child.isPresent()) {
                UniqueId uniqueId = ((TestDescriptor)child.get()).getUniqueId();
                if (EngineDiscoveryRequestResolution.this.resolvedUniqueIds.containsKey(uniqueId)) {
                    return Optional.of(((SelectorResolver.Match)EngineDiscoveryRequestResolution.this.resolvedUniqueIds.get(uniqueId)).getTestDescriptor());
                }
                parent.addChild((TestDescriptor)child.get());
            }
            return child;
        }
    }
}

