/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.descriptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.experimental.categories.Category;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.util.FunctionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.runner.Description;

@API(status=API.Status.INTERNAL, since="4.12")
public class VintageTestDescriptor
extends AbstractTestDescriptor {
    public static final String ENGINE_ID = "junit-vintage";
    public static final String SEGMENT_TYPE_RUNNER = "runner";
    public static final String SEGMENT_TYPE_TEST = "test";
    public static final String SEGMENT_TYPE_DYNAMIC = "dynamic";
    protected Description description;

    public VintageTestDescriptor(UniqueId uniqueId, Description description) {
        this(uniqueId, description, VintageTestDescriptor.generateDisplayName(description), VintageTestDescriptor.toTestSource(description));
    }

    VintageTestDescriptor(UniqueId uniqueId, Description description, String displayName, TestSource source) {
        super(uniqueId, displayName, source);
        this.description = description;
    }

    private static String generateDisplayName(Description description) {
        return description.getMethodName() != null ? description.getMethodName() : description.getDisplayName();
    }

    public Description getDescription() {
        return this.description;
    }

    @Override
    public String getLegacyReportingName() {
        String className;
        String methodName = this.description.getMethodName();
        if (methodName == null && StringUtils.isNotBlank(className = this.description.getClassName())) {
            return className;
        }
        return super.getLegacyReportingName();
    }

    @Override
    public TestDescriptor.Type getType() {
        return this.description.isTest() ? TestDescriptor.Type.TEST : TestDescriptor.Type.CONTAINER;
    }

    @Override
    public Set<TestTag> getTags() {
        LinkedHashSet<TestTag> tags = new LinkedHashSet<TestTag>();
        this.addTagsFromParent(tags);
        this.addCategoriesAsTags(tags);
        return tags;
    }

    @Override
    public void removeFromHierarchy() {
        if (this.canBeRemovedFromHierarchy()) {
            super.removeFromHierarchy();
        }
    }

    protected boolean canBeRemovedFromHierarchy() {
        return this.tryToExcludeFromRunner(this.description);
    }

    protected boolean tryToExcludeFromRunner(Description description) {
        return this.getParent().map(VintageTestDescriptor.class::cast).map(parent -> parent.tryToExcludeFromRunner(description)).orElse(false);
    }

    void pruneDescriptorsForObsoleteDescriptions(List<Description> newSiblingDescriptions) {
        Optional newDescription = newSiblingDescriptions.stream().filter(Predicate.isEqual(this.description)).findAny();
        if (newDescription.isPresent()) {
            ArrayList<Description> newChildren = ((Description)newDescription.get()).getChildren();
            new ArrayList(this.children).stream().map(VintageTestDescriptor.class::cast).forEach(childDescriptor -> childDescriptor.pruneDescriptorsForObsoleteDescriptions(newChildren));
        } else {
            super.removeFromHierarchy();
        }
    }

    private void addTagsFromParent(Set<TestTag> tags) {
        this.getParent().map(TestDescriptor::getTags).ifPresent(tags::addAll);
    }

    private void addCategoriesAsTags(Set<TestTag> tags) {
        Category annotation = this.description.getAnnotation(Category.class);
        if (annotation != null) {
            Arrays.stream(annotation.value()).map(ReflectionUtils::getAllAssignmentCompatibleClasses).flatMap(Collection::stream).distinct().map(Class::getName).map(TestTag::create).forEachOrdered(tags::add);
        }
    }

    private static TestSource toTestSource(Description description) {
        Class<?> testClass = description.getTestClass();
        if (testClass != null) {
            Method method;
            String methodName = description.getMethodName();
            if (methodName != null && (method = VintageTestDescriptor.findMethod(testClass, methodName)) != null) {
                return MethodSource.from(testClass, method);
            }
            return ClassSource.from(testClass);
        }
        return null;
    }

    private static Method findMethod(Class<?> testClass, String methodName) {
        if (methodName.contains("[") && methodName.endsWith("]")) {
            return VintageTestDescriptor.findMethod(testClass, methodName.substring(0, methodName.indexOf("[")));
        }
        List<Method> methods = ReflectionUtils.findMethods(testClass, FunctionUtils.where(Method::getName, Predicate.isEqual(methodName)));
        if (methods.isEmpty()) {
            return null;
        }
        if (methods.size() == 1) {
            return methods.get(0);
        }
        if ((methods = methods.stream().filter(ModifierSupport::isPublic).collect(Collectors.toList())).size() == 1) {
            return methods.get(0);
        }
        return null;
    }
}

