/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter;

import bluej.extensions2.BPackage;
import bluej.extensions2.BProject;
import bluej.extensions2.ExtensionException;
import bluej.extensions2.MenuGenerator;
import javafx.scene.control.MenuItem;
import org.bluej.extensions.submitter.Stat;

public class MenuBuilder
extends MenuGenerator {
    private Stat stat;
    private String aLabel;

    MenuBuilder(Stat i_stat) {
        this.stat = i_stat;
        this.aLabel = this.stat.bluej.getLabel("menu.submit");
    }

    public MenuItem getToolsMenuItem(BPackage aPackage) {
        if (aPackage == null) {
            return null;
        }
        MenuItem anItem = new MenuItem(this.aLabel);
        anItem.setDisable(!this.isMenuEnabled(aPackage));
        anItem.setOnAction(event -> {
            event.consume();
            try {
                BPackage bpkg = this.stat.bluej.getCurrentPackage();
                if (bpkg == null) {
                    return;
                }
                BProject bproj = bpkg.getProject();
                bproj.save();
                this.stat.submitDialog.submitThis(bproj.getDir(), bproj.getName());
            }
            catch (ExtensionException extensionException) {
                // empty catch block
            }
        });
        return anItem;
    }

    public void notifyPostToolsMenu(BPackage bp, MenuItem jmi) {
        jmi.setDisable(!this.isMenuEnabled(bp));
    }

    private boolean isMenuEnabled(BPackage aPackage) {
        if (aPackage == null) {
            return false;
        }
        try {
            BProject bproj = aPackage.getProject();
            return this.stat.schemeData.haveConfiguration(bproj.getDir());
        }
        catch (Exception exc) {
            return false;
        }
    }
}

