/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.bluej.extensions.submitter.AbortOperationException;
import org.bluej.extensions.submitter.FileHandler;
import org.bluej.extensions.submitter.ResultDialog;
import org.bluej.extensions.submitter.Stat;
import org.bluej.extensions.submitter.Submitter;
import org.bluej.extensions.submitter.UrlRewrite;
import org.bluej.extensions.submitter.properties.SchemeEntry;
import org.bluej.extensions.submitter.transport.TransportReport;
import org.bluej.extensions.submitter.transport.TransportSession;
import org.bluej.utility.FXCustomizedDialog;
import org.bluej.utility.Utility;
import threadchecker.OnThread;
import threadchecker.Tag;

public class SubmitDialog
extends FXCustomizedDialog {
    private static final String SELECTED_NODE_PROPERTY = "selectedNode";
    private static final String PROPERTIES_FILENAME = "submitter.properties";
    private final Stat stat;
    private ComboBox<SchemeEntry> schemeComboBox;
    private TextArea statusArea;
    private TextArea logArea;
    private ButtonType submitButton;
    private ButtonType cancelButton;
    private ProgressBar progressBar;
    private ResultDialog resultDialog;
    private @OnThread(value=Tag.Any) File curProjectRootDir;
    private @OnThread(value=Tag.Any) String curProjectName;
    private Thread backgroundThread;
    private boolean isDlgAlreadyShown = false;

    public SubmitDialog(Stat i_stat, Window parent) {
        super(parent, "Submitter", "");
        this.initModality(Modality.NONE);
        this.stat = i_stat;
        VBox aPanel = new VBox();
        aPanel.getStylesheets().add((Object)Submitter.getCSSStyleFilePath());
        aPanel.getChildren().add((Object)this.getWorkPanel());
        aPanel.getChildren().add((Object)this.getLoggingPanel());
        this.getDialogPane().setContent((Node)aPanel);
        aPanel.setFillWidth(true);
        this.getDialogPane().getScene().getWindow().setOnCloseRequest(evt -> this.checkCancelSubmit(evt));
        this.resultDialog = new ResultDialog(this.stat, this.asWindow());
    }

    public void submitThis(File pRootDir, String pName) {
        if (this.backgroundThread != null && this.backgroundThread.isAlive()) {
            this.statusWriteln("ERROR: Background task still running");
            return;
        }
        this.curProjectRootDir = pRootDir;
        this.curProjectName = pName;
        this.statusArea.setText("");
        this.logArea.setText("");
        this.resultDialog.showResult("");
        this.backgroundThread = new ComboLoadThread();
        this.backgroundThread.start();
        if (!this.isDlgAlreadyShown) {
            this.isDlgAlreadyShown = true;
            this.showAndWait();
        }
    }

    public void statusWriteln(String aMessage) {
        this.statusArea.setText(this.statusArea.getText() + aMessage + "\n");
        this.statusArea.selectPositionCaret(this.statusArea.getText().length());
    }

    public void logWriteln(String aMessage) {
        this.logArea.setText(this.statusArea.getText() + aMessage + "\n");
        this.logArea.selectPositionCaret(this.statusArea.getText().length());
    }

    public void schemeSelectedSet(String curScheme) {
        if (!this.stat.schemeData.selectEntryFromScheme(curScheme)) {
            curScheme = "";
        }
        this.stat.globalProp.setProperty("title", curScheme);
        this.checkSubmitButton();
    }

    public String schemeSelectedGet() {
        if (this.schemeComboBox.getSelectionModel().getSelectedItem() != null) {
            return ((SchemeEntry)this.schemeComboBox.getSelectionModel().getSelectedItem()).getTitle();
        }
        return "";
    }

    private VBox getWorkPanel() {
        VBox aPanel = new VBox();
        Utility.applyStyle((Node)aPanel, "submit-work-panel-dlg");
        this.progressBar = new ProgressBar();
        this.progressBar.setVisible(false);
        this.progressBar.prefWidthProperty().bind((ObservableValue)aPanel.widthProperty());
        Utility.applyStyle((Node)this.progressBar, "submit-dlg-progressbar");
        aPanel.getChildren().add((Object)this.getSubmitPanel());
        aPanel.getChildren().add((Object)this.progressBar);
        this.addButtons();
        return aPanel;
    }

    private HBox getSubmitPanel() {
        HBox submitBox = new HBox();
        submitBox.setAlignment(Pos.BASELINE_LEFT);
        Utility.applyStyle((Node)submitBox, "submitter-hbox");
        Label schemeLabel = new Label(this.stat.bluej.getLabel("dialog.scheme"));
        submitBox.getChildren().add((Object)schemeLabel);
        this.schemeComboBox = this.stat.schemeData.getComboBox();
        this.schemeComboBox.editableProperty().set(false);
        this.schemeComboBox.setOnAction(e -> this.checkSubmitButton());
        submitBox.getChildren().add(this.schemeComboBox);
        return submitBox;
    }

    private TabPane getLoggingPanel() {
        this.statusArea = new TextArea();
        this.statusArea.setWrapText(true);
        this.statusArea.setEditable(false);
        ScrollPane statusPane = new ScrollPane((Node)this.statusArea);
        statusPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.logArea = new TextArea();
        this.logArea.setEditable(false);
        this.logArea.setWrapText(true);
        ScrollPane logPane = new ScrollPane((Node)this.logArea);
        logPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        TabPane tabbed = new TabPane();
        tabbed.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        tabbed.getTabs().add((Object)new Tab("Status", (Node)statusPane));
        tabbed.getTabs().add((Object)new Tab("Log", (Node)logPane));
        return tabbed;
    }

    private void addButtons() {
        this.submitButton = new ButtonType(this.stat.bluej.getLabel("button.submit"), ButtonBar.ButtonData.OK_DONE);
        this.getDialogPane().getButtonTypes().add((Object)this.submitButton);
        ((Button)this.getDialogPane().lookupButton(this.submitButton)).addEventFilter(ActionEvent.ACTION, event -> {
            if (this.backgroundThread != null && this.backgroundThread.isAlive()) {
                this.statusWriteln("ERROR: Background task still running");
            } else {
                this.backgroundThread = new SubmitThread(this.schemeSelectedGet());
                this.backgroundThread.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                this.backgroundThread.start();
            }
            event.consume();
        });
        this.cancelButton = new ButtonType(this.stat.bluej.getLabel("cancel"), ButtonBar.ButtonData.CANCEL_CLOSE);
        this.getDialogPane().getButtonTypes().add((Object)this.cancelButton);
        ((Button)this.getDialogPane().lookupButton(this.cancelButton)).addEventFilter(ActionEvent.ACTION, evt -> this.checkCancelSubmit(evt));
    }

    private void checkCancelSubmit(Event evt) {
        if (this.backgroundThread != null && this.backgroundThread.isAlive()) {
            try {
                this.backgroundThread.interrupt();
                this.statusWriteln("INFO: Attempt to cancel submit");
                evt.consume();
            }
            catch (Exception ex) {
                this.logWriteln("interruptedThread Exception=" + ex.toString());
                ex.printStackTrace();
                this.statusWriteln(this.translateException(ex));
            }
        } else {
            this.isDlgAlreadyShown = false;
        }
    }

    @OnThread(value=Tag.Worker)
    private String sendFiles(UrlRewrite urlProps) {
        TransportSession ts = null;
        File[] files = new File[]{};
        try {
            CompletableFuture fhFuture = new CompletableFuture();
            Platform.runLater(() -> fhFuture.complete(new FileHandler(this.stat.bluej, this.curProjectRootDir, this.stat.schemeData)));
            FileHandler fh = (FileHandler)fhFuture.get();
            files = fh.getFiles();
            if (files == null) {
                Platform.runLater(() -> this.statusWriteln("sendFiles: NOTICE: no files to send"));
                return null;
            }
            CompletableFuture jarNamesFuture = new CompletableFuture();
            Platform.runLater(() -> jarNamesFuture.complete(this.stat.schemeData.getProps(".file.jar")));
            Collection jarNames = (Collection)jarNamesFuture.get();
            String jarName = null;
            if (jarNames.isEmpty()) {
                ts = TransportSession.createTransportSession(urlProps.getURL(), this.stat.globalProp, this.stat);
            } else {
                jarName = (String)jarNames.iterator().next();
                ts = TransportSession.createJarTransportSession(urlProps.getURL(), this.stat.globalProp, jarName, this.stat);
            }
            ts.setTransportReport(new transportReport());
            ts.connect();
            String projNamePrefix = null;
            String tsProtocol = ts.getProtocol();
            if (tsProtocol.equals("ftp") || tsProtocol.equals("file") || jarName != null) {
                projNamePrefix = this.curProjectName;
            }
            for (int index = 0; index < files.length; ++index) {
                boolean binary = FileHandler.isBinary(files[index]);
                FileInputStream fis = new FileInputStream(files[index]);
                Object name = fh.getSubName(files[index]);
                if (projNamePrefix != null) {
                    name = projNamePrefix + File.separator + (String)name;
                }
                Object nameFinal = name = ((String)name).replace(File.separatorChar, '/');
                Platform.runLater(() -> this.lambda$sendFiles$7((String)nameFinal));
                ts.send(fis, (String)name, binary);
                Utility.inputStreamClose(fis);
            }
            ts.disconnect();
        }
        catch (Exception ex) {
            Platform.runLater(() -> {
                this.logWriteln("sendFiles Exception=" + ex.toString());
                ex.printStackTrace();
                this.statusWriteln(this.translateException(ex));
            });
            return null;
        }
        int filesLength = files.length;
        Platform.runLater(() -> this.statusWriteln(filesLength + " " + this.stat.bluej.getLabel("message.filessent")));
        return ts.getResult();
    }

    @OnThread(value=Tag.FXPlatform)
    private String translateException(Throwable ex) {
        if (ex instanceof AbortOperationException) {
            return ((AbortOperationException)ex).getMessage(this.stat.bluej);
        }
        if (ex instanceof UnknownHostException) {
            return this.getLabelInsert("exception.unknownhost", ex.getMessage());
        }
        if (ex instanceof NoRouteToHostException) {
            return this.stat.bluej.getLabel("exception.notroutetohost");
        }
        if (ex instanceof ProtocolException) {
            return ex.getMessage();
        }
        if (ex instanceof FileNotFoundException) {
            return this.getLabelInsert("exception.filenotfound", ex.getMessage());
        }
        if (ex instanceof IllegalArgumentException && ex.getMessage().equals("SMTP Host has not been set")) {
            return this.stat.bluej.getLabel("exception.hostnotset");
        }
        if (ex instanceof IllegalArgumentException && ex.getMessage().equals("User Email address invalid")) {
            return this.stat.bluej.getLabel("exception.addrnotset");
        }
        return ex.getMessage();
    }

    @OnThread(value=Tag.FXPlatform)
    public String getLabelInsert(String id, String replacement) {
        Object label = this.stat.bluej.getLabel(id);
        int p = ((String)label).indexOf(36);
        if (p == -1) {
            label = (String)label + " $";
            p = ((String)label).indexOf(36);
        }
        label = ((String)label).substring(0, p) + replacement + ((String)label).substring(p + 1);
        return label;
    }

    @OnThread(value=Tag.Worker)
    private String sendMessage(UrlRewrite urlProps) {
        try {
            TransportSession ts = TransportSession.createTransportSession(urlProps.getURL(), this.stat.globalProp, this.stat);
            ts.connect();
            ts.disconnect();
            return ts.getResult();
        }
        catch (Exception exc) {
            Platform.runLater(() -> this.statusWriteln("sendMessage: Exception=" + exc.toString()));
            return null;
        }
    }

    @OnThread(value=Tag.Worker)
    private void submitWork() {
        String result = null;
        UrlRewrite urlProps = new UrlRewrite(this.stat);
        CompletableFuture guiResult = new CompletableFuture();
        Platform.runLater(() -> {
            try {
                guiResult.complete(urlProps.process(this));
            }
            catch (UnsupportedEncodingException e) {
                this.statusWriteln("Unsupported encoding scheme exception = " + e.toString());
                guiResult.complete(false);
            }
        });
        try {
            if (!((Boolean)guiResult.get()).booleanValue()) {
                return;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            Platform.runLater(() -> this.statusWriteln("Internal error: " + e.toString()));
        }
        result = urlProps.isMessage() ? this.sendMessage(urlProps) : this.sendFiles(urlProps);
        String resultFinal = result;
        Platform.runLater(() -> this.resultDialog.showResult(resultFinal));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Worker)
    private void loadDefaultScheme() {
        Platform.runLater(() -> this.schemeSelectedSet(""));
        File projectDefsFile = new File(this.curProjectRootDir, PROPERTIES_FILENAME);
        if (!projectDefsFile.canRead()) {
            return;
        }
        Properties projProps = new Properties();
        FileInputStream iStream = null;
        try {
            iStream = new FileInputStream(projectDefsFile);
            projProps.load(iStream);
        }
        catch (Exception exc) {
            try {
                Platform.runLater(() -> this.statusWriteln("loadDefaultScheme: No defaultScheme on project " + projectDefsFile));
            }
            catch (Throwable throwable) {
                Utility.inputStreamClose(iStream);
                throw throwable;
            }
            Utility.inputStreamClose(iStream);
            return;
        }
        Utility.inputStreamClose(iStream);
        String defaultNodeStr = projProps.getProperty(SELECTED_NODE_PROPERTY, "");
        Platform.runLater(() -> this.schemeSelectedSet(defaultNodeStr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Worker)
    private void saveDefaultScheme(String curScheme) {
        Platform.runLater(() -> {
            if (this.schemeComboBox.getSelectionModel().getSelectedItem() == null) {
                return;
            }
        });
        Properties projProps = new Properties();
        projProps.setProperty(SELECTED_NODE_PROPERTY, curScheme);
        File projectDefsFile = new File(this.curProjectRootDir, PROPERTIES_FILENAME);
        FileOutputStream oStream = null;
        try {
            oStream = new FileOutputStream(projectDefsFile);
            projProps.store(oStream, "Submitter per project properties");
        }
        catch (Exception exc) {
            try {
                Platform.runLater(() -> this.logWriteln("setDefaultScheme: Cannot write properties to file=" + projectDefsFile.toString()));
            }
            catch (Throwable throwable) {
                Utility.outputStreamClose(oStream);
                throw throwable;
            }
            Utility.outputStreamClose(oStream);
            return;
        }
        Utility.outputStreamClose(oStream);
    }

    private void checkSubmitButton() {
        boolean isComboValueEmpty = this.schemeComboBox.getSelectionModel().isEmpty();
        if (!isComboValueEmpty) {
            this.stat.globalProp.setProperty("simpletitle", ((SchemeEntry)this.schemeComboBox.getSelectionModel().getSelectedItem()).getSimpleTitle());
        }
        this.getDialogPane().lookupButton(this.submitButton).setDisable(isComboValueEmpty);
    }

    private /* synthetic */ void lambda$sendFiles$7(String nameFinal) {
        this.statusWriteln(this.stat.bluej.getLabel("message.sending") + " " + nameFinal);
    }

    @OnThread(value=Tag.Any, ignoreParent=true)
    class SubmitThread
    extends Thread {
        private final String selectedScheme;

        public SubmitThread(String selectedScheme) {
            this.selectedScheme = selectedScheme;
        }

        @Override
        @OnThread(value=Tag.Worker, ignoreParent=true)
        public void run() {
            Platform.runLater(() -> {
                SubmitDialog.this.progressBar.setVisible(true);
                SubmitDialog.this.progressBar.setProgress(-1.0);
            });
            SubmitDialog.this.saveDefaultScheme(this.selectedScheme);
            SubmitDialog.this.submitWork();
            Platform.runLater(() -> {
                SubmitDialog.this.progressBar.setVisible(false);
                SubmitDialog.this.progressBar.setProgress(1.0);
            });
        }
    }

    @OnThread(value=Tag.Any, ignoreParent=true)
    class ComboLoadThread
    extends Thread {
        ComboLoadThread() {
        }

        @Override
        @OnThread(value=Tag.Worker, ignoreParent=true)
        public void run() {
            Platform.runLater(() -> {
                SubmitDialog.this.progressBar.setVisible(true);
                SubmitDialog.this.progressBar.setProgress(-1.0);
            });
            SubmitDialog.this.stat.schemeData.loadComboBox(SubmitDialog.this.curProjectRootDir);
            SubmitDialog.this.loadDefaultScheme();
            Platform.runLater(() -> {
                SubmitDialog.this.statusWriteln("Loading Done");
                SubmitDialog.this.progressBar.setVisible(false);
                SubmitDialog.this.progressBar.setProgress(1.0);
            });
        }
    }

    @OnThread(value=Tag.Any)
    class transportReport
    implements TransportReport {
        transportReport() {
        }

        @Override
        @OnThread(value=Tag.Any)
        public void reportEvent(String message) {
            Platform.runLater(() -> SubmitDialog.this.statusWriteln(message));
        }

        @Override
        @OnThread(value=Tag.Any)
        public void reportLog(String message) {
            Platform.runLater(() -> SubmitDialog.this.logWriteln(message));
        }
    }
}

