/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.properties;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import org.bluej.extensions.submitter.Stat;
import org.bluej.extensions.submitter.properties.CompilationException;
import org.bluej.extensions.submitter.properties.SchemeEntry;
import org.bluej.extensions.submitter.properties.Tokenizer;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ConfParser {
    private Tokenizer token;
    private @OnThread(value=Tag.FXPlatform) Stat stat;
    private static List<SchemeEntry> schemeParents = new ArrayList<SchemeEntry>();
    private static int currentParentIndex = -1;

    public ConfParser(Stat i_stat) {
        this.stat = i_stat;
    }

    public void parse(InputStream is) throws CompilationException {
        Platform.runLater(() -> this.stat.aDbg.debug(4, "Parser.parse"));
        this.token = new Tokenizer(new InputStreamReader(is));
        if (this.parseStatements() != Tokenizer.Type.END) {
            throw new CompilationException("} without {", this.token);
        }
    }

    private Tokenizer.Type parseStatements() throws CompilationException {
        Tokenizer.Type type;
        boolean isWaitingFirstTransport = true;
        while ((type = this.token.next()) != Tokenizer.Type.END) {
            SchemeEntry newEntry;
            if (type == Tokenizer.Type.BLOCK_END) {
                SchemeEntry leafEntry = schemeParents.get(currentParentIndex);
                if (!leafEntry.getIsHidden()) {
                    Platform.runLater(() -> this.stat.schemeData.getComboBox().getItems().add((Object)leafEntry));
                }
                schemeParents.remove(currentParentIndex);
                --currentParentIndex;
                break;
            }
            if (type == Tokenizer.Type.BLOCK_START) {
                CompletableFuture futureEntry = new CompletableFuture();
                String tokenTitle = this.token.getTitle();
                Platform.runLater(() -> {
                    this.stat.aDbg.debug(4, "parseStatements: new Node, title=" + tokenTitle);
                    futureEntry.complete(new SchemeEntry(this.stat, tokenTitle));
                });
                try {
                    newEntry = (SchemeEntry)futureEntry.get();
                    if (this.getEntryHiddenStatus(this.token.getTitle())) {
                        newEntry.setIsHidden();
                    }
                    if (currentParentIndex > -1) {
                        schemeParents.get(currentParentIndex).copyConfigurationsTo(newEntry);
                        newEntry.setTitle(schemeParents.get(currentParentIndex) + "/" + newEntry.getTitle());
                    }
                    schemeParents.add(newEntry);
                    ++currentParentIndex;
                    type = this.parseStatements();
                    if (type == Tokenizer.Type.BLOCK_END) continue;
                    throw new CompilationException("} expected", this.token);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            if (type == Tokenizer.Type.EMPTY_SCHEME) {
                String tokenTitle = this.token.getTitle();
                CompletableFuture futureEntry = new CompletableFuture();
                Platform.runLater(() -> futureEntry.complete(new SchemeEntry(this.stat, tokenTitle)));
                try {
                    newEntry = (SchemeEntry)futureEntry.get();
                    if (currentParentIndex > -1) {
                        schemeParents.get(currentParentIndex).copyConfigurationsTo(newEntry);
                        newEntry.setTitle(schemeParents.get(currentParentIndex) + "/" + newEntry.getTitle());
                    }
                    if (this.getEntryHiddenStatus(this.token.getTitle())) continue;
                    Platform.runLater(() -> this.stat.schemeData.getComboBox().getItems().add((Object)newEntry));
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            if (type == Tokenizer.Type.CONFIG) {
                try {
                    schemeParents.get(currentParentIndex).addConfig(this.token.getKey(), this.token.getValue(), isWaitingFirstTransport);
                    if (!this.token.getKey().equals(".transport") || !isWaitingFirstTransport) continue;
                    isWaitingFirstTransport = false;
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                    throw new CompilationException(ex.getMessage(), this.token);
                }
            }
            throw new CompilationException("Syntax error", this.token);
        }
        return type;
    }

    private boolean getEntryHiddenStatus(String nodeTitle) {
        if (nodeTitle.startsWith("#")) {
            return true;
        }
        return currentParentIndex > 0 && schemeParents.get(currentParentIndex).getIsHidden();
    }
}

