/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import javafx.application.Platform;
import javafx.scene.control.ComboBox;
import org.bluej.extensions.submitter.Stat;
import org.bluej.extensions.submitter.properties.CompilationException;
import org.bluej.extensions.submitter.properties.ConfParser;
import org.bluej.extensions.submitter.properties.SchemeEntry;
import org.bluej.utility.Utility;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any, ignoreParent=true)
public class SchemeData {
    private static final String CONFIG_FILENAME = "submission.defs";
    private Stat stat;
    private @OnThread(value=Tag.FXPlatform) ComboBox<SchemeEntry> combo;
    private File systemLibDir;
    private File userConfigDir;

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public @OnThread(value=Tag.FXPlatform, ignoreParent=true) SchemeData(Stat i_stat) {
        this.stat = i_stat;
        this.stat.aDbg.trace(1, "new SchemeData: CALLED");
        this.combo = new ComboBox();
        this.systemLibDir = this.stat.bluej.getSystemLibDir();
        this.userConfigDir = this.stat.bluej.getUserConfigDir();
    }

    public boolean haveConfiguration(File projectRoot) {
        File systemConfFile = new File(this.systemLibDir, CONFIG_FILENAME);
        if (systemConfFile.canRead()) {
            return true;
        }
        File userConfFile = new File(this.userConfigDir, CONFIG_FILENAME);
        if (userConfFile.canRead()) {
            return true;
        }
        File projectConfFile = new File(projectRoot, CONFIG_FILENAME);
        return projectConfFile.canRead();
    }

    public void loadComboBox(File projectRoot) {
        Platform.runLater(() -> {
            this.stat.aDbg.trace(1, "SubmitTree.loadTree: CALLED");
            this.combo.getItems().clear();
        });
        File systemConfFile = new File(this.systemLibDir, CONFIG_FILENAME);
        this.loadFile(systemConfFile);
        File userConfFile = new File(this.userConfigDir, CONFIG_FILENAME);
        this.loadFile(userConfFile);
        File projectConfFile = new File(projectRoot, CONFIG_FILENAME);
        this.loadFile(projectConfFile);
    }

    private void loadFile(File fromFile) {
        if (fromFile == null) {
            return;
        }
        try {
            FileInputStream risul = new FileInputStream(fromFile);
            if (risul == null) {
                return;
            }
            this.loadOneStream(risul, fromFile.toString());
        }
        catch (Exception exc) {
            Platform.runLater(() -> this.stat.submitDialog.logWriteln("Opening " + exc.getMessage()));
        }
    }

    void loadUrl(String fromUrl) {
        if (fromUrl == null) {
            return;
        }
        try {
            URL url = new URL(fromUrl);
            InputStream risul = url.openStream();
            if (risul == null) {
                return;
            }
            this.loadOneStream(risul, fromUrl);
        }
        catch (Exception exc) {
            Platform.runLater(() -> this.stat.submitDialog.logWriteln("Opening " + exc.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOneStream(InputStream fromStream, String streamName) {
        this.stat.aDbg.trace(1, "SubmissionProperties.loadOneStream CALLED");
        try {
            Platform.runLater(() -> this.stat.submitDialog.statusWriteln("Loading " + streamName));
            ConfParser aParser = new ConfParser(this.stat);
            aParser.parse(fromStream);
        }
        catch (CompilationException cex) {
            cex.addFilename(streamName);
            Platform.runLater(() -> this.stat.submitDialog.logWriteln(cex.toString()));
        }
        finally {
            Utility.inputStreamClose(fromStream);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public ComboBox<SchemeEntry> getComboBox() {
        return this.combo;
    }

    @OnThread(value=Tag.FXPlatform)
    public Collection<String> getProps(String item) {
        SchemeEntry selectedItem = (SchemeEntry)this.combo.getSelectionModel().getSelectedItem();
        if (selectedItem == null) {
            return null;
        }
        return selectedItem.getConfig(item);
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean selectEntryFromScheme(String curScheme) {
        if (curScheme.length() == 0) {
            return true;
        }
        for (SchemeEntry schemeEntry : this.combo.getItems()) {
            if (!schemeEntry.getTitle().equals(curScheme)) continue;
            this.combo.getSelectionModel().select((Object)schemeEntry);
            return true;
        }
        return false;
    }
}

