/*
 * Decompiled with CFR 0.152.
 */
package bluej.collect;

import bluej.collect.DataCollector;
import bluej.collect.DiagnosticWithShown;
import bluej.compiler.CompileInputFile;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.compiler.Diagnostic;
import bluej.compiler.FXCompileObserver;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DataCollectionCompileObserverWrapper
implements FXCompileObserver {
    private FXCompileObserver wrapped;
    private List<DiagnosticWithShown> diagnostics = new ArrayList<DiagnosticWithShown>();
    private CompileInputFile[] sources;
    private CompileReason reason;
    private Project project;

    public DataCollectionCompileObserverWrapper(Project project, FXCompileObserver wrapped) {
        this.project = project;
        this.wrapped = wrapped;
    }

    @Override
    public void startCompile(CompileInputFile[] sources, CompileReason reason, CompileType type, int compilationSequence) {
        this.diagnostics.clear();
        this.sources = sources;
        this.reason = reason;
        this.wrapped.startCompile(sources, reason, type, compilationSequence);
    }

    @Override
    public boolean compilerMessage(Diagnostic diagnostic, CompileType type) {
        boolean shownToUser = this.wrapped.compilerMessage(diagnostic, type);
        if (diagnostic.getFileName() != null) {
            File userFile = new File(diagnostic.getFileName());
            for (CompileInputFile input : this.sources) {
                if (!input.getJavaCompileInputFile().getName().equals(userFile.getName())) continue;
                userFile = input.getUserSourceFile();
                break;
            }
            this.diagnostics.add(new DiagnosticWithShown(diagnostic, shownToUser, userFile));
        }
        return shownToUser;
    }

    @Override
    public void endCompile(CompileInputFile[] sources, boolean successful, CompileType type, int compilationSequence) {
        HashSet<String> packages = new HashSet<String>();
        for (CompileInputFile f : sources) {
            packages.add(this.project.getPackageForFile(f.getJavaCompileInputFile()));
        }
        Package pkg = packages.size() == 1 ? this.project.getPackage((String)packages.iterator().next()) : null;
        DataCollector.compiled(this.project, pkg, sources, this.diagnostics, successful, this.reason, compilationSequence);
        this.wrapped.endCompile(sources, successful, type, compilationSequence);
    }
}

