/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenTypeCapture;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.IntersectionType;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.NameTransform;
import java.util.ArrayList;
import java.util.Map;
import threadchecker.OnThread;
import threadchecker.Tag;

public class GenTypeWildcard
extends GenTypeParameter {
    GenTypeSolid upperBound;
    GenTypeSolid lowerBound;

    public GenTypeWildcard(GenTypeSolid upper, GenTypeSolid lower) {
        this.upperBound = upper;
        this.lowerBound = lower;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(NameTransform nt) {
        String uboundStr;
        if (this.lowerBound != null) {
            return "? super " + this.lowerBound.toString(nt);
        }
        if (this.upperBound != null && !(uboundStr = this.upperBound.toString()).equals("java.lang.Object")) {
            return "? extends " + this.upperBound.toString(nt);
        }
        return "?";
    }

    @Override
    public String toTypeArgString(NameTransform nt) {
        return this.toString(nt);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public GenTypeWildcard mapTparsToTypes(Map<String, ? extends GenTypeParameter> tparams) {
        GenTypeSolid newUpper = null;
        GenTypeSolid newLower = null;
        if (this.upperBound != null) {
            ArrayList<GenTypeSolid> newUppers = new ArrayList<GenTypeSolid>();
            GenTypeSolid[] upperBounds = this.upperBound.getUpperBounds();
            for (int i = 0; i < upperBounds.length; ++i) {
                GenTypeParameter newBound = upperBounds[i].mapTparsToTypes(tparams);
                if (newBound instanceof GenTypeWildcard) {
                    GenTypeWildcard newWcBound = (GenTypeWildcard)newBound;
                    newUppers.add(newWcBound.upperBound);
                    continue;
                }
                newUppers.add((GenTypeSolid)newBound);
            }
            GenTypeSolid[] newUppersA = newUppers.toArray(new GenTypeSolid[newUppers.size()]);
            newUpper = IntersectionType.getIntersection(newUppersA);
        }
        if (this.lowerBound != null) {
            GenTypeParameter newLowerP = this.lowerBound.mapTparsToTypes(tparams);
            newLower = newLowerP.getLowerBound();
        }
        return new GenTypeWildcard(newUpper, newLower);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean equals(GenTypeParameter other) {
        if (this == other) {
            return true;
        }
        if (!other.isWildcard()) {
            return false;
        }
        GenTypeSolid otherLower = other.getLowerBound();
        JavaType otherUpper = other.getUpperBound();
        if (this.upperBound != null && !this.upperBound.equals(otherUpper)) {
            return false;
        }
        if (this.upperBound == null && otherUpper != null) {
            return false;
        }
        if (this.lowerBound != null && !this.lowerBound.equals(otherLower)) {
            return false;
        }
        return this.lowerBound != null || otherLower == null;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public JavaType getErasedType() {
        return this.upperBound.getErasedType();
    }

    @Override
    public boolean isWildcard() {
        return true;
    }

    @Override
    public GenTypeSolid getUpperBound() {
        return this.upperBound;
    }

    @Override
    public GenTypeSolid getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public JavaType getTparCapture() {
        return new GenTypeCapture(this);
    }
}

