/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.codepad;

import bluej.BlueJEvent;
import bluej.Config;
import bluej.collect.DataCollector;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.gentype.JavaType;
import bluej.debugmgr.ExecutionEvent;
import bluej.debugmgr.IndexHistory;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.ValueCollection;
import bluej.debugmgr.codepad.DeclaredVar;
import bluej.parser.TextAnalyzer;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.Utility;
import bluej.utility.javafx.AbstractOperation;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class CodePad
extends VBox
implements ValueCollection {
    private final ListView<HistoryRow> historyView;
    private final TextField inputField;
    private final Pane arrowOverlay;
    private BooleanBinding shadowShowing;
    private ObjectBinding shadowShowBinding;
    private ContextMenu contextMenu;
    private static final String[] allRowStyles = new String[RowStyle.values().length];
    private static final String nullLabel = "null";
    private static final String uninitializedWarning;
    private static final Image objectImage;
    private static final Image objectImageHighlight;
    private final PkgMgrFrame frame;
    private @OnThread(value=Tag.FX) String currentCommand = "";
    private @OnThread(value=Tag.FX) IndexHistory history;
    private Invoker invoker = null;
    private TextAnalyzer textParser = null;
    private boolean firstTry;
    private boolean wrappedResult;
    private String errorMessage;
    private boolean busy = false;
    private List<CodepadVar> localVars = new ArrayList<CodepadVar>();
    private List<CodepadVar> newlyDeclareds;
    private List<String> autoInitializedVars;
    private Runnable removeHover;

    public CodePad(PkgMgrFrame frame, Pane arrowOverlay) {
        this.frame = frame;
        this.arrowOverlay = arrowOverlay;
        JavaFXUtil.addStyleClass((Styleable)this, "codepad");
        this.setMinWidth(100.0);
        this.inputField = new TextField();
        JavaFXUtil.addStyleClass((Styleable)this.inputField, "codepad-input");
        this.inputField.setFocusTraversable(true);
        this.inputField.setEditable(true);
        this.historyView = new ListView();
        this.historyView.setEditable(false);
        JavaFXUtil.addFocusListener(this.historyView, focused -> {
            if (focused.booleanValue() && this.historyView.getSelectionModel().isEmpty()) {
                this.historyView.getSelectionModel().selectLast();
            }
        });
        this.inputField.styleProperty().bind((ObservableValue)PrefMgr.getEditorFontCSS(false));
        this.historyView.styleProperty().bind((ObservableValue)PrefMgr.getEditorFontCSS(false));
        Nodes.addInputMap((Node)this.inputField, (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.EQUALS, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), e -> Utility.increaseFontSize(PrefMgr.getEditorFontSize())), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.MINUS, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), e -> Utility.decreaseFontSize(PrefMgr.getEditorFontSize()))}));
        this.historyView.getItems().addListener((ListChangeListener)new ListChangeListener<HistoryRow>(){

            @OnThread(value=Tag.FX)
            public void onChanged(ListChangeListener.Change<? extends HistoryRow> c) {
                ScrollBar scrollBar = (ScrollBar)CodePad.this.historyView.lookup(".scroll-bar");
                CodePad.this.shadowShowing = scrollBar.visibleProperty().and((ObservableBooleanValue)scrollBar.valueProperty().isNotEqualTo(1.0, 0.01));
                CodePad.this.shadowShowBinding = Bindings.when((ObservableBooleanValue)CodePad.this.shadowShowing).then((Object)new DropShadow(6.0, 0.0, -3.0, Color.GRAY)).otherwise((Object)null);
                CodePad.this.inputField.effectProperty().bind((ObservableValue)CodePad.this.shadowShowBinding);
                CodePad.this.historyView.getItems().removeListener((ListChangeListener)this);
            }
        });
        JavaFXUtil.addStyleClass(this.historyView, new String[]{"codepad-history"});
        this.getChildren().setAll((Object[])new Node[]{this.historyView, this.inputField});
        VBox.setVgrow(this.historyView, (Priority)Priority.ALWAYS);
        this.history = new IndexHistory(20);
        this.historyView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.historyView.setOnContextMenuRequested(e -> this.showContextMenu(e.getScreenX(), e.getScreenY()));
        this.historyView.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
            if (e.getButton() == MouseButton.PRIMARY && this.contextMenu != null) {
                this.contextMenu.hide();
                this.contextMenu = null;
            }
        });
        this.historyView.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.C && e.isShortcutDown()) {
                this.copySelectedRows();
                e.consume();
            } else if (e.getCode() == KeyCode.A && e.isShortcutDown()) {
                this.historyView.getSelectionModel().selectAll();
                e.consume();
            } else if (e.getCode() == KeyCode.ENTER || e.getCode() == KeyCode.SPACE) {
                Bounds screenBounds = this.historyView.localToScreen(this.historyView.getBoundsInLocal());
                this.showContextMenu(screenBounds.getCenterX(), screenBounds.getCenterY());
                e.consume();
            }
        });
        this.inputField.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.UP) {
                this.historyBack();
                e.consume();
            } else if (e.getCode() == KeyCode.DOWN) {
                this.historyForward();
                e.consume();
            } else if (e.getCode() == KeyCode.ENTER && e.isShiftDown()) {
                this.softReturn();
                e.consume();
            }
        });
        this.inputField.setOnAction(e -> {
            String line = this.inputField.getText();
            if (line.trim().isEmpty()) {
                return;
            }
            this.command(line, true);
            this.inputField.setEditable(false);
            this.inputField.setText("");
            this.currentCommand = (this.currentCommand + line).trim();
            if (this.currentCommand.length() != 0) {
                this.history.add(line);
                String cmd = this.currentCommand;
                this.currentCommand = "";
                this.executeCommand(cmd);
            }
        });
        this.historyView.setCellFactory(lv -> new ListCell<HistoryRow>(){
            {
                JavaFXUtil.addStyleClass((Styleable)this, "codepad-row");
            }

            @OnThread(value=Tag.FX)
            public void updateItem(HistoryRow item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty && item != null) {
                    this.setGraphic(item.getGraphic());
                    this.setText(item.getText());
                    JavaFXUtil.selectPseudoClass((Node)this, Arrays.asList(allRowStyles).indexOf(item.getStyle().getPseudoClass()), allRowStyles);
                } else {
                    this.setGraphic(null);
                    this.setText("");
                    JavaFXUtil.selectPseudoClass((Node)this, -1, allRowStyles);
                }
            }
        });
    }

    private void showContextMenu(double screenX, double screenY) {
        if (this.contextMenu != null) {
            this.contextMenu.hide();
        }
        this.contextMenu = AbstractOperation.getMenuItems(this.historyView.getSelectionModel().getSelectedItems(), true).makeContextMenu();
        this.contextMenu.show(this.historyView, screenX, screenY);
    }

    private void copySelectedRows() {
        if (this.historyView.getSelectionModel().isEmpty()) {
            this.historyView.getSelectionModel().selectAll();
        }
        String copied = this.historyView.getSelectionModel().getSelectedItems().stream().map(HistoryRow::getText).collect(Collectors.joining("\n"));
        Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, copied));
        this.historyView.getSelectionModel().clearSelection();
    }

    public void clearVars() {
        this.localVars.clear();
        if (this.textParser != null && this.frame.getProject() != null) {
            this.textParser.newClassLoader(this.frame.getProject().getClassLoader());
        }
    }

    public Iterator<CodepadVar> getValueIterator() {
        return this.localVars.iterator();
    }

    @Override
    public NamedValue getNamedValue(String name) {
        Class<Object> c = Object.class;
        NamedValue nv = this.getLocalVar(name);
        if (nv != null) {
            return nv;
        }
        return this.frame.getObjectBench().getNamedValue(name);
    }

    private NamedValue getLocalVar(String name) {
        for (NamedValue namedValue : this.localVars) {
            if (!namedValue.getName().equals(name)) continue;
            return namedValue;
        }
        return null;
    }

    private void removeNewlyDeclareds() {
        if (this.newlyDeclareds != null) {
            Iterator<CodepadVar> i = this.newlyDeclareds.iterator();
            while (i.hasNext()) {
                this.localVars.remove(i.next());
            }
            this.newlyDeclareds = null;
        }
    }

    private void showErrorMsg(String message) {
        this.error("Error: " + message);
        this.completeExecution();
    }

    private void showExceptionMsg(String message) {
        this.error("Exception: " + message);
        this.completeExecution();
    }

    private void completeExecution() {
        this.inputField.setEditable(true);
        this.busy = false;
    }

    private void command(String s, boolean isFinalLine) {
        this.addRow(new CommandRow(s, isFinalLine));
    }

    private void addRow(HistoryRow row) {
        this.historyView.getSelectionModel().clearSelection();
        this.historyView.getItems().add((Object)row);
        this.historyView.scrollTo(this.historyView.getItems().size() - 1);
    }

    private void output(String s) {
        this.addRow(new OutputSuccessRow(s, null));
    }

    private void objectOutput(String s, ObjectInfo objInfo) {
        this.addRow(new OutputSuccessRow(s, objInfo));
    }

    private void error(String s) {
        this.addRow(new ErrorRow(s));
    }

    public void clear() {
        this.clearVars();
    }

    public void clearHistoryView() {
        this.historyView.getItems().clear();
    }

    private void executeCommand(String command) {
        String retType;
        if (this.busy) {
            return;
        }
        this.firstTry = true;
        this.busy = true;
        if (this.textParser == null) {
            this.textParser = new TextAnalyzer(this.frame.getProject().getEntityResolver(), this.frame.getPackage().getQualifiedName(), this);
        }
        boolean bl = this.wrappedResult = (retType = this.textParser.parseCommand(command)) != null && retType.length() != 0;
        if (retType == null) {
            this.firstTry = false;
            command = this.textParser.getAmendedCommand();
            List<DeclaredVar> declaredVars = this.textParser.getDeclaredVars();
            if (declaredVars != null) {
                Iterator<DeclaredVar> i = declaredVars.iterator();
                while (i.hasNext()) {
                    if (this.newlyDeclareds == null) {
                        this.newlyDeclareds = new ArrayList<CodepadVar>();
                    }
                    if (this.autoInitializedVars == null) {
                        this.autoInitializedVars = new ArrayList<String>();
                    }
                    DeclaredVar dv = i.next();
                    String declaredName = dv.getName();
                    if (dv.getDeclaredType() == null) {
                        this.showErrorMsg("Could not determine variable type");
                        this.removeNewlyDeclareds();
                        return;
                    }
                    if (this.getLocalVar(declaredName) != null) {
                        String errMsg = Config.getString("pkgmgr.codepad.redefinedVar");
                        errMsg = Utility.mergeStrings(errMsg, declaredName);
                        this.showErrorMsg(errMsg);
                        this.removeNewlyDeclareds();
                        return;
                    }
                    CodepadVar cpv = new CodepadVar(dv.getName(), dv.getDeclaredType(), dv.isFinal());
                    this.newlyDeclareds.add(cpv);
                    this.localVars.add(cpv);
                    if (dv.isInitialized()) continue;
                    this.autoInitializedVars.add(dv.getName());
                }
            }
        }
        CodePadResultWatcher watcher = new CodePadResultWatcher(command);
        this.invoker = new Invoker(this.frame, this, command, watcher);
        this.invoker.setImports(this.textParser.getImportStatements());
        if (!this.invoker.doFreeFormInvocation(retType)) {
            this.firstTry = false;
            watcher.putError("Invocation failed.", null);
        }
    }

    private void softReturn() {
        String line = this.inputField.getText();
        if (line.trim().isEmpty()) {
            return;
        }
        this.currentCommand = this.currentCommand + line + " ";
        this.history.add(line);
        this.command(line, false);
        this.inputField.setText("");
    }

    private void historyBack() {
        String line = this.history.getPrevious();
        if (line != null) {
            this.setInput(line);
        }
    }

    private void setInput(String line) {
        this.inputField.setText(line);
        this.inputField.end();
    }

    private void historyForward() {
        String line = this.history.getNext();
        if (line != null) {
            this.setInput(line);
        }
    }

    public PkgMgrFrame.PkgMgrPane getHistoryPane() {
        return () -> this.historyView;
    }

    public PkgMgrFrame.PkgMgrPane getInputFieldPane() {
        return () -> this.inputField;
    }

    static {
        for (int i = 0; i < RowStyle.values().length; ++i) {
            CodePad.allRowStyles[i] = RowStyle.values()[i].getPseudoClass();
        }
        uninitializedWarning = Config.getString("pkgmgr.codepad.uninitialized");
        objectImage = Config.getImageAsFXImage("image.eval.object");
        objectImageHighlight = Config.getImageAsFXImage("image.eval.object");
    }

    @OnThread(value=Tag.FX)
    private class CommandRow
    extends HistoryRow {
        private final boolean isFinalLine;

        public CommandRow(String text, boolean isFinalLine) {
            super(text);
            this.isFinalLine = isFinalLine;
        }

        @Override
        public Node getGraphic() {
            return null;
        }

        @Override
        public RowStyle getStyle() {
            return this.isFinalLine ? RowStyle.COMMAND_END : RowStyle.COMMAND_PARTIAL;
        }
    }

    @OnThread(value=Tag.FX)
    private abstract class HistoryRow
    implements AbstractOperation.ContextualItem<HistoryRow> {
        private final String text;

        public HistoryRow(String text) {
            this.text = text;
        }

        public final String getText() {
            return this.text;
        }

        public String toString() {
            return this.getText();
        }

        public abstract Node getGraphic();

        public abstract RowStyle getStyle();

        @Override
        @OnThread(value=Tag.FXPlatform)
        public List<? extends AbstractOperation<HistoryRow>> getContextOperations() {
            return List.of(new CopyOperation(), new ClearOperation(), new SelectAllOperation());
        }
    }

    @OnThread(value=Tag.FX)
    private class OutputSuccessRow
    extends IndentedRow {
        private final ImageView graphic;
        private Path arrow;
        private FXPlatformRunnable cancelAddToBench;
        private final ObjectInfo objInfo;

        public OutputSuccessRow(String text, ObjectInfo objInfo) {
            super(text);
            this.objInfo = objInfo;
            if (objInfo != null) {
                this.graphic = new ImageView(objectImage);
                this.graphic.setMouseTransparent(false);
                JavaFXUtil.addChangeListener(this.graphic.mouseTransparentProperty(), b -> {
                    if (b.booleanValue()) {
                        this.graphic.setMouseTransparent(false);
                    }
                });
                this.graphic.setCursor(Cursor.HAND);
                this.graphic.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
                    if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() == 1) {
                        this.cancelAddToBench = JavaFXUtil.runAfter(Duration.millis((double)500.0), () -> JavaFXUtil.runAfterCurrent(() -> {
                            this.addResultToBench();
                            this.cancelAddToBench = null;
                        }));
                        e.consume();
                    } else if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() == 2) {
                        if (this.cancelAddToBench != null) {
                            this.cancelAddToBench.run();
                            this.cancelAddToBench = null;
                        }
                        this.inspectResult();
                        e.consume();
                    }
                });
                this.graphic.setOnMouseEntered(e -> {
                    this.graphic.setImage(objectImageHighlight);
                    this.graphic.setEffect((Effect)new ColorAdjust(0.0, -0.2, 0.45, 0.0));
                    if (this.arrow == null) {
                        this.arrow = new Path();
                        JavaFXUtil.addStyleClass((Styleable)this.arrow, "codepad-add-object-arrow");
                        double centreAngle = 35.0;
                        this.arrow.getElements().addAll((Object[])new PathElement[]{new MoveTo(40.0, 10.0), new QuadCurveTo(25.0, -10.0, 0.0, 10.0), new LineTo(0.0 + Math.cos(Math.toRadians(centreAngle + 45.0)) * 10.0, 10.0 - Math.sin(Math.toRadians(centreAngle + 45.0)) * 10.0), new MoveTo(0.0, 10.0), new LineTo(0.0 + Math.cos(Math.toRadians(centreAngle - 45.0)) * 10.0, 10.0 - Math.sin(Math.toRadians(centreAngle - 45.0)) * 10.0)});
                    }
                    Bounds b = CodePad.this.arrowOverlay.sceneToLocal(this.graphic.localToScene(this.graphic.getBoundsInLocal()));
                    this.arrow.setLayoutX(b.getMinX() - 40.0);
                    this.arrow.setLayoutY(b.getMinY() - 10.0 + b.getHeight() * 0.5);
                    CodePad.this.arrowOverlay.getChildren().add((Object)this.arrow);
                });
                this.graphic.setOnMouseExited(e -> {
                    this.graphic.setImage(objectImage);
                    this.graphic.setEffect(null);
                    CodePad.this.arrowOverlay.getChildren().remove((Object)this.arrow);
                });
            } else {
                this.graphic = null;
            }
        }

        @OnThread(value=Tag.FXPlatform)
        private void inspectResult() {
            Project project = CodePad.this.frame.getProject();
            if (project != null) {
                project.getInspectorInstance(this.objInfo.obj, "", CodePad.this.frame.getPackage(), this.objInfo.ir, (Window)CodePad.this.frame.getWindow(), (Node)this.graphic).bringToFront();
            }
        }

        @OnThread(value=Tag.FXPlatform)
        private void addResultToBench() {
            Stage fxWindow = CodePad.this.frame.getWindow();
            Point2D from = this.graphic.localToScene(new Point2D(0.0, 0.0));
            CodePad.this.frame.getPackage().getEditor().raisePutOnBenchEvent((Window)fxWindow, this.objInfo.obj, this.objInfo.obj.getGenType(), this.objInfo.ir, true, Optional.of(from));
        }

        @Override
        public Node getGraphic() {
            return this.graphic != null ? this.graphic : super.getGraphic();
        }

        @Override
        public RowStyle getStyle() {
            return RowStyle.OUTPUT;
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public List<? extends AbstractOperation<HistoryRow>> getContextOperations() {
            ArrayList<AbstractOperation> ops = new ArrayList<AbstractOperation>(super.getContextOperations());
            if (this.objInfo != null) {
                ops.add(new AbstractOperation<HistoryRow>("addtobench", AbstractOperation.Combine.ONE, null){

                    @Override
                    public void activate(List<HistoryRow> historyRows) {
                        for (HistoryRow historyRow : historyRows) {
                            if (!(historyRow instanceof OutputSuccessRow)) continue;
                            OutputSuccessRow o = (OutputSuccessRow)historyRow;
                            if (o.objInfo == null) continue;
                            o.addResultToBench();
                        }
                    }

                    @Override
                    public List<AbstractOperation.ItemLabel> getLabels() {
                        return List.of(new AbstractOperation.ItemLabel((ObservableValue<String>)new ReadOnlyStringWrapper(Config.getString("codepad.addToBench")), AbstractOperation.MenuItemOrder.CODEPAD_ADD_TO_BENCH));
                    }
                });
                ops.add(new AbstractOperation<HistoryRow>("inspect", AbstractOperation.Combine.ONE, null){

                    @Override
                    public void activate(List<HistoryRow> historyRows) {
                        for (HistoryRow historyRow : historyRows) {
                            if (!(historyRow instanceof OutputSuccessRow)) continue;
                            OutputSuccessRow o = (OutputSuccessRow)historyRow;
                            if (o.objInfo == null) continue;
                            o.inspectResult();
                        }
                    }

                    @Override
                    public List<AbstractOperation.ItemLabel> getLabels() {
                        return List.of(new AbstractOperation.ItemLabel((ObservableValue<String>)new ReadOnlyStringWrapper(Config.getString("codepad.inspect")), AbstractOperation.MenuItemOrder.CODEPAD_INSPECT));
                    }
                });
            }
            return ops;
        }
    }

    @OnThread(value=Tag.Any)
    final class ObjectInfo {
        DebuggerObject obj;
        InvokerRecord ir;

        public ObjectInfo(DebuggerObject obj, InvokerRecord ir) {
            this.obj = obj;
            this.ir = ir;
        }
    }

    @OnThread(value=Tag.FX)
    private class ErrorRow
    extends IndentedRow {
        public ErrorRow(String text) {
            super(text);
        }

        @Override
        public RowStyle getStyle() {
            return RowStyle.ERROR;
        }
    }

    final class CodepadVar
    implements NamedValue {
        String name;
        boolean finalVar;
        boolean initialized = false;
        JavaType type;

        public CodepadVar(String name, JavaType type, boolean finalVar) {
            this.name = name;
            this.finalVar = finalVar;
            this.type = type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public JavaType getGenType() {
            return this.type;
        }

        @Override
        public boolean isFinal() {
            return this.finalVar;
        }

        @Override
        public boolean isInitialized() {
            return this.initialized;
        }

        public void setInitialized() {
            this.initialized = true;
        }
    }

    private class CodePadResultWatcher
    implements ResultWatcher {
        private final String command;

        public CodePadResultWatcher(String command) {
            this.command = command;
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public void beginCompile() {
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public void beginExecution(InvokerRecord ir) {
            BlueJEvent.raiseEvent(3, ir);
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public void putResult(DebuggerObject result, String name, InvokerRecord ir) {
            boolean giveUninitializedWarning;
            CodePad.this.frame.getObjectBench().addInteraction(ir);
            this.updateInspectors();
            if (CodePad.this.newlyDeclareds != null) {
                for (CodepadVar cpv : CodePad.this.newlyDeclareds) {
                    cpv.setInitialized();
                }
                CodePad.this.newlyDeclareds = null;
            }
            boolean bl = giveUninitializedWarning = CodePad.this.autoInitializedVars != null && CodePad.this.autoInitializedVars.size() != 0;
            if (giveUninitializedWarning && Utility.firstTimeThisRun("TextEvalPane.uninitializedWarning")) {
                String warning = uninitializedWarning;
                int findex = 0;
                while (findex < warning.length()) {
                    int nindex = warning.indexOf(10, findex);
                    if (nindex == -1) {
                        nindex = warning.length();
                    }
                    String warnLine = warning.substring(findex, nindex);
                    CodePad.this.error(warnLine);
                    findex = nindex + 1;
                }
                CodePad.this.autoInitializedVars.clear();
            }
            if (!result.isNullObject()) {
                DebuggerField resultField = result.getField(0);
                String resultString = resultField.getValueString();
                if (resultString.equals(CodePad.nullLabel)) {
                    DataCollector.codePadSuccess(CodePad.this.frame.getPackage(), ir.getOriginalCommand(), resultString);
                    CodePad.this.output(resultString);
                } else {
                    boolean isObject = resultField.isReferenceType();
                    if (isObject) {
                        DebuggerObject resultObject = resultField.getValueObject(null);
                        String resultType = resultObject.getGenType().toString(true);
                        String resultOutputString = resultString + "   (" + resultType + ")";
                        DataCollector.codePadSuccess(CodePad.this.frame.getPackage(), ir.getOriginalCommand(), resultOutputString);
                        CodePad.this.objectOutput(resultOutputString, new ObjectInfo(resultObject, ir));
                    } else {
                        String resultType = resultField.getType().toString(true);
                        String resultOutputString = resultString + "   (" + resultType + ")";
                        DataCollector.codePadSuccess(CodePad.this.frame.getPackage(), ir.getOriginalCommand(), resultOutputString);
                        CodePad.this.output(resultOutputString);
                    }
                }
            }
            ExecutionEvent executionEvent = new ExecutionEvent(CodePad.this.frame.getPackage());
            executionEvent.setCommand(this.command);
            executionEvent.setResult("Normal exit");
            executionEvent.setResultObject(result);
            BlueJEvent.raiseEvent(5, executionEvent);
            CodePad.this.textParser.confirmCommand();
            CodePad.this.inputField.setEditable(true);
            CodePad.this.busy = false;
        }

        private void updateInspectors() {
            Project proj = CodePad.this.frame.getPackage().getProject();
            proj.updateInspectors();
        }

        @Override
        public void putError(String message, InvokerRecord ir) {
            if (CodePad.this.firstTry) {
                if (CodePad.this.wrappedResult) {
                    CodePad.this.wrappedResult = false;
                    CodePad.this.errorMessage = null;
                    CodePad.this.invoker = new Invoker(CodePad.this.frame, CodePad.this, this.command, this);
                    CodePad.this.invoker.setImports(CodePad.this.textParser.getImportStatements());
                    CodePad.this.invoker.doFreeFormInvocation("");
                } else {
                    CodePad.this.firstTry = false;
                    CodePad.this.invoker = new Invoker(CodePad.this.frame, CodePad.this, this.command, this);
                    CodePad.this.invoker.setImports(CodePad.this.textParser.getImportStatements());
                    CodePad.this.invoker.doFreeFormInvocation(null);
                    if (CodePad.this.errorMessage == null) {
                        CodePad.this.errorMessage = message;
                    }
                }
            } else {
                if (CodePad.this.errorMessage == null) {
                    CodePad.this.errorMessage = message;
                }
                if (CodePad.this.autoInitializedVars != null) {
                    CodePad.this.autoInitializedVars.clear();
                }
                CodePad.this.removeNewlyDeclareds();
                DataCollector.codePadError(CodePad.this.frame.getPackage(), ir.getOriginalCommand(), CodePad.this.errorMessage);
                CodePad.this.showErrorMsg(CodePad.this.errorMessage);
                CodePad.this.errorMessage = null;
            }
        }

        @Override
        public void putException(ExceptionDescription exception, InvokerRecord ir) {
            ExecutionEvent executionEvent = new ExecutionEvent(CodePad.this.frame.getPackage());
            executionEvent.setCommand(this.command);
            executionEvent.setResult("An exception occurred");
            executionEvent.setException(exception);
            BlueJEvent.raiseEvent(5, executionEvent);
            this.updateInspectors();
            if (CodePad.this.autoInitializedVars != null) {
                CodePad.this.autoInitializedVars.clear();
            }
            CodePad.this.removeNewlyDeclareds();
            String message = exception.getClassName() + " (" + exception.getText() + ")";
            DataCollector.codePadException(CodePad.this.frame.getPackage(), ir.getOriginalCommand(), message);
            CodePad.this.showExceptionMsg(message);
        }

        @Override
        public void putVMTerminated(InvokerRecord ir, boolean terminatedByUserCode) {
            if (CodePad.this.autoInitializedVars != null) {
                CodePad.this.autoInitializedVars.clear();
            }
            CodePad.this.removeNewlyDeclareds();
            String message = Config.getString("pkgmgr.codepad.vmTerminated");
            DataCollector.codePadError(CodePad.this.frame.getPackage(), ir.getOriginalCommand(), message);
            CodePad.this.error(message);
            CodePad.this.completeExecution();
        }
    }

    @OnThread(value=Tag.Any)
    public static enum RowStyle {
        COMMAND_PARTIAL("bj-codepad-cmd-partial"),
        COMMAND_END("bj-codepad-cmd-end"),
        ERROR("bj-codepad-error"),
        OUTPUT("bj-codepad-output");

        private final String pseudo;

        public String getPseudoClass() {
            return this.pseudo;
        }

        private RowStyle(String pseudo) {
            this.pseudo = pseudo;
        }
    }

    private class SelectAllOperation
    extends AbstractOperation<HistoryRow> {
        public SelectAllOperation() {
            super("selectAll", AbstractOperation.Combine.ANY, null);
        }

        @Override
        public void activate(List<HistoryRow> historyRows) {
            CodePad.this.historyView.getSelectionModel().selectAll();
        }

        @Override
        public List<AbstractOperation.ItemLabel> getLabels() {
            return List.of(new AbstractOperation.ItemLabel((ObservableValue<String>)new ReadOnlyStringWrapper(Config.getString("codepad.selectAll")), AbstractOperation.MenuItemOrder.CODEPAD_SELECT_ALL));
        }
    }

    private class ClearOperation
    extends AbstractOperation<HistoryRow> {
        public ClearOperation() {
            super("clear", AbstractOperation.Combine.ANY, null);
        }

        @Override
        public void activate(List<HistoryRow> historyRows) {
            CodePad.this.historyView.getSelectionModel().clearSelection();
            CodePad.this.historyView.getItems().clear();
        }

        @Override
        public List<AbstractOperation.ItemLabel> getLabels() {
            return List.of(new AbstractOperation.ItemLabel((ObservableValue<String>)new ReadOnlyStringWrapper(Config.getString("codepad.clear")), AbstractOperation.MenuItemOrder.CODEPAD_CLEAR));
        }
    }

    private static class CopyOperation
    extends AbstractOperation<HistoryRow> {
        public CopyOperation() {
            super("copy", AbstractOperation.Combine.ALL, null);
        }

        @Override
        public void activate(List<HistoryRow> historyRows) {
            String copied = historyRows.stream().map(HistoryRow::getText).collect(Collectors.joining("\n"));
            Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, copied));
        }

        @Override
        public List<AbstractOperation.ItemLabel> getLabels() {
            return List.of(new AbstractOperation.ItemLabel((ObservableValue<String>)new ReadOnlyStringWrapper(Config.getString("editor.copyLabel")), AbstractOperation.MenuItemOrder.CODEPAD_COPY));
        }
    }

    @OnThread(value=Tag.FX)
    public abstract class IndentedRow
    extends HistoryRow {
        protected Rectangle r;

        public IndentedRow(String text) {
            super(text);
            this.r = new Rectangle(objectImage.getWidth(), objectImage.getHeight());
            this.r.setVisible(false);
        }

        @Override
        public Node getGraphic() {
            return this.r;
        }
    }
}

