/*
 * Decompiled with CFR 0.152.
 */
package bluej.graph;

import bluej.graph.SelectionSet;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.target.Target;
import java.util.ArrayList;
import javafx.scene.shape.Rectangle;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public final class Marquee {
    private final Package graph;
    private int drag_start_x;
    private int drag_start_y;
    private Rectangle currentRect;
    private final SelectionSet selected;
    private boolean active = false;
    private final ArrayList<Target> previouslySelected = new ArrayList();

    public Marquee(Package graph, SelectionSet selection) {
        this.graph = graph;
        this.selected = selection;
        this.currentRect = new Rectangle();
        this.currentRect.setVisible(false);
    }

    public void start(int x, int y) {
        this.previouslySelected.clear();
        this.previouslySelected.addAll(this.selected.getSelected());
        this.drag_start_x = x;
        this.drag_start_y = y;
        this.currentRect.setX((double)x);
        this.currentRect.setY((double)y);
        this.currentRect.setWidth(0.0);
        this.currentRect.setHeight(0.0);
        this.currentRect.setVisible(false);
        this.active = true;
    }

    public void move(int drag_x, int drag_y) {
        int x = this.drag_start_x;
        int y = this.drag_start_y;
        int w = drag_x - this.drag_start_x;
        int h = drag_y - this.drag_start_y;
        if (w < 0) {
            x += w;
        }
        if (h < 0) {
            y += h;
        }
        w = Math.abs(w);
        h = Math.abs(h);
        this.currentRect.setX((double)x);
        this.currentRect.setY((double)y);
        this.currentRect.setWidth((double)w);
        this.currentRect.setHeight((double)h);
        if (w != 0 || h != 0) {
            this.currentRect.setVisible(true);
        }
        this.findSelectedVertices(x, y, w, h);
    }

    private void findSelectedVertices(int x, int y, int w, int h) {
        this.selected.clear();
        this.selected.addAll(this.previouslySelected);
        for (Target v : this.graph.getVertices()) {
            if (!v.getBoundsInEditor().intersects((double)x, (double)y, (double)w, (double)h)) continue;
            this.selected.add(v);
        }
        if (!this.selected.isEmpty() && !this.selected.getSelected().stream().anyMatch(Target::isFocused)) {
            this.selected.getAnyVertex().requestFocus();
        }
    }

    public void stop() {
        this.currentRect.setVisible(false);
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public Rectangle getRectangle() {
        return this.currentRect;
    }
}

