/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork;

import bluej.Config;
import bluej.groupwork.CodeFileFilter;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamworkProvider;
import bluej.groupwork.UnsupportedSettingException;
import bluej.groupwork.ui.TeamSettingsDialog;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javafx.stage.Window;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class TeamSettingsController {
    private static final @OnThread(value=Tag.Any) TeamworkProvider teamProvider;
    private Project project;
    private File projectDir;
    private Properties teamProperties;
    private TeamSettingsDialog teamSettingsDialog;
    private TeamSettings settings;
    private String password;
    private final SecretKey pwdAESKey;
    private final IvParameterSpec pwdAESIv;
    private File teamdefs;
    private Repository repository;

    private static TeamworkProvider loadProvider(String name) throws Throwable {
        Class<?> c = Class.forName(name);
        Object instance = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return (TeamworkProvider)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TeamSettingsController(Project project) {
        MessageDigest sha;
        SecretKeySpec tempKey = null;
        try {
            byte[] key = "5v8y/B?E(H+MbQeShVmYq3t6w9z$C&F)".getBytes(StandardCharsets.UTF_8);
            sha = MessageDigest.getInstance("SHA-256");
            key = sha.digest(key);
            tempKey = new SecretKeySpec(key, "AES");
        }
        catch (Exception e) {
            Debug.log("Teamwork AES key creation error: " + e.getMessage());
        }
        finally {
            this.pwdAESKey = tempKey;
        }
        IvParameterSpec tempIv = null;
        try {
            byte[] iv = "x/A?D(G+KbPeShVm".getBytes(StandardCharsets.UTF_8);
            sha = MessageDigest.getInstance("SHA-256");
            iv = sha.digest(iv);
            iv = Arrays.copyOf(iv, 16);
            tempIv = new IvParameterSpec(iv);
        }
        catch (Exception e) {
            Debug.log("Teamwork AES IV creation error: " + e.getMessage());
        }
        finally {
            this.pwdAESIv = tempIv;
        }
        this.project = project;
        this.projectDir = project.getProjectDir();
        this.teamProperties = new Properties();
        this.readSetupFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TeamSettingsController(File projectDir) {
        MessageDigest sha;
        SecretKeySpec tempKey = null;
        try {
            byte[] key = "5v8y/B?E(H+MbQeShVmYq3t6w9z$C&F)".getBytes(StandardCharsets.UTF_8);
            sha = MessageDigest.getInstance("SHA-256");
            key = sha.digest(key);
            tempKey = new SecretKeySpec(key, "AES");
        }
        catch (Exception e) {
            Debug.log("Teamwork AES key creation error: " + e.getMessage());
        }
        finally {
            this.pwdAESKey = tempKey;
        }
        IvParameterSpec tempIv = null;
        try {
            byte[] iv = "x/A?D(G+KbPeShVm".getBytes(StandardCharsets.UTF_8);
            sha = MessageDigest.getInstance("SHA-256");
            iv = sha.digest(iv);
            iv = Arrays.copyOf(iv, 16);
            tempIv = new IvParameterSpec(iv);
        }
        catch (Exception e) {
            Debug.log("Teamwork AES IV creation error: " + e.getMessage());
        }
        finally {
            this.pwdAESIv = tempIv;
        }
        this.projectDir = projectDir;
        this.teamProperties = new Properties();
    }

    public void setProject(Project proj) {
        this.project = proj;
        this.projectDir = proj.getProjectDir();
        this.repository = null;
        this.disableRepositorySettings();
    }

    public TeamworkProvider getTeamworkProvider() {
        return teamProvider;
    }

    public Repository trytoEstablishRepository(boolean authRequired, boolean isShareAction) {
        block13: {
            if (authRequired && this.password == null) {
                if (!this.getTeamSettingsDialog(isShareAction).showAndWait().isPresent()) {
                    return null;
                }
                TeamSettings settings = this.teamSettingsDialog.getSettings();
                if (this.repository == null) {
                    try {
                        this.repository = teamProvider.getRepository(this.projectDir, settings);
                    }
                    catch (UnsupportedSettingException e) {
                        DialogManager.showErrorTextFX(this.teamSettingsDialog.asWindow(), e.getLocalizedMessage());
                    }
                } else {
                    this.repository.setPassword(settings);
                }
            } else {
                if (!authRequired && this.password == null) {
                    try {
                        return teamProvider.getRepository(this.projectDir, this.settings);
                    }
                    catch (UnsupportedSettingException e) {
                        DialogManager.showErrorTextFX(this.teamSettingsDialog.asWindow(), e.getLocalizedMessage());
                        break block13;
                    }
                }
                if (this.repository == null) {
                    try {
                        this.repository = teamProvider.getRepository(this.projectDir, this.settings);
                    }
                    catch (UnsupportedSettingException e) {
                        DialogManager.showErrorTextFX(this.teamSettingsDialog.asWindow(), e.getLocalizedMessage());
                    }
                }
            }
        }
        return this.repository;
    }

    public Repository trytoEstablishRepository(boolean authRequired) {
        return this.trytoEstablishRepository(authRequired, false);
    }

    public boolean initRepository() {
        return this.initRepository(true);
    }

    private boolean initRepository(boolean auth) {
        return this.trytoEstablishRepository(auth) != null;
    }

    public Set<File> getProjectFiles(boolean includeLayout) {
        this.initRepository();
        boolean versionsDirs = false;
        if (this.repository != null) {
            versionsDirs = this.repository.versionsDirectories();
        }
        Set<File> files = this.project.getFilesInProject(includeLayout, versionsDirs);
        if (this.repository != null) {
            this.repository.getAllLocallyDeletedFiles(files);
        }
        return files;
    }

    public FileFilter getFileFilter(boolean includeDirectories) {
        this.initRepository(false);
        FileFilter repositoryFilter = null;
        if (this.repository != null) {
            repositoryFilter = this.repository.getMetadataFilter();
        }
        return new CodeFileFilter(this.getIgnoreFiles(), includeDirectories, this.projectDir, repositoryFilter);
    }

    private void readSetupFile() {
        this.teamdefs = new File(this.projectDir, "team.defs");
        try {
            this.teamProperties.load(new FileInputStream(this.teamdefs));
            this.initSettings();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @OnThread(value=Tag.Any)
    public static boolean isValidVCSfound(File projDir) {
        File teamDefs = new File(projDir, "team.defs");
        Properties p = new Properties();
        String providerName = null;
        try {
            p.load(new FileInputStream(teamDefs));
            providerName = p.getProperty("bluej.teamsettings.vcs");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return providerName != null && teamProvider.getProviderName().equalsIgnoreCase(providerName);
    }

    private void initSettings() {
        String savedPassword;
        String yourEmail;
        String yourName;
        String user = this.getPropString("bluej.teamsettings.user");
        if (user == null) {
            user = "";
        }
        if ((yourName = this.getPropString("bluej.teamsettings.yourName")) == null) {
            yourName = "";
        }
        if ((yourEmail = this.getPropString("bluej.teamsettings.yourEmail")) == null) {
            yourEmail = "";
        }
        TeamworkProvider provider = null;
        String providerName = this.getPropString("bluej.teamsettings.vcs");
        if (providerName != null && teamProvider.getProviderName().equalsIgnoreCase(providerName)) {
            provider = teamProvider;
        }
        if ((savedPassword = this.getPropString("bluej.teamsettings.savedpwd")) != null) {
            try {
                Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                cipher.init(2, (Key)this.pwdAESKey, this.pwdAESIv);
                byte[] plainText = cipher.doFinal(Base64.getDecoder().decode(savedPassword));
                this.password = new String(plainText, StandardCharsets.UTF_8);
            }
            catch (Exception ex) {
                Debug.log("Teamwork password decryption error: " + ex.getMessage());
            }
        }
        if (provider != null) {
            this.settings = this.initProviderSettings(user, this.password);
            this.settings.setYourName(yourName);
            this.settings.setYourEmail(yourEmail);
            this.settings.setSavePassword(this.password != null && savedPassword != null);
        }
    }

    public TeamSettings initProviderSettings(String user, String password) {
        String keyBase = "bluej.teamsettings." + teamProvider.getProviderName().toLowerCase() + ".";
        String prefix = this.getPropString(keyBase + "repositoryPrefix");
        String server = this.getPropString(keyBase + "server");
        int port = this.getPropInt(keyBase + "port");
        String protocol = this.getPropString(keyBase + "protocol");
        String branch = this.getPropString(keyBase + "branch");
        boolean savepassword = this.getPropString(keyBase + "savedpwd") != null;
        return new TeamSettings(protocol, server, port, prefix, branch, user, password, savepassword);
    }

    public boolean prepareDeleteDir(File dir) {
        Repository repository = this.trytoEstablishRepository(false);
        if (repository == null) {
            return false;
        }
        return repository.prepareDeleteDir(dir);
    }

    public void prepareCreateDir(File dir) {
        Repository repository = this.trytoEstablishRepository(false);
        if (repository != null) {
            repository.prepareCreateDir(dir);
        }
    }

    public TeamSettingsDialog getTeamSettingsDialog(boolean isShareAction) {
        if (this.teamSettingsDialog == null) {
            this.teamSettingsDialog = new TeamSettingsDialog((Window)PkgMgrFrame.getMostRecent().getWindow(), this, isShareAction);
            this.disableRepositorySettings();
        }
        return this.teamSettingsDialog;
    }

    public TeamSettingsDialog getTeamSettingsDialog() {
        if (this.teamSettingsDialog == null) {
            this.teamSettingsDialog = new TeamSettingsDialog((Window)PkgMgrFrame.getMostRecent().getWindow(), this, false);
            this.disableRepositorySettings();
        }
        return this.teamSettingsDialog;
    }

    private void disableRepositorySettings() {
        if (this.teamSettingsDialog != null && this.project != null) {
            this.teamSettingsDialog.disableRepositorySettings();
        }
    }

    public void writeToProject() {
        if (this.projectDir == null) {
            return;
        }
        File cfgFile = new File(this.projectDir + "/team.defs");
        if (!cfgFile.exists()) {
            this.addIgnoreFilePatterns(this.teamProperties);
        }
        try {
            this.teamProperties.store(new FileOutputStream(cfgFile), null);
            this.repository = null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addIgnoreFilePatterns(Properties teamProperties) {
        teamProperties.put("bluej.teamsettings.ignore1", ".*\\.class");
        teamProperties.put("bluej.teamsettings.ignore2", "bluej\\.pkh");
        teamProperties.put("bluej.teamsettings.ignore3", "team\\.defs");
        teamProperties.put("bluej.teamsettings.ignore4", ".*\\.ctxt");
        teamProperties.put("bluej.teamsettings.ignore5", ".*\\~");
        teamProperties.put("bluej.teamsettings.ignore6", ".*\\#");
        teamProperties.put("bluej.teamsettings.ignore7", ".*\\#backup");
        teamProperties.put("bluej.teamsettings.ignore8", "\\.DS_Store");
    }

    public String getPropString(String strname) {
        String result = this.teamProperties.getProperty(strname);
        if (result != null) {
            return result;
        }
        result = Config.getPropString(strname, null);
        return result;
    }

    public int getPropInt(String strname) {
        String result = this.teamProperties.getProperty(strname);
        int intRes = -1;
        if (result != null) {
            try {
                intRes = Integer.parseInt(result);
                return intRes;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            intRes = Integer.parseInt(Config.getPropString(strname, null));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return intRes;
    }

    public void setPropString(String key, String value) {
        if (key != null && value != null) {
            this.teamProperties.setProperty(key, value);
        }
    }

    public void setPropInt(String key, int value) {
        if (key != null) {
            this.teamProperties.setProperty(key, "" + value);
        }
    }

    public void updateSettings(TeamSettings newSettings) {
        this.settings = newSettings;
        String userKey = "bluej.teamsettings.user";
        String userValue = this.settings.getUserName();
        this.setPropString(userKey, userValue);
        String yourNameKey = "bluej.teamsettings.yourName";
        String yourNameValue = "";
        yourNameValue = this.settings.getYourName();
        this.setPropString(yourNameKey, yourNameValue);
        String yourEmailKey = "bluej.teamsettings.yourEmail";
        String yourEmailValue = "";
        yourEmailValue = this.settings.getYourEmail();
        this.setPropString(yourEmailKey, yourEmailValue);
        String providerKey = "bluej.teamsettings.vcs";
        String providerName = teamProvider.getProviderName().toLowerCase();
        this.setPropString(providerKey, providerName);
        String keyBase = "bluej.teamsettings." + providerName + ".";
        String serverKey = keyBase + "server";
        String serverValue = this.settings.getServer();
        if (serverValue != null) {
            this.setPropString(serverKey, serverValue);
        }
        String portKey = keyBase + "port";
        int portValue = this.settings.getPort();
        if (portValue > 0) {
            this.setPropInt(portKey, portValue);
        }
        String prefixKey = keyBase + "repositoryPrefix";
        String prefixValue = this.settings.getPrefix();
        this.setPropString(prefixKey, prefixValue);
        String branchkey = keyBase + "branch";
        String branchValue = this.settings.getBranch();
        this.setPropString(branchkey, branchValue);
        String protocolKey = keyBase + "protocol";
        String protocolValue = this.settings.getProtocol();
        this.setPropString(protocolKey, protocolValue);
        String passValue = this.settings.getPassword();
        this.setPasswordString(passValue);
        if (!this.setSavedPassword(this.settings.getSavePassword(), passValue)) {
            this.settings.setSavePassword(false);
        }
        if (this.repository != null) {
            TeamSettings settings = this.getTeamSettingsDialog().getSettings();
            this.repository.setPassword(settings);
        }
        Config.putPropString(providerKey, providerName);
        Config.putPropString(userKey, userValue);
        Config.putPropString(yourNameKey, yourNameValue);
        Config.putPropString(yourEmailKey, yourEmailValue);
    }

    public String getPasswordString() {
        return this.password;
    }

    private void setPasswordString(String password) {
        this.password = password;
    }

    public boolean hasPasswordString() {
        return this.password != null;
    }

    private boolean setSavedPassword(boolean save, String passValue) {
        if (save) {
            try {
                Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                cipher.init(1, (Key)this.pwdAESKey, this.pwdAESIv);
                byte[] cipherText = cipher.doFinal(passValue.getBytes(StandardCharsets.UTF_8));
                String encodedpwd = Base64.getEncoder().encodeToString(cipherText);
                this.setPropString("bluej.teamsettings.savedpwd", encodedpwd);
                return true;
            }
            catch (Exception e) {
                Debug.log("Teamwork pasword encryption error: " + e.getMessage());
                return false;
            }
        }
        this.teamProperties.remove("bluej.teamsettings.savedpwd");
        return true;
    }

    public List<String> getIgnoreFiles() {
        Iterator<Object> keys = this.teamProperties.keySet().iterator();
        LinkedList<String> patterns = new LinkedList<String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key.startsWith("bluej.teamsettings.cvs.ignore")) {
                patterns.add(this.teamProperties.getProperty(key));
            }
            if (!key.startsWith("bluej.teamsettings.ignore")) continue;
            patterns.add(this.teamProperties.getProperty(key));
        }
        return patterns;
    }

    public boolean hasProject() {
        return this.project != null;
    }

    public Project getProject() {
        return this.project;
    }

    static {
        TeamworkProvider tempTeamworProvider = null;
        try {
            tempTeamworProvider = TeamSettingsController.loadProvider("bluej.groupwork.git.GitProvider");
        }
        catch (Throwable e) {
            Debug.message("Failed to initialize Git: " + e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        finally {
            teamProvider = tempTeamworProvider;
        }
    }
}

