/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamSettingsController;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.actions.TeamAction;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.Utility;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ShareAction
extends TeamAction {
    public ShareAction() {
        super("team.share", true);
    }

    @Override
    public void actionPerformed(PkgMgrFrame pmf) {
        Project project = pmf.getProject();
        if (project == null) {
            return;
        }
        this.doShare(pmf, project);
    }

    private void doShare(final PkgMgrFrame pmf, final Project project) {
        Repository repository;
        TeamSettingsController tsc;
        block3: {
            tsc = new TeamSettingsController(project.getProjectDir());
            repository = tsc.trytoEstablishRepository(true, true);
            if (repository == null) {
                return;
            }
            try {
                project.saveAll();
                project.saveAllEditors();
            }
            catch (IOException ioe) {
                String msg = DialogManager.getMessage("team-error-saving-project", new String[0]);
                if (msg == null) break block3;
                String finalMsg = Utility.mergeStrings(msg, ioe.getLocalizedMessage());
                DialogManager.showErrorTextFX((Window)pmf.getWindow(), finalMsg);
                return;
            }
        }
        pmf.setStatus(Config.getString("team.sharing"));
        pmf.startProgress();
        Thread thread = new Thread("Sharing project"){
            TeamworkCommandResult result;
            {
                super(arg0);
                this.result = null;
            }

            @Override
            @OnThread(value=Tag.Worker, ignoreParent=true)
            public void run() {
                TeamworkCommand command = repository.shareProject();
                this.result = command.getResult();
                if (!this.result.isError()) {
                    CompletableFuture filesFuture = new CompletableFuture();
                    Platform.runLater(() -> {
                        project.setTeamSettingsController(tsc);
                        Set<File> projFiles = tsc.getProjectFiles(true);
                        filesFuture.complete(new HashSet<File>(projFiles));
                    });
                    try {
                        Set files = (Set)filesFuture.get();
                        LinkedHashSet<File> newFiles = new LinkedHashSet<File>(files);
                        Set<File> binFiles = TeamUtils.extractBinaryFilesFromSet(newFiles);
                        command = repository.commitAll(newFiles, binFiles, Collections.emptySet(), files, Config.getString("team.share.initialMessage"));
                        this.result = command.getResult();
                        command = repository.pushChanges();
                        this.result = command.getResult();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        Debug.reportError(e);
                    }
                }
                Platform.runLater(() -> {
                    TeamUtils.handleServerResponseFX(this.result, (Window)pmf.getWindow());
                    pmf.stopProgress();
                    if (!this.result.isError()) {
                        pmf.setStatus(Config.getString("team.shared"));
                        DataCollector.teamShareProject(project, repository);
                    } else {
                        pmf.clearStatus();
                    }
                });
            }
        };
        thread.start();
    }
}

