/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.debugger.gentype.BadInheritanceChainException;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeTpar;
import bluej.debugger.gentype.GenTypeWildcard;
import bluej.debugger.gentype.IntersectionType;
import bluej.debugger.gentype.JavaPrimitiveType;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.MethodReflective;
import bluej.debugger.gentype.Reflective;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.ValueCollection;
import bluej.debugmgr.codepad.DeclaredVar;
import bluej.parser.CodepadImportParser;
import bluej.parser.CodepadVarParser;
import bluej.parser.DummyReflective;
import bluej.parser.ImportsCollection;
import bluej.parser.ParseFailure;
import bluej.parser.TextParser;
import bluej.parser.entity.ConstantFloatValue;
import bluej.parser.entity.ConstantIntValue;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.PackageEntity;
import bluej.parser.entity.PackageOrClass;
import bluej.parser.entity.TypeEntity;
import bluej.parser.entity.ValueEntity;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import bluej.utility.JavaReflective;
import bluej.utility.JavaUtils;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import threadchecker.OnThread;
import threadchecker.Tag;

public class TextAnalyzer {
    private EntityResolver parentResolver;
    private String packageScope;
    private ValueCollection objectBench;
    private List<DeclaredVar> declVars;
    private String amendedCommand;
    private ImportsCollection imports;
    private String importCandidate;

    public TextAnalyzer(EntityResolver parentResolver, String packageScope, ValueCollection ob) {
        this.parentResolver = parentResolver;
        this.packageScope = packageScope;
        this.objectBench = ob;
        this.imports = new ImportsCollection();
    }

    public void newClassLoader(ClassLoader newLoader) {
        this.imports.clear();
    }

    @OnThread(value=Tag.FXPlatform)
    public String parseCommand(String command) {
        this.importCandidate = "";
        this.amendedCommand = command;
        this.declVars = Collections.emptyList();
        EntityResolver resolver = this.getResolver();
        DummyReflective accessRef = new DummyReflective(JavaNames.combineNames(this.packageScope, "$SHELL"));
        TypeEntity accessType = new TypeEntity(accessRef);
        TextParser parser = new TextParser(resolver, command, (JavaEntity)accessType, true);
        try {
            try {
                parser.parseImportStatement();
                if (parser.atEnd()) {
                    this.amendedCommand = "";
                    this.importCandidate = command;
                    return null;
                }
            }
            catch (ParseFailure parseFailure) {
                // empty catch block
            }
            CodepadVarParser vparser = new CodepadVarParser(resolver, command, (JavaEntity)accessType);
            try {
                if (vparser.parseVariableDeclarations() != null) {
                    this.declVars = vparser.getVariables();
                    if (!this.declVars.isEmpty()) {
                        for (DeclaredVar var : this.declVars) {
                            if (var.isInitialized() || var.isFinal()) continue;
                            this.amendedCommand = this.amendedCommand + "\n" + var.getName();
                            JavaType declVarType = var.getDeclaredType();
                            String text = declVarType.isPrimitive() ? (declVarType.isNumeric() ? " = 0" : " = false") : " = null";
                            this.amendedCommand = this.amendedCommand + text + ";\n";
                        }
                        return null;
                    }
                }
            }
            catch (ParseFailure parseFailure) {
                // empty catch block
            }
            parser = new TextParser(resolver, command, (JavaEntity)accessType, true);
            try {
                parser.parseExpression();
                if (parser.atEnd()) {
                    JavaEntity exprType = parser.getExpressionType();
                    if (exprType == null) {
                        return "";
                    }
                    ValueEntity rval = exprType.resolveAsValue();
                    if (rval != null) {
                        if (((JavaEntity)rval).getType().typeIs(JavaType.JT_VOID)) {
                            return null;
                        }
                        JavaType rtype = ((JavaEntity)rval).getType();
                        if (rtype.isPrimitive() || rtype.getArrayComponent() != null) {
                            return rtype.toString();
                        }
                        return rtype.asSolid().getReferenceSupertypes()[0].toString();
                    }
                    return "";
                }
            }
            catch (ParseFailure parseFailure) {}
        }
        catch (Throwable t) {
            Debug.reportError("Exception in parser", t);
        }
        return null;
    }

    private EntityResolver getResolver() {
        EntityResolver resolver = new EntityResolver(){

            @Override
            public TypeEntity resolveQualifiedClass(String name) {
                return TextAnalyzer.this.parentResolver.resolveQualifiedClass(name);
            }

            @Override
            public PackageOrClass resolvePackageOrClass(String name, Reflective querySource) {
                TypeEntity entity;
                Object pkgScopePrefix = TextAnalyzer.this.packageScope;
                if (TextAnalyzer.this.packageScope.length() > 0) {
                    pkgScopePrefix = (String)pkgScopePrefix + ".";
                }
                if ((entity = TextAnalyzer.this.imports.getTypeImport(name)) != null) {
                    return entity;
                }
                TypeEntity rval = TextAnalyzer.this.parentResolver.resolveQualifiedClass((String)pkgScopePrefix + name);
                if (rval != null) {
                    return rval;
                }
                rval = TextAnalyzer.this.parentResolver.resolveQualifiedClass("java.lang." + name);
                if (rval != null) {
                    return rval;
                }
                entity = TextAnalyzer.this.imports.getTypeImportWC(name);
                if (entity != null) {
                    return entity;
                }
                return new PackageEntity(name, this);
            }

            @Override
            @OnThread(value=Tag.FXPlatform, ignoreParent=true)
            public @OnThread(value=Tag.FXPlatform, ignoreParent=true) JavaEntity getValueEntity(String name, Reflective querySource) {
                NamedValue obVal = TextAnalyzer.this.objectBench.getNamedValue(name);
                if (obVal != null) {
                    return new ValueEntity(obVal.getGenType());
                }
                List<JavaEntity> importStaticVals = TextAnalyzer.this.imports.getStaticImports(name);
                if (importStaticVals != null && !importStaticVals.isEmpty()) {
                    return importStaticVals.get(0).getSubentity(name, querySource);
                }
                importStaticVals = TextAnalyzer.this.imports.getStaticWildcardImports();
                if (importStaticVals != null) {
                    for (JavaEntity importStatic : importStaticVals) {
                        JavaEntity entity;
                        if ((importStatic = importStatic.resolveAsType()) == null || (entity = importStatic.getSubentity(name, querySource)) == null) continue;
                        return entity;
                    }
                }
                return this.resolvePackageOrClass(name, querySource);
            }
        };
        return resolver;
    }

    @OnThread(value=Tag.FXPlatform)
    public void confirmCommand() {
        if (this.importCandidate.length() != 0) {
            StringReader r = new StringReader(this.importCandidate);
            CodepadImportParser parser = new CodepadImportParser(this.getResolver(), r);
            parser.parseImportStatement();
            if (parser.isStaticImport()) {
                if (parser.isWildcardImport()) {
                    this.imports.addStaticWildcardImport(parser.getImportEntity().resolveAsType(), null, null);
                } else {
                    this.imports.addStaticImport(parser.getMemberName(), parser.getImportEntity().resolveAsType(), null, null);
                }
            } else if (parser.isWildcardImport()) {
                this.imports.addWildcardImport(parser.getImportEntity().resolveAsPackageOrClass(), null, null);
            } else {
                JavaEntity importEntity = parser.getImportEntity();
                TypeEntity classEnt = importEntity.resolveAsType();
                String name = classEnt.getType().toString(true);
                this.imports.addNormalImport(name, classEnt, null, null);
            }
        }
    }

    public List<DeclaredVar> getDeclaredVars() {
        return this.declVars;
    }

    public String getAmendedCommand() {
        return this.amendedCommand;
    }

    public String getImportStatements() {
        return this.imports.toString() + this.importCandidate;
    }

    private static boolean doesValueFitIntType(long value, JavaType type) {
        if (type.typeIs(JavaType.JT_BYTE)) {
            return value <= 127L && value >= -128L;
        }
        if (type.typeIs(JavaType.JT_CHAR)) {
            return value <= 65535L && value >= 0L;
        }
        if (type.typeIs(JavaType.JT_SHORT)) {
            return value <= 32767L && value >= -32768L;
        }
        return false;
    }

    public static ValueEntity questionOperator15(ValueEntity condition, ValueEntity trueAlt, ValueEntity falseAlt) {
        long fval;
        boolean falseIsSmallInt;
        long fval2;
        boolean trueIsSmallInt;
        boolean trueIsShort;
        JavaType trueAltType = trueAlt.getType();
        JavaType falseAltType = falseAlt.getType();
        JavaType conditionType = condition.getType();
        if (conditionType == null || !conditionType.typeIs(JavaType.JT_BOOLEAN)) {
            return null;
        }
        if (trueAltType == null || falseAltType == null) {
            return null;
        }
        if (trueAltType.isVoid() || falseAltType.isVoid()) {
            return null;
        }
        if (trueAltType.equals(falseAltType)) {
            if (condition.hasConstantBooleanValue() && ValueEntity.isConstant(trueAlt) && ValueEntity.isConstant(falseAlt)) {
                return condition.getConstantBooleanValue() ? trueAlt : falseAlt;
            }
            return new ValueEntity(trueAltType);
        }
        if (trueAltType.isNull() && !falseAltType.isPrimitive()) {
            return new ValueEntity(falseAltType);
        }
        String trueAltStr = trueAltType.toString();
        String falseAltStr = falseAltType.toString();
        boolean trueIsByte = trueAltStr.equals("byte") || trueAltStr.equals("java.lang.Byte");
        boolean falseIsShort = falseAltStr.equals("short") || falseAltStr.equals("java.lang.Short");
        boolean falseIsByte = falseAltStr.equals("byte") || falseAltStr.equals("java.lang.Byte");
        boolean bl = trueIsShort = trueAltStr.equals("short") || trueAltStr.equals("java.lang.Short");
        if (trueIsByte && falseIsShort || falseIsByte && trueIsShort) {
            if (condition.hasConstantBooleanValue() && trueAlt.hasConstantIntValue() && falseAlt.hasConstantIntValue()) {
                long intVal = condition.getConstantBooleanValue() ? trueAlt.getConstantIntValue() : falseAlt.getConstantIntValue();
                return new ConstantIntValue(null, JavaPrimitiveType.getShort(), intVal);
            }
            return new ValueEntity(JavaPrimitiveType.getShort());
        }
        JavaType trueUnboxed = TextAnalyzer.unBox(trueAltType);
        boolean bl2 = trueIsSmallInt = trueUnboxed.typeIs(JavaType.JT_BYTE) || trueUnboxed.typeIs(JavaType.JT_SHORT) || trueUnboxed.typeIs(JavaType.JT_CHAR);
        if (trueIsSmallInt && falseAltType.typeIs(JavaType.JT_INT) && falseAlt.hasConstantIntValue() && TextAnalyzer.doesValueFitIntType(fval2 = falseAlt.getConstantIntValue(), trueAltType)) {
            if (trueAlt.hasConstantIntValue() && condition.hasConstantBooleanValue()) {
                long val = condition.getConstantBooleanValue() ? trueAlt.getConstantIntValue() : falseAlt.getConstantIntValue();
                return new ConstantIntValue(null, trueAltType, val);
            }
            return new ValueEntity(trueUnboxed);
        }
        JavaType falseUnboxed = TextAnalyzer.unBox(falseAltType);
        boolean bl3 = falseIsSmallInt = falseUnboxed.typeIs(JavaType.JT_BYTE) || falseUnboxed.typeIs(JavaType.JT_SHORT) || falseUnboxed.typeIs(JavaType.JT_CHAR);
        if (falseIsSmallInt && trueAltType.typeIs(JavaType.JT_INT) && trueAlt.hasConstantIntValue() && TextAnalyzer.doesValueFitIntType(fval = trueAlt.getConstantIntValue(), falseAltType)) {
            if (falseAlt.hasConstantIntValue() && condition.hasConstantBooleanValue()) {
                long val = condition.getConstantBooleanValue() ? trueAlt.getConstantIntValue() : falseAlt.getConstantIntValue();
                return new ConstantIntValue(null, falseUnboxed, val);
            }
            return new ValueEntity(falseUnboxed);
        }
        if (trueUnboxed.isNumeric() && falseUnboxed.isNumeric()) {
            JavaType rtype = TextAnalyzer.binaryNumericPromotion(trueUnboxed, falseUnboxed);
            if (condition.hasConstantBooleanValue() && ValueEntity.isConstant(trueAlt) && ValueEntity.isConstant(falseAlt)) {
                ValueEntity relevantAlt;
                ValueEntity valueEntity = relevantAlt = condition.getConstantBooleanValue() ? trueAlt : falseAlt;
                if (rtype.typeIs(JavaType.JT_DOUBLE) || rtype.typeIs(JavaType.JT_FLOAT)) {
                    double val = relevantAlt.getType().typeIs(JavaType.JT_DOUBLE) || relevantAlt.getType().typeIs(JavaType.JT_FLOAT) ? relevantAlt.getConstantFloatValue() : (double)relevantAlt.getConstantIntValue();
                    return new ConstantFloatValue(rtype, val);
                }
                long val = condition.getConstantBooleanValue() ? trueAlt.getConstantIntValue() : falseAlt.getConstantIntValue();
                return new ConstantIntValue(null, rtype, val);
            }
            return new ValueEntity(rtype);
        }
        GenTypeSolid trueBoxed = TextAnalyzer.boxType(trueAltType);
        GenTypeSolid falseBoxed = TextAnalyzer.boxType(falseAltType);
        GenTypeSolid rtype = GenTypeSolid.lub(new GenTypeSolid[]{trueBoxed, falseBoxed});
        return new ValueEntity(rtype.getCapture());
    }

    public static JavaType binaryNumericPromotion(JavaType a, JavaType b) {
        JavaType ua = TextAnalyzer.unBox(a);
        JavaType ub = TextAnalyzer.unBox(b);
        if (ua.typeIs(JavaType.JT_DOUBLE) || ub.typeIs(JavaType.JT_DOUBLE)) {
            return JavaPrimitiveType.getDouble();
        }
        if (ua.typeIs(JavaType.JT_FLOAT) || ub.typeIs(JavaType.JT_FLOAT)) {
            return JavaPrimitiveType.getFloat();
        }
        if (ua.typeIs(JavaType.JT_LONG) || ub.typeIs(JavaType.JT_LONG)) {
            return JavaPrimitiveType.getLong();
        }
        if (ua.isNumeric() && ub.isNumeric()) {
            return JavaPrimitiveType.getInt();
        }
        return null;
    }

    public static JavaType unaryNumericPromotion(JavaType a) {
        JavaType ua = TextAnalyzer.unBox(a);
        if (ua.typeIs(JavaType.JT_DOUBLE)) {
            return JavaPrimitiveType.getDouble();
        }
        if (ua.typeIs(JavaType.JT_FLOAT)) {
            return JavaPrimitiveType.getFloat();
        }
        if (ua.typeIs(JavaType.JT_LONG)) {
            return JavaPrimitiveType.getLong();
        }
        if (ua.isNumeric()) {
            return JavaPrimitiveType.getInt();
        }
        return null;
    }

    private static MethodCallDesc isMethodApplicable(GenTypeClass targetType, List<GenTypeParameter> targs, MethodReflective m, JavaType[] args) {
        boolean methodIsVarargs = m.isVarArgs();
        MethodCallDesc rdesc = null;
        rdesc = TextAnalyzer.isMethodApplicable(targetType, targs, m, args, false);
        if (rdesc == null && methodIsVarargs) {
            rdesc = TextAnalyzer.isMethodApplicable(targetType, targs, m, args, true);
        }
        return rdesc;
    }

    /*
     * WARNING - void declaration
     */
    private static MethodCallDesc isMethodApplicable(GenTypeClass targetType, List<GenTypeParameter> targs, MethodReflective m, JavaType[] args, boolean varargs) {
        boolean rawTarget = targetType.isRaw();
        boolean boxingRequired = false;
        List<JavaType> mparams = m.getParamTypes();
        if (varargs) {
            void var11_14;
            if (mparams.size() > args.length + 1) {
                return null;
            }
            GenTypeSolid lastArgType = mparams.get(mparams.size() - 1).asSolid();
            JavaType vaType = lastArgType.getArrayComponent();
            ArrayList<JavaType> expandedParams = new ArrayList<JavaType>(args.length);
            expandedParams.addAll(mparams);
            expandedParams.remove(expandedParams.size() - 1);
            int n = mparams.size() - 1;
            while (var11_14 < args.length) {
                expandedParams.add(vaType);
                ++var11_14;
            }
            mparams = expandedParams;
        } else if (mparams.size() != args.length) {
            return null;
        }
        List<Object> tparams = Collections.emptyList();
        if (!rawTarget || m.isStatic()) {
            tparams = m.getTparTypes();
            List<Object> list = tparams = tparams != null ? tparams : Collections.emptyList();
        }
        if (!targs.isEmpty() && !tparams.isEmpty() && targs.size() != tparams.size()) {
            return null;
        }
        HashMap<String, GenTypeParameter> tparMap = rawTarget ? (m.isStatic() ? new HashMap() : null) : targetType.getMap();
        if (!tparams.isEmpty() && targs.isEmpty()) {
            for (GenTypeDeclTpar genTypeDeclTpar : tparams) {
                tparMap.put(genTypeDeclTpar.getTparName(), genTypeDeclTpar);
            }
            HashMap<String, Set<GenTypeSolid>> tlbConstraints = new HashMap<String, Set<GenTypeSolid>>();
            HashMap<String, GenTypeSolid> hashMap = new HashMap<String, GenTypeSolid>();
            HashMap<String, GenTypeSolid> tubConstraints = new HashMap<String, GenTypeSolid>();
            for (int i = 0; i < mparams.size(); ++i) {
                if (mparams.get(i).isPrimitive()) continue;
                GenTypeSolid genTypeSolid2 = (GenTypeSolid)mparams.get(i);
                genTypeSolid2 = genTypeSolid2.mapTparsToTypes(tparMap).asType().asSolid();
                TextAnalyzer.processAtoFConstraint(args[i], genTypeSolid2, tlbConstraints, hashMap, tubConstraints);
            }
            targs = new ArrayList<GenTypeParameter>();
            for (GenTypeDeclTpar genTypeDeclTpar : tparams) {
                String tparName = genTypeDeclTpar.getTparName();
                GenTypeSolid eqConstraint = (GenTypeSolid)hashMap.get(tparName);
                if (eqConstraint == null) {
                    Set lbConstraintSet = (Set)tlbConstraints.get(tparName);
                    if (lbConstraintSet != null) {
                        GenTypeSolid[] lbounds = lbConstraintSet.toArray(new GenTypeSolid[lbConstraintSet.size()]);
                        eqConstraint = GenTypeSolid.lub(lbounds);
                    } else {
                        eqConstraint = (GenTypeSolid)tubConstraints.get(tparName);
                        if (eqConstraint == null) {
                            eqConstraint = genTypeDeclTpar.getBound();
                        }
                    }
                }
                targs.add(eqConstraint);
                tparMap.put(tparName, eqConstraint);
            }
        } else {
            Iterator<Object> formalI = tparams.iterator();
            Iterator<GenTypeParameter> iterator = targs.iterator();
            while (formalI.hasNext()) {
                GenTypeDeclTpar formalTpar = (GenTypeDeclTpar)formalI.next();
                GenTypeSolid argTpar = (GenTypeSolid)iterator.next();
                GenTypeSolid[] genTypeSolidArray = formalTpar.upperBounds();
                for (int i = 0; i < genTypeSolidArray.length; ++i) {
                    genTypeSolidArray[i] = (GenTypeSolid)genTypeSolidArray[i].mapTparsToTypes(tparMap);
                    if (genTypeSolidArray[i].isAssignableFrom(argTpar)) break;
                    if (i != genTypeSolidArray.length - 1) continue;
                    return null;
                }
                tparMap.put(formalTpar.getTparName(), argTpar);
            }
        }
        for (int i = 0; i < args.length; ++i) {
            JavaType javaType = mparams.get(i);
            JavaType givenParam = args[i];
            JavaType javaType2 = javaType.mapTparsToTypes(tparMap).getUpperBound();
            if (javaType2.isAssignableFrom(givenParam)) continue;
            if (!javaType2.isAssignableFrom(TextAnalyzer.boxType(givenParam)) && !javaType2.isAssignableFrom(TextAnalyzer.unBox(givenParam))) {
                return null;
            }
            boxingRequired = true;
        }
        JavaType rType = m.getReturnType().mapTparsToTypes(tparMap).asType().getCapture();
        return new MethodCallDesc(m, mparams, varargs, boxingRequired, rType);
    }

    private static void processAtoFConstraint(JavaType a, GenTypeSolid f, Map<String, Set<GenTypeSolid>> tlbConstraints, Map<String, GenTypeSolid> teqConstraints, Map<String, GenTypeSolid> tubConstraints) {
        if ((a = TextAnalyzer.boxType(a)) == null) {
            return;
        }
        if (f instanceof GenTypeTpar) {
            GenTypeTpar t = (GenTypeTpar)f;
            Set<GenTypeSolid> constraintsSet = tlbConstraints.get(t.getTparName());
            if (constraintsSet == null) {
                constraintsSet = new HashSet<GenTypeSolid>();
                tlbConstraints.put(t.getTparName(), constraintsSet);
            }
            constraintsSet.add(a.asSolid());
        } else if (f.getArrayComponent() != null) {
            if (a.getArrayComponent() != null && f.getArrayComponent() instanceof GenTypeSolid) {
                a = a.getArrayComponent();
                f = (GenTypeSolid)f.getArrayComponent();
                TextAnalyzer.processAtoFConstraint(a, f, tlbConstraints, teqConstraints, tubConstraints);
            }
        } else {
            GenTypeClass cf = f.asClass();
            HashMap<String, GenTypeParameter> fMap = cf.getMap();
            if (fMap != null && a.asSolid() != null) {
                GenTypeClass[] asts = a.asSolid().getReferenceSupertypes();
                for (int i = 0; i < asts.length; ++i) {
                    try {
                        GenTypeClass aMapped = asts[i].mapToSuper(cf.classloaderName());
                        HashMap<String, GenTypeParameter> aMap = aMapped.getMap();
                        if (aMap == null) continue;
                        for (String tpName : fMap.keySet()) {
                            GenTypeParameter fPar = (GenTypeParameter)fMap.get(tpName);
                            GenTypeParameter aPar = (GenTypeParameter)aMap.get(tpName);
                            TextAnalyzer.processAtoFtpar(aPar, fPar, tlbConstraints, teqConstraints, tubConstraints);
                        }
                        continue;
                    }
                    catch (BadInheritanceChainException badInheritanceChainException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static void processAtoFtpar(GenTypeParameter aPar, GenTypeParameter fPar, Map<String, Set<GenTypeSolid>> tlbConstraints, Map<String, GenTypeSolid> teqConstraints, Map<String, GenTypeSolid> tubConstraints) {
        if (fPar instanceof GenTypeSolid) {
            if (aPar instanceof GenTypeSolid) {
                TextAnalyzer.processAeqFConstraint((GenTypeSolid)aPar, (GenTypeSolid)fPar, tlbConstraints, teqConstraints);
            }
        } else {
            GenTypeSolid flbound = fPar.getLowerBound();
            if (flbound != null) {
                GenTypeSolid albound = aPar.getLowerBound();
                if (albound != null) {
                    TextAnalyzer.processFtoAConstraint(albound, flbound, tlbConstraints, teqConstraints, tubConstraints);
                }
            } else {
                GenTypeSolid[] fubounds = fPar.getUpperBound().asSolid().getIntersectionTypes();
                GenTypeSolid[] aubounds = aPar.getUpperBound().asSolid().getIntersectionTypes();
                if (fubounds.length > 0 && aubounds.length > 0) {
                    TextAnalyzer.processAtoFConstraint(IntersectionType.getIntersection(aubounds), fubounds[0], tlbConstraints, teqConstraints, tubConstraints);
                }
            }
        }
    }

    private static void processAeqFConstraint(GenTypeSolid a, GenTypeSolid f, Map<String, Set<GenTypeSolid>> tlbConstraints, Map<String, GenTypeSolid> teqConstraints) {
        block4: {
            block5: {
                block3: {
                    if (!(f instanceof GenTypeTpar)) break block3;
                    GenTypeTpar t = (GenTypeTpar)f;
                    teqConstraints.put(t.getTparName(), a);
                    break block4;
                }
                if (!(f.getArrayComponent() instanceof GenTypeSolid)) break block5;
                GenTypeSolid[] asts = a instanceof GenTypeDeclTpar ? ((GenTypeDeclTpar)a).upperBounds() : new GenTypeSolid[]{a};
                for (int i = 0; i < asts.length; ++i) {
                    JavaType act = asts[i].getArrayComponent();
                    if (!(act instanceof GenTypeSolid)) continue;
                    TextAnalyzer.processAeqFConstraint((GenTypeSolid)act, (GenTypeSolid)f.getArrayComponent(), tlbConstraints, teqConstraints);
                }
                break block4;
            }
            GenTypeClass cf = f.asClass();
            GenTypeClass af = a.asClass();
            if (af == null || cf == null || !cf.classloaderName().equals(af.classloaderName())) break block4;
            HashMap<String, GenTypeParameter> fMap = cf.getMap();
            HashMap<String, GenTypeParameter> aMap = af.getMap();
            if (fMap != null && aMap != null) {
                for (String tpName : fMap.keySet()) {
                    GenTypeParameter fPar = (GenTypeParameter)fMap.get(tpName);
                    GenTypeParameter aPar = (GenTypeParameter)aMap.get(tpName);
                    TextAnalyzer.processAeqFtpar(aPar, fPar, tlbConstraints, teqConstraints);
                }
            }
        }
    }

    private static GenTypeSolid getSolidUpperBound(GenTypeParameter tpar) {
        JavaType ubound = tpar.getUpperBound();
        if (ubound != null) {
            return ubound.asSolid();
        }
        return null;
    }

    private static void processAeqFtpar(GenTypeParameter aPar, GenTypeParameter fPar, Map<String, Set<GenTypeSolid>> tlbConstraints, Map<String, GenTypeSolid> teqConstraints) {
        if (aPar instanceof GenTypeSolid && fPar instanceof GenTypeSolid) {
            TextAnalyzer.processAeqFConstraint((GenTypeSolid)aPar, (GenTypeSolid)fPar, tlbConstraints, teqConstraints);
        } else if (aPar instanceof GenTypeWildcard && fPar instanceof GenTypeWildcard) {
            GenTypeSolid auBound;
            GenTypeSolid flBound = fPar.getLowerBound();
            GenTypeSolid fuBound = TextAnalyzer.getSolidUpperBound(fPar);
            if (flBound != null) {
                GenTypeSolid alBound = aPar.getLowerBound();
                if (alBound != null) {
                    TextAnalyzer.processAeqFConstraint(alBound, flBound, tlbConstraints, teqConstraints);
                }
            } else if (fuBound != null && (auBound = TextAnalyzer.getSolidUpperBound(aPar)) != null) {
                TextAnalyzer.processAeqFConstraint(auBound, fuBound, tlbConstraints, teqConstraints);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processFtoAConstraint(GenTypeSolid a, GenTypeSolid f, Map<String, Set<GenTypeSolid>> tlbConstraints, Map<String, GenTypeSolid> teqConstraints, Map<String, GenTypeSolid> tubConstraints) {
        if (f instanceof GenTypeTpar) {
            GenTypeTpar ftpar = (GenTypeTpar)f;
            GenTypeSolid ubcons = tubConstraints.get(ftpar.getTparName());
            ubcons = ubcons == null ? a : IntersectionType.getIntersection(new GenTypeSolid[]{ubcons, a});
            tubConstraints.put(ftpar.getTparName(), ubcons);
            return;
        } else if (f.getArrayComponent() instanceof GenTypeSolid) {
            GenTypeSolid[] asts = a instanceof GenTypeDeclTpar ? ((GenTypeDeclTpar)a).upperBounds() : new GenTypeSolid[]{a};
            for (int i = 0; i < asts.length; ++i) {
                GenTypeSolid act = asts[i].getArrayComponent().asSolid();
                if (act == null) continue;
                TextAnalyzer.processFtoAConstraint(act, (GenTypeSolid)f.getArrayComponent(), tlbConstraints, teqConstraints, tubConstraints);
            }
            return;
        } else {
            if (f.asClass() == null || a.asClass() == null) return;
            GenTypeClass cf = f.asClass();
            GenTypeClass af = a.asClass();
            try {
                GenTypeClass fMapped = cf.mapToSuper(af.classloaderName());
                HashMap<String, GenTypeParameter> aMap = af.getMap();
                HashMap<String, GenTypeParameter> fMap = fMapped.getMap();
                if (aMap == null || fMap == null) return;
                for (String tpName : fMap.keySet()) {
                    GenTypeParameter fPar = (GenTypeParameter)fMap.get(tpName);
                    GenTypeParameter aPar = (GenTypeParameter)aMap.get(tpName);
                    TextAnalyzer.processFtoAtpar(aPar, fPar, tlbConstraints, teqConstraints, tubConstraints);
                }
                return;
            }
            catch (BadInheritanceChainException badInheritanceChainException) {
                // empty catch block
            }
        }
    }

    private static void processFtoAtpar(GenTypeParameter aPar, GenTypeParameter fPar, Map<String, Set<GenTypeSolid>> tlbConstraints, Map<String, GenTypeSolid> teqConstraints, Map<String, GenTypeSolid> tubConstraints) {
        if (fPar instanceof GenTypeSolid) {
            if (aPar instanceof GenTypeSolid) {
                TextAnalyzer.processAeqFConstraint((GenTypeSolid)aPar, (GenTypeSolid)fPar, tlbConstraints, teqConstraints);
            } else {
                GenTypeSolid alBound = aPar.getLowerBound();
                if (alBound != null) {
                    TextAnalyzer.processAtoFConstraint(alBound, (GenTypeSolid)fPar, tlbConstraints, teqConstraints, tubConstraints);
                } else {
                    GenTypeSolid auBound = aPar.getUpperBound().asSolid();
                    if (auBound != null) {
                        TextAnalyzer.processFtoAConstraint(auBound, fPar.asSolid(), tlbConstraints, teqConstraints, tubConstraints);
                    }
                }
            }
        } else {
            GenTypeSolid flBound = fPar.getLowerBound();
            if (flBound != null) {
                if (aPar instanceof GenTypeWildcard) {
                    GenTypeSolid alBound = aPar.getLowerBound();
                    if (alBound != null) {
                        TextAnalyzer.processAtoFConstraint(alBound, flBound, tlbConstraints, teqConstraints, tubConstraints);
                    }
                } else {
                    GenTypeSolid fuBound = fPar.getUpperBound().asSolid();
                    GenTypeSolid auBound = aPar.getUpperBound().asSolid();
                    if (fuBound != null && auBound != null) {
                        GenTypeSolid[] fuBounds = fuBound.getIntersectionTypes();
                        GenTypeSolid[] auBounds = auBound.getIntersectionTypes();
                        TextAnalyzer.processFtoAConstraint(auBounds[0], fuBounds[0], tlbConstraints, teqConstraints, tubConstraints);
                    }
                }
            }
        }
    }

    public static ArrayList<MethodCallDesc> getSuitableMethods(String methodName, GenTypeSolid targetType, JavaType[] argumentTypes, List<GenTypeParameter> typeArgs, Reflective accessType) {
        ArrayList<MethodCallDesc> suitableMethods = new ArrayList<MethodCallDesc>();
        Stack<GenTypeParameter> targetTypes = new Stack<GenTypeParameter>();
        targetTypes.push(targetType);
        HashSet<GenTypeParameter> doneTypes = new HashSet<GenTypeParameter>();
        while (!targetTypes.isEmpty()) {
            GenTypeSolid topType = (GenTypeSolid)targetTypes.pop();
            GenTypeClass targetClass = topType.asClass();
            if (targetClass == null) {
                GenTypeSolid[] bounds = topType.getUpperBounds();
                for (int i = 0; i < bounds.length; ++i) {
                    if (!doneTypes.add(bounds[i])) continue;
                    targetTypes.push(bounds[i]);
                }
                continue;
            }
            Reflective ref = targetClass.getReflective();
            List<GenTypeClass> supers = ref.getSuperTypes();
            HashMap<String, GenTypeParameter> tparMap = targetClass.getMap();
            for (GenTypeClass superType : supers) {
                GenTypeParameter mapped = superType.mapTparsToTypes(tparMap);
                if (!doneTypes.add(mapped)) continue;
                targetTypes.push(mapped);
            }
            Map<String, Set<MethodReflective>> methodMap = targetClass.getReflective().getDeclaredMethods();
            Set<MethodReflective> methods = methodMap.get(methodName);
            if (methods == null) continue;
            for (MethodReflective method : methods) {
                MethodCallDesc mcd;
                if (!JavaUtils.checkMemberAccess(method.getDeclaringType(), targetType, accessType, method.getModifiers(), false) || (mcd = TextAnalyzer.isMethodApplicable(targetClass, typeArgs, method, argumentTypes)) == null) continue;
                boolean replaced = false;
                for (int j = 0; j < suitableMethods.size(); ++j) {
                    MethodCallDesc mc = suitableMethods.get(j);
                    int compare = mcd.compareSpecificity(mc);
                    if (compare == 1) {
                        suitableMethods.remove(j);
                        --j;
                        continue;
                    }
                    if (compare != -1) continue;
                    replaced = true;
                    break;
                }
                if (replaced) continue;
                suitableMethods.add(mcd);
            }
        }
        return suitableMethods;
    }

    public static JavaType unBox(JavaType b) {
        GenTypeClass c = b.asClass();
        if (c != null) {
            String cName = c.classloaderName();
            if (cName.equals("java.lang.Integer")) {
                return JavaPrimitiveType.getInt();
            }
            if (cName.equals("java.lang.Long")) {
                return JavaPrimitiveType.getLong();
            }
            if (cName.equals("java.lang.Short")) {
                return JavaPrimitiveType.getShort();
            }
            if (cName.equals("java.lang.Byte")) {
                return JavaPrimitiveType.getByte();
            }
            if (cName.equals("java.lang.Character")) {
                return JavaPrimitiveType.getChar();
            }
            if (cName.equals("java.lang.Float")) {
                return JavaPrimitiveType.getFloat();
            }
            if (cName.equals("java.lang.Double")) {
                return JavaPrimitiveType.getDouble();
            }
            if (cName.equals("java.lang.Boolean")) {
                return JavaPrimitiveType.getBoolean();
            }
        }
        return b;
    }

    private static GenTypeSolid boxType(JavaType u) {
        if (u.isPrimitive()) {
            if (u.typeIs(JavaType.JT_INT)) {
                return new GenTypeClass(new JavaReflective(Integer.class));
            }
            if (u.typeIs(JavaType.JT_LONG)) {
                return new GenTypeClass(new JavaReflective(Long.class));
            }
            if (u.typeIs(JavaType.JT_SHORT)) {
                return new GenTypeClass(new JavaReflective(Short.class));
            }
            if (u.typeIs(JavaType.JT_BYTE)) {
                return new GenTypeClass(new JavaReflective(Byte.class));
            }
            if (u.typeIs(JavaType.JT_CHAR)) {
                return new GenTypeClass(new JavaReflective(Character.class));
            }
            if (u.typeIs(JavaType.JT_FLOAT)) {
                return new GenTypeClass(new JavaReflective(Float.class));
            }
            if (u.typeIs(JavaType.JT_DOUBLE)) {
                return new GenTypeClass(new JavaReflective(Double.class));
            }
            if (u.typeIs(JavaType.JT_BOOLEAN)) {
                return new GenTypeClass(new JavaReflective(Boolean.class));
            }
        }
        return u.asSolid();
    }

    public static class MethodCallDesc {
        public MethodReflective method;
        public List<JavaType> argTypes;
        public boolean vararg;
        public boolean autoboxing;
        public JavaType retType;

        public MethodCallDesc(MethodReflective m, List<JavaType> argTypes, boolean vararg, boolean autoboxing, JavaType retType) {
            this.method = m;
            this.argTypes = argTypes;
            this.vararg = vararg;
            this.autoboxing = autoboxing;
            this.retType = retType;
        }

        public int compareSpecificity(MethodCallDesc other) {
            if (other.vararg && !this.vararg) {
                return 1;
            }
            if (!other.vararg && this.vararg) {
                return -1;
            }
            Iterator<JavaType> i = this.argTypes.iterator();
            Iterator<JavaType> j = other.argTypes.iterator();
            int upCount = 0;
            int downCount = 0;
            while (i.hasNext()) {
                JavaType otherArg;
                JavaType myArg = i.next();
                if (myArg.isAssignableFrom(otherArg = j.next())) {
                    if (otherArg.isAssignableFrom(myArg)) continue;
                    ++upCount;
                    continue;
                }
                if (!otherArg.isAssignableFrom(myArg)) continue;
                ++downCount;
            }
            if (upCount > 0 && downCount == 0) {
                return -1;
            }
            if (downCount > 0 && upCount == 0) {
                return 1;
            }
            return 0;
        }
    }
}

