/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class Token {
    public TokenType id;
    public int length;
    public Token next;

    public Token(int length, TokenType id) {
        this.id = id;
        this.length = length;
    }

    @OnThread(value=Tag.Any)
    public static enum TokenType {
        DEFAULT,
        COMMENT_NORMAL,
        COMMENT_JAVADOC,
        COMMENT_SPECIAL,
        KEYWORD1,
        KEYWORD2,
        KEYWORD3,
        PRIMITIVE,
        STRING_LITERAL,
        CHAR_LITERAL,
        LABEL,
        INVALID,
        END;

        private static ImmutableSet<String> ALL_CLASSES;

        public String getCSSClass() {
            return "token-" + this.name().toLowerCase().replace("_", "-");
        }

        public static ImmutableSet<String> allCSSClasses() {
            if (ALL_CLASSES == null) {
                ALL_CLASSES = ImmutableSet.copyOf((Collection)Arrays.stream(TokenType.values()).map(TokenType::getCSSClass).collect(Collectors.toList()));
            }
            return ALL_CLASSES;
        }
    }
}

