/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.nodes;

import bluej.debugger.gentype.JavaType;
import bluej.parser.ExpressionTypeInfo;
import bluej.parser.TextParser;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.ErrorEntity;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.ParsedReflective;
import bluej.parser.entity.TypeEntity;
import bluej.parser.entity.UnresolvedArray;
import bluej.parser.entity.ValueEntity;
import bluej.parser.nodes.ExpressionNode;
import bluej.parser.nodes.JavaParentNode;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.ParsedTypeNode;
import bluej.parser.nodes.ReparseableDocument;
import bluej.parser.nodes.VariableDeclaration;

public class FieldNode
extends JavaParentNode
implements VariableDeclaration {
    private String name;
    private JavaEntity fieldType;
    private boolean isVarType;
    private FieldNode firstNode;
    private int modifiers;
    private int arrayDecls;
    private ReparseableDocument document;

    public FieldNode(JavaParentNode parent, String name, JavaEntity fieldType, int arrayDecls, int modifiers) {
        super(parent);
        this.name = name;
        this.fieldType = fieldType;
        this.arrayDecls = arrayDecls;
        this.modifiers = modifiers;
        this.document = null;
        this.isVarType = false;
    }

    public FieldNode(JavaParentNode parent, String name, int arrayDecls, int modifiers, ReparseableDocument document) {
        super(parent);
        this.name = name;
        this.fieldType = null;
        this.arrayDecls = arrayDecls;
        this.modifiers = modifiers;
        this.document = document;
        this.isVarType = true;
    }

    public FieldNode(JavaParentNode parent, String name, FieldNode firstNode, int arrayDecls) {
        super(parent);
        this.name = name;
        this.firstNode = firstNode;
        this.arrayDecls = arrayDecls;
    }

    @Override
    public int getNodeType() {
        return 5;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected boolean marksOwnEnd() {
        return true;
    }

    private int getAbsoluteOffset() {
        int offs = 0;
        ParsedNode pnode = this.getParentNode();
        JavaParentNode node = this;
        while (pnode != null) {
            offs += node.getOffsetFromParent();
            node = pnode;
            pnode = ((ParsedNode)node).getParentNode();
        }
        return offs;
    }

    private JavaEntity getContainingType() {
        ParsedNode pnode = this.getParentNode();
        while (pnode.getNodeType() != 1) {
            pnode = ((ParsedNode)pnode).getParentNode();
        }
        return new TypeEntity(new ParsedReflective((ParsedTypeNode)pnode));
    }

    private NodeTree.NodeAndPosition<ParsedNode> getInitExpression() {
        int mypos = this.getAbsoluteOffset();
        NodeTree.NodeAndPosition<ParsedNode> r = this.findNodeAtOrAfter(0, mypos);
        return r;
    }

    @Override
    public JavaEntity getFieldType() {
        JavaEntity ftype;
        JavaEntity javaEntity = ftype = this.firstNode == null ? this.fieldType : this.firstNode.fieldType;
        if (ftype == null) {
            if (this.isVarType) {
                NodeTree.NodeAndPosition<ParsedNode> initExpr = this.getInitExpression();
                if (this.document == null) {
                    return new ErrorEntity();
                }
                TextParser tp = new TextParser((EntityResolver)this, this.document.makeReader(initExpr.getPosition(), initExpr.getEnd()), this.getContainingType(), false);
                tp.parseExpression();
                JavaEntity inferredTypeEnt = tp.getExpressionType();
                if (inferredTypeEnt == null) {
                    return new ErrorEntity();
                }
                ValueEntity inferredVal = inferredTypeEnt.resolveAsValue();
                if (inferredVal == null) {
                    return new ErrorEntity();
                }
                JavaType inferredType = inferredVal.getType();
                if (inferredType != null) {
                    return new TypeEntity(inferredType);
                }
            }
            return new ErrorEntity();
        }
        for (int i = 0; i < this.arrayDecls; ++i) {
            ftype = new UnresolvedArray(ftype);
        }
        return ftype;
    }

    @Override
    public int getModifiers() {
        if (this.firstNode != null) {
            return this.firstNode.getModifiers();
        }
        return this.modifiers;
    }

    @Override
    protected ExpressionTypeInfo getExpressionType(int pos, int nodePos, JavaEntity defaultType, ReparseableDocument document, ExpressionNode largestPlainExpressionNode) {
        NodeTree.NodeAndPosition<ParsedNode> child = this.getNodeTree().findNode(Math.max(pos - 1, 0), nodePos);
        if (child != null) {
            return child.getNode().getExpressionType(pos, child.getPosition(), defaultType, document, null);
        }
        return ExpressionNode.suggestAsExpression(pos, nodePos, this, defaultType, document);
    }

    public boolean isFirstFieldNode() {
        return this.firstNode == null;
    }
}

