/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.extensions2.SourceType;
import bluej.parser.InfoParser;
import bluej.parser.symtab.ClassInfo;
import bluej.pkgmgr.ImportMismatchDialog;
import bluej.pkgmgr.PackageFileFactory;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import bluej.utility.javafx.FXPlatformSupplier;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.stage.Window;

public class Import {
    public static boolean convertNonBlueJ(FXPlatformSupplier<Window> parentWin, File path) {
        ImportMismatchDialog imd;
        boolean shouldContinue;
        List<File> interestingDirs = Import.findInterestingDirectories(path);
        if (interestingDirs.size() == 0) {
            DialogManager.showErrorFX(parentWin.get(), "open-non-bluej-no-java");
            return false;
        }
        List<File> javaFiles = Import.findJavaFiles(interestingDirs);
        ArrayList<File> mismatchFiles = new ArrayList<File>();
        ArrayList<String> mismatchPackagesOriginal = new ArrayList<String>();
        ArrayList<String> mismatchPackagesChanged = new ArrayList<String>();
        for (File f : javaFiles) {
            try {
                String qf;
                ClassInfo info = InfoParser.parse(f);
                if (info == null || info.hadParseError() || JavaNames.getPrefix(qf = JavaNames.convertFileToQualifiedName(path, f)).equals(info.getPackage())) continue;
                mismatchFiles.add(f);
                mismatchPackagesOriginal.add(info.getPackage());
                mismatchPackagesChanged.add(qf);
            }
            catch (FileNotFoundException info) {}
        }
        if (mismatchFiles.size() > 0 && !(shouldContinue = (imd = new ImportMismatchDialog(parentWin.get(), mismatchFiles)).showAndWait().orElse(false).booleanValue())) {
            return false;
        }
        Import.convertDirectory(interestingDirs);
        return true;
    }

    public static List<File> findInterestingDirectories(File dir) {
        LinkedList<File> interesting = new LinkedList<File>();
        File[] files = dir.listFiles();
        if (files == null) {
            return interesting;
        }
        boolean imInteresting = false;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                List<File> subInteresting;
                if (!JavaNames.isIdentifier(files[i].getName()) || (subInteresting = Import.findInterestingDirectories(files[i])).size() <= 0) continue;
                interesting.addAll(subInteresting);
                imInteresting = true;
                continue;
            }
            if (!files[i].getName().endsWith("." + SourceType.Java.toString().toLowerCase())) continue;
            imInteresting = true;
        }
        if (imInteresting) {
            interesting.add(dir);
        }
        return interesting;
    }

    public static List<File> findJavaFiles(List<File> dirs) {
        LinkedList<File> interesting = new LinkedList<File>();
        for (File dir : dirs) {
            File[] files = dir.listFiles();
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || !files[i].getName().endsWith("." + SourceType.Java.toString().toLowerCase())) continue;
                interesting.add(files[i]);
            }
        }
        return interesting;
    }

    public static void convertDirectory(List<File> dirs) {
        for (File f : dirs) {
            try {
                PackageFileFactory.getPackageFile(f).create();
            }
            catch (IOException e) {
                Debug.reportError("Could not create package files in dir: " + f, e);
            }
        }
    }
}

