/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.BlueJTheme;
import bluej.Boot;
import bluej.Config;
import bluej.Main;
import bluej.classmgr.BPClassLoader;
import bluej.collect.DataCollector;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.debugger.DebuggerObject;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.LibraryCallDialog;
import bluej.debugmgr.codepad.CodePad;
import bluej.debugmgr.objectbench.BluejResultWatcher;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.editor.flow.PrintDialog;
import bluej.extensions2.SourceType;
import bluej.extmgr.ExtensionsManager;
import bluej.extmgr.ExtensionsMenuManager;
import bluej.extmgr.ToolsExtensionMenu;
import bluej.groupwork.NoSVNSupportDialog;
import bluej.groupwork.actions.CheckoutAction;
import bluej.groupwork.actions.CommitCommentAction;
import bluej.groupwork.actions.ShareAction;
import bluej.groupwork.actions.StatusAction;
import bluej.groupwork.actions.TeamActionGroup;
import bluej.groupwork.actions.UpdateDialogAction;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.pkgmgr.AboutDialogTemplate;
import bluej.pkgmgr.ExportManager;
import bluej.pkgmgr.Import;
import bluej.pkgmgr.ImportFailedDialog;
import bluej.pkgmgr.MachineIcon;
import bluej.pkgmgr.MouseTrackingOverlayPane;
import bluej.pkgmgr.NewCSSDialog;
import bluej.pkgmgr.NewClassDialog;
import bluej.pkgmgr.NewPackageDialog;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.ProjectUtils;
import bluej.pkgmgr.TestRunnerThread;
import bluej.pkgmgr.actions.AddClassAction;
import bluej.pkgmgr.actions.CancelTestRecordAction;
import bluej.pkgmgr.actions.CheckExtensionsAction;
import bluej.pkgmgr.actions.CheckVersionAction;
import bluej.pkgmgr.actions.CloseProjectAction;
import bluej.pkgmgr.actions.CompileAction;
import bluej.pkgmgr.actions.CompileSelectedAction;
import bluej.pkgmgr.actions.EndTestRecordAction;
import bluej.pkgmgr.actions.ExportProjectAction;
import bluej.pkgmgr.actions.GenerateDocsAction;
import bluej.pkgmgr.actions.HelpAboutAction;
import bluej.pkgmgr.actions.ImportProjectAction;
import bluej.pkgmgr.actions.InteractiveTutorialAction;
import bluej.pkgmgr.actions.NewCSSAction;
import bluej.pkgmgr.actions.NewClassAction;
import bluej.pkgmgr.actions.NewInheritsAction;
import bluej.pkgmgr.actions.NewPackageAction;
import bluej.pkgmgr.actions.NewProjectAction;
import bluej.pkgmgr.actions.OnlineDocAction;
import bluej.pkgmgr.actions.OpenArchiveAction;
import bluej.pkgmgr.actions.OpenNonBlueJAction;
import bluej.pkgmgr.actions.OpenProjectAction;
import bluej.pkgmgr.actions.PkgMgrAction;
import bluej.pkgmgr.actions.PreferencesAction;
import bluej.pkgmgr.actions.PrintAction;
import bluej.pkgmgr.actions.QuitAction;
import bluej.pkgmgr.actions.RebuildAction;
import bluej.pkgmgr.actions.RemoveAction;
import bluej.pkgmgr.actions.RestartVMAction;
import bluej.pkgmgr.actions.RunTestsAction;
import bluej.pkgmgr.actions.SaveProjectAction;
import bluej.pkgmgr.actions.SaveProjectAsAction;
import bluej.pkgmgr.actions.ShowCopyrightAction;
import bluej.pkgmgr.actions.StandardAPIHelpAction;
import bluej.pkgmgr.actions.UseLibraryAction;
import bluej.pkgmgr.actions.WebsiteAction;
import bluej.pkgmgr.print.PackagePrintManager;
import bluej.pkgmgr.target.CSSTarget;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.PackageTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.role.UnitTestClassRole;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.terminal.Terminal;
import bluej.testmgr.TestDisplayFrame;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.BlueJFileReader;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.TriangleArrow;
import bluej.utility.javafx.UnfocusableScrollPane;
import bluej.utility.javafx.UntitledCollapsiblePane;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javafx.animation.Animation;
import javafx.animation.FillTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.Styleable;
import javafx.embed.swing.SwingNode;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.print.PrinterJob;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TitledPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

public class PkgMgrFrame
implements BlueJEventListener {
    private static @OnThread(value=Tag.Any) PkgMgrFrame recentFrame = null;
    private static final AtomicInteger nextTestIdentifier = new AtomicInteger(0);
    private static final @OnThread(value=Tag.Any, requireSynchronized=true) List<PkgMgrFrame> frames = new ArrayList<PkgMgrFrame>();
    private static final ExtensionsManager extMgr = ExtensionsManager.getInstance();
    private @OnThread(value=Tag.FXPlatform) TitledPane testPanel;
    private @OnThread(value=Tag.FXPlatform) TitledPane teamPanel;
    private @OnThread(value=Tag.FX) Label statusbar;
    private @OnThread(value=Tag.Any) ActivityIndicator progressbar;
    private @OnThread(value=Tag.FX) Label testStatusMessage;
    private @OnThread(value=Tag.FXPlatform) Label recordingLabel;
    private final @OnThread(value=Tag.Any) EndTestRecordAction endTestRecordAction = new EndTestRecordAction(this);
    private final @OnThread(value=Tag.Any) CancelTestRecordAction cancelTestRecordAction = new CancelTestRecordAction(this);
    private ClassTarget testTarget = null;
    private String testTargetMethod;
    private int testIdentifier = 0;
    private @OnThread(value=Tag.FX) Menu recentProjectsMenu;
    private final @OnThread(value=Tag.FXPlatform) SimpleObjectProperty<ExtensionsMenuManager> toolsMenuManager;
    private Menu teamMenu;
    private MenuItem shareProjectMenuItem;
    private MenuItem teamSettingsMenuItem;
    private MenuItem showLogMenuItem;
    private MenuItem updateMenuItem;
    private MenuItem commitMenuItem;
    private MenuItem statusMenuItem;
    private @OnThread(value=Tag.FX) ButtonBase updateButton;
    private @OnThread(value=Tag.FX) ButtonBase commitButton;
    private @OnThread(value=Tag.FX) ButtonBase teamStatusButton;
    private @OnThread(value=Tag.FX) ButtonBase teamShareButton;
    private TeamActionGroup teamActions;
    private BooleanProperty projectOpenProperty = new SimpleBooleanProperty(false);
    private final @OnThread(value=Tag.FX) List<Node> itemsToDisable = new ArrayList<Node>();
    private final @OnThread(value=Tag.FX) List<MenuItem> menuItemsToDisable = new ArrayList<MenuItem>();
    private final List<PkgMgrAction> actionsToDisable = new ArrayList<PkgMgrAction>();
    private @OnThread(value=Tag.Any) MachineIcon machineIcon;
    private final PkgMgrAction closeProjectAction = new CloseProjectAction(this);
    private final PkgMgrAction saveProjectAction = new SaveProjectAction(this);
    private final PkgMgrAction saveProjectAsAction = new SaveProjectAsAction(this);
    private final PkgMgrAction importProjectAction = new ImportProjectAction(this);
    private final PkgMgrAction exportProjectAction = new ExportProjectAction(this);
    private final PkgMgrAction printAction = new PrintAction(this);
    private final @OnThread(value=Tag.Any) PkgMgrAction newClassAction = new NewClassAction(this);
    private final PkgMgrAction newPackageAction = new NewPackageAction(this);
    private final PkgMgrAction newCSSAction = new NewCSSAction(this);
    private final PkgMgrAction addClassAction = new AddClassAction(this);
    private final PkgMgrAction removeAction = new RemoveAction(this);
    private final @OnThread(value=Tag.Any) PkgMgrAction newInheritsAction = new NewInheritsAction(this);
    private final @OnThread(value=Tag.Any) PkgMgrAction compileAction = new CompileAction(this);
    private final PkgMgrAction compileSelectedAction = new CompileSelectedAction(this);
    private final PkgMgrAction rebuildAction = new RebuildAction(this);
    private final @OnThread(value=Tag.Any) RestartVMAction restartVMAction = new RestartVMAction(this);
    private final PkgMgrAction useLibraryAction = new UseLibraryAction(this);
    private final PkgMgrAction generateDocsAction = new GenerateDocsAction(this);
    private final @OnThread(value=Tag.Any) PkgMgrAction runTestsAction = new RunTestsAction(this);
    private final @OnThread(value=Tag.FXPlatform) ObjectProperty<Package> pkg = new SimpleObjectProperty(null);
    private @OnThread(value=Tag.Any) PackageEditor editor = null;
    private @OnThread(value=Tag.Any) ObjectBench objbench;
    private @OnThread(value=Tag.FXPlatform) CodePad codePad;
    private final @OnThread(value=Tag.FXPlatform) SimpleBooleanProperty showingDebugger;
    private final @OnThread(value=Tag.FXPlatform) SimpleBooleanProperty showingTextEval;
    private final @OnThread(value=Tag.FXPlatform) SimpleBooleanProperty showingTerminal;
    private final @OnThread(value=Tag.FXPlatform) SimpleBooleanProperty showingTestResults;
    private @OnThread(value=Tag.FXPlatform) LibraryCallDialog libraryCallDialog = null;
    private ExportManager exporter;
    private final @OnThread(value=Tag.FX) Property<Stage> stageProperty;
    private final @OnThread(value=Tag.FX) Property<BorderPane> paneProperty;
    private @OnThread(value=Tag.FXPlatform) VBox toolPanel;
    private @OnThread(value=Tag.FXPlatform) EventHandler<MouseEvent> editorMousePressed;
    private @OnThread(value=Tag.FXPlatform) ScrollPane pkgEditorScrollPane;
    private @OnThread(value=Tag.Any) SimpleBooleanProperty showUsesProperty;
    private @OnThread(value=Tag.Any) SimpleBooleanProperty showInheritsProperty;
    private @OnThread(value=Tag.FX) SplitPane bottomPane;
    private @OnThread(value=Tag.FX) double bottomPaneLastDividerPos = 0.6;
    private @OnThread(value=Tag.FX) Pane bottomOverlay;
    private @OnThread(value=Tag.Any) SwingNode dummySwingNode;
    private @OnThread(value=Tag.FX) SplitPane topBottomSplit;
    private final @OnThread(value=Tag.Any) MouseTrackingOverlayPane topOverlay = new MouseTrackingOverlayPane();
    private @OnThread(value=Tag.FX) UntitledCollapsiblePane teamAndTestFoldout;
    private @OnThread(value=Tag.FX) BooleanExpression teamShowSharedButtons;
    private AboutDialogTemplate aboutDialog = null;

    private PkgMgrFrame() {
        this.stageProperty = new SimpleObjectProperty(null);
        this.paneProperty = new SimpleObjectProperty(null);
        this.showingTextEval = new SimpleBooleanProperty(false);
        this.showingDebugger = new SimpleBooleanProperty(false);
        this.showingTerminal = new SimpleBooleanProperty(false);
        this.showingTestResults = new SimpleBooleanProperty(false);
        this.showUsesProperty = new SimpleBooleanProperty(true);
        this.showInheritsProperty = new SimpleBooleanProperty(true);
        this.toolsMenuManager = new SimpleObjectProperty(null);
        if (!Config.isGreenfoot()) {
            this.teamActions = new TeamActionGroup(false);
            this.teamActions.setAllDisabled();
            this.setupActionDisableSet();
            this.makeFrame();
            this.setStatus("BlueJ 5.1.0");
            Stage stage = new Stage();
            BlueJTheme.setWindowIconFX(stage);
            this.objbench = new ObjectBench(this);
            this.addCtrlTabShortcut(this.objbench);
            this.itemsToDisable.add((Node)this.objbench);
            BorderPane topPane = new BorderPane();
            this.pkgEditorScrollPane = new UnfocusableScrollPane(null);
            this.pkgEditorScrollPane.setVisible(false);
            JavaFXUtil.addChangeListenerAndCallNow(this.pkgEditorScrollPane.contentProperty(), newVal -> this.pkgEditorScrollPane.setVisible(newVal != null));
            this.pkgEditorScrollPane.setFitToWidth(true);
            this.pkgEditorScrollPane.setFitToHeight(true);
            Label emptyProjectMessage = new Label(Config.getString("pkgmgr.noProjectOpened.message"));
            JavaFXUtil.addStyleClass((Styleable)emptyProjectMessage, "pmf-empty-project-msg");
            StackPane centralPane = new StackPane(new Node[]{emptyProjectMessage, this.pkgEditorScrollPane});
            JavaFXUtil.addStyleClass((Styleable)centralPane, "pmf-central-pane");
            topPane.setCenter((Node)centralPane);
            topPane.setLeft((Node)this.toolPanel);
            final TriangleArrow triangleLabel = new TriangleArrow(Orientation.HORIZONTAL);
            JavaFXUtil.addStyleClass((Styleable)triangleLabel, "codepad-fold-arrow");
            StackPane.setAlignment((Node)triangleLabel, (Pos)Pos.CENTER_RIGHT);
            StackPane.setMargin((Node)triangleLabel, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
            triangleLabel.setOnMouseClicked(e -> this.showingTextEval.set(!this.showingTextEval.get()));
            JavaFXUtil.addChangeListenerAndCallNow(this.showingTextEval, newVal -> triangleLabel.scaleProperty().set(newVal != false ? -1.0 : 1.0));
            FXPlatformRunnable addScrollBarListener = new FXPlatformRunnable(){

                @Override
                @OnThread(value=Tag.FXPlatform)
                public void run() {
                    Region scrollBar = (Region)PkgMgrFrame.this.objbench.lookup(".scroll-bar:horizontal");
                    if (scrollBar == null) {
                        JavaFXUtil.runAfterCurrent(this);
                        return;
                    }
                    FXConsumer<Object> update = showing -> JavaFXUtil.runPlatformLater(() -> {
                        if (scrollBar.isVisible()) {
                            StackPane.setMargin((Node)triangleLabel, (Insets)new Insets(0.0, 5.0 + scrollBar.getWidth(), 0.0, 0.0));
                        } else {
                            StackPane.setMargin((Node)triangleLabel, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
                        }
                    });
                    JavaFXUtil.addChangeListener(scrollBar.visibleProperty(), update);
                    JavaFXUtil.addChangeListener(scrollBar.widthProperty(), update);
                }
            };
            JavaFXUtil.runAfterCurrent(addScrollBarListener);
            this.bottomOverlay = new Pane();
            this.bottomOverlay.setMouseTransparent(true);
            this.bottomPane = new SplitPane(new Node[]{new StackPane(new Node[]{this.objbench, triangleLabel})});
            this.bottomPane.setOrientation(Orientation.HORIZONTAL);
            this.bottomPane.getDividers().addListener(c -> {
                c.next();
                if (c.wasAdded()) {
                    ((SplitPane.Divider)c.getAddedSubList().get(0)).setPosition(1.0);
                    double eventualMinWidth = this.codePad.getMinWidth();
                    this.codePad.setMinWidth(0.0);
                    Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)((SplitPane.Divider)c.getAddedSubList().get(0)).positionProperty(), (Object)this.bottomPaneLastDividerPos)})});
                    t.setOnFinished(e -> this.codePad.setMinWidth(eventualMinWidth));
                    t.play();
                }
            });
            StackPane bottomPaneAndOverlay = new StackPane(new Node[]{this.bottomPane, this.bottomOverlay});
            SplitPane.setResizableWithParent((Node)bottomPaneAndOverlay, (Boolean)false);
            StackPane topPaneAndOverlay = new StackPane(new Node[]{topPane, this.topOverlay});
            SplitPane.setResizableWithParent((Node)topPaneAndOverlay, (Boolean)false);
            JavaFXUtil.runAfter(Duration.seconds((double)5.0), () -> SplitPane.setResizableWithParent((Node)topPaneAndOverlay, (Boolean)true));
            this.topBottomSplit = new SplitPane(new Node[]{topPaneAndOverlay, bottomPaneAndOverlay});
            JavaFXUtil.addStyleClass((Styleable)this.topBottomSplit, "top-bottom-split");
            this.topBottomSplit.setOrientation(Orientation.VERTICAL);
            this.topBottomSplit.setDividerPositions(new double[]{0.8});
            EventHandler<MouseEvent> handler = new EventHandler<MouseEvent>(){
                public ObjectProperty<Cursor> cursorProperty;
                private boolean isResizingBoth;

                @OnThread(value=Tag.FXPlatform)
                public void handle(MouseEvent e) {
                    if (this.cursorProperty == null) {
                        this.cursorProperty = PkgMgrFrame.this.topBottomSplit.lookup(".top-bottom-split > .split-pane-divider").cursorProperty();
                    }
                    if (PkgMgrFrame.this.codePad == null) {
                        this.cursorProperty.set((Object)Cursor.V_RESIZE);
                        this.isResizingBoth = false;
                        return;
                    }
                    if (e.getEventType() == MouseEvent.MOUSE_MOVED) {
                        Bounds bounds = ((Node)PkgMgrFrame.this.bottomPane.getItems().get(0)).localToScene(((Node)PkgMgrFrame.this.bottomPane.getItems().get(0)).getBoundsInLocal());
                        double sceneX = bounds.getMaxX();
                        double sceneY = bounds.getMinY();
                        if (e.getSceneX() >= sceneX - 1.0 && e.getSceneX() <= sceneX + 8.0 && e.getSceneY() >= sceneY - 5.0 && e.getSceneY() <= sceneY + 5.0) {
                            this.isResizingBoth = true;
                            this.cursorProperty.set((Object)(!Config.isMacOS() ? Cursor.MOVE : Cursor.CROSSHAIR));
                        } else {
                            this.isResizingBoth = false;
                            this.cursorProperty.set((Object)Cursor.V_RESIZE);
                        }
                    } else if (e.getEventType() == MouseEvent.MOUSE_DRAGGED && this.isResizingBoth) {
                        Bounds bottomBounds = PkgMgrFrame.this.bottomPane.localToScene(PkgMgrFrame.this.bottomPane.getBoundsInLocal());
                        PkgMgrFrame.this.bottomPane.setDividerPositions(new double[]{(e.getSceneX() - bottomBounds.getMinX()) / bottomBounds.getWidth()});
                    }
                }
            };
            this.topBottomSplit.addEventFilter(MouseEvent.MOUSE_MOVED, (EventHandler)handler);
            this.topBottomSplit.addEventFilter(MouseEvent.MOUSE_DRAGGED, (EventHandler)handler);
            BorderPane contentRoot = new BorderPane((Node)this.topBottomSplit);
            JavaFXUtil.addStyleClass((Styleable)contentRoot, "pmf-root");
            this.statusbar = new Label();
            BorderPane.setAlignment((Node)this.statusbar, (Pos)Pos.CENTER_LEFT);
            BorderPane statusArea = new BorderPane();
            BorderPane.setMargin((Node)statusArea, (Insets)new Insets(2.0, 0.0, 0.0, 0.0));
            statusArea.setCenter((Node)this.statusbar);
            this.testStatusMessage = new Label();
            JavaFXUtil.addStyleClass((Styleable)this.testStatusMessage, "test-status-message");
            JavaFXUtil.addChangeListenerAndCallNow(this.testStatusMessage.textProperty(), newVal -> {
                this.testStatusMessage.setManaged(!newVal.isEmpty());
                this.testStatusMessage.setVisible(!newVal.isEmpty());
            });
            BorderPane.setAlignment((Node)this.testStatusMessage, (Pos)Pos.CENTER_LEFT);
            statusArea.setLeft((Node)this.testStatusMessage);
            this.progressbar = new ActivityIndicator();
            this.progressbar.setRunning(false);
            statusArea.setRight((Node)new HBox(new Node[]{this.progressbar, this.machineIcon}));
            contentRoot.setBottom((Node)statusArea);
            BorderPane rootPlusMenu = new BorderPane((Node)contentRoot);
            Scene scene = new Scene((Parent)rootPlusMenu);
            Config.addPMFStylesheets(scene);
            stage.setScene(scene);
            stage.setWidth(800.0);
            stage.setHeight(600.0);
            JavaFXUtil.addMacMinimiseShortcutHandler(stage);
            this.stageProperty.setValue((Object)stage);
            this.paneProperty.setValue((Object)rootPlusMenu);
            JavaFXUtil.runAfterCurrent(() -> {
                if (stage.getX() < 0.0) {
                    stage.setX(10.0);
                }
                if (stage.getY() < 0.0) {
                    stage.setY(10.0);
                }
                stage.show();
                Utility.bringToFrontFX((Window)stage);
            });
            if (this.showingTextEval.get()) {
                this.showHideTextEval(true);
            }
            JavaFXUtil.addChangeListener(this.showingTextEval, this::showHideTextEval);
            this.pkg.addListener((prop, oldPkg, newPkg) -> JavaFXUtil.runNowOrLater(() -> {
                if (oldPkg != null) {
                    this.showingDebugger.unbindBidirectional((Property)oldPkg.getProject().debuggerShowing());
                    this.showingTerminal.unbindBidirectional((Property)oldPkg.getProject().terminalShowing());
                }
                if (newPkg != null) {
                    this.showingDebugger.bindBidirectional((Property)newPkg.getProject().debuggerShowing());
                    this.showingTerminal.bindBidirectional((Property)newPkg.getProject().terminalShowing());
                }
            }));
            this.showingTestResults.bindBidirectional((Property)TestDisplayFrame.showingProperty());
            this.updateWindow();
            if (this.isEmptyFrame()) {
                this.enableFunctions(false);
            }
        } else {
            this.objbench = new ObjectBench(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PkgMgrFrame createFrame() {
        PkgMgrFrame frame = new PkgMgrFrame();
        BlueJEvent.addListener(frame);
        Class<PkgMgrFrame> clazz = PkgMgrFrame.class;
        synchronized (PkgMgrFrame.class) {
            frames.add(frame);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            JavaFXUtil.onceNotNull(frame.stageProperty, stage -> JavaFXUtil.addChangeListener(stage.focusedProperty(), focused -> {
                if (focused.booleanValue()) {
                    recentFrame = frame;
                }
            }));
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @OnThread(value=Tag.FXPlatform)
    public static PkgMgrFrame createFrame(Package aPkg, PkgMgrFrame parentWindow) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(aPkg);
        if (pmf != null) return pmf;
        if (PkgMgrFrame.frameCount() == 1) {
            Class<PkgMgrFrame> clazz = PkgMgrFrame.class;
            // MONITORENTER : bluej.pkgmgr.PkgMgrFrame.class
            pmf = frames.get(0);
            // MONITOREXIT : clazz
        }
        if (pmf == null || !pmf.isEmptyFrame()) {
            pmf = PkgMgrFrame.createFrame();
        }
        pmf.openPackage(aPkg, parentWindow);
        return pmf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.FXPlatform)
    public static void closeFrame(PkgMgrFrame frame) {
        if (!frame.isEmptyFrame()) {
            throw new IllegalArgumentException();
        }
        Class<PkgMgrFrame> clazz = PkgMgrFrame.class;
        synchronized (PkgMgrFrame.class) {
            frames.remove(frame);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            BlueJEvent.removeListener(frame);
            PrefMgr.setFlag("bluej.startWithTextEval", frame.showingTextEval.get());
            Stage window = frame.getWindow();
            if (window != null) {
                window.hide();
            }
            return;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static synchronized PkgMgrFrame findFrame(Package aPkg) {
        for (PkgMgrFrame pmf : frames) {
            if (pmf.isEmptyFrame() || pmf.getPackage() != aPkg) continue;
            return pmf;
        }
        return null;
    }

    @OnThread(value=Tag.Any)
    public static synchronized int frameCount() {
        return frames.size();
    }

    @OnThread(value=Tag.Any)
    public static synchronized PkgMgrFrame[] getAllFrames() {
        PkgMgrFrame[] openFrames = new PkgMgrFrame[frames.size()];
        frames.toArray(openFrames);
        return openFrames;
    }

    public static PkgMgrFrame[] getAllProjectFrames(Project proj) {
        return PkgMgrFrame.getAllProjectFrames(proj, "");
    }

    public static PkgMgrFrame[] getAllProjectFrames(Project proj, String pkgPrefix) {
        ArrayList<PkgMgrFrame> list = new ArrayList<PkgMgrFrame>();
        String pkgPrefixWithDot = pkgPrefix + ".";
        for (PkgMgrFrame pmf : PkgMgrFrame.getAllFrames()) {
            if (pmf.isEmptyFrame() || pmf.getProject() != proj) continue;
            String fullName = pmf.getPackage().getQualifiedName();
            if (fullName.startsWith(pkgPrefixWithDot)) {
                list.add(pmf);
                continue;
            }
            if (!fullName.equals(pkgPrefix) && pkgPrefix.length() != 0) continue;
            list.add(pmf);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new PkgMgrFrame[list.size()]);
    }

    public static PkgMgrFrame getMostRecent() {
        if (recentFrame != null) {
            return recentFrame;
        }
        PkgMgrFrame[] allFrames = PkgMgrFrame.getAllFrames();
        if (allFrames.length < 1) {
            return null;
        }
        PkgMgrFrame mostRecent = allFrames[0];
        return mostRecent;
    }

    public static void handleAbout() {
        new HelpAboutAction(PkgMgrFrame.getMostRecent()).actionPerformed(PkgMgrFrame.getMostRecent());
    }

    public static void handlePreferences() {
        new PreferencesAction(PkgMgrFrame.getMostRecent()).actionPerformed(PkgMgrFrame.getMostRecent());
    }

    public static void handleQuit() {
        new QuitAction(PkgMgrFrame.getMostRecent()).actionPerformed(PkgMgrFrame.getMostRecent());
    }

    public static void displayMessage(String message) {
        for (PkgMgrFrame frame : PkgMgrFrame.getAllFrames()) {
            frame.setStatus(message);
        }
    }

    public static void displayMessage(Package sourcePkg, String message) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            pmf.setStatus(message);
        }
    }

    public static void displayMessage(Project sourceProj, String message) {
        PkgMgrFrame[] pmf = PkgMgrFrame.getAllProjectFrames(sourceProj);
        if (pmf != null) {
            for (PkgMgrFrame pmf1 : pmf) {
                if (pmf1 == null) continue;
                pmf1.setStatus(message);
            }
        }
    }

    public static void showError(Package sourcePkg, String msgId) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            DialogManager.showErrorFX((Window)pmf.getWindow(), msgId);
        }
    }

    public static void showMessage(Package sourcePkg, String msgId) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            DialogManager.showMessageFX((Window)pmf.getWindow(), msgId, new String[0]);
        }
    }

    public static void showMessageWithText(Package sourcePkg, String msgId, String text) {
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(sourcePkg);
        if (pmf != null) {
            DialogManager.showMessageWithTextFX((Window)pmf.getWindow(), msgId, text);
        }
    }

    public static boolean doOpen(File projectPath, PkgMgrFrame pmf) {
        boolean createdNewFrame = false;
        if (pmf == null && frames.size() > 0) {
            pmf = frames.get(0);
        } else if (pmf == null) {
            pmf = PkgMgrFrame.createFrame();
            createdNewFrame = true;
        }
        boolean openedProject = false;
        if (projectPath != null) {
            if (projectPath.isDirectory() || Project.isProject(projectPath.toString())) {
                if (pmf.openProject(projectPath.getAbsolutePath())) {
                    openedProject = true;
                }
            } else if (pmf.openArchive(projectPath)) {
                openedProject = true;
            }
        }
        if (createdNewFrame && !openedProject) {
            PkgMgrFrame.closeFrame(pmf);
        }
        return openedProject;
    }

    public static void closeProject(Project project) {
        PkgMgrFrame[] allFrames = PkgMgrFrame.getAllProjectFrames(project);
        if (allFrames != null) {
            for (PkgMgrFrame allFrame : allFrames) {
                allFrame.doClose(true, true);
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void openPackage(Package aPkg, PkgMgrFrame parentWindow) {
        if (this.pkg.get() != null) {
            this.closePackage();
        }
        this.pkg.set((Object)aPkg);
        if (!Config.isGreenfoot()) {
            this.editor = new PackageEditor(this, aPkg, (BooleanProperty)this.showUsesProperty, (BooleanProperty)this.showInheritsProperty, this.topOverlay);
            this.pkgEditorScrollPane.setContent((Node)this.editor);
            this.editor.setOnDragOver(event -> {
                Dragboard db = event.getDragboard();
                if (db.hasFiles()) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                } else {
                    event.consume();
                }
            });
            this.editor.setOnDragDropped(event -> {
                Dragboard db = event.getDragboard();
                boolean success = false;
                if (db.hasFiles()) {
                    success = true;
                    this.addFiles(db.getFiles());
                }
                event.setDropCompleted(success);
                event.consume();
            });
            this.editorMousePressed = e -> this.clearStatus();
            this.editor.addEventFilter(MouseEvent.MOUSE_PRESSED, this.editorMousePressed);
            this.editor.startMouseListening();
            this.addCtrlTabShortcut(this.editor);
            aPkg.setEditor(this.editor);
            Properties p = aPkg.getLastSavedProperties();
            try {
                String x_str = p.getProperty("package.editor.x", parentWindow == null ? "30" : "-1");
                String y_str = p.getProperty("package.editor.y", parentWindow == null ? "30" : "-1");
                int x = Integer.parseInt(x_str);
                int y = Integer.parseInt(y_str);
                String width = p.getProperty("package.frame.width");
                String height = p.getProperty("package.frame.height");
                String mainDivPos = p.getProperty("package.divider.vertical");
                String bottomDivPos = p.getProperty("package.divider.horizontal");
                JavaFXUtil.onceNotNull(this.stageProperty, s -> {
                    Point2D location = Config.ensureOnScreen(x, y);
                    if (location == null || x == -1 || y == -1) {
                        if (parentWindow != null) {
                            s.setX(((Stage)parentWindow.stageProperty.getValue()).getX() + 20.0);
                            s.setY(((Stage)parentWindow.stageProperty.getValue()).getY() + 20.0);
                        }
                    } else {
                        s.setX(location.getX());
                        s.setY(location.getY());
                    }
                    if (width != null && height != null) {
                        s.setWidth((double)Integer.parseInt(width));
                        s.setHeight((double)Integer.parseInt(height));
                    } else {
                        s.setWidth(800.0);
                        s.setHeight(600.0);
                    }
                    if (mainDivPos != null) {
                        this.topBottomSplit.setDividerPositions(new double[]{Double.parseDouble(mainDivPos)});
                    } else {
                        this.topBottomSplit.setDividerPositions(new double[]{0.8});
                    }
                    if (bottomDivPos != null) {
                        if (this.bottomPane.getDividers().size() == 1) {
                            this.bottomPane.setDividerPositions(new double[]{Double.parseDouble(bottomDivPos)});
                        } else {
                            this.bottomPaneLastDividerPos = Double.parseDouble(bottomDivPos);
                        }
                    }
                });
            }
            catch (NumberFormatException e2) {
                Debug.reportError("Could not read preferred project screen position");
            }
            String uses_str = p.getProperty("package.showUses", "true");
            String extends_str = p.getProperty("package.showExtends", "true");
            this.editor.setShowUses(uses_str.equals("true"));
            this.editor.setShowExtends(extends_str.equals("true"));
            this.editor.requestFocus();
            this.updateWindow();
            this.enableFunctions(true);
            this.setVisible(true);
            Package pkgFinal = aPkg;
            ((ExtensionsMenuManager)this.toolsMenuManager.get()).setMenuGenerator(new ToolsExtensionMenu(pkgFinal));
            ((ExtensionsMenuManager)this.toolsMenuManager.get()).addExtensionMenu(pkgFinal.getProject());
            this.teamActions = aPkg.getProject().getTeamActions();
            this.resetTeamActions();
            this.projectOpenProperty.set(true);
            this.commitMenuItem.textProperty().unbind();
            if (aPkg.getProject().getTeamSettingsController() != null) {
                this.commitMenuItem.setText(Config.getString("team.menu.commitPush"));
            } else {
                this.commitMenuItem.setText(Config.getString("team.menu.commit"));
            }
            aPkg.getProject().scheduleCompilation(true, CompileReason.LOADED, Config.isGreenfoot() ? CompileType.INDIRECT_USER_COMPILE : CompileType.ERROR_CHECK_ONLY, aPkg);
        }
        extMgr.packageOpened(aPkg);
    }

    private void resetTeamActions() {
        this.teamActions.getStatusAction().useButton(this, this.teamStatusButton);
        this.teamActions.getUpdateAction().useButton(this, this.updateButton);
        this.teamActions.getCommitCommentAction().useButton(this, this.commitButton);
        this.teamActions.getShareAction().useButton(this, this.teamShareButton);
        this.teamShareButton.textProperty().unbind();
        this.teamShareButton.setText(Config.getString("team.share.short"));
        this.teamActions.getTeamSettingsAction().useMenuItem(this, this.teamSettingsMenuItem);
        this.teamActions.getShareAction().useMenuItem(this, this.shareProjectMenuItem);
        this.teamActions.getStatusAction().useMenuItem(this, this.statusMenuItem);
        this.teamActions.getCommitCommentAction().useMenuItem(this, this.commitMenuItem);
        this.commitMenuItem.textProperty().unbind();
        this.commitMenuItem.setText(Config.getString("team.menu.commit"));
        this.teamActions.getUpdateAction().useMenuItem(this, this.updateMenuItem);
        this.updateMenuItem.textProperty().unbind();
        this.updateMenuItem.setText(Config.getString("team.menu.update"));
        this.teamActions.getShowLogAction().useMenuItem(this, this.showLogMenuItem);
    }

    @OnThread(value=Tag.FXPlatform)
    public void closePackage() {
        if (this.isEmptyFrame()) {
            return;
        }
        Package thePkg = this.getPackage();
        extMgr.packageClosing(thePkg);
        if (!Config.isGreenfoot()) {
            ((ExtensionsMenuManager)this.toolsMenuManager.get()).setMenuGenerator(new ToolsExtensionMenu(thePkg));
            ObjectBench bench = this.getObjectBench();
            String uniqueId = this.getProject().getUniqueId();
            bench.removeAllObjects(uniqueId);
            this.clearTextEval();
            if (this.codePad != null) {
                this.codePad.setDisable(true);
            }
            PackageEditor oldEd = this.editor;
            oldEd.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.editorMousePressed);
            this.pkgEditorScrollPane.setContent(null);
            this.teamActions = new TeamActionGroup(false);
            this.enableFunctions(false);
        }
        this.getPackage().closeAllEditors();
        this.getPackage().setEditor(null);
        DataCollector.packageClosed(thePkg);
        Project proj = this.getProject();
        this.editor = null;
        this.pkg.set(null);
        if (PkgMgrFrame.getAllProjectFrames(proj) == null) {
            Project.cleanUp(proj);
        }
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            JavaFXUtil.onceNotNull(this.stageProperty, Window::hide);
        } else if (!Config.isGreenfoot()) {
            JavaFXUtil.onceNotNull(this.stageProperty, s -> {
                s.show();
                Utility.bringToFrontFX((Window)s);
            });
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public Package getPackage() {
        return (Package)this.pkg.get();
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized Project getProject() {
        return this.pkg.get() == null ? null : ((Package)this.pkg.get()).getProject();
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized boolean isEmptyFrame() {
        return this.pkg.get() == null;
    }

    @OnThread(value=Tag.FXPlatform)
    private void updateWindowTitle() {
        if (this.isEmptyFrame()) {
            this.setTitle("BlueJ");
        } else {
            String title = Config.getString("pkgmgr.title") + this.getProject().getProjectName();
            if (!this.getPackage().isUnnamedPackage()) {
                title = title + "  [" + this.getPackage().getQualifiedName() + "]";
            }
            if (this.getProject().isTeamProject()) {
                title = title + " (" + Config.getString("team.project.marker") + ")";
            }
            this.setTitle(title);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void setTitle(String title) {
        JavaFXUtil.onceNotNull(this.stageProperty, stage -> stage.setTitle(title));
    }

    @OnThread(value=Tag.FXPlatform)
    private void updateWindow() {
        if (this.isEmptyFrame()) {
            // empty if block
        }
        this.updateWindowTitle();
    }

    @OnThread(value=Tag.Any)
    public final void setStatus(String status) {
        JavaFXUtil.runNowOrLater(() -> {
            if (this.statusbar != null) {
                this.statusbar.setText(status);
            }
        });
    }

    @OnThread(value=Tag.Any)
    public void startProgress() {
        JavaFXUtil.runNowOrLater(() -> this.progressbar.setRunning(true));
    }

    @OnThread(value=Tag.Any)
    public void stopProgress() {
        JavaFXUtil.runNowOrLater(() -> this.progressbar.setRunning(false));
    }

    @OnThread(value=Tag.Any)
    public void clearStatus() {
        JavaFXUtil.runNowOrLater(() -> {
            if (this.statusbar != null) {
                this.statusbar.setText(" ");
            }
        });
    }

    public void setWaitCursor(boolean wait) {
        Stage stage = (Stage)this.stageProperty.getValue();
        if (stage != null) {
            stage.getScene().setCursor((Cursor)(wait ? Cursor.WAIT : null));
        }
    }

    public ObjectBench getObjectBench() {
        return this.objbench;
    }

    @OnThread(value=Tag.FXPlatform)
    public CodePad getCodePad() {
        return this.codePad;
    }

    protected void putObjectOnBench(Window srcWindow, DebuggerObject gotObj, GenTypeClass iType, InvokerRecord ir, boolean askForName, Optional<Point2D> animateFromScenePoint) {
        String name = this.getProject().getDebugger().guessNewName(gotObj);
        boolean tryAgain = true;
        do {
            String newObjectName;
            String string = newObjectName = askForName ? DialogManager.askStringFX(srcWindow, "getobject-new-name", name) : name;
            if (newObjectName == null) {
                tryAgain = false;
                continue;
            }
            if (JavaNames.isIdentifier(newObjectName)) {
                DataCollector.benchGet(this.getPackage(), newObjectName, gotObj.getClassName(), this.getTestIdentifier());
                this.putObjectOnBench(newObjectName, gotObj, iType, ir, animateFromScenePoint);
                tryAgain = false;
                continue;
            }
            DialogManager.showErrorFX(srcWindow, "must-be-identifier");
        } while (tryAgain);
    }

    public void recordInteraction(InvokerRecord ir) {
        this.getObjectBench().addInteraction(ir);
    }

    public int getTestIdentifier() {
        return this.testIdentifier;
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean newProject(String dirName) {
        if (Project.createNewProject(dirName)) {
            Project proj = Project.openProject(dirName);
            Package unNamedPkg = proj.getPackage("");
            if (this.isEmptyFrame()) {
                this.openPackage(unNamedPkg, this);
            } else {
                PkgMgrFrame pmf = PkgMgrFrame.createFrame(unNamedPkg, this);
                pmf.setVisible(true);
            }
            return true;
        }
        return false;
    }

    public File[] importProjectDir(File dir, boolean showFailureDialog) {
        File[] fails = FileUtility.recursiveCopyFile(dir, this.getPackage().getPath());
        if (fails != null && showFailureDialog) {
            ImportFailedDialog importFailedDlg = new ImportFailedDialog((Window)this.getWindow(), Arrays.asList(fails));
            importFailedDlg.showAndWait();
        }
        List<File> dirsToConvert = Import.findInterestingDirectories(this.getPackage().getPath());
        Import.convertDirectory(dirsToConvert);
        this.getProject().reloadAll();
        return fails;
    }

    public boolean createNewClass(String name, String template, SourceType sourceType, boolean showErr, double x, double y) {
        boolean success;
        Package thePkg = this.getPackage();
        if (thePkg.getTarget(name) != null) {
            DialogManager.showErrorFX((Window)this.getWindow(), "duplicate-name");
            return false;
        }
        String[] conflict = new String[1];
        Class<?> c = thePkg.loadClass(thePkg.getQualifiedName(name));
        if (c != null && !Package.checkClassMatchesFile(c, new File(this.getPackage().getPath(), name + ".class"))) {
            boolean shouldContinue;
            conflict[0] = Package.getResourcePath(c);
            boolean bl = shouldContinue = DialogManager.askQuestionFX((Window)this.getWindow(), "class-library-conflict", conflict) != 0;
            if (!shouldContinue) {
                return false;
            }
        }
        ClassTarget target = new ClassTarget(thePkg, name, template);
        if (template != null && !(success = target.generateSkeleton(template, sourceType))) {
            return false;
        }
        thePkg.addTarget(target);
        if (this.editor != null) {
            if (x == -1.0) {
                this.editor.findSpaceForVertex(target);
            } else {
                target.setPos((int)x, (int)y);
            }
            JavaFXUtil.scrollTo(this.pkgEditorScrollPane, target.getNode());
        }
        if (target.getRole() instanceof UnitTestClassRole) {
            thePkg.compileQuiet(target, CompileReason.NEW_CLASS, CompileType.INDIRECT_USER_COMPILE);
        }
        DataCollector.addClass(thePkg, target);
        return true;
    }

    public void duplicateClass(String originalClassName, String newClassName, File originalFile, SourceType sourceType) {
        try {
            String extension = sourceType.getExtension();
            File newFile = new File(originalFile.getParentFile(), newClassName + "." + extension);
            Hashtable<String, String> translations = new Hashtable<String, String>();
            ((Dictionary)translations).put(originalClassName, newClassName);
            BlueJFileReader.duplicateFile(originalFile, newFile, translations);
            ClassTarget target = this.getPackage().addClass(newClassName);
            this.getPackage().addTarget(target);
            if (this.editor != null) {
                this.editor.findSpaceForVertex(target);
                JavaFXUtil.scrollTo(this.pkgEditorScrollPane, target.getNode());
            }
            target.analyseSource();
            DataCollector.addClass(this.getPackage(), target);
        }
        catch (IOException e) {
            Debug.reportError("Error in duplicating a class: ", e);
        }
    }

    public void doNewProject() {
        String title = Config.getString("pkgmgr.newPkg.title");
        File newnameFile = FileUtility.getSaveProjectFX(this.getProject(), (Window)this.getWindow(), title);
        if (newnameFile == null) {
            return;
        }
        if (!this.newProject(newnameFile.getAbsolutePath())) {
            DialogManager.showErrorWithTextFX(null, "cannot-create-directory", newnameFile.getPath());
        }
    }

    public void doOpen() {
        File choice = FileUtility.getOpenProjectFX((Window)this.getWindow());
        if (choice != null) {
            PkgMgrFrame.doOpen(choice, this);
        }
    }

    public void doOpenNonBlueJ() {
        File choice = FileUtility.getOpenDirFX((Window)this.getWindow(), Config.getString("pkgmgr.openNonBlueJPkg.title"), true);
        if (choice != null) {
            PkgMgrFrame.doOpenNonBlueJ(choice, this);
        }
    }

    public void doOpenArchive() {
        File archiveFile = FileUtility.getOpenArchiveFX((Window)this.getWindow(), null, true);
        PkgMgrFrame.doOpen(archiveFile, this);
    }

    private boolean openProject(String projectPath) {
        Project openProj = Project.openProject(projectPath);
        if (openProj == null) {
            DialogManager.showErrorFX((Window)this.getWindow(), "could-not-open-project");
            return false;
        }
        Package initialPkg = openProj.getPackage(openProj.getInitialPackageName());
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(initialPkg);
        if (pmf == null) {
            if (this.isEmptyFrame()) {
                pmf = this;
                this.openPackage(initialPkg, this);
            } else {
                pmf = PkgMgrFrame.createFrame(initialPkg, this);
            }
            pmf.projectOpenProperty.set(true);
        }
        pmf.setVisible(true);
        if (openProj.isSharedSVNProject()) {
            NoSVNSupportDialog dialog = new NoSVNSupportDialog((Window)pmf.getWindow());
            dialog.initModality(Modality.APPLICATION_MODAL);
            Optional result = dialog.showAndWait();
            if (result.get() == dialog.getDialogPane().getButtonTypes().get(0)) {
                openProj.removeSVNInfos();
            } else {
                this.teamMenu.setDisable(true);
                this.teamShareButton.visibleProperty().unbind();
                this.teamShareButton.disableProperty().unbind();
                this.teamShareButton.setDisable(true);
            }
        }
        if (Config.isGreenfoot()) {
            for (PkgMgrFrame pkgMgrFrame : PkgMgrFrame.getAllFrames()) {
                if (!Config.isGreenfootStartupProject(pkgMgrFrame.getProject().getProjectDir())) continue;
                pkgMgrFrame.doClose(false, false);
                break;
            }
        }
        return true;
    }

    public static void doOpenNonBlueJ(File dirName, PkgMgrFrame pmf) {
        File absDirName = dirName.getAbsoluteFile();
        if (!absDirName.exists()) {
            DialogManager.showErrorFX((Window)pmf.getWindow(), "file-does-not-exist");
            return;
        }
        if (absDirName.isDirectory()) {
            if (Project.isProject(absDirName.getPath())) {
                DialogManager.showErrorFX((Window)pmf.getWindow(), "open-non-bluej-already-bluej");
                return;
            }
            if (!Import.convertNonBlueJ(pmf::getWindow, absDirName)) {
                return;
            }
            pmf.openProject(absDirName.getPath());
        }
    }

    private boolean openArchive(File archive) {
        File oPath = Utility.maybeExtractArchive(archive, this::getWindow);
        if (oPath == null) {
            return false;
        }
        if (!oPath.isDirectory()) {
            return false;
        }
        for (File file : oPath.listFiles()) {
            if (!file.isDirectory() || file.getName().equals("__MACOSX") || !Project.isProject(file.getPath())) continue;
            return this.openProject(file.getPath());
        }
        if (Project.isProject(oPath.getPath())) {
            return this.openProject(oPath.getPath());
        }
        if (Import.convertNonBlueJ(this::getWindow, oPath)) {
            return this.openProject(oPath.getPath());
        }
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    public void doClose(boolean keepLastFrame, boolean doSave) {
        if (doSave) {
            this.doSave();
        }
        if (keepLastFrame) {
            this.projectOpenProperty.set(false);
            this.teamActions.setAllDisabled();
        }
        if (PkgMgrFrame.frameCount() == 1) {
            if (keepLastFrame && !Config.isGreenfoot()) {
                this.closePackage();
                this.updateWindow();
                if (this.codePad != null) {
                    this.codePad.clearHistoryView();
                }
                ((ExtensionsMenuManager)this.toolsMenuManager.get()).addExtensionMenu(null);
            } else {
                Main.doQuit();
            }
        } else {
            this.closePackage();
            PkgMgrFrame.closeFrame(this);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized void doSave() {
        Properties p;
        if (this.isEmptyFrame()) {
            return;
        }
        if (((Package)this.pkg.get()).isUnnamedPackage()) {
            p = this.getProject().getProjectPropertiesCopy();
            this.getProject().saveEditorLocations(p);
            this.getProject().getImportScanner().saveCachedImports();
        } else {
            p = new Properties();
        }
        if (!Config.isGreenfoot()) {
            p.put("package.editor.width", Integer.toString((int)this.pkgEditorScrollPane.getViewportBounds().getWidth()));
            p.put("package.editor.height", Integer.toString((int)this.pkgEditorScrollPane.getViewportBounds().getHeight()));
            p.put("objectbench.width", Integer.toString((int)this.objbench.getViewportBounds().getWidth()));
            p.put("objectbench.height", Integer.toString((int)this.objbench.getViewportBounds().getHeight()));
            p.put("package.editor.x", Integer.toString((int)Math.max(((Stage)this.stageProperty.getValue()).getX(), 0.0)));
            p.put("package.editor.y", Integer.toString((int)Math.max(((Stage)this.stageProperty.getValue()).getY(), 0.0)));
            p.put("package.frame.width", Integer.toString((int)((Stage)this.stageProperty.getValue()).getWidth()));
            p.put("package.frame.height", Integer.toString((int)((Stage)this.stageProperty.getValue()).getHeight()));
            p.put("package.divider.vertical", Double.toString(this.topBottomSplit.getDividerPositions()[0]));
            if (this.bottomPane.getDividers().size() == 1) {
                p.put("package.divider.horizontal", Double.toString(this.bottomPane.getDividerPositions()[0]));
            } else {
                p.put("package.divider.horizontal", Double.toString(this.bottomPaneLastDividerPos));
            }
            p.put("package.showUses", Boolean.toString(this.showUsesProperty.get()));
            p.put("package.showExtends", Boolean.toString(this.showInheritsProperty.get()));
        }
        ((Package)this.pkg.get()).save(p);
    }

    public void doImport() {
        File importDir = FileUtility.getOpenDirFX((Window)this.getWindow(), Config.getString("pkgmgr.importPkg.title"), false);
        if (importDir == null) {
            return;
        }
        if (!importDir.isDirectory()) {
            return;
        }
        if (this.isEmptyFrame()) {
            return;
        }
        this.importProjectDir(importDir, true);
    }

    public void doAddFromFile() {
        List<File> classes = FileUtility.getMultipleFilesFX((Window)this.getWindow(), Config.getString("pkgmgr.addClass.title"), FileUtility.getJavaStrideSourceFilterFX());
        if (classes == null || classes.isEmpty()) {
            return;
        }
        this.importFromFile(classes);
    }

    public void addFiles(List<File> classes) {
        this.importFromFile(classes);
    }

    private void importFromFile(List<File> classes) {
        HashMap<Integer, String> errorNames = new HashMap<Integer, String>();
        errorNames.put(1, "file-does-not-exist");
        errorNames.put(2, "cannot-import");
        errorNames.put(4, "duplicate-name");
        errorNames.put(3, "error-in-import");
        for (File cls : classes) {
            int result = this.getPackage().importFile(cls);
            if (!errorNames.containsKey(result)) continue;
            DialogManager.showErrorWithTextFX((Window)this.getWindow(), (String)errorNames.get(result), cls.getName());
        }
    }

    public void doExport() {
        if (this.exporter == null) {
            this.exporter = new ExportManager(this);
        }
        this.exporter.export();
    }

    public void doPrint() {
        Optional choices = new PrintDialog((Window)this.getWindow(), this.getPackage(), true).showAndWait();
        if (!choices.isPresent()) {
            return;
        }
        PrinterJob job = JavaFXUtil.createPrinterJob();
        if (job == null) {
            DialogManager.showErrorFX((Window)this.getWindow(), "print-no-printers");
            return;
        }
        if (!job.showPrintDialog((Window)this.getWindow())) {
            return;
        }
        PackagePrintManager printManager = new PackagePrintManager(job, this, (PrintDialog.PrintChoices)choices.get());
        printManager.start();
        printManager.showDialogAndWait();
    }

    public void showPreferences() {
        PrefMgrDialog.showDialog(this.getProject());
    }

    public void aboutBlueJ() {
        Image image;
        String[] translatorNames = new String[]{"Afrikaans", "Petri Jooste", "Arabic", "Abdelkader Zitouni", "Catalan", "Santiago Manrique", "Chinese", "Ma Wing Ho and Biao Ma", "Czech", "Rudolf Pecinovsk\u00fd", "Danish", "Jacob Nordfalk", "Dutch", "Kris Coolsaet", "French", "Laurent Pierron", "German", "Michael K\u00f6lling, Stefan Mueller, Thomas R\u00f6fer, and Martin Schleyer", "Greek", "Ioannis G. Baltopoulos", "Hindi", "Tajvir Singh", "Italian", "Angelo Papadia and Luzio Menna", "Montenegrin", "Omer Djokic", "Persian", "M. Shahdoost", "Portuguese", "Marco Aurelio Souza Mangan, Fabio Hedayioglu, and Fred Guedes Pereira", "Russian", "Sergey Zemlyannikov", "Slovak", "Roman Horv\u00e1th", "Spanish", "Aldo Mettini, Viviana Marcela Alvarez Tom\u00e9, and Jos\u00e9 Ram\u00f3n Puente Lerma", "Swedish", "Daniel Norrman"};
        String[] previousTeamMembers = new String[]{"Amjad Altadmri", "Damiano Bolla", "Hamza Hamza", "Fabio Hedayioglu", "Poul Henriksen", "Davin McCall", "Clive Miller", "Andrew Patterson", "Bruce Quig", "John Rosenberg", "Phil Stevens", "Ian Utting", "Cecilia Vargas", "Marion Zalk"};
        URL splashImageURL = Boot.class.getResource("gen-bluej-splash.png");
        Image image2 = image = splashImageURL == null ? null : new Image(splashImageURL.toString());
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialogTemplate(this.getWindow().getOwner(), "5.1.0", "https://www.bluej.org/", image, translatorNames, previousTeamMembers);
            this.aboutDialog.showAndWait();
        } else if (!this.aboutDialog.isShowing()) {
            this.aboutDialog.showAndWait();
        }
    }

    public void showCopyright() {
        DialogManager.showTextFX((Window)this.getWindow(), String.join((CharSequence)"\n", "BlueJ \u00a9 2000-2022 Michael K\u00f6lling, John Rosenberg.", "", Config.getString("menu.help.copyright.line1"), Config.getString("menu.help.copyright.line2"), Config.getString("menu.help.copyright.line3"), Config.getString("menu.help.copyright.line4")));
    }

    protected void callStaticMethodOrConstructor(CallableView cv) {
        BluejResultWatcher watcher = null;
        if (cv instanceof ConstructorView) {
            watcher = new BluejResultWatcher(this.getPackage(), this, cv){

                @Override
                public void beginCompile() {
                    PkgMgrFrame.this.setStatus(Config.getString("pkgmgr.creating"));
                    super.beginCompile();
                }

                @Override
                protected void nonNullResult(DebuggerObject result, String name, InvokerRecord ir) {
                    ObjectWrapper wrapper = ObjectWrapper.getWrapper(PkgMgrFrame.this, PkgMgrFrame.this.getObjectBench(), result, result.getGenType(), name);
                    PkgMgrFrame.this.getObjectBench().addObject(wrapper);
                    PkgMgrFrame.this.getPackage().getDebugger().addObject(((Package)PkgMgrFrame.this.pkg.get()).getId(), wrapper.getName(), result);
                }

                @Override
                public void putError(String msg, InvokerRecord ir) {
                    PkgMgrFrame.this.setStatus("");
                    super.putError(msg, ir);
                }

                @Override
                public void putException(ExceptionDescription exception, InvokerRecord ir) {
                    super.putException(exception, ir);
                    PkgMgrFrame.this.setStatus("");
                }

                @Override
                public void putVMTerminated(InvokerRecord ir, boolean terminatedByUserCode) {
                    super.putVMTerminated(ir, terminatedByUserCode);
                    PkgMgrFrame.this.setStatus("");
                }

                @Override
                protected void addInteraction(InvokerRecord ir) {
                    PkgMgrFrame.this.getObjectBench().addInteraction(ir);
                }
            };
        } else if (cv instanceof MethodView) {
            final MethodView mv = (MethodView)cv;
            watcher = new BluejResultWatcher(this.getPackage(), this, cv){
                private final ExpressionInformation expressionInformation;
                {
                    super(pkg, pmf, method);
                    this.expressionInformation = new ExpressionInformation(mv, mv.getName());
                }

                @Override
                public void beginCompile() {
                    PkgMgrFrame.this.setWaitCursor(true);
                    if (mv.isMain()) {
                        PkgMgrFrame.this.getProject().removeClassLoader();
                        PkgMgrFrame.this.getProject().newRemoteClassLoaderLeavingBreakpoints();
                    }
                }

                @Override
                protected void nonNullResult(DebuggerObject result, String name, InvokerRecord ir) {
                    Project project = PkgMgrFrame.this.getProject();
                    Package pkg = PkgMgrFrame.this.getPackage();
                    project.getResultInspectorInstance(result, name, pkg, ir, this.expressionInformation, (Window)PkgMgrFrame.this.getWindow());
                }

                @Override
                protected void addInteraction(InvokerRecord ir) {
                    PkgMgrFrame.this.getObjectBench().addInteraction(ir);
                }
            };
        }
        if (this.checkDebuggerState()) {
            new Invoker(this, cv, watcher).invokeInteractive();
        }
    }

    protected void openPackageTarget(String newname) {
        Package p = this.getPackage().getProject().getPackage(newname);
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(p);
        if (pmf == null) {
            pmf = PkgMgrFrame.createFrame(p, this);
        }
        pmf.setVisible(true);
    }

    protected void objectBenchToTestFixture(ClassTarget target) {
        if (target.getRole() instanceof UnitTestClassRole) {
            UnitTestClassRole utcr = (UnitTestClassRole)target.getRole();
            utcr.doBenchToFixture(this, target);
        }
    }

    protected void testFixtureToObjectBench(ClassTarget target) {
        if (target.getRole() instanceof UnitTestClassRole) {
            UnitTestClassRole utcr = (UnitTestClassRole)target.getRole();
            utcr.doFixtureToBench(this, target);
        }
    }

    protected void makeTestCase(ClassTarget target) {
        if (target.getRole() instanceof UnitTestClassRole) {
            UnitTestClassRole utcr = (UnitTestClassRole)target.getRole();
            this.teamAndTestFoldout.expandedProperty().set(true);
            utcr.doMakeTestCase(this, target);
        }
    }

    public String putObjectOnBench(String newInstanceName, DebuggerObject object, GenTypeClass iType, InvokerRecord ir, Optional<Point2D> animateFromScenePoint) {
        if (!object.isNullObject()) {
            ObjectWrapper wrapper = ObjectWrapper.getWrapper(this, this.getObjectBench(), object, iType, newInstanceName);
            this.getObjectBench().addObject(wrapper, animateFromScenePoint);
            newInstanceName = wrapper.getName();
            this.getPackage().getDebugger().addObject(this.getPackage().getId(), newInstanceName, object);
            if (ir != null) {
                ir.setBenchName(newInstanceName, wrapper.getTypeName());
            }
            return newInstanceName;
        }
        return null;
    }

    public void doCreateNewClass(double x, double y) {
        SourceType sourceType = ((Package)this.pkg.get()).getDefaultSourceType();
        NewClassDialog dlg = new NewClassDialog((Window)this.getWindow(), sourceType);
        Optional result = dlg.showAndWait();
        result.ifPresent(info -> this.createNewClass(info.className, info.templateName, info.sourceType, true, x, y));
    }

    public void doCreateNewCSS(double x, double y) {
        NewCSSDialog dlg = new NewCSSDialog((Window)this.stageProperty.getValue());
        Optional fileName = dlg.showAndWait();
        fileName.ifPresent(name -> this.createNewCSS((String)name, x, y));
    }

    public void doCreateNewPackage(double x, double y) {
        NewPackageDialog dlg = new NewPackageDialog((Window)this.stageProperty.getValue());
        Optional pkgName = dlg.showAndWait();
        pkgName.ifPresent(name -> this.createNewPackage((String)name, true, x, y));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createNewPackage(String name, boolean showErrDialog, double x, double y) {
        String fullName = name.indexOf(46) > -1 ? name : this.getPackage().getQualifiedName(name);
        String prefix = JavaNames.getPrefix(fullName);
        String base = JavaNames.getBase(fullName);
        Package basePkg = this.getProject().getPackage(prefix);
        if (basePkg != null && basePkg.getTarget(base) != null) {
            if (showErrDialog) {
                DialogManager.showErrorFX((Window)this.getWindow(), "duplicate-name");
            }
            return false;
        }
        this.getProject().createPackageDirectory(fullName);
        Package newPackage = this.getProject().getPackage(fullName);
        if (newPackage == null) {
            Debug.reportError("creation of new package failed unexpectedly");
            return false;
        }
        for (newPackage = newPackage.getParent(); newPackage != null; newPackage = newPackage.getParent()) {
            newPackage.reload();
        }
        PkgMgrFrame pkgMgrFrame = this;
        synchronized (pkgMgrFrame) {
            for (Target t : ((Package)this.pkg.get()).getVertices()) {
                PackageTarget pt;
                if (!(t instanceof PackageTarget) || !(pt = (PackageTarget)t).getQualifiedName().equals(fullName) || x == -1.0) continue;
                pt.setPos((int)x, (int)y);
            }
        }
        return true;
    }

    private void createNewCSS(String fileName, double x, double y) {
        if (this.getProject().getTarget(fileName) != null) {
            DialogManager.showErrorFX((Window)this.getWindow(), "duplicate-name");
            return;
        }
        File cssFile = new File(this.getPackage().getPath(), fileName);
        try {
            cssFile.createNewFile();
        }
        catch (IOException e) {
            Debug.reportError(e);
        }
        CSSTarget target = new CSSTarget(this.getPackage(), cssFile);
        target.setPos((int)x, (int)y);
        if (this.editor != null && x == -1.0) {
            this.editor.findSpaceForVertex(target);
        }
        this.getPackage().addTarget(target);
    }

    public void doRemove() {
        Package pkgFinal = this.getPackage();
        String pkgId = pkgFinal.getId();
        if (this.editor.targetHasFocus()) {
            if (!this.doRemoveTargets(pkgFinal) && !this.editor.doRemoveDependency()) {
                DialogManager.showErrorFX((Window)this.getWindow(), "no-class-selected");
            }
        } else if (this.objbench.objectHasFocus()) {
            this.objbench.removeSelectedObject(pkgId);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private boolean doRemoveTargets(Package thePkg) {
        List<Target> targets = thePkg.getSelectedTargets();
        if (targets.size() <= 0) {
            return false;
        }
        if (this.askRemoveClass()) {
            for (Target target : targets) {
                target.remove();
            }
        }
        return true;
    }

    public void doTest() {
        this.runTestsAction.setAvailable(false);
        Terminal terminal = this.getPackage().getProject().getTerminal();
        if (terminal.clearOnMethodCall()) {
            terminal.clear();
        }
        List<ClassTarget> l = this.getPackage().getTestTargets();
        int numTests = 0;
        ListIterator<ClassTarget> i = l.listIterator();
        while (i.hasNext()) {
            ClassTarget ct = i.next();
            if (ct.isCompiled() && !ct.isAbstract()) {
                UnitTestClassRole utcr = (UnitTestClassRole)ct.getRole();
                numTests += utcr.getTestCount(ct);
                continue;
            }
            i.remove();
        }
        Iterator<ClassTarget> it = l.iterator();
        int numTestsFinal = numTests;
        Project projFinal = this.getProject();
        TestDisplayFrame.getTestDisplay().startMultipleTests(projFinal, numTestsFinal);
        TestRunnerThread trt = new TestRunnerThread(this, it);
        trt.start();
    }

    public void endTestRun() {
        TestDisplayFrame.getTestDisplay().endMultipleTests();
        this.runTestsAction.setAvailable(true);
    }

    public void doEndTest() {
        if (this.testTarget != null) {
            this.testRecordingEnded();
            DataCollector.endTestMethod(this.getPackage(), this.testIdentifier);
            if (this.testTarget.getRole() instanceof UnitTestClassRole) {
                UnitTestClassRole utcr = (UnitTestClassRole)this.testTarget.getRole();
                utcr.doEndMakeTestCase(this, this.testTarget, this.testTargetMethod);
            }
            this.getPackage().compileQuiet(this.testTarget, CompileReason.MODIFIED, CompileType.INDIRECT_USER_COMPILE);
            this.getProject().removeClassLoader();
            this.getProject().newRemoteClassLoaderLeavingBreakpoints();
            this.testTarget = null;
        }
    }

    public void doCancelTest() {
        this.testRecordingEnded();
        DataCollector.cancelTestMethod(this.getPackage(), this.testIdentifier);
        this.getProject().removeClassLoader();
        this.getProject().newRemoteClassLoaderLeavingBreakpoints();
        this.testTarget = null;
    }

    public void testRecordingStarted(String message) {
        this.testStatusMessage.setText(message);
        this.recordingLabel.setDisable(false);
        this.endTestRecordAction.setEnabled(true);
        this.cancelTestRecordAction.setEnabled(true);
        this.getProject().setTestMode(true);
    }

    private void testRecordingEnded() {
        this.testStatusMessage.setText("");
        this.recordingLabel.setDisable(true);
        this.endTestRecordAction.setEnabled(false);
        this.cancelTestRecordAction.setEnabled(false);
        Project proj = this.getProject();
        if (proj != null) {
            proj.setTestMode(false);
        }
    }

    public void setTestInfo(String testName, ClassTarget testClass) {
        this.testTargetMethod = testName;
        this.testTarget = testClass;
        this.testIdentifier = nextTestIdentifier.incrementAndGet();
        DataCollector.startTestMethod(this.getPackage(), this.testIdentifier, testClass.getSourceFile(), testName);
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean askRemoveClass() {
        int response = DialogManager.askQuestionFX((Window)this.getWindow(), "really-remove-class");
        return response == 0;
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean askRemoveFiles() {
        int response = DialogManager.askQuestionFX((Window)this.getWindow(), "really-remove-files");
        return response == 0;
    }

    public void compileSelected() {
        Package thePkg = this.getPackage();
        List<Target> targets = thePkg.getSelectedTargets();
        if (targets.size() > 0) {
            for (Target target : targets) {
                ClassTarget t;
                if (!(target instanceof ClassTarget) || !(t = (ClassTarget)target).hasSourceCode()) continue;
                thePkg.compile(t, CompileReason.USER, CompileType.EXPLICIT_USER_COMPILE);
            }
        } else {
            DialogManager.showErrorFX((Window)this.getWindow(), "no-class-selected-compile");
        }
    }

    public void callLibraryClass() {
        Package pkgRef = this.getPackage();
        BPClassLoader classLoader = this.getProject().getClassLoader();
        if (this.libraryCallDialog == null) {
            this.libraryCallDialog = new LibraryCallDialog((Window)this.getWindow(), pkgRef, classLoader);
        }
        this.libraryCallDialog.setResult(null);
        this.libraryCallDialog.requestfocus();
        Optional result = this.libraryCallDialog.showAndWait();
        result.ifPresent(viewToCall -> pkgRef.callStaticMethodOrConstructor((CallableView)viewToCall));
    }

    public void generateProjectDocumentation() {
        String message = this.getPackage().generateDocumentation();
        if (message.length() != 0) {
            DialogManager.showTextFX((Window)this.getWindow(), message);
        }
    }

    public boolean checkDebuggerState() {
        return ProjectUtils.checkDebuggerState(this.getProject(), this.getWindow());
    }

    public void restartDebugger() {
        if (!this.isEmptyFrame()) {
            this.getProject().restartVM();
            DataCollector.restartVM(this.getProject());
        }
    }

    public void updateSharedStatus(boolean shared) {
        this.updateWindow();
    }

    @OnThread(value=Tag.FXPlatform)
    private void showHideTextEval(boolean show) {
        if (show) {
            if (this.codePad == null) {
                this.codePad = new CodePad(this, this.bottomOverlay);
                this.addCtrlTabShortcut(this.codePad.getInputFieldPane());
                this.addCtrlTabShortcut(this.codePad.getHistoryPane());
                CodePad cpFinal = this.codePad;
                this.itemsToDisable.add((Node)cpFinal);
                this.bottomPane.getItems().add((Object)this.codePad);
                this.codePad.getInputFieldPane().getPkgMgrPaneNode().requestFocus();
            }
            this.codePad.setDisable(this.isEmptyFrame());
        } else {
            CodePad cpFinal = this.codePad;
            this.itemsToDisable.remove(cpFinal);
            this.bottomPaneLastDividerPos = ((SplitPane.Divider)this.bottomPane.getDividers().get(0)).getPosition();
            cpFinal.setMinWidth(0.0);
            Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)((SplitPane.Divider)this.bottomPane.getDividers().get(0)).positionProperty(), (Object)1.0)})});
            t.setOnFinished(e -> this.bottomPane.getItems().remove((Object)cpFinal));
            t.play();
            this.codePad = null;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void clearTextEval() {
        if (this.codePad != null) {
            this.codePad.clear();
        }
    }

    @Override
    public void blueJEvent(int eventId, Object arg, Project prj) {
        switch (eventId) {
            case 0: {
                this.setStatus(Config.getString("pkgmgr.creatingVM"));
                break;
            }
            case 2: {
                this.setStatus(Config.getString("pkgmgr.creatingVMDone"));
                break;
            }
            case 6: {
                this.setStatus(Config.getString("pkgmgr.generatingDocu"));
                break;
            }
            case 7: {
                this.setStatus(Config.getString("pkgmgr.docuGenerated"));
                break;
            }
            case 8: {
                this.setStatus(Config.getString("pkgmgr.docuAborted"));
                break;
            }
            case 1: {
                DialogManager.showErrorFX((Window)this.getWindow(), "error-create-vm");
            }
        }
    }

    public void setDebuggerState(int state) {
        switch (state) {
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                if (this.machineIcon == null) break;
                this.machineIcon.setIdle();
                break;
            }
            case 3: {
                if (this.machineIcon == null) break;
                this.machineIcon.setRunning();
                break;
            }
            case 4: {
                if (this.machineIcon == null) break;
                this.machineIcon.setStopped();
            }
        }
    }

    public String toString() {
        Object str = "PkgMgrFrame(): ";
        str = this.isEmptyFrame() ? (String)str + "empty" : (String)str + this.getPackage().toString() + " " + this.getProject().toString();
        return str;
    }

    public void showWebPage(String url) {
        SwingUtilities.invokeLater(() -> {
            boolean openedBrowser = Utility.openWebBrowser(url);
            Platform.runLater(() -> {
                if (openedBrowser) {
                    this.setStatus(Config.getString("pkgmgr.webBrowserMsg"));
                } else {
                    this.setStatus(Config.getString("pkgmgr.webBrowserError"));
                }
            });
        });
    }

    private void makeFrame() {
        this.setupMenus();
        UpdateDialogAction updateAction = this.teamActions.getUpdateAction();
        CommitCommentAction commitCommentAction = this.teamActions.getCommitCommentAction();
        StatusAction statusAction = this.teamActions.getStatusAction();
        ShareAction shareAction = this.teamActions.getShareAction();
        this.endTestRecordAction.setEnabled(false);
        this.cancelTestRecordAction.setEnabled(false);
        this.toolPanel = new VBox();
        JavaFXUtil.addStyleClass((Styleable)this.toolPanel, "pmf-tools");
        VBox topButtons = new VBox();
        JavaFXUtil.addStyleClass((Styleable)topButtons, "pmf-tools-top");
        topButtons.getChildren().add((Object)this.newClassAction.makeButton());
        Button imgExtendsButton = this.newInheritsAction.makeButton();
        imgExtendsButton.setText(null);
        SVGPath arrow = new SVGPath();
        arrow.setContent("M2 10 L22 10 L22 16 L32 10 L22 4 L22 10 Z");
        arrow.setFill(null);
        arrow.setStroke((Paint)Color.BLACK);
        imgExtendsButton.setGraphic((Node)arrow);
        topButtons.getChildren().add((Object)imgExtendsButton);
        Button compileButton = this.compileAction.makeButton();
        JavaFXUtil.addStyleClass((Styleable)compileButton, "compile-button");
        topButtons.getChildren().add((Object)compileButton);
        this.toolPanel.getChildren().add((Object)topButtons);
        this.dummySwingNode = new SwingNode();
        SwingUtilities.invokeLater(() -> this.dummySwingNode.setContent((JComponent)new JLabel("")));
        this.dummySwingNode.setFocusTraversable(false);
        this.toolPanel.getChildren().add((Object)this.dummySwingNode);
        Pane space = new Pane();
        VBox.setVgrow((Node)space, (Priority)Priority.ALWAYS);
        this.toolPanel.getChildren().add((Object)space);
        this.testPanel = new TitledPane();
        this.testPanel.setFocusTraversable(false);
        JavaFXUtil.addStyleClass((Styleable)this.testPanel, "pmf-tools-test");
        this.testPanel.setText(Config.getString("pkgmgr.test.title"));
        VBox testPanelItems = new VBox();
        JavaFXUtil.addStyleClass((Styleable)testPanelItems, "pmf-tools-test-items");
        this.testPanel.setContent((Node)testPanelItems);
        Button runButton = this.runTestsAction.makeButton();
        runButton.setText(Config.getString("pkgmgr.test.run"));
        testPanelItems.getChildren().add((Object)runButton);
        Ellipse recordingIcon = new Ellipse(7.0, 7.0);
        recordingIcon.setFill((Paint)Color.RED);
        this.recordingLabel = new Label(Config.getString("pkgmgr.test.record"), (Node)recordingIcon);
        this.recordingLabel.disabledProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){
            private Animation pulseAnimation;
            final /* synthetic */ Shape val$recordingIcon;
            {
                this.val$recordingIcon = shape;
            }

            @OnThread(value=Tag.FX)
            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (this.pulseAnimation != null) {
                    this.pulseAnimation.stop();
                    this.pulseAnimation = null;
                }
                if (!newValue.booleanValue()) {
                    this.pulseAnimation = new FillTransition(Duration.millis((double)2000.0), this.val$recordingIcon, new Color(1.0, 0.2, 0.2, 1.0), Color.DARKRED);
                    this.pulseAnimation.setAutoReverse(true);
                    this.pulseAnimation.setCycleCount(-1);
                    this.pulseAnimation.playFromStart();
                } else {
                    this.val$recordingIcon.setFill((Paint)Color.DARKGRAY);
                }
            }
        });
        this.recordingLabel.setDisable(true);
        testPanelItems.getChildren().add((Object)this.recordingLabel);
        Button endTestButton = this.endTestRecordAction.makeButton();
        endTestButton.setText(Config.getString("pkgmgr.test.end"));
        testPanelItems.getChildren().add((Object)((Node)JavaFXUtil.withStyleClass(new VBox(new Node[]{endTestButton}), "pmf-tools-test-recording-button")));
        Button cancelTestButton = this.cancelTestRecordAction.makeButton();
        cancelTestButton.setText(Config.getString("cancel"));
        testPanelItems.getChildren().add((Object)((Node)JavaFXUtil.withStyleClass(new VBox(new Node[]{cancelTestButton}), "pmf-tools-test-recording-button")));
        this.teamPanel = new TitledPane();
        this.teamPanel.setFocusTraversable(false);
        this.teamPanel.setText(Config.getString("pkgmgr.team.title"));
        JavaFXUtil.addStyleClass((Styleable)this.teamPanel, "pmf-tools-team");
        VBox teamPanelItemsOnceShared = new VBox();
        JavaFXUtil.addStyleClass((Styleable)teamPanelItemsOnceShared, "pmf-tools-team-items");
        teamPanelItemsOnceShared.setPickOnBounds(false);
        VBox teamPanelItemsUnshared = new VBox();
        JavaFXUtil.addStyleClass((Styleable)teamPanelItemsUnshared, "pmf-tools-team-items");
        teamPanelItemsUnshared.setPickOnBounds(false);
        this.teamPanel.setContent((Node)new StackPane(new Node[]{teamPanelItemsUnshared, teamPanelItemsOnceShared}));
        this.updateButton = new Button();
        this.updateButton.setFocusTraversable(false);
        updateAction.useButton(this, this.updateButton);
        JavaFXUtil.addChangeListenerAndCallNow(this.updateButton.disableProperty(), newVal -> this.updateButton.setVisible(newVal == false));
        teamPanelItemsOnceShared.getChildren().add((Object)this.updateButton);
        this.commitButton = new Button();
        this.commitButton.setFocusTraversable(false);
        commitCommentAction.useButton(this, this.commitButton);
        JavaFXUtil.addChangeListenerAndCallNow(this.commitButton.disableProperty(), newVal -> this.commitButton.setVisible(newVal == false));
        teamPanelItemsOnceShared.getChildren().add((Object)this.commitButton);
        this.teamStatusButton = new Button();
        this.teamStatusButton.setFocusTraversable(false);
        statusAction.useButton(this, this.teamStatusButton);
        JavaFXUtil.addChangeListenerAndCallNow(this.teamStatusButton.disableProperty(), newVal -> this.teamStatusButton.setVisible(newVal == false));
        teamPanelItemsOnceShared.getChildren().add((Object)this.teamStatusButton);
        this.teamShareButton = new Button();
        this.teamShareButton.setFocusTraversable(false);
        shareAction.useButton(this, this.teamShareButton);
        JavaFXUtil.addChangeListenerAndCallNow(this.teamShareButton.disableProperty(), newVal -> this.teamShareButton.setVisible(newVal == false));
        teamPanelItemsUnshared.getChildren().add((Object)this.teamShareButton);
        this.teamShareButton.textProperty().unbind();
        this.teamShareButton.setText(Config.getString("team.share.short"));
        this.teamShowSharedButtons = this.teamShareButton.disableProperty().and((ObservableBooleanValue)this.teamStatusButton.disableProperty().not());
        teamPanelItemsOnceShared.managedProperty().bind((ObservableValue)this.teamShowSharedButtons);
        teamPanelItemsOnceShared.visibleProperty().bind((ObservableValue)this.projectOpenProperty);
        teamPanelItemsUnshared.visibleProperty().bind((ObservableValue)this.projectOpenProperty);
        VBox foldout = new VBox(new Node[]{this.teamPanel, this.testPanel});
        this.teamPanel.setCollapsible(false);
        this.teamPanel.setExpanded(true);
        this.testPanel.setCollapsible(false);
        this.testPanel.setExpanded(true);
        this.teamAndTestFoldout = new UntitledCollapsiblePane((Node)foldout, UntitledCollapsiblePane.ArrowLocation.TOP, !PrefMgr.getFlag("bluej.testing.showtools") && !PrefMgr.getFlag("bluej.teamwork.showtools")){

            @Override
            @OnThread(value=Tag.FX)
            protected double computeMinHeight(double width) {
                return 12.0;
            }
        };
        JavaFXUtil.addStyleClass((Styleable)foldout, "team-test-foldout-content");
        this.teamAndTestFoldout.addArrowWrapperStyleClass("pmf-triangle-foldout-wrapper");
        JavaFXUtil.addChangeListener(this.teamAndTestFoldout.expandedProperty(), expanded -> {
            PrefMgr.setFlag("bluej.teamwork.showtools", expanded);
            PrefMgr.setFlag("bluej.testing.showtools", expanded);
        });
        this.toolPanel.getChildren().add((Object)this.teamAndTestFoldout);
        this.machineIcon = new MachineIcon(this, this.restartVMAction);
        this.itemsToDisable.add((Node)this.machineIcon);
        if (PrefMgr.getFlag("bluej.startWithTextEval")) {
            this.showingTextEval.set(true);
        }
        JavaFXUtil.onceNotNull(this.stageProperty, stage -> stage.setOnCloseRequest(e -> this.doClose(false, true)));
    }

    private void setupMenus() {
        MenuBar menubar = new MenuBar();
        Menu menu = new Menu(Config.getMenuString("menu.package"));
        menubar.getMenus().add((Object)menu);
        menu.getItems().add((Object)new NewProjectAction(this).makeMenuItem());
        menu.getItems().add((Object)new OpenProjectAction(this).makeMenuItem());
        this.recentProjectsMenu = new Menu(Config.getMenuString("menu.package.openRecent"));
        this.recentProjectsMenu.setOnShowing(e -> this.updateRecentProjects());
        this.updateRecentProjects();
        menu.getItems().add((Object)this.recentProjectsMenu);
        menu.getItems().add((Object)new OpenNonBlueJAction(this).makeMenuItem());
        menu.getItems().add((Object)new OpenArchiveAction(this).makeMenuItem());
        menu.getItems().add((Object)this.closeProjectAction.makeMenuItem());
        menu.getItems().add((Object)this.saveProjectAction.makeMenuItem());
        menu.getItems().add((Object)this.saveProjectAsAction.makeMenuItem());
        menu.getItems().add((Object)new SeparatorMenuItem());
        menu.getItems().add((Object)this.importProjectAction.makeMenuItem());
        menu.getItems().add((Object)this.exportProjectAction.makeMenuItem());
        menu.getItems().add((Object)new SeparatorMenuItem());
        menu.getItems().add((Object)this.printAction.makeMenuItem());
        if (!Config.isMacOS()) {
            menu.getItems().add((Object)new SeparatorMenuItem());
            menu.getItems().add((Object)new QuitAction(this).makeMenuItem());
        }
        menu = new Menu(Config.getMenuString("menu.edit"));
        menubar.getMenus().add((Object)menu);
        menu.getItems().add((Object)this.newClassAction.makeMenuItem());
        menu.getItems().add((Object)this.newPackageAction.makeMenuItem());
        menu.getItems().add((Object)this.newCSSAction.makeMenuItem());
        menu.getItems().add((Object)this.addClassAction.makeMenuItem());
        menu.getItems().add((Object)this.removeAction.makeMenuItem());
        menu.getItems().add((Object)new SeparatorMenuItem());
        menu.getItems().add((Object)this.newInheritsAction.makeMenuItem());
        ExtensionsManager extMgr = ExtensionsManager.getInstance();
        Menu toolsMenu = new Menu(Config.getMenuString("menu.tools"));
        this.toolsMenuManager.set((Object)new ExtensionsMenuManager(toolsMenu, extMgr, null));
        toolsMenu.getItems().add((Object)this.compileAction.makeMenuItem());
        toolsMenu.getItems().add((Object)this.compileSelectedAction.makeMenuItem());
        toolsMenu.getItems().add((Object)this.rebuildAction.makeMenuItem());
        toolsMenu.getItems().add((Object)this.restartVMAction.makeMenuItem());
        toolsMenu.getItems().add((Object)new SeparatorMenuItem());
        toolsMenu.getItems().add((Object)this.useLibraryAction.makeMenuItem());
        toolsMenu.getItems().add((Object)this.generateDocsAction.makeMenuItem());
        Menu testingMenu = new Menu(Config.getString("menu.tools.testing"));
        testingMenu.getItems().add((Object)this.runTestsAction.makeMenuItem());
        testingMenu.getItems().add((Object)this.endTestRecordAction.makeMenuItem());
        testingMenu.getItems().add((Object)this.cancelTestRecordAction.makeMenuItem());
        toolsMenu.getItems().add((Object)testingMenu);
        this.teamMenu = new Menu(Config.getString("menu.tools.teamwork"));
        CheckoutAction checkoutAction = new CheckoutAction();
        MenuItem checkoutMenuItem = new MenuItem();
        checkoutAction.useMenuItem(this, checkoutMenuItem);
        this.shareProjectMenuItem = new MenuItem();
        this.teamActions.getShareAction().useMenuItem(this, this.shareProjectMenuItem);
        this.updateMenuItem = new MenuItem();
        this.teamActions.getUpdateAction().useMenuItem(this, this.updateMenuItem);
        this.updateMenuItem.textProperty().unbind();
        this.updateMenuItem.setText(Config.getString("team.menu.update"));
        this.commitMenuItem = new MenuItem();
        this.teamActions.getCommitCommentAction().useMenuItem(this, this.commitMenuItem);
        this.commitMenuItem.textProperty().unbind();
        this.commitMenuItem.setText(Config.getString("team.menu.commit"));
        this.statusMenuItem = new MenuItem();
        this.teamActions.getStatusAction().useMenuItem(this, this.statusMenuItem);
        this.showLogMenuItem = new MenuItem();
        this.teamActions.getShowLogAction().useMenuItem(this, this.showLogMenuItem);
        this.teamSettingsMenuItem = new MenuItem();
        this.teamActions.getTeamSettingsAction().useMenuItem(this, this.teamSettingsMenuItem);
        this.teamMenu.getItems().addAll((Object[])new MenuItem[]{checkoutMenuItem, this.shareProjectMenuItem, new SeparatorMenuItem(), this.updateMenuItem, this.commitMenuItem, this.statusMenuItem, this.showLogMenuItem, new SeparatorMenuItem(), this.teamSettingsMenuItem});
        toolsMenu.getItems().add((Object)this.teamMenu);
        if (!Config.isMacOS()) {
            toolsMenu.getItems().add((Object)new SeparatorMenuItem());
            toolsMenu.getItems().add((Object)new PreferencesAction(this).makeMenuItem());
        }
        if (PkgMgrFrame.frameCount() <= 1) {
            ((ExtensionsMenuManager)this.toolsMenuManager.get()).addExtensionMenu(null);
        }
        menubar.getMenus().add((Object)toolsMenu);
        Menu extensionsMenu = new Menu(Config.getMenuString("menu.view"));
        CheckMenuItem item = JavaFXUtil.makeCheckMenuItem(Config.getString("menu.view.showUses"), (Property<Boolean>)this.showUsesProperty, null);
        extensionsMenu.getItems().add((Object)item);
        this.menuItemsToDisable.add((MenuItem)item);
        item = JavaFXUtil.makeCheckMenuItem(Config.getString("menu.view.showInherits"), (Property<Boolean>)this.showInheritsProperty, null);
        extensionsMenu.getItems().add((Object)item);
        this.menuItemsToDisable.add((MenuItem)item);
        extensionsMenu.getItems().add((Object)new SeparatorMenuItem());
        extensionsMenu.getItems().add((Object)JavaFXUtil.makeCheckMenuItem(Config.getString("menu.view.showExecControls"), (Property<Boolean>)this.showingDebugger, Config.hasAcceleratorKey("menu.view.showExecControls") ? Config.getAcceleratorKeyFX("menu.view.showExecControls") : null));
        CheckMenuItem terminalItem = JavaFXUtil.makeCheckMenuItem(Config.getString("menu.view.showTerminal"), (Property<Boolean>)this.showingTerminal, (KeyCombination)new KeyCodeCombination(KeyCode.T, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        JavaFXUtil.addChangeListenerAndCallNow(this.pkg, newVal -> terminalItem.setDisable(newVal == null));
        extensionsMenu.getItems().add((Object)terminalItem);
        extensionsMenu.getItems().add((Object)JavaFXUtil.makeCheckMenuItem(Config.getString("menu.view.showTextEval"), (Property<Boolean>)this.showingTextEval, Config.hasAcceleratorKey("menu.view.showTextEval") ? Config.getAcceleratorKeyFX("menu.view.showTextEval") : null));
        if (this.teamAndTestFoldout != null) {
            extensionsMenu.getItems().add((Object)JavaFXUtil.makeCheckMenuItem(Config.getString("menu.view.showTeamTest"), (Property<Boolean>)this.teamAndTestFoldout.expandedProperty(), Config.hasAcceleratorKey("menu.view.showTeamTest") ? Config.getAcceleratorKeyFX("menu.view.showTeamTest") : null));
        }
        extensionsMenu.getItems().add((Object)JavaFXUtil.makeCheckMenuItem(Config.getString("menu.view.showTestDisplay"), (Property<Boolean>)this.showingTestResults, null));
        menubar.getMenus().add((Object)extensionsMenu);
        Menu menu2 = new Menu(Config.getMenuString("menu.help"));
        if (!Config.isMacOS()) {
            menu2.getItems().add((Object)new HelpAboutAction(this).makeMenuItem());
        }
        menu2.getItems().add((Object)new CheckVersionAction(this).makeMenuItem());
        menu2.getItems().add((Object)new CheckExtensionsAction(this).makeMenuItem());
        menu2.getItems().add((Object)new ShowCopyrightAction(this).makeMenuItem());
        menu2.getItems().add((Object)new SeparatorMenuItem());
        menu2.getItems().add((Object)new WebsiteAction(this).makeMenuItem());
        menu2.getItems().add((Object)new OnlineDocAction(this).makeMenuItem());
        menu2.getItems().add((Object)new InteractiveTutorialAction(this).makeMenuItem());
        menu2.getItems().add((Object)new StandardAPIHelpAction(this).makeMenuItem());
        this.addUserHelpItems(menu2);
        menubar.getMenus().add((Object)menu2);
        menubar.setUseSystemMenuBar(true);
        JavaFXUtil.onceNotNull(this.paneProperty, pane -> pane.setTop((Node)menubar));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void menuCall() {
        if (!this.isEmptyFrame()) {
            PkgMgrFrame pkgMgrFrame = this;
            synchronized (pkgMgrFrame) {
                PackageEditor pkgEd = ((Package)this.pkg.get()).getEditor();
                if (pkgEd != null) {
                    pkgEd.clearState();
                }
            }
        }
        this.clearStatus();
    }

    private void setupActionDisableSet() {
        this.actionsToDisable.add(this.closeProjectAction);
        this.actionsToDisable.add(this.saveProjectAction);
        this.actionsToDisable.add(this.saveProjectAsAction);
        this.actionsToDisable.add(this.importProjectAction);
        this.actionsToDisable.add(this.exportProjectAction);
        this.actionsToDisable.add(this.printAction);
        this.actionsToDisable.add(this.newClassAction);
        this.actionsToDisable.add(this.newPackageAction);
        this.actionsToDisable.add(this.newCSSAction);
        this.actionsToDisable.add(this.addClassAction);
        this.actionsToDisable.add(this.removeAction);
        this.actionsToDisable.add(this.newInheritsAction);
        this.actionsToDisable.add(this.compileAction);
        this.actionsToDisable.add(this.compileSelectedAction);
        this.actionsToDisable.add(this.rebuildAction);
        this.actionsToDisable.add(this.restartVMAction);
        this.actionsToDisable.add(this.useLibraryAction);
        this.actionsToDisable.add(this.generateDocsAction);
        this.actionsToDisable.add(this.runTestsAction);
    }

    private void addUserHelpItems(Menu menu) {
        String helpItems = Config.getPropString("bluej.help.items", "");
        if (helpItems != null && helpItems.length() > 0) {
            menu.getItems().add((Object)new SeparatorMenuItem());
            StringTokenizer t = new StringTokenizer(helpItems);
            while (t.hasMoreTokens()) {
                String itemID = t.nextToken();
                String itemName = Config.getPropString("bluej.help." + itemID + ".label");
                String itemURL = Config.getPropString("bluej.help." + itemID + ".url");
                MenuItem item = new MenuItem(itemName);
                item.setOnAction(e -> this.showWebPage(itemURL));
                menu.getItems().add((Object)item);
            }
        }
    }

    @OnThread(value=Tag.FX)
    private void updateRecentProjects() {
        this.recentProjectsMenu.getItems().clear();
        List<String> projects = PrefMgr.getRecentProjects();
        for (String projectToOpen : projects) {
            MenuItem item = new MenuItem(projectToOpen);
            this.recentProjectsMenu.getItems().add((Object)item);
            item.setOnAction(e -> {
                if (!this.openProject(projectToOpen)) {
                    this.setStatus(Config.getString("pkgmgr.error.open"));
                }
            });
        }
    }

    protected void enableFunctions(boolean enable) {
        if (!enable) {
            this.testRecordingEnded();
            this.teamActions.setAllDisabled();
        }
        for (Node node : this.itemsToDisable) {
            node.setDisable(!enable);
        }
        for (MenuItem menuItem : this.menuItemsToDisable) {
            menuItem.setDisable(!enable);
        }
        for (PkgMgrAction pkgMgrAction : this.actionsToDisable) {
            pkgMgrAction.setEnabled(enable);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void addCtrlTabShortcut(PkgMgrPane srcPane) {
        srcPane.getPkgMgrPaneNode().addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.TAB && e.isControlDown() || e.getCode() == KeyCode.F6) {
                ArrayList indexed;
                int currentFocused;
                LinkedHashMap<PkgMgrPane, Supplier<Boolean>> panes = new LinkedHashMap<PkgMgrPane, Supplier<Boolean>>();
                panes.put(this.editor, this::tryFocusClassDiagram);
                panes.put(this.objbench, this::tryFocusObjBench);
                if (this.codePad != null) {
                    panes.put(this.codePad.getHistoryPane(), () -> this.tryFocusCodePad(false));
                    panes.put(this.codePad.getInputFieldPane(), () -> this.tryFocusCodePad(true));
                }
                if ((currentFocused = Utility.findIndex(indexed = new ArrayList(panes.entrySet()), en -> ((PkgMgrPane)en.getKey()).getPkgMgrPaneNode() == srcPane.getPkgMgrPaneNode())) == -1) {
                    for (Map.Entry en2 : indexed) {
                        if (((Boolean)((Supplier)en2.getValue()).get()).booleanValue()) break;
                    }
                } else if (!e.isShiftDown()) {
                    int i = (currentFocused + 1) % indexed.size();
                    while (i != currentFocused && !((Boolean)((Supplier)indexed.get(i).getValue()).get()).booleanValue()) {
                        i = (i + 1) % indexed.size();
                    }
                } else {
                    int i = (currentFocused - 1 + indexed.size()) % indexed.size();
                    while (i != currentFocused && !((Boolean)((Supplier)indexed.get(i).getValue()).get()).booleanValue()) {
                        i = (i - 1 + indexed.size()) % indexed.size();
                    }
                }
                e.consume();
            }
        });
    }

    @OnThread(value=Tag.FXPlatform)
    private boolean tryFocusClassDiagram() {
        if (this.editor != null) {
            return this.editor.focusSelectedOrArbitrary();
        }
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    private boolean tryFocusCodePad(boolean inputField) {
        if (this.codePad != null) {
            if (inputField) {
                if (!this.codePad.isDisabled()) {
                    this.codePad.getInputFieldPane().getPkgMgrPaneNode().requestFocus();
                    return true;
                }
            } else {
                this.codePad.getHistoryPane().getPkgMgrPaneNode().requestFocus();
                return true;
            }
        }
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    private boolean tryFocusObjBench() {
        if (this.objbench.getObjectCount() > 0) {
            this.objbench.getObjects().get(0).requestFocus();
            return true;
        }
        return false;
    }

    @OnThread(value=Tag.FX)
    public Stage getWindow() {
        return (Stage)this.stageProperty.getValue();
    }

    void bringToFront() {
        Utility.bringToFrontFX((Window)this.getWindow());
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized void doNewInherits() {
        if (this.pkg.get() != null && ((Package)this.pkg.get()).getEditor() != null) {
            PackageEditor pkgEg = ((Package)this.pkg.get()).getEditor();
            pkgEg.doNewInherits();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.FXPlatform)
    public void graphChanged() {
        int numPackagesNested;
        int numClassTargetsWithSource;
        int numClassTargets;
        PkgMgrFrame pkgMgrFrame = this;
        synchronized (pkgMgrFrame) {
            if (this.pkg.get() == null) {
                return;
            }
            ArrayList<ClassTarget> classTargets = ((Package)this.pkg.get()).getClassTargets();
            numClassTargets = classTargets.size();
            numClassTargetsWithSource = (int)classTargets.stream().filter(ClassTarget::hasSourceCode).count();
            numPackagesNested = ((Package)this.pkg.get()).getChildren(true).size();
        }
        this.compileAction.setEnabled(numClassTargetsWithSource > 0);
        this.newInheritsAction.setEnabled(numClassTargets >= 2 && numClassTargetsWithSource >= 1);
        if (this.editor != null) {
            this.editor.noClassesExistedMessage.setVisible(numClassTargets + numPackagesNested == 0);
        }
    }

    public void notifySelectionChanged(Collection<Target> curSelection) {
        boolean hasSelection = !curSelection.isEmpty();
        this.removeAction.setEnabled(hasSelection);
        this.compileSelectedAction.setEnabled(hasSelection);
    }

    @OnThread(value=Tag.FX)
    public void printDiagram(PrinterJob printJob) {
        CompletableFuture done = new CompletableFuture();
        JavaFXUtil.runPlatformLater(() -> {
            WritableImage snapshotImage = new WritableImage((int)this.editor.getWidth(), (int)this.editor.getHeight());
            this.editor.snapshot(null, snapshotImage);
            int rotatedWidth = (int)snapshotImage.getHeight();
            int rotatedHeight = (int)snapshotImage.getWidth();
            WritableImage rotatedImage = new WritableImage(rotatedWidth, rotatedHeight);
            for (int y = 0; y < rotatedHeight; ++y) {
                for (int x = 0; x < rotatedWidth; ++x) {
                    rotatedImage.getPixelWriter().setColor(x, y, snapshotImage.getPixelReader().getColor(rotatedHeight - 1 - y, x));
                }
            }
            ImageView imageView = new ImageView((Image)rotatedImage);
            imageView.setPreserveRatio(true);
            imageView.setFitWidth(printJob.getJobSettings().getPageLayout().getPrintableWidth());
            imageView.setFitHeight(printJob.getJobSettings().getPageLayout().getPrintableHeight());
            printJob.printPage((Node)imageView);
            done.complete(true);
        });
        try {
            done.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Debug.reportError(e);
        }
    }

    public ReadOnlyObjectProperty<Package> packageProperty() {
        return this.pkg;
    }

    public static interface PkgMgrPane {
        @OnThread(value=Tag.FXPlatform)
        public Node getPkgMgrPaneNode();
    }
}

